<?php

class Parceria extends Zend_Db_Table_Abstract
{

    protected $_name = TB_PARCERIA;

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false, $where = false)
    {
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = DB::getInstance();

        if ($count && $offset === false && $page === false) {
            $select = "SELECT count(c.id_empreendimento) AS count FROM " . TB_PARCERIA_COMISSAO . " c
                    JOIN " . TB_PESSOA . " p  ON c.id_pessoa = p.id
                    JOIN " . TB_EMPREENDIMENTO . " e  ON c.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento)) LIKE {$termo}
                  ";
            if ($where) {
                $select .= " AND $where";
            }
            $select .= " GROUP BY e.id";
        } else {
            $select = "SELECT c.*, e.nm_empreendimento FROM " . TB_PARCERIA_COMISSAO . " c
                    JOIN " . TB_PESSOA . " p  ON c.id_pessoa = p.id
                    JOIN " . TB_EMPREENDIMENTO . " e  ON c.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento)) LIKE {$termo}
                  ";
            if ($where) {
                $select .= " AND $where";
            }
            $select .= " GROUP BY e.id";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $ids;
    }
}