<?php

class ParcelaMigrada extends Zend_Db_Table_Abstract {

    protected $_name = TB_PARCELA_MIGRADA;

    public function buscaTodasParcelasMigradas() 
    {
        $parcelasMigradas = self::getDefaultAdapter()->select()
            ->from(['pm' => TB_PARCELA_MIGRADA], '*')
            ->join(['b' => TB_BANCO], 'pm.id_banco = b.id', ['cd_banco', 'conta_corrente', 'conta_corrente_dv', 'agencia', 'agencia_dv'])
            ->join(['ta' => TB_AGRUPADA], 'b.cd_banco = ta.idCampo AND idTabela = "9"', ['nmBanco' => 'descricao'])
            ->query()->fetchAll();

        return $parcelasMigradas;
    }

    public function salvaParcelasMigradas($migradas)
    {
        $salvaMigradas = new ParcelaMigrada();

        $salvaMigradas = $salvaMigradas->createRow();

        $salvaMigradas->id_banco = Banco::findBancoByContaAgencia($migradas['banco'], $migradas['contaCorrente'], $migradas['agencia'])['id'];
        $salvaMigradas->nm_cliente = $migradas['cliente'];
        $salvaMigradas->dt_geracao = date('Y-m-d');
        $salvaMigradas->arquivo = $migradas['arquivo'];
        $salvaMigradas->arquivo_pdf = $migradas['arquivoPdf'];
        $salvaMigradas->nr_retorno = $migradas['sequencia'];
        $salvaMigradas->dt_criacao = $migradas['dt_criacao'];    
        $salvaMigradas->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
        $salvaMigradas->save();
    }
}