<?php

class ParcelaHistorico extends Zend_Db_Table_Abstract {

    protected $_name = TB_PARCELA_HISTORICO;
    static $parcelaHistoricoInstacia;

    public static function getInstance()
    {
        if (!self::$parcelaHistoricoInstacia) {
            self::$parcelaHistoricoInstacia = new ParcelaHistorico();
        }
        return self::$parcelaHistoricoInstacia;
    }

    public static function findParcelasHistPagasByIdEmpreendimento($idEmpreendimento, $dataDe, $dataAte, $tpParcela = null, $tpBaixa = null)
    {
        $parcelasHistInstance = self::getInstance();
        $parcelasHist = $parcelasHistInstance->getAdapter()->select()
            ->from(array('p' => TB_PARCELA_HISTORICO), array('id_parcela_contrato'))
            ->join(['c' => TB_CONTRATO], 'c.id = p.id_contrato', '')
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', '')
            ->where('l.id_empreendimento = ?', $idEmpreendimento)
            ->where('p.pago = "1"')
            ->where("dt_pagamento >= '$dataDe'")
            ->where("dt_pagamento <= '$dataAte'")
            ->where("tp_parcela NOT IN ('NE','SE','E','IE','CE')");

        if ($tpParcela)
            $parcelasHist = $parcelasHist->where("tp_parcela IN ('$tpParcela')");
        if ($tpBaixa)
            $parcelasHist = $parcelasHist->where("tp_baixa IN ('$tpBaixa')");
        
        $parcelasHist = $parcelasHist->order('dt_parcela')->query()->fetchAll();    
        
        //Refaz a consulta para evitar erros de valores trazidos do JOIN.
        if ($parcelasHist) {
            foreach ($parcelasHist as $parcela) {
                $numParcelas[] = $parcela['id_parcela_contrato'];
            }
            $numParcelas = implode("','", $numParcelas);
        } else {
            return null;
        }
        return $parcelasHistInstance->getAdapter()->select()
            ->from(array('p' => TB_PARCELA_HISTORICO), array('vl_total_pago','vl_parcela',
            'vl_multa', 'vl_juros', 'desconto', 'acrescimo', 'dt_pagamento', 'dt_parcela'))
            ->where("id_parcela_contrato IN ('$numParcelas')")
            ->order('dt_parcela')->query()->fetchAll();
    }

    public function buscaNrBoletosAvulsosParcelaHistorico($idBancoConta, $idBanco) {
        
        $minNrBoleto = (int)(new BancoConta())->fetchRow('id_banco_conta = ' . $idBancoConta)->nr_boleto;

        $minEmaxNrBoletoParcela = ParcelaHistorico::getDefaultAdapter()->select();

        if ($minNrBoleto) {
            $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela->from(['p' => TB_PARCELA_HISTORICO], ['maxNrBoleto' => 'MAX(p.nr_boleto)'])
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '');
        } else {
            $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela->from(['p' => TB_PARCELA_HISTORICO], ['minNrBoleto' => 'MIN(p.nr_boleto)', 'maxNrBoleto' => 'MAX(p.nr_boleto)'])
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '');
        }
            
        $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela
            ->where("c.id_banco in ('" . $idBanco . "')")
            ->order('p.nr_boleto ASC')
            ->query()->fetch();
        
        if ($minEmaxNrBoletoParcela['maxNrBoleto']) {
            /**
             * Essa condio serve para casos em que o valor mnimo  maior ou igual ao o valor mximo,
             * nesse caso deve-se apenas retornar o valor mnimo e somar +1, em formato de array,
             * pois algumas partes do cdigo em EmissaoController,
             * tratam esse retorno como array.
             */
            if ($minNrBoleto >= $minEmaxNrBoletoParcela['maxNrBoleto'])
                return $minNrBoleto + 1;
    
            if ($minNrBoleto) {
                $minEmaxNrBoletoParcela['minNrBoleto'] = $minNrBoleto;
            }
                
            $buscaNrBoletosParcela = ParcelaHistorico::getDefaultAdapter()->select()
                ->from(['p' => TB_PARCELA_HISTORICO], 'nr_boleto')
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '')
                ->where("c.id_banco in ('" . $idBanco . "')")
                ->where('p.nr_boleto is not null')
                ->order('p.nr_boleto ASC')
                ->query()->fetchAll();
    
            $listaParcela = [];
    
            foreach ($buscaNrBoletosParcela as $nrBoleto) {
                $listaParcela[] = (int)$nrBoleto['nr_boleto'];
            }
    
            if ($minEmaxNrBoletoParcela['maxNrBoleto'] > 999999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 1000;
            } elseif ($minEmaxNrBoletoParcela['maxNrBoleto'] > 99999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 100;
            } elseif ($minEmaxNrBoletoParcela['maxNrBoleto'] > 9999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 10;
            }
    
            $rangeParcela = range($minEmaxNrBoletoParcela['minNrBoleto'] + 1, $minEmaxNrBoletoParcela['maxNrBoleto'] + 1);
            $rangeParcela = array_diff($rangeParcela, $listaParcela);
            /**
             * Esse if serve para casos em que no tenham ids livres entre o valor mnimo do nr_boleto da tabela BANCO_CONTA
             * e o valor de nr_boleto mximo das parcelas do banco selecionado, nesse caso o sistema retorno o valor mximo + 1.
             */
            if ($rangeParcela == null)
                return (int)$minEmaxNrBoletoParcela['maxNrBoleto'] + 1;

            return $rangeParcela;
        }

        return null;
    }
}