<?php

class Parcela2Via extends Zend_Db_Table_Abstract {

    protected $_name = TB_PARCELA_2VIA;

    public function buscaNrBoletosAvulsosParcela2Via($idBancoConta, $idBanco) {
        
        $minNrBoleto = (int)(new BancoConta())->fetchRow('id_banco_conta = ' . $idBancoConta)->nr_boleto;
        
        $minEmaxNrBoletoParcela = Parcela2Via::getDefaultAdapter()->select();
        
        if ($minNrBoleto) {
            $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela->from(['p' => TB_PARCELA_2VIA], ['maxNrBoleto' => 'MAX(p.nr_boleto)'])
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '');
        } else {
            $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela->from(['p' => TB_PARCELA_2VIA], ['minNrBoleto' => 'MIN(p.nr_boleto)', 'maxNrBoleto' => 'MAX(p.nr_boleto)'])
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '');
        }
        
        $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela
            ->where("c.id_banco in ('" . $idBanco . "')")
            ->order('p.nr_boleto ASC')
            ->query()->fetch();
            
        if ($minEmaxNrBoletoParcela) {
            /**
             * Essa condio serve para casos em que o valor mnimo  maior ou igual ao o valor mximo,
             * nesse caso deve-se apenas retornar o valor mnimo e somar +1, em formato de array,
             * pois algumas partes do cdigo em EmissaoController,
             * tratam esse retorno como array.
             */
            if ($minNrBoleto >= $minEmaxNrBoletoParcela['maxNrBoleto'])
                return $minNrBoleto + 1;

            if ($minNrBoleto) {
                $minEmaxNrBoletoParcela['minNrBoleto'] = $minNrBoleto;
            }
    
            $buscaNrBoletosParcela = Parcela2Via::getDefaultAdapter()->select()
                ->from(['p' => TB_PARCELA_2VIA], 'nr_boleto')
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '')
                ->where("c.id_banco in ('" . $idBanco . "')")
                ->where('p.nr_boleto is not null')
                ->order('p.nr_boleto ASC')
                ->query()->fetchAll();
    
            $listaParcela = [];
    
            foreach ($buscaNrBoletosParcela as $nrBoleto) {
                $listaParcela[] = (int)$nrBoleto['nr_boleto'];
            }
            
            if ($minEmaxNrBoletoParcela['maxNrBoleto'] > 999999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 1000;
            } elseif ($minEmaxNrBoletoParcela['maxNrBoleto'] > 99999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 100;
            } elseif ($minEmaxNrBoletoParcela['maxNrBoleto'] > 9999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 10;
            }
        
            $rangeParcela = range($minEmaxNrBoletoParcela['minNrBoleto'] + 1, (int)$minEmaxNrBoletoParcela['maxNrBoleto'] + 1);
            $rangeParcela = array_diff($rangeParcela, $listaParcela);

            /**
             * Esse if serve para casos em que no tenham ids livres entre o valor mnimo do nr_boleto da tabela BANCO_CONTA
             * e o valor de nr_boleto mximo das parcelas do banco selecionado, nesse caso o sistema retorno o valor mximo + 1.
             */
            if ($rangeParcela == null)
                return (int)$minEmaxNrBoletoParcela['maxNrBoleto'] + 1;
            
            return $rangeParcela;
        }

        return null;
    }
}