<?php

class Parcela extends Zend_Db_Table_Abstract
{

    protected $_name = TB_PARCELA;
    static $parcelaInstacia;


    /**
     * @return Contrato
     */
    public static function getInstance()
    {
        if (!self::$parcelaInstacia) {
            self::$parcelaInstacia = new Parcela();
        }
        return self::$parcelaInstacia;
    }

    public static function getParcelasByIdRemessa($id)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->where('p.id_remessa = ?', $id)
            ->query()->fetchAll();
        return $parcelas;
    }
    public static function getParcelasByDt_pagamento($dt_pagamento)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->where('dt_parcela <="'. $dt_pagamento.'"')
            ->where('cod_boleto_api <> ""')
            ->where('id_remessa <> ""')
            ->where('pago = "0"')
            ->query()->fetchAll();
        return $parcelas;
    }

    /**
     * Esse mtodo busca informaes para as colunas "valor PREVISTO" e "Valor PREVISTO e No Realizado"
     */
    public static function findParcelasByIdEmpreendimento($idEmpreendimento, $dataDe, $dataAte, $tpParcela = null, $tpBaixa = null)
    {
        $parcelasInstance = self::getInstance();
        $parcelas = $parcelasInstance->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato'))
            ->join(['c' => TB_CONTRATO], 'c.id = p.id_contrato', '')
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', '')
            ->where('l.id_empreendimento = ?', $idEmpreendimento)
            ->where("dt_parcela >= '$dataDe'")
            ->where("dt_parcela <= '$dataAte'")
            ->where("tp_parcela NOT IN ('NE','SE','E','IE','CE')");

        if ($tpParcela)
            $parcelas = $parcelas->where("tp_parcela IN ('$tpParcela')");
        if ($tpBaixa)
            $parcelas = $parcelas->where("tp_baixa IN ('$tpBaixa')");
        
        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();
        
        //Refaz a consulta para evitar erros de valores trazidos do JOIN.
        if ($parcelas) {
            foreach ($parcelas as $parcela) {
                $numParcelas[] = $parcela['id_parcela_contrato'];
            }
            $numParcelas = implode("','", $numParcelas);
        } else {
            return null;
        }

        return $parcelasInstance->getAdapter()->select()
            ->from(
                array('p' => TB_PARCELA), 
                array(
                    'id_parcela_contrato',
                    'vl_parcela',
                    'dt_parcela',
                    'pago',
                    'vl_multa',
                    'vl_juros',
                    'desconto',
                    'acrescimo',
                ))
            ->where("id_parcela_contrato IN ('$numParcelas')")
            ->order('dt_parcela')->query()->fetchAll();
    }

    public static function findParcelasPagasByIdEmpreendimento($idEmpreendimento, $dataDe, $dataAte, $tpParcela = null, $tpBaixa = null)
    {
        $parcelasInstance = self::getInstance();
        $parcelas = $parcelasInstance->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato'))
            ->join(array('c' => TB_CONTRATO), 'c.id = p.id_contrato', '')
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', '')
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', '')
            ->where('e.id = ?', $idEmpreendimento)
            ->where('p.pago = "1"')
            ->where("dt_pagamento >= '$dataDe'")
            ->where("dt_pagamento <= '$dataAte'")
            ->where("tp_parcela NOT IN ('NE','SE','E','IE','CE')");

        if ($tpParcela)
            $parcelas = $parcelas->where("tp_parcela IN ('$tpParcela')");
        if ($tpBaixa)
            $parcelas = $parcelas->where("tp_baixa IN ('$tpBaixa')");
        
        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();

        //Refaz a consulta para evitar erros de valores trazidos do JOIN.
        if ($parcelas) {
            foreach ($parcelas as $parcela) {
                $numParcelas[] = $parcela['id_parcela_contrato'];
            }
            $numParcelas = implode("','", $numParcelas);
        } else {
            return null;
        }

        return $parcelasInstance->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'vl_total_pago',
            'vl_parcela', 'vl_multa', 'vl_juros', 'desconto', 'acrescimo', 'dt_parcela', 
            'dt_pagamento'))
            ->where("id_parcela_contrato IN ('$numParcelas')")
            ->order('dt_parcela')->query()->fetchAll();
    }

    /*
     * Busca todas as parcelas pagas pelo id do contrato
     * @param string $idContrato
     * @return array $parcelas
     */
    public static function findParcelasPagasById($idContrato)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->where('p.id_contrato = ?', $idContrato)
            ->where('p.pago = "1"')
            ->order('dt_parcela')
            ->query()->fetchAll();
        for ($i = 0; $i < count($parcelas); $i++) {
            $parcelas[$i]['dt_parcela'] = Helper::getDate($parcelas[$i]['dt_parcela']);
        }
        return $parcelas;
    }
    public static function getParcelasById($id, $idBanco = null)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->join(array('ct'=>TB_CONTRATO),'ct.id = p.id_contrato','id_pessoa')
            ->join(array('ps' =>TB_PESSOA),'ps.id = id_pessoa',array('nm_pessoa','nr_telefone','nr_celular','email'))
            ->join(array('l' => TB_LOTES), 'ct.id_lote = l.id', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('*'));
        
        if ($idBanco == '274') {
            $parcelas = $parcelas->where('p.id_parcela_contrato = ' . $id . ' or p.id_parcela_contrato_antigo = ' . $id);
        } else {
            $parcelas = $parcelas->where('p.id_parcela_contrato = ?', $id);
        }
        
        return $parcelas->query()->fetchAll();
    }
    public static function getParcelasByNrBoleto($nr)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->join(array('ct'=>TB_CONTRATO),'ct.id = p.id_contrato','id_pessoa')
            ->join(array('ps' =>TB_PESSOA),'ps.id = id_pessoa',array('nm_pessoa','nr_telefone','nr_celular','email'))
            ->join(array('l' => TB_LOTES), 'ct.id_lote = l.id', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('*'))
            ->where('p.nr_boleto = ?', $nr)
            ->query()->fetchAll();
        return $parcelas;
    }
    public static function findParcelasDistratoById($idContrato)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->where('p.id_contrato = ?', $idContrato)
            ->where('p.pago = "1"')
            ->where('tp_parcela NOT IN ("A")')
            ->order('dt_parcela')
            ->query()->fetchAll();
        for ($i = 0; $i < count($parcelas); $i++) {
            $parcelas[$i]['dt_parcela'] = Helper::getDate($parcelas[$i]['dt_parcela']);
        }
        return $parcelas;
    }
    public static function findParcelasPagasHistoricoById($idContrato)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('ph' => TB_PARCELA_HISTORICO), array('*'))
            ->where('id_contrato = ?', $idContrato)
            ->where('pago = "1"')
            ->where('tp_parcela NOT IN ("A")')
            ->order('dt_parcela')
            ->query()->fetchAll();
        for ($i = 0; $i < count($parcelas); $i++) {
            $parcelas[$i]['dt_parcela'] = Helper::getDate($parcelas[$i]['dt_parcela']);
        }
        return $parcelas;
    }
    /**
     * @param $idContrato
     * @return array|Contrato
     */
    public static function findParcelasMigracao($idProposta, $idParcela, $tpParcela)
    {
        $parcela = self::getInstance()->getAdapter();
        $parcela = $parcela->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->join(array('c' => TB_CONTRATO), 'c.id = p.id_contrato', array('*'))
            ->where('c.nr_proposta = ?', $idProposta)
            ->where('p.id_parcela = ?', $idParcela)
            ->where('p.tp_parcela = ?', $tpParcela)
            ->query()->fetch();

        return $parcela;
    }
    public static function findParcelasReajuste($post, $count = false)
    {
        $search = $_POST['search']['value'];
        $order = $_POST['order'];

        $array = array(
            0 => 'c.id',
            1 => 'c.contrato',
            2 => 'hr.indice',
            3 => 'p.nm_pessoa',
        );

        if ($search) {
            $where = 'c.id LIKE "%' . $search . '%" ';
            $where .= 'or UPPER(c.contrato) LIKE "%' . mb_strtoupper($search, 'UTF-8') . '%" ';
            $where .= 'or UPPER(hr.indice) LIKE "%' . mb_strtoupper($search, 'UTF-8') . '%" ';
            $where .= 'or UPPER(p.nm_pessoa) LIKE "%' . mb_strtoupper($search, 'UTF-8') . '%" ';
        }
        $tb_reajuste = new HistoricoReajuste();
        $adapter = $tb_reajuste->getAdapter();
        $reajustes = $adapter->select()->distinct()
            ->from(array('hr' => TB_HISTORICO_REAJUSTE), '*')
            ->join(array('c' => TB_CONTRATO), 'hr.idContrato = c.id', null)
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', null);
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $reajustes->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $reajustes = $reajustes->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $reajustes = $reajustes->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $reajustes = $reajustes->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $reajustes;
    }

    public static function parcelaByIdContrato($idContrato, $idParcela)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()->
        from(array('p' => TB_PARCELA), array('*'))->
        where('p.id_contrato = ?', $idContrato)->
        where('p.id_parcela = ?', $idParcela)->query()->fetch();

        return $parcelas;
    }

    /**
     * Busca todas as parcelas nao pagas pelo id do contrato
     * @param $idContrato
     * @param null $dtInicio
     * @param null $dtFim
     * @return array|Zend_Db_Select,
     */
    public static function findParcelasNPagasById($idContrato, $dtInicio = null, $dtFim = null, $flEnvio = false, $banco = false)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('vl_parcela_2avia','dt_parcela','dt_parcela_2avia','vl_parcela','desconto','acrescimo','id_remessa','id_parcela_contrato','id_contrato','id_parcela','tp_parcela'))
            ->where('p.id_contrato = ? ', $idContrato)
            //Acrescentada condicao para trazer so as parcelas do tipo especifico abaixo.
            ->where("tp_parcela NOT IN ('E','NE','SE','CE','IE')")
            ->where('p.pago = "0"');
        if ($flEnvio) {
            $parcelas->where('p.fl_envio = "1"');
        }

        if (isset($dtInicio) && isset($dtFim))
            $parcelas = $parcelas->where('(dt_parcela >= "' . Helper::getInputDate($dtInicio) . '" AND dt_parcela <= "' . Helper::getInputDate($dtFim) . '") OR (dt_parcela_2avia >= "' . Helper::getInputDate($dtInicio) . '" AND dt_parcela_2avia <= "' . Helper::getInputDate($dtFim) . '")');

        if ($banco)
        {
            $parcelas = $parcelas
                ->join(['c' => TB_CONTRATO], 'c.id = p.id_contrato', '')
                ->join(array('b' => TB_BANCO), 'b.id_banco_conta = p.id_banco_boleto or (p.id_banco_boleto is null and c.id_banco = ' .$banco. ')', array())
                ->where('b.id = ' . $banco);
        }

        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();

        for ($i = 0; $i < count($parcelas); $i++) {
            $parcelas[$i]['dt_parcela'] = Helper::getDate($parcelas[$i]['dt_parcela']);
        }

        return $parcelas;
    }

    public static function findParcelasPorContratoDistratado($idContrato, $dtInicio = null, $dtFim = null, $flEnvio = false)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA_HISTORICO), array('vl_parcela_2avia','dt_parcela','dt_parcela_2avia','vl_parcela','desconto','acrescimo','id_remessa','id_parcela_contrato','id_contrato','id_parcela','tp_parcela'))
            ->where('p.id_contrato = ? ', $idContrato)
            //Acrescentada condicao para trazer so as parcelas do tipo especifico abaixo.
            ->where("tp_parcela NOT IN ('E','NE','SE','CE','IE')")
            ->where('p.pago = "0"');
        if ($flEnvio) {
            $parcelas->where('p.fl_envio = "1"');
        }

        if (isset($dtInicio) && isset($dtFim))
            $parcelas = $parcelas->where('(dt_parcela >= "' . Helper::getInputDate($dtInicio) . '" AND dt_parcela <= "' . Helper::getInputDate($dtFim) . '") OR (dt_parcela_2avia >= "' . Helper::getInputDate($dtInicio) . '" AND dt_parcela_2avia <= "' . Helper::getInputDate($dtFim) . '")');

        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();

        for ($i = 0; $i < count($parcelas); $i++) {
            $parcelas[$i]['dt_parcela'] = Helper::getDate($parcelas[$i]['dt_parcela']);
        }

        return $parcelas;
    }

    /*
     * Busca todas as parcelas pagas e verifica se o contrato esta totalmente quitado
     * @param string $idContrato
     * @return boolean
     */
    public static function verificaQuitacao($idContrato)
    {
        $parcelas = self::getInstance();

        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('parcelas' => 'COUNT(id_parcela_contrato)'))
            ->where('p.id_contrato = ?', $idContrato)
            ->where('p.tp_parcela NOT IN ("SE","NE","IE","CE","QE","E")')
            ->where('p.pago = "0"')
            ->order('dt_parcela')->query()->fetch();

        $parcelasPagas = self::getInstance();
        $parcelasPagas = $parcelasPagas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('parcelas' => 'COUNT(id_parcela_contrato)'))
            ->where('p.id_contrato = ?', $idContrato)
            ->where('p.pago = "1"')->order('dt_parcela')->query()->fetch();

        if ((int)$parcelas['parcelas'] == 0 && (int)$parcelasPagas['parcelas'] > 0) {
            return true;
        } else
            return false;
    }

    /*
     * Busca todas as parcelas pagas do tipo S e verifica se o contrato esta totalmente quitado
     * @param string $idContrato
     * @return boolean
     */
    public static function verificaQuitacaoSinal($idContrato)
    {
        $parcelas = self::getInstance();

        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('parcelas' => 'COUNT(id_parcela_contrato)'))
            ->where('p.id_contrato = ?', $idContrato)
            ->where('p.tp_parcela = "S"')->query()->fetch();
            
        if ((int)$parcelas['parcelas'] > 0 ) {
            $parcelasPagas = self::getInstance();
            $parcelasPagas = $parcelasPagas->getAdapter()->select()
                ->from(array('p' => TB_PARCELA), array('parcelas' => 'COUNT(id_parcela_contrato)'))
                ->where('p.id_contrato = ?', $idContrato)
                ->where('p.tp_parcela = "S"')
                ->where('p.pago = "0"')->order('dt_parcela')->query()->fetch();

            if ((int)$parcelasPagas['parcelas'] > 0) {
                return false;
            } else {
                return true;
            }
        } else
            return false;
     }

    /*
     * Busca as parcelas nao pagas relativas a um empreendimento
     * $param integer $idEmpreendimento
     */
    public static function findNPagasByEmpreendimento($idEmpreendimento)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', 'c.id')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', 'l.id')
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', 'e.id')
            ->where('e.id = ?', $idEmpreendimento)
            ->where('p.pago = "0"')
            ->order('dt_parcela')->query()->fetchAll();

        return $parcelas;
    }

    /* Retorna os dados necessarios para a montar o boleto,
     * recebe como parametro apenas a parcela
     */
    public static function toDados($parcela)
    {
        $cliente = new Db_Cliente();
        $cliente = $cliente->fetchRow()->toArray();

        $cedEndereco = $parcela['cedEndereco'];
        if ($parcela['cedNrEndereco'])
            $cedEndereco .= ', ' . $parcela['cedNrEndereco'];
        $cedEndereco .= ', ' . $parcela['cedBairro'];

        $valor = $parcela['vl_parcela'];
        $nmEmpreendimento = $parcela['nm_empreendimento'];
        $nosso_numero = str_pad($parcela['id_parcela_contrato'], STR_PAD_LEFT);
        if ($parcela['cd_banco'] == '748') {
            $nosso_numero = str_pad($parcela['nr_boleto'], STR_PAD_LEFT);
        }
        $cpf_cnpj_sacado = $parcela['nr_cpf'] ? $parcela['nr_cpf'] : $parcela['nr_cnpj'];
        $nmLote = $parcela["lote"];

        $parcela['obs_parcela'] ? $parcelaObs = ' (' . $parcela['obs_parcela'] . ')' : $parcelaObs = '';
        
        $demonstrativo2 = 'Parcela ' . $parcela['id_parcela'].$parcela['tp_parcela'] .  $parcelaObs . ' referente a pagamento ' . $parcela['ds_subgrupo'] .' ' . $nmLote;
        $demonstrativo2 .= ($parcela['quadra']) ? ' - ' .  $parcela['ds_grupo'] . ' '. $parcela['quadra'] : '';
        $demonstrativo3 = ($parcela['obs'])?$parcela['obs']:'';

        if (strlen($parcela['nm_cedente']) > 67) {
            $parcela['nm_cedente'] = '<small>' . $parcela['nm_cedente'] . '</small>';
        }

        $cnpjCpfCedente = ($parcela['cnpj_cedente'])?'CNPJ: '.$parcela['cnpj_cedente']:'CPF: '.$parcela['cpf_cedente'];

        $instrucoes1 = '';
        if ($parcela['tp_multa'] != 'S' || $parcela['tp_juros'] != 'S') {
            $instrucoes1 = 'Aps o vencimento: ';
        }
        if ($parcela['tp_multa'] != 'S') {
            $valorMulta = ($parcela['tp_multa'] == 'P') ? Helper::getMoney($valor * ($parcela['multa'] / 100)) : Helper::getMoney($parcela['multa']);
            $instrucoes1 .= 'multa de '.$_SESSION['simboloMoeda'].' ' . $valorMulta;
        }
        if ($parcela['tp_multa'] != 'S' && $parcela['tp_juros'] != 'S') {
            $instrucoes1 .= ' e ';
        }
        if ($parcela['tp_juros'] != 'S') {
            $valorJuros = ($parcela['tp_juros'] == 'P') ? Helper::getMoney($valor * ($parcela['juros'] / 100)) : Helper::getMoney($parcela['juros']);
            $instrucoes1 .= ' juros de '.$_SESSION['simboloMoeda'].' ' . $valorJuros . ' ao dia';
        }
        $contrato = Contrato::findContratoById($parcela['idContrato']);
        $contrato['dt_parcela'] = $parcela['dt_parcela'];
        $contrato['tp_parcela'] = $parcela['tp_parcela'];

        $descontoParcela = self::getDescontoParcela($contrato, $parcela['vl_parcela']);
        $endereco = '';

        if ($parcela['cliComplemento'] != '' || $parcela['cliComplemento'] != null) {
            $endereco = ', ' . $parcela['cliComplemento'];
        }

        $dados = array(

            'taxa_boleto' => 0,
            'vencimento' => Helper::getDate($parcela['dt_parcela']),
            'valor_cobrado' => $valor,
            'desconto' => $parcela['desconto'],
            'acrescimo' => $parcela['acrescimo'],
            'nosso_numero' => $nosso_numero,
            'formatacao_nosso_numero' => '1',
            'numero_documento' => $nosso_numero,
            'sacado' => "<strong>" . $parcela['nm_pessoa'] . '</strong> - CPF/CNPJ: ' . $cpf_cnpj_sacado,
            'endereco1' => $parcela['cliEndereco'] . ' ,' . $parcela['cliNrEndereco'] . $endereco . ' - ' . $parcela['cliBairro'],
            'endereco2' => $parcela['cliCidade'] . ' - ' . $parcela['cliUf'] . ' - CEP: ' . $parcela['cliCep'],
            'demonstrativo1' => 'Pagamento de compra no empreendimento ' . $nmEmpreendimento,
            'demonstrativo2' => $demonstrativo2,
            'demonstrativo3' => $demonstrativo3,
            'instrucoes1' => $instrucoes1,
            'instrucoes2' => $parcela['msg_boleto'],
            'instrucoes3' => $parcela['msg_adicional'],
            'instrucoes4' => ($descontoParcela['vlDesconto'] > 0)?'Desconto de '.$_SESSION['simboloMoeda'].' '.Helper::getMoney($descontoParcela['vlDesconto']).' at o vencimento.':'',
            'banco' => $parcela['cd_banco'],
            'agencia' => $parcela['agencia'],
            'agencia_dv' => $parcela['agencia_dv'],
            'conta' => $parcela['conta_corrente'],
            'conta_dv' => $parcela['conta_corrente_dv'],
            'conta_cedente' => $parcela['cd_cedente'],
            'conta_cedente_dv' => substr($parcela['conta_corrente_dv'], -1),
            'cd_cedente' => $parcela['cd_cedente'],
            'identificacao' => $parcela['nm_empreendimento'],
            'nr_contrato' => str_pad($parcela["idContrato"], 5, "0", STR_PAD_LEFT),
            'lote' => str_pad($nmLote, 3, "0", STR_PAD_LEFT),
            'quadra' => $parcela["quadra"],
            'tp_parcela' => $parcela["tp_parcela"],
            'nr_parcela' => $parcela["nr_tipo_parcela"]?$parcela["nr_tipo_parcela"]:str_pad($parcela["id_parcela"], 3, "0", STR_PAD_LEFT) . " / " . str_pad($parcela['nrParcelas'], 3, "0", STR_PAD_LEFT),
            'especie_doc' => $parcela['especie_documento'],
            'cpf_cnpj' => ($parcela['cnpj_cedente'])?$parcela['cnpj_cedente']:$parcela['cpf_cedente'],
            'endereco' => substr($cedEndereco . ' ' . $parcela['cedCidade'] . '-' . $parcela['cedUf'], 0, 150),
            'cep' => $parcela['cedCep'],
            'cidade_uf' => $parcela['cedCidade'] . '-' . $parcela['cedUf'],
            'cedente' => $parcela['nm_cedente'] . ' - ' . $cnpjCpfCedente,
            'cnpj' => Helper::getMaskCNPJ($cliente['nr_cnpj']),
            'carteira' => $parcela['carteira'],
            'variacao_carteira' => ($parcela['cd_banco'] == '748')?$parcela['carteira_variacao']:substr($parcela['carteira_variacao'], 0,2).'-'.substr($parcela['carteira_variacao'], -1),
            'convenio' => $parcela['cd_cedente'],
            'formatacao_convenio' => '7',
            'modelo' => isset($_POST['modelo'])?$_POST['modelo']:$_GET['modelo'],
            'nr_boleto' => $parcela['nr_boleto'],
            'ano_boleto_emissao' => $parcela['ano_boleto_emissao'],
            'cod_boleto_api' => $parcela['cod_boleto_api'],
            'linha_digitavel' => $parcela['linha_digitavel'],
            'codigo_barras' => $parcela['cod_barras'],
            'txid' => $parcela['txid'],
            'chavePix' => $parcela['chave_pix'],
            'ds_grupo' => $parcela['ds_grupo'],
            'ds_subgrupo' => $parcela['ds_subgrupo'],
            'ds_tipo_loteamento' => $parcela['ds_tipo_loteamento'],
            'qrCode' => $parcela['qrCode'],
        );
        return $dados;
    }


    public static function toDadosParcela($parcela, $bancoMulti = false)
    {
        //Injecao de dependencia -  Non coesao -
        $empreendimentos = new Empreendimento();
        $lotes = new Lote();
        $bancos = new Banco();
        $contratos = new Contrato();
        $pessoas = new Pessoa();
        $pfs = new Pessoa_Fisica();
        $pjs = new Pessoa_Juridica();
        $parcerias = new Parceria();
        $cidades = new Cidade();
        $cliente = new Db_Cliente();

        $contrato = $contratos->fetchRow('id = '.$parcela['id_contrato'])->toArray();

        //filtro das parcelas do tipo_parcela + Negociadas
        $filtroParcela = 'tp_parcela IN( "' . $parcela['tp_parcela'] . '" , "E", "' . $parcela['tp_parcela'] . 'E") AND id_contrato = ' . $parcela['id_contrato'];

        if ($parcela['tp_parcela'] == 'G' && $parcela['id_negociacao'] != "")
            $filtroParcela .= ' AND id_negociacao = ' . $parcela['id_negociacao'];

        $nrParcelas = $contratos->getAdapter()->select()->from(TB_PARCELA, array('(count(*))'));
        
        $parcelasDs = $contratos->getAdapter()->select()->from(array('c' => TB_CONTRATO), array(''))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array(''))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array(''))
            ->joinLeft(array('tp' => TB_TIPO_LOTEAMENTO), 'tp.id_tipo_loteamento = e.id_tipo_loteamento', array('ds_grupo', 'ds_subgrupo', 'ds_tipo_loteamento'))
            ->where('c.id = '.$parcela['id_contrato'])
            ->query()->fetchAll();
        
        if ($parcela['id_renegociacao'])
            $filtroParcela .= ' AND id_renegociacao = ' . $parcela['id_renegociacao'];

        $nrParcelas = $nrParcelas->where($filtroParcela)->query()->fetchColumn();

        $lote = $lotes->fetchRow('id = '.$contrato['id_lote'])->toArray();
        $emp = $empreendimentos->fetchRow('id = '.$lote['id_empreendimento'])->toArray();
        $banco = $bancos->fetchRow('id = '. $contrato['id_banco']);
        
        if ($bancoMulti)
            $banco = $bancos->fetchRow('id_banco_conta = '. $bancoMulti);

        if ($banco)
            $banco = $banco->toArray();

        $pessoa = $pessoas->fetchRow('id = '.$contrato['id_pessoa'])->toArray();

        $cliente = $cliente->fetchRow()->toArray();

        if ($pessoa['cd_cidade'])
            $cidade = (new Cidade())->fetchRow('id = '.$pessoa['cd_cidade'])->toArray();

        if ($pessoa['tp_pessoa'] == 'F') {
            $pf = $pfs->fetchRow('id_pessoa = '.$pessoa['id'])->toArray();
        } else {
            $pj = $pjs->fetchRow('id_pessoa = '.$pessoa['id'])->toArray();
        }

        $parceiros = array();
        $list = $parcerias->fetchAll('id_empreendimento = '. $lote['id_empreendimento'])->toArray();

        foreach ($list as $it) {
            $parceiros[] = $pessoas->fetchRow('id = '.$it['id_pessoa'])->toArray();
        }

        if($banco['cnpj_cedente'])
            $ced = $pjs->fetchRow('nr_cnpj = "'. $banco['cnpj_cedente'].'"');
        else
            $ced = $pfs->fetchRow('nr_cpf = "'. $banco['cpf_cedente'].'"');


        if ($ced) {
            $dados_cedente = $pessoas->fetchRow('id = '. $ced['id_pessoa']);
            if ($dados_cedente['cd_cidade']) {
                $cid_cedente = $cidades->fetchRow('id = '. $dados_cedente['cd_cidade']);
            }
        }

        $endereco = $dados_cedente['endereco'];
        if ($dados_cedente['nr_endereco'])
            $endereco .= ', ' . $dados_cedente['nr_endereco'];
        $endereco .= ', ' . $dados_cedente['nm_bairro'];

        $cpf_cnpjs = array();

        foreach ($parceiros as $p) {
            if ($p['tp_pessoa'] == 'F') {
                $_pf = $pfs->fetchRow('id_pessoa = '.$p['id'])->toArray();
                $cpf_cnpjs[] = $_pf['nr_cpf'];
            } else {
                $_pj = $pjs->fetchRow('id_pessoa = '.$p['id']);
                $cpf_cnpjs[] = $_pj['nr_cnpj'];
            }
        }

        $cpf_cnpjs = implode(' - ', $cpf_cnpjs);

        //Testa se existem dados nas colunas de segunda via
        if ((float)$parcela['vl_parcela_2avia'] > 0)
            $valor = $parcela['vl_parcela_2avia'];
        else
            $valor = $parcela['vl_parcela'];
        if ($parcela['dt_parcela_2avia'])
            $dt_parcela = Helper::getDate($parcela['dt_parcela_2avia']);
        else
            $dt_parcela = Helper::getDate($parcela['dt_parcela']);

        $nosso_numero = str_pad($parcela['id_parcela_contrato'], STR_PAD_LEFT);
        if ($banco['cd_banco'] == '748') {
            $nosso_numero = str_pad($parcela['nr_boleto'], STR_PAD_LEFT);
        }

        //somente para o banco grafeno
        if ($banco['cd_banco'] == '274') {
            $linhaDigitavel = '';
            $codBarras = '';
            $linhaDigitavel = $parcela['linha_digitavel'];
            $codBarras = $parcela['cod_barras'];
        }

        $cpf_cnpj_sacado = $pf['nr_cpf'] ? $pf['nr_cpf'] : $pj['nr_cnpj'];

        $instrucoes1 = '';
        if ($banco['tp_multa'] != 'S' || $banco['tp_juros'] != 'S') {
            $instrucoes1 = 'Aps o vencimento: ';
        }
        if ($banco['tp_multa'] != 'S') {
            $multaValor = ($banco['tp_multa'] == 'P') ? Helper::getMoney($valor * ($banco['multa'] / 100)) : Helper::getMoney($banco['multa']);
            $instrucoes1 .= 'multa de '.$_SESSION['simboloMoeda'].' ' . $multaValor;
        }
        if ($banco['tp_multa'] != 'S' && $banco['tp_juros'] != 'S') {
            $instrucoes1 .= ' e ';
        }
        if ($banco['tp_juros'] != 'S') {
            $jurosValor = ($banco['tp_juros'] == 'P') ? Helper::getMoney($valor * ($banco['juros'] / 100)) : Helper::getMoney($banco['juros']);
            $instrucoes1 .=  ' juros de '.$_SESSION['simboloMoeda'].' ' . $jurosValor . ' ao dia';
        }

        /**
         * @todo Dados de converter contrato para parcelas
         */
        $demonstrativo2 = 'Parcela ' . $parcela['id_parcela'] . $parcela['tp_parcela'] . ' referente a pagamento ' . $parcelasDs[0]['ds_subgrupo'] .' ' . $lote['lote']; 
        $demonstrativo2 .= ($lote['quadra']) ? ' - ' .  $parcelasDs[0]['ds_grupo'] . ' '. $lote['quadra'] : '';
        $demonstrativo3 = ($parcela['obs'])?$parcela['obs']:'';
        $cnpjCpfCedente = ($banco['cnpj_cedente'])?'CNPJ: '.$banco['cnpj_cedente']:'CPF: '.$banco['cpf_cedente'];
        if( $parcela['cod_barras']){
            $codBarras= $parcela['cod_barras'];
        }
        if( $parcela['linha_digitavel']){
            $linhaDigitavel= $parcela['linha_digitavel'];
        }
        $dados = array(
            'taxa_boleto' => 0,
            'vencimento' => $dt_parcela,
            'valor_cobrado' => $valor,
            'desconto' => $parcela['desconto'],
            'acrescimo' => $parcela['acrescimo'],
            'nosso_numero' => $nosso_numero,
            'formatacao_nosso_numero' => '1',
            'numero_documento' => $nosso_numero,
            'sacado' => "<strong>" . $pessoa['nm_pessoa'] . '</strong> - CPF/CNPJ: ' . $cpf_cnpj_sacado,
            'endereco1' => $pessoa['endereco'] . ' ,' . $pessoa['nr_endereco'] . ' - ' . $pessoa['nm_bairro'],
            'endereco2' => $cidade['nome'] . ' - ' . $cidade['uf'] . ' - CEP: ' . $pessoa['nr_cep'],
            'demonstrativo1' => 'Pagamento de compra no empreendimento ' . $emp['nm_empreendimento'],
            'demonstrativo2' => $demonstrativo2,
            'demonstrativo3' => $demonstrativo3,
            'instrucoes1' => $instrucoes1,
            'instrucoes2' => $banco['msg_boleto'],
            'instrucoes3' => $banco['msg_adicional'],
            'instrucoes4' => '',
            'banco' => $banco['cd_banco'],
            'agencia' => $banco['agencia'],
            'agencia_dv' => $banco['agencia_dv'],
            'conta' => $banco['conta_corrente'],
            'conta_dv' => $banco['conta_corrente_dv'],
            'conta_cedente' => $banco['cd_cedente'], //substr($banco['cd_cendente'], 0,-1),
            'conta_cedente_dv' => substr($banco['conta_corrente_dv'], -1), //substr($banco['cd_cendente'],-1),
            'cd_cedente' => $banco['cd_cedente'],
            'identificacao' => $emp['nm_empreendimento'],
            'nr_contrato' => str_pad($parcela["id_contrato"], 5, "0", STR_PAD_LEFT),
            'lote' => str_pad($lote["lote"], 3, "0", STR_PAD_LEFT),
            'quadra' => $lote["quadra"],
            'tp_parcela' => $parcela["tp_parcela"],
            'nr_parcela' => $parcela["nr_tipo_parcela"]?$parcela["nr_tipo_parcela"]:str_pad($parcela["id_parcela"], 3, "0", STR_PAD_LEFT) . " / " . str_pad($nrParcelas, 3, "0", STR_PAD_LEFT),
            'especie_doc' => $banco['especie_documento'],
            'cpf_cnpj' => ($banco['cnpj_cedente'])?$banco['cnpj_cedente']:$banco['cpf_cedente'], //$cpf_cnpjs,
            'endereco' => $endereco,
            'cidade_uf' => $cid_cedente['nome'] . '-' . $cid_cedente['uf'],
            'cedente' => $banco['nm_cedente'] . ' - ' . $cnpjCpfCedente,
            'cnpj' => Helper::getMaskCNPJ($cliente['nr_cnpj']),
            'carteira' => $banco['carteira'],
            'variacao_carteira' => ($banco['cd_banco'] == '748')?$banco['carteira_variacao']:'01-9',
            'convenio' => $banco['cd_cedente'],
            'formatacao_convenio' => '7',
            'nr_boleto' => $parcela['nr_boleto'], 
            'ano_boleto_emissao' => $parcela['ano_boleto_emissao'],
            'ds_grupo' => $parcelasDs[0]['ds_grupo'],
            'ds_subgrupo' => $parcelasDs[0]['ds_subgrupo'],
            'ds_tipo_loteamento' => $parcelasDs[0]['ds_tipo_loteamento'],
            'codigo_barras' => $codBarras,
            'linha_digitavel' => $linhaDigitavel,
            'txid' => $parcela['txid'],
            'qrCode' => $parcela['qrCode']
        );

        return $dados;
    }

    /**
     * Busca todas parcelas pagas de um contrato na tabela de parcela
     *
     * @param $contrato - id do contrato
     * @param bool $dt_inicial - data inicial das parcelas
     * @param bool $dt_final - data final das parcelas
     * @param bool $tp_parcela - tipos de parcelas
     * @param int $paga - se e pra pesquisar parcelas pagas ou nao pagas
     * @param bool $tipoPg - tipo de pagamento
     * @return Contrato|Zend_Db_Select
     */

    public static function parcelaByContrato($contrato, $dt_inicial = false, $dt_final = false, $tp_parcela = false, $paga = 0, $tipoPg = false, $dtCredito = false, $order = false, $formaBaixa = null)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'nr_tipo_parcela', 'tp_parcela', 'dt_parcela',
                'acrescimo', 'desconto', 'vl_parcela', 'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa',
                'vl_total_pago', 'tp_baixa', 'id_negociacao', 'id_renegociacao', 'id_banco','obs_baixa','dt_parcela_2avia', 'fm_baixa'))
            ->where('p.id_contrato = ?', $contrato)
            ->where('p.pago = "?"', $paga);

        if ($tp_parcela) {
            $parcelas = $parcelas->where('p.tp_parcela IN ' . $tp_parcela);
        }
        if ($tipoPg && $paga == 1) {
            $parcelas = $parcelas->where('p.tp_baixa IN ' . $tipoPg);
        }

        if ($formaBaixa) {
            $parcelas = $parcelas->where('p.fm_baixa IN ("' . $formaBaixa . '")');
        }

        //testa se possui um periodo
        if ($dt_inicial && $dt_final) {
            if ($paga == 1) {
                //testa se e por data de credito ou pagamento
                if ($dtCredito == 'C') {
                    $parcelas = $parcelas->where('p.dt_credito BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
                } elseif (is_array($dtCredito)) {
                    $parcelas = $parcelas->where('p.dt_credito BETWEEN "' . Helper::getInputDate($dtCredito['de']) . '" AND "' . Helper::getInputDate($dtCredito['ate']) . '" AND ' .
                        'p.dt_pagamento BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
                } else {
                    $parcelas = $parcelas->where('p.dt_pagamento BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
                }
            } else {
                $parcelas = $parcelas->where('p.dt_parcela BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
            }
        }
        
        if (!$order) {
            $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();
        } else {
            $parcelas = $parcelas->order("$order")->query()->fetchAll();
        }

        return $parcelas;
    }

    public static function parcelaTodasByContrato($contrato, $dt_inicial = false, $dt_final = false, $tp_parcela = false, $paga, $tipoPg = false, $dtCredito = false, $order = false, $formaBaixa = null)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'tp_parcela', 'dt_parcela',
                'acrescimo', 'desconto', 'vl_parcela', 'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa',
                'vl_total_pago', 'tp_baixa', 'id_negociacao', 'id_banco','obs_baixa','dt_parcela_2avia', 'fm_baixa', 'dt_reajuste', 'vl_indice'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('tx_juros'))
            ->where('p.id_contrato = ?', $contrato)
            ->where('c.tx_juros > 0')
            ->where('p.tp_parcela != "NE"');

        if ($tp_parcela) {
            $parcelas = $parcelas->where('p.tp_parcela IN ' . $tp_parcela);
        }
        //testa se possui um periodo
        if ($dt_inicial && $dt_final) {          
            $parcelas = $parcelas->where('p.dt_parcela BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
        }
        
        if (!$order) {
            $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();
        } else {
            $parcelas = $parcelas->order("$order")->query()->fetchAll();
        }

        return $parcelas;
    }

    /**
     * Busca todas parcelas pagas de um contrato na tabela de parcela historico
     * @param $contrato
     * @param bool $dt_inicial
     * @param bool $dt_final
     * @param bool $tp_parcela
     * @param int $paga
     * @param bool $tipoPg
     * @param bool $dtCredito
     * @return Contrato|Zend_Db_Select
     */
    public static function parcelaHistoricoByContrato($contrato, $dt_inicial = false, $dt_final = false, $tp_parcela = false, $paga = 0, $tipoPg = false, $dtCredito = false, $formaBaixa = null)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA_HISTORICO), array('id_parcela_contrato', 'id_parcela', 'tp_parcela', 'dt_parcela',
                'acrescimo', 'desconto', 'vl_parcela', 'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa', 'vl_total_pago',
                'tp_baixa', 'id_negociacao', 'id_renegociacao', 'id_banco', 'fm_baixa'))
            ->where('p.id_contrato = ?', $contrato)
            ->where('p.pago = "?"', $paga);

        //testa se existe tipos especificos de parcela
        if ($tp_parcela) {
            $parcelas = $parcelas->where('p.tp_parcela IN ' . $tp_parcela);
        }
        //testa se e de pagas
        if ($tipoPg && $paga == 1) {
            $parcelas = $parcelas->where('p.tp_baixa IN ' . $tipoPg);
        }
        
        if ($formaBaixa) {
            $parcelas = $parcelas->where('p.fm_baixa IN ("' . $formaBaixa . '")');
        }
        //testa se possui um periodo
        if ($dt_inicial && $dt_final) {
            if ($paga == 1) {
                //testa se e por data de credito ou de pagamento
                if ($dtCredito == 'C') {
                    $parcelas = $parcelas->where('p.dt_credito BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
                } elseif (is_array($dtCredito)) {
                    $parcelas = $parcelas->where('p.dt_credito BETWEEN "' . Helper::getInputDate($dtCredito['de']) . '" AND "' . Helper::getInputDate($dtCredito['ate']) . '" AND ' .
                        'p.dt_pagamento BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
                } else {
                    $parcelas = $parcelas->where('p.dt_pagamento BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
                }
            } else {
                $parcelas = $parcelas->where('p.dt_parcela BETWEEN "' . Helper::getInputDate($dt_inicial) . '" AND "' . Helper::getInputDate($dt_final) . '" ');
            }
        }
        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();

        return $parcelas;

    }

    /*
     * Busca as parcelas nao pagas atrasadas do contrato pelo id do mesmo
     * @param date dt_inicial
     * @param date dt_final
     * @param string tp_parcela (string no formato '("TIPO","TIPO",...,"TIPO)' para os tipos de parcelas)
     */
    public static function parcelasAtrasadasByContrato($contrato, $dt_final = false, $tp_parcela = false, $paga = 0, $tipoPg = false)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'nr_tipo_parcela', 'tp_parcela', 'dt_parcela', 'acrescimo', 'desconto', 'vl_parcela',
                'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa', 'vl_total_pago', 'tp_baixa', 'id_negociacao','dt_parcela_2avia'))
            ->where('p.id_contrato = ?', $contrato)
            ->where('p.pago = "?"', $paga);

        if ($tp_parcela) {
            $parcelas = $parcelas->where('p.tp_parcela IN ' . $tp_parcela);
        }
        if ($tipoPg && $paga == 1) {
            $parcelas = $parcelas->where('p.tp_baixa IN ' . $tipoPg);
        }
        //testa se possui um periodo
        if ($dt_final) {
            $parcelas = $parcelas->where('p.dt_parcela <= "' . Helper::getInputDate($dt_final) . '" ');
        }
        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();

        $count = 0;
        foreach ($parcelas as $key => &$parcela) {
            $parcela['atraso'] = Helper::date_diff($parcela['dt_parcela'], date('Y-m-d'));
            if ($parcela['atraso'] < 0) {
                $parcela['atraso'] = 0;
            }
            if ($parcela['atraso'] > 30) {
                $count++;
            }
            $parcela['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);
        }
        if ($count > 0) {
            return array();
        } else {
            return $parcelas;
        }
    }

    /*
     * Busca as parcelas nao pagas do contrato pelo id do mesmo e retorna todos os dados completos
     * @param date dt_inicial
     * @param date dt_final
     * @param string tp_parcela (string no formato '("TIPO","TIPO",...,"TIPO)' para os tipos de parcelas)
     */
    public static function parcelaCompletaByContrato($contrato, $dt_inicial = false, $dt_final = false, $tp_parcela = false, $paga = 0)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'nr_tipo_parcela', 'tp_parcela',
            'dt_parcela', 'acrescimo', 'desconto', 'vl_parcela', 'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa', 'vl_total_pago', 'tp_baixa', 'id_negociacao','dt_parcela_2avia'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('c.nr_parcela', 'idDoContrato' => 'id'))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('juros', "multa", 'tp_juros', 'tp_multa'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->join(array('ps' => TB_PESSOA), 'ps.id = c.id_pessoa', array('id', 'nm_pessoa', 'email', "nr_telefone", "nr_celular", "nr_recado"))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = c.id_pessoa', array('nm_profissao'))
            ->where('p.id_contrato = ?', $contrato)
            ->where('p.pago = "?"', $paga);

        if ($tp_parcela) {
            $parcelas = $parcelas->where('p.tp_parcela IN ' . $tp_parcela);
        }

        //testa se possui um periodo
        if ($dt_inicial && $dt_final) {
            if ($paga == 1) {
                $parcelas = $parcelas->where('p.dt_pagamento BETWEEN "' . Helper::dataParaAmericano($dt_inicial) . '" AND "' . Helper::dataParaAmericano($dt_final) . '" ');
            }
            else if ('p.dt_parcela_2avia' != NULL && $_POST['dtVencimento'] == '1') {
                $parcelas = $parcelas->where('p.dt_parcela_2avia BETWEEN "' . Helper::dataParaAmericano($dt_inicial) . '" AND "' . Helper::dataParaAmericano($dt_final) . '" ');
            }
            else {
                $parcelas = $parcelas->where('p.dt_parcela BETWEEN "' . Helper::dataParaAmericano($dt_inicial) . '" AND "' . Helper::dataParaAmericano($dt_final) . '" ');                
            }
        }
        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();

        foreach ($parcelas as &$parcela) {
            $parcela['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);
        }

        return $parcelas;
    }

    /*
     * Busca as parcelas nao pagas atrasadas do contrato pelo id do mesmo e retorna todos os dados completos
     * Cliente em atraso e aquele que so esta em atraso ate 30 dias com uma parcela apenas
     * @param date dt_inicial
     * @param date dt_final
     * @param string tp_parcela (string no formato '("TIPO","TIPO",...,"TIPO)' para os tipos de parcelas)
     */
    public static function parcelasAtrasadasCompletaByContrato($contrato, $dt_final = false, $tp_parcela = false, $paga = 0, $profissao = 0)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()->
        from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'nr_tipo_parcela', 'tp_parcela', 'dt_parcela', 'acrescimo', 'desconto', 'vl_parcela',
            'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa', 'vl_total_pago', 'tp_baixa', 'id_negociacao','dt_parcela_2avia'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('c.nr_parcela', 'idDoContrato' => 'id'))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('juros', "multa", 'tp_juros', 'tp_multa'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->join(array('ps' => TB_PESSOA), 'ps.id = c.id_pessoa', array('id', 'nm_pessoa', 'email', "nr_telefone", "nr_celular", "nr_recado"));

        if ($profissao == 1)
            $parcelas = $parcelas->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = c.id_pessoa', array('nm_profissao'));

        $parcelas = $parcelas->where('p.id_contrato = ?', $contrato)
            ->where('p.pago = "?"', $paga);

        if ($tp_parcela) {
            $parcelas = $parcelas->where('p.tp_parcela IN ' . $tp_parcela);
        }

        //testa se possui um periodo
        if ($dt_final) {
            $parcelas = $parcelas->where('p.dt_parcela <= "' . Helper::dataParaAmericano($dt_final) . '" ');
        }
        $parcelas = $parcelas->order('dt_parcela')->query()->fetchAll();

        $count = 0;
        foreach ($parcelas as $key => &$parcela) {
            $parcela['atraso'] = Helper::date_diff($parcela['dt_parcela'], date('Y-m-d'));
            if ($parcela['atraso'] < 0) {
                $parcela['atraso'] = 0;
            }
            if ($parcela['atraso'] > 30) {
                $count++;
            }
            $parcela['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);
        }
        if ($count > 0) {
            return array();
        } else {
            return $parcelas;
        }
    }

    //retorna parcelas sinal pagas do contrato
    public static function parcelasSinalPagasByContrato($contrato)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()->
        from(array('p' => TB_PARCELA), array('valorSinal' => 'SUM(vl_parcela)', 'id_parcela_contrato', 'id_parcela', 'tp_parcela', 'dt_parcela'))->
        where('p.id_contrato = ?', $contrato)->where('p.pago = "1"')->
        where('p.tp_parcela = "S"')->
        order('dt_parcela')->query()->fetchAll();
        for ($i = 0; $i < count($parcelas); $i++) {
            $parcelas[$i]['dt_parcela'] = Helper::getDate($parcelas[$i]['dt_parcela']);
        }
        return $parcelas;
    }

    //seleciona a parcela pelo id
    public static function parcelaById($id)
    {
        $parcela = self::getInstance();
        $parcela = $parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id',array())
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra','lote'))
            ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa','email','nr_celular'))
            ->where('p.id_parcela_contrato = ?', $id)
            ->query()->fetch();
            
        $parcela['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);
        $parcela['nm_pessoa'] = utf8_encode($parcela['nm_pessoa']);

        return $parcela;
    }

    //mtodo utilizado para buscar as parcelas geradas por outros bancos no mdulo emisso multibanco
    public static function buscaParcelasPeloIdParacelaContrato($idParcelas, $banco)
    {
        $idParcelas = implode("','", $idParcelas);
        //busca o id_banco_conta do banco selecionado
        $idBancoConta = (new Banco())->fetchRow('id = ' . $banco)->id_banco_conta;
        
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', '')
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra','lote'))
            ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa','email','nr_celular'))
            ->joinLeft(['b' => TB_BANCO], 'c.id_banco = b.id', ['idBancoConta' => 'b.id_banco_conta', 'idBanco' => 'b.id'])
            ->where("p.id_parcela_contrato in ('" . $idParcelas . "')")
            //->where('p.id_banco_boleto != ' . $idBancoConta . ' AND p.id_banco_boleto IS NOT NULL') comentado por causa que no estava aparecendo o alterna que j estava emitido
            ->query()->fetchAll();
            
        foreach ($parcelas as $k => $parcela) {
            $parcelas[$k]['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);
            $parcelas[$k]['nm_pessoa'] = utf8_encode($parcela['nm_pessoa']);
        }
        
        return $parcelas;
    }

    /**
     * Busca o valor das parcelas pagas por periodo de determinado contrato
     * @param $idContrato
     * @param bool $dt_inicial
     * @param bool $dt_final
     * @return array|Contrato
     */
    public static function valorParcelasPagasByContrato($idContrato, $dt_inicial = false, $dt_final = false, $tpExcluido = false, $filtroData = false, $parcSinal = false)
    {
        $filtroData = ($filtroData && $filtroData == 'DC') ? 'p.dt_credito' : 'p.dt_pagamento';
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('valorParcela' => 'SUM(vl_parcela)', 'valorMulta' => 'SUM(vl_multa)',
                'valorJuros' => 'SUM(vl_juros)', 'valorTotal' => 'SUM(vl_total_pago)', 'desconto' => 'SUM(desconto)', 'acrescimo' => 'SUM(acrescimo)'))
            ->where('p.id_contrato = ?', $idContrato)->where('p.pago = "1"');

        $parcelas = $parcelas->where($filtroData . ' >= "' . $dt_inicial . '" AND ' . $filtroData . ' <= "' . $dt_final . '"');

        if ($tpExcluido) {
            $parcelas = $parcelas->where('p.tp_baixa IN ("'.$tpExcluido.'")');
        }
        if($parcSinal){
            $parcelas = $parcelas->where('p.tp_parcela != "'. $parcSinal . '"');
        }

        $parcelas = $parcelas->query()->fetch();
        return $parcelas;
    }

    /**
     * ESTE MTODO SERVE UNICO E EXCLUSIVAMENTE PARA A GERAO DO DIMOB
     * Busca o valor das parcelas pagas por periodo de determinado contrato
     * @param $idContrato
     * @param bool $dt_inicial
     * @param bool $dt_final
     * @return array|Contrato
     */
    public static function valorParcelasPagasByContratoDimob($idContrato, $dt_inicial = false, $dt_final = false, $tpExcluido = false, $filtroData = false)
    {
        $filtroData = ($filtroData && $filtroData == 'DC') ? 'p.dt_credito' : 'p.dt_pagamento';
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('valorParcela' => 'SUM(vl_parcela)', 'valorMulta' => 'SUM(vl_multa)',
                'valorJuros' => 'SUM(vl_juros)', 'valorTotal' => 'SUM(vl_total_pago)', 'desconto' => 'SUM(desconto)', 'acrescimo' => 'SUM(acrescimo)'))
            ->where('p.id_contrato = ?', $idContrato)
            ->where('p.pago = "1"')
            ->where('YEAR('.$filtroData . ') >= "' . $dt_inicial . '" AND YEAR(' . $filtroData . ') <= "' . $dt_final . '"');

        if ($tpExcluido&&is_array($tpExcluido)) {
            $tpExcluido = implode('","', $tpExcluido);
            $parcelas = $parcelas->where('p.tp_baixa IN ("'.$tpExcluido.'")');
        }

        $parcelas = $parcelas->query()->fetch();
        return $parcelas;
    }

    /**
     * ESTE MTODO SERVE UNICO E EXCLUSIVAMENTE PARA A GERAO DO DIMOB
     * Busca o valor das parcelas pagas no histirico por periodo de determinado contrato
     * @param $idContrato
     * @param bool $dt_inicial
     * @param bool $dt_final
     * @return Contrato|mixed
     */
    public static function valorParcelasPagasHistoricoByContratoDimob($idContrato, $dt_inicial = false, $dt_final = false, $tpExcluido = false, $filtroData = false)
    {
        $filtroData = ($filtroData && $filtroData == 'DC') ? 'p.dt_credito' : 'p.dt_pagamento';
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()->
        from(array('p' => TB_PARCELA_HISTORICO), array('id_contrato', 'valorParcela' => 'SUM(vl_parcela)', 'valorMulta' => 'SUM(vl_multa)',
            'valorJuros' => 'SUM(vl_juros)', 'valorTotal' => 'SUM(vl_total_pago)', 'desconto' => 'SUM(desconto)', 'acrescimo' => 'SUM(acrescimo)'))
        ->where('p.id_contrato = ?', $idContrato)
        ->where('p.pago = "1"')
        ->where('YEAR('.$filtroData . ') >= "' . $dt_inicial . '" AND YEAR(' . $filtroData . ') <= "' . $dt_final . '"');

        if ($tpExcluido&&is_array($tpExcluido)) {
            $tpExcluido = implode('","', $tpExcluido);
            $parcelas = $parcelas->where('p.tp_baixa IN ("'.$tpExcluido.'")');
        }

        $parcelas = $parcelas->query()->fetch();
        return $parcelas;
    }

    /**
     * @param $idContrato
     * @return mixed
     */
    public static function getUltimaPaga($idContrato)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('dt_pagamento'))
            ->where('p.id_contrato = ?', $idContrato)
            ->where('p.pago = "1"')
            ->order('dt_pagamento DESC')
            ->query()->fetchAll();

        return $parcelas[0]['dt_pagamento'];
    }

    /**
     * Busca o valor das parcelas pagas no histirico por periodo de determinado contrato
     * @param $idContrato
     * @param bool $dt_inicial
     * @param bool $dt_final
     * @return Contrato|mixed
     */
    public static function valorParcelasPagasHistoricoByContrato($idContrato, $dt_inicial = false, $dt_final = false, $tpExcluido = false, $filtroData = false)
    {
        $filtroData = ($filtroData && $filtroData == 'DC') ? 'p.dt_credito' : 'p.dt_pagamento';

        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()->
        from(array('p' => TB_PARCELA_HISTORICO), array('valorParcela' => 'SUM(vl_parcela)', 'valorMulta' => 'SUM(vl_multa)',
            'valorJuros' => 'SUM(vl_juros)', 'valorTotal' => 'SUM(vl_total_pago)', 'desconto' => 'SUM(desconto)', 'acrescimo' => 'SUM(acrescimo)'))->
        where('p.id_contrato = ?', $idContrato)->where('p.pago = "1"')->
        where($filtroData . ' >= "' . $dt_inicial . '" AND ' . $filtroData . ' <= "' . $dt_final . '"');

        if ($tpExcluido) {
            $parcelas = $parcelas->where('p.tp_baixa IN ("'.$tpExcluido.'")');
        }

        $parcelas = $parcelas->query()->fetch();
        return $parcelas;
    }

    //seleciona todos os dados de uma parcela pelo id
    public static function getParcelaCompletaById($id)
    {
        $parcela = self::getInstance();
        $parcela = $parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('id_contrato' => 'id', 'c.nr_parcela'))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('id_banco' => 'id', 'juros', 'multa', 'tp_multa', 'tp_juros'))
            ->where('p.id_parcela_contrato = ?', $id)
            ->query()->fetch();
        $parcela['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);

        return $parcela;
    }

    //busca as informaes das parcelas contidas na tabela, PARCELA_HISTORICO
    public static function getParcelaHistoricoCompletaById($idParcela)
    {
        $parcela = self::getInstance();

        $parcela = $parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA_HISTORICO), array('*'))
            ->join(array('c' => TB_CONTRATO_HISTORICO), 'p.id_contrato = c.id', array('id_contrato' => 'id', 'c.nr_parcela'))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('id_banco' => 'id', 'juros', 'multa', 'tp_multa', 'tp_juros'))
            ->where('p.id_parcela_contrato = ?', $idParcela)
            ->query()->fetch();
        $parcela['dt_parcela'] = Helper::getDate($parcela['dt_parcela']);

        return $parcela;
    }

    /*
     * Altera nas parcelas o id_remessa para o passado por parametro
     * $param string $id, string $idRemessa
     * @return boolean $parcela->save()
     */
    public static function updateRemessaById($id, $idRemessa)
    {
        $parcela = self::getInstance();
        $parcela = $parcela->fetchRow('id_parcela_contrato = ' . $id);
        $parcela->id_remessa = $idRemessa;

        return $parcela->save();
    }

    /**
     * Seta null todas as remessas das parcelas pelo id da remessa
     * @param $idRemessa
     * @return bool
     */
    public static function cancelaRemessa($idRemessa)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->fetchAll('id_remessa = ' . $idRemessa);

        $retorno = true;
        $contrato = null;
        try {
            foreach ($parcelas as $parcela) {
                //Criado condicao para verificar se parcelas sao iguais!
                if ($contrato != $parcela['id_contrato']) {
                    (new Relacionamento())->saveContato(76, date('Y-m-d'), $parcela['id_contrato'], 'Log: Remessa Cancelada N'.$idRemessa);
                    $contrato = $parcela['id_contrato'];
                }
                self::updateRemessaById($parcela['id_parcela_contrato'], null);
            }
        } catch (Exception $e) {
            $retorno = false;
        }

        return $retorno;
    }

    /** Busca parcelas que podem ser reajustaveis a partir da data e contrato
     *
     * @param $data
     * @param $contrato
     * @return bool
     */
    public static function findParcelaReajustavel($data, $contrato, $tpParcelas = false)
    {
        $parcela = self::getInstance();
        $parcela = $parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), '*')
            ->where("p.dt_parcela >= '$data'")
            ->where("p.id_contrato = $contrato")
            ->where("p.fl_reajustavel = '1'")
            ->where("p.pago = '0'")
            ->where('tp_parcela in ("N","I","C")')
            ->query()->fetchAll();

        return $parcela;
    }
    public static function findReajusteParcela($post, $count = false)
    {
        $select = "*";
        if($count){
            $select = "COUNT(*) as contador";
        }
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];
        $array = array(
            0 => 'hr.id',
            1 => 'hr.idContrato',
            2 => 'e.nm_empreendimento',
            3 => 'p.nm_pessoa',
            4 => 'l.quadra',
            5 => 'l.lote',
            6 => 'hr.data',
            8 => 'agrIndice.descricao',
        );

        if ($search) {
            $where = 'hr.idContrato LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search .'%"';
        }
        $tb_reajuste = new HistoricoReajuste();
        $adapter = $tb_reajuste->getAdapter();
        $reajustes = $adapter->select()->distinct()
            ->from(array('hr' => TB_HISTORICO_REAJUSTE), $select)
            ->join(array('c' => TB_CONTRATO), 'hr.idContrato = c.id', null)
            ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', 'nm_pessoa')
            ->joinLeft(array('ie' => TB_INDICE_EMPREENDIMENTO), 'ie.id_indice_empreendimento = hr.id_indice', array('idIndice' => 'id_indice', 'fl_periodo', 'fl_periodo_adc'))
            ->joinLeft(array('agrIndice'=> TB_AGRUPADA),'agrIndice.idTabela = "12" AND agrIndice.idCampo = ie.id_indice', array('nmIndice' => 'descricao'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra','lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', ['nm_empreendimento']);

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']->getSuper() != '1') {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $reajustes->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $reajustes = $reajustes->where($where);
        }
        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $reajustes = $reajustes->limit($post['length'], $post['start']);
            }
        $orderByQuery=[];
        if(is_array($order)){
            foreach ($order as $ord){
                $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];
            }
        }
        foreach ($_POST['columns'] as $key=>$coluna){
            if($coluna['search']['value']){
                $reajustes = $reajustes->where($array[$key]." like ?","%".$coluna['search']['value']."%");
            }
        }
        $reajustes = $reajustes->order(implode(',', $orderByQuery))->query()->fetchAll();

        //Tb agrupada nova
        foreach ($reajustes as &$reajuste) {
            $tbAgrupada = AgrupadaGeral::buscar('12', $reajuste['idIndice']);
            $reajuste['nmIndice'] = $tbAgrupada['descricao'];
        }

        return $reajustes;
    }

    /**
     * Busca o id do empreendimento caso seja integrado
     * @param $p
     * @return bool
     */
    public static function getIntegracaoEmpreendimento($idParcela, $tesouraria = false)
    {
        $dados = Parcela::getDefaultAdapter()->select()
            ->from(array('p' => TB_PARCELA), null)
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('id_pessoa'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('*'));
            
        if (!$tesouraria)
            $dados = $dados->join(array('b' => TB_BANCO), 'b.id = p.id_banco', array('id_finan'));

        $dados = $dados->where('p.id_parcela_contrato = ' . $idParcela)->query()->fetch();

        if ($dados['fl_integracao'] == '1') {
            return $dados;
        } else {
            return false;
        }
    }

    /**
     * Busca todos os dados da parcela para exibicao em baixa e status
     * @param $idParcela
     * @return mixed
     */
    public static function getParcela($idParcela)
    {

        $dados = Parcela::getDefaultAdapter()->select()
            ->from(array('p' => TB_PARCELA), ['pago','tp_parcela','id_parcela','desconto', 'id_contrato'])
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', null)
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', null)
            ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', 'nm_pessoa')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', ['quadra', 'lote'])
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', ['nm_empreendimento', 'id_empreendimento' => 'id'])
            ->where('p.nr_boleto = ' . (int)$idParcela)
            ->where('b.cd_banco = "748"')
            ->query()->fetch();

        if (!$dados) {
            $dados = Parcela::getDefaultAdapter()->select()
                ->from(array('p' => TB_PARCELA), ['pago','tp_parcela','id_parcela','desconto', 'id_contrato'])
                ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id')
                ->join(array('b' => TB_BANCO), 'b.id = c.id_banco')
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', 'nm_pessoa')
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', ['quadra', 'lote'])
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', ['nm_empreendimento', 'id_empreendimento' => 'id'])
                ->where('p.id_parcela_contrato = ' . $idParcela)
                ->where('b.cd_banco != "748"')
                ->query()->fetch();
        }

        return $dados;
    }

    /**
     * Retornar um array com as informacoes da parcela pesquisada, baseado no id de contrato
     */
    public static function getTitulos($id, $parcelaMigrada = '0')
    {
        if ($parcelaMigrada == '1') {
            $parcelaMigrada = 'p.id_parcela_contrato_antigo = '. (int)$id;
        } else {
            $parcelaMigrada = 'p.id_parcela_contrato = '.(int)$id;
        }
        
        $parcelas = array();
        // Pesquisa 1 via de SICREDI e RIBEIRO
        $parcelasPrimeira = Parcela::getDefaultAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->joinLeft(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('c.nr_parcela'))
            ->joinLeft(array('b' => TB_BANCO), 'b.id = c.id_banco', ['conta_corrente', 'conta_corrente_dv', 'agencia', 'agencia_dv'])
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
            ->joinLeft(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento', 'id_empreendimento' => 'id'))
            ->joinLeft(['ta' => TB_AGRUPADA], 'b.cd_banco = ta.idCampo AND idTabela = "9"', 'descricao')
            ->joinLeft(array('tp' => TB_TIPO_LOTEAMENTO), 'tp.id_tipo_loteamento = e.id_tipo_loteamento', array('ds_grupo', 'ds_subgrupo', 'ds_tipo_loteamento'))
            ->where($parcelaMigrada  . ' || p.nr_boleto = ' .(int)$id)
            ->query()->fetchAll();
            
        if ($parcelasPrimeira) {
            if (count($parcelasPrimeira) > 1) {
                foreach ($parcelasPrimeira as $k => $parcela) {
                    $parcelasPrimeira[$k]['situacao'] = 'ATIVO';
                }
            } else {
                $parcelasPrimeira[0]['situacao'] = 'ATIVO';
            } 
            $parcelas = $parcelasPrimeira;
        }
        // Pesquisa 2 via de SICREDI e RIBEIRO
        $parcelasSegunda = Parcela::getDefaultAdapter()->select()
        ->from(array('p' => TB_PARCELA_2VIA), array('*'))
        ->joinLeft(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('c.nr_parcela'))
        ->joinLeft(array('b' => TB_BANCO), 'b.id = c.id_banco', ['conta_corrente', 'conta_corrente_dv', 'agencia', 'agencia_dv'])
        ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
        ->joinLeft(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
        ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento', 'id_empreendimento' => 'id'))
        ->joinLeft(['ta' => TB_AGRUPADA], 'b.cd_banco = ta.idCampo AND idTabela = "9"', 'descricao')
        ->where($parcelaMigrada  . ' || p.nr_boleto = ' .(int)$id)
        ->query()->fetchAll();

        if ($parcelasSegunda) {
            if (count($parcelasSegunda) > 1) {
                foreach ($parcelasSegunda as $k => $parcela) {
                    $parcelasSegunda[$k]['situacao'] = 'INATIVO 2AVIA';
                }
            } else {
                $parcelasSegunda[0]['situacao'] = 'INATIVO 2AVIA';
            }
            $parcelas = array_merge($parcelas, $parcelasSegunda);
            
        }
        
        //Pesquisa na tabela PARCELA_HISTORICO as parcelas que ja foram pagas
        $parcelaHistorico = new ParcelaHistorico();
        $parcelasHist = $parcelaHistorico->getAdapter()->select()
            ->from(array('p' => TB_PARCELA_HISTORICO), array('*'))
            ->joinLeft(array('c' => TB_CONTRATO_HISTORICO), 'p.id_contrato = c.id', array('c.nr_parcela'))
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
            ->joinLeft(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento', 'id_empreendimento' => 'id'))
            ->where($parcelaMigrada  . ' || p.nr_boleto = ' .(int)$id)
            ->query()->fetch();
        if ($parcelasHist) {
            $parcelasHist['situacao'] = 'INATIVO';
            $parcelasHist = array_fill_keys([0], $parcelasHist);
            $parcelas = array_merge($parcelas, $parcelasHist);
        }
        
        return $parcelas;
    }

    /*
     * Retorna a quantidade de cada tipo de parcela de um contrato
     */
    public function getQtdeParcelas($id, $idNegociacao = '', $idRenegociacao = '')
    {
        if ($idNegociacao) {
            $idNegociacao = ($idNegociacao)?' AND id_negociacao in ("'.$idNegociacao.'")':'';
        }
        if ($idRenegociacao) {
            $idRenegociacao = ($idRenegociacao)?' AND id_renegociacao in ("'.$idRenegociacao.'")':'';
        }
        
        return Parcela::getDefaultAdapter()->select()
            ->from(array('p' => TB_PARCELA), array(
                'QtdeNormal'=>'SUM(tp_parcela IN ("N","E","NE"))',
                'QtdeRenegociada'=>'SUM(tp_parcela IN ("N","E","NE")'.$idRenegociacao.')',
                'QtdeSinal'=>'SUM(tp_parcela IN ("S","E","SE"))',
                'QtdeIntercalada'=>'SUM(tp_parcela IN ("I","E","IE"))',
                'QtdeChave'=>'SUM(tp_parcela IN ("C","E","CE"))',
                'QtdeNegociada'=>'SUM(tp_parcela IN ("G","E")'.$idNegociacao.')',
                'QtdeQuitadas'=>'SUM(tp_parcela IN ("Q","E"))',
                'QtdeAvulsas'=>'SUM(tp_parcela IN ("A"))'
            ))
            ->where('p.id_contrato = '. $id)
            ->query()->fetch();
    }

    /*
     * Retorna todas parcelas com dados para a emissao dos boletos
     */
    public function findParcelasBoletos($empreendimento = null,$contrato = null,$banco = null,$tipos = null,$dataA = null,$dataB = null, $idsParcelas = null, $idParcelaAntigo = null)
    {
        $cdBanco = (new Banco())->getBanco($banco)['cd_banco'];
        $jurosMensal = '';

        if ($cdBanco == '274') {
            $jurosMensal = 'jurosMensal';
        }
        
        $listaParcelas = Parcela::getDefaultAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('dt_parcela','id_contrato','desconto','acrescimo','id_parcela_contrato','tp_parcela','id_parcela','obs','vl_parcela','id_renegociacao','id_negociacao',
                        'nr_boleto', 'ano_boleto_emissao', 'obs_parcela', 'cod_barras','linha_digitavel','cod_boleto_api','id_banco_boleto','nr_tipo_parcela', 'txid', 'pago', 'fl_envio', 
                        'vl_parcela_2avia', 'dt_parcela_2avia', 'id_taxa', 'desconto_2via', 'dt_credito', 'cod_layout_api', 'id_parcela_contrato_antigo', 'qrCode'))
            ->join(array('c' => TB_CONTRATO), 'c.id = p.id_contrato', array('id_banco','idContrato'=>'id', 'fl_desc_normal', 'vl_desc_normal', 'fl_desc_sinal', 'vl_desc_sinal', 'fl_desc_intercalada', 'vl_desc_intercalada', 'fl_desc_chave', 'vl_desc_chave'))
            ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('nm_pessoa','cliEndereco'=>'endereco', 'cliBairro'=>'nm_bairro', 'cliNrEndereco'=>'nr_endereco', 'cliCep'=>'nr_cep','email','nr_telefone','nr_celular', 'cliComplemento' => 'ds_complemento'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = pe.id', array('nr_cpf','nr_rg'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = pe.id', array('nr_cnpj','nm_fantasia'))
            ->joinLeft(array('cidp' => TB_CIDADE), 'cidp.id = pe.cd_cidade', array('cliCidade'=>'nome','cliUf'=>'uf'))
            ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('cd_banco','multa','juros', $jurosMensal, 'msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta', 'chave_pix'))
            ->join(array('bc' => TB_BANCO_CONTA), 'bc.id_banco_conta = b.id_banco_conta',array('cod_layout_api','nr_cooperativa','nr_carteira','nr_dias_permanencia'))
            ->joinLeft(array('la' => TB_LAYOUT), 'bc.cod_layout_api = la.id',array('pp_token','password','gerar_token','req_cliente_id'))
            ->joinLeft(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
            ->joinLeft(array('pjCedente' => TB_PESSOA_JURIDICA), 'pjCedente.nr_cnpj = b.cnpj_cedente', null)
            ->joinLeft(array('pfCedente' => TB_PESSOA_FISICA), 'pfCedente.nr_cpf = b.cpf_cedente', null)
            ->joinLeft(array('pCedente' => TB_PESSOA), 'pCedente.id = pjCedente.id_pessoa OR pCedente.id = pfCedente.id_pessoa', array('cedEndereco'=>'endereco', 'cedBairro'=>'nm_bairro', 'cedNrEndereco'=>'nr_endereco','cedComplemento'=>'ds_complemento','cedCep'=>'nr_cep','cedEmail'=>'email','cedTelefone'=>'nr_telefone','cedCelular'=>'nr_celular'))
            ->joinLeft(array('cidCedente' => TB_CIDADE), 'cidCedente.id = pCedente.cd_cidade', array('cedCidade'=>'nome','cedUf'=>'uf'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote','quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento'))
            ->join(array('tp' => TB_TIPO_LOTEAMENTO), 'tp.id_tipo_loteamento = e.id_tipo_loteamento', array('ds_grupo', 'ds_subgrupo', 'ds_tipo_loteamento'))
            ->group('p.id_parcela_contrato');

        if($empreendimento)
            $listaParcelas = $listaParcelas->where('e.id = ?', $empreendimento);
        if($banco)
            $listaParcelas = $listaParcelas->where('c.id_banco = '.$banco);
        if($contrato && $contrato != '*')
            $listaParcelas = $listaParcelas->where('id_contrato IN ("' . $contrato . '")');
        if($dataA && $dataB)
            $listaParcelas = $listaParcelas->where("dt_parcela BETWEEN '" . $dataA . "' AND '" . $dataB . "'");
        if($tipos)
            $listaParcelas = $listaParcelas->where("tp_parcela IN $tipos");
        if($idsParcelas && $idParcelaAntigo)
            $listaParcelas = $listaParcelas->Where("p.id_parcela_contrato_antigo IN ($idsParcelas)");
        elseif($idsParcelas)
            $listaParcelas = $listaParcelas->where("p.id_parcela_contrato IN ($idsParcelas)");

        return $listaParcelas->where('p.pago = "0"')->order(array('pe.nm_pessoa','c.id','p.dt_parcela'))->query()->fetchAll();
    }

    public static function ParcelasRelatorioPrevisao($empreendimento, $tp_parcelas, $post, $notParcNE = false, $banco_id = '*', $parcEmissao = '', $idContrato)
    {
        $parcelasSelect = Parcela::getDefaultAdapter()->select()
            ->from(array('parcela' => TB_PARCELA))
            ->join(array('contrato' => TB_CONTRATO), 'contrato.id = parcela.id_contrato', array())
            ->join(array('lote' => TB_LOTES), 'lote.id = contrato.id_lote', array('lote', 'quadra'))
            ->join(array('pessoa' => TB_PESSOA), 'pessoa.id = contrato.id_pessoa', 'nm_pessoa')
            ->where('lote.id_empreendimento = ?', $empreendimento->id)
            ->order(array($_POST['ordena']));
        
        if ($parcEmissao != '') {
            $parcelasSelect->where("fl_envio = '1'");
        }

        if ($idContrato != null) {
            $parcelasSelect->where('contrato.id = ?', $idContrato);
        }
               
        if (isset($_POST['tp_parcela']) && count($_POST['tp_parcela'])) {
            $parcelasSelect->where("parcela.tp_parcela IN " . $tp_parcelas);
        }
        if ($_POST['de'] && $_POST['ate']) {
            $parcelasSelect->where('parcela.dt_parcela >= ?', Helper::getInputDate($_POST['de']))
                ->where('parcela.dt_parcela <= ?', Helper::getInputDate($_POST['ate']));
        }
        if (isset($_POST['tp_pagamento']) && count($_POST['tp_pagamento'])) {
            $parcelasSelectNaoPagos = clone ($parcelasSelect);
            $parcelasSelect->where("parcela.tp_baixa IN ('" . implode("','", $_POST['tp_pagamento']) . "')");
        }
        if ($notParcNE) {
            $parcelasSelect ->where("tp_parcela NOT IN ('NE','SE','IE','CE','E')");
        }
        
        $parcelasSelectPagos = clone $parcelasSelect;
        $parcelasSelectNaoPagos = empty($parcelasSelectNaoPagos) ? clone ($parcelasSelect) : $parcelasSelectNaoPagos;

        if ($banco_id != '*') {
            $parcelasSelectNaoPagos->where("CASE WHEN parcela.id_banco_boleto IS NULL THEN contrato.id_banco = '{$banco_id}' ELSE banco.id = '{$banco_id}' and parcela.id_banco_boleto = banco.id_banco_conta END");
            $parcelasSelectPagos->where("parcela.id_banco=".$banco_id);
        }

        $parcelasSelectNaoPagos->join(array('banco' => TB_BANCO), 'banco.id = contrato.id_banco', array('juros', "multa"))
            ->where("parcela.pago = '0'");
        $parcelasPagas = $parcelasSelectPagos->where("parcela.pago = '1'")->query()->fetchAll();
        $parcelasNaoPagas = $parcelasSelectNaoPagos->where("parcela.pago = '0'")->query()->fetchAll();
        $parcelasPagaNPaga = array($parcelasPagas, $parcelasNaoPagas);

        return $parcelasPagaNPaga;
    }

    public static function findParcelaByIdContrato($idContrato)
    {
        $parcelas = self::getInstance();
        $parcelas = $parcelas->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('*'))
            ->where('p.id_contrato = ?', $idContrato)
            ->group('obs_baixa')
            ->query()->fetchAll();

        return $parcelas;
    }

    /**
     * Mtodo que retorna o valor do desconto se a parcela no estiver vencida
     * e se o contrato possuir a opo de desconto ativa no cadastro
     */
    public static function getDescontoParcela($contrato, $vlParcela1) {
//
        $flDesconto = 'S';
        $vlDesconto = 0;
        //Se a data da parcela for maior que a data atual passou do vencimento e no ter desconto
        if ($contrato['dt_parcela'] >= date('Y-m-d')) {
            switch ($contrato['tp_parcela']) {
                case 'N':
                    $flDesconto = $contrato['fl_desc_normal'];
                    $vlDesconto = $contrato['vl_desc_normal'];
                    break;
                case 'S':
                    $flDesconto = $contrato['fl_desc_sinal'];
                    $vlDesconto = $contrato['vl_desc_sinal'];
                    break;
                case 'I':
                    $flDesconto = $contrato['fl_desc_intercalada'];
                    $vlDesconto = $contrato['vl_desc_intercalada'];
                    break;
                case 'C':
                    $flDesconto = $contrato['fl_desc_chave'];
                    $vlDesconto = $contrato['vl_desc_chave'];
                    break;
            }
        }
        //Se for "Sem Desconto" valor zerado
//        if ($flDesconto == 'P') { //Se for "Porcentagem"
//            $vlDesconto = ($vlDesconto / 100) * $contrato['vl_parcela'];
//        }
        if ($flDesconto == 'P') { //Se for "Porcentagem"
            $vlDesconto = ($vlDesconto / 100) * $vlParcela1;
        }

        $retorno = [
            'vlDesconto' => $vlDesconto,
            'flDesconto' => $flDesconto
        ];

        return $retorno;
    }

    /**
     * Retorna a lista de clientes e a quantidade de boletos que cada um poss?i.
     */
    private static function listaDeClientesPorBoleto($parcelas)
    {
        $i = 0;
        $nome = $parcelas[0]['nm_pessoa'];
        $listaNomesClientes = [];

        foreach ($parcelas as $k => $parcela)
        {
            if ($nome == $parcela['nm_pessoa'])
            {
                $listaNomesClientes[$parcela['nm_pessoa']] = ++$i;
                $nome = $parcelas[$k + 1]['nm_pessoa'];
            } else {
                $i = 1;
                $nome = $parcelas[$k]['nm_pessoa'];
            }
        }

        return $listaNomesClientes;
    }

    /**
     * Retorna a lista de boletos ordenados por cliente, em forma crescente, do cliente que tem a menor quantidade de boletos,
     * para o que tem a maior quantidade de boletos.
     */
    public static function ordenacaoDeBoletosPorCliente($parcelas)
    {
        $listaNomesClientes = self::listaDeClientesPorBoleto($parcelas);
        $indice = 0;
        $limite = 50;
        $listaQuebrada = [];
        
        foreach ($listaNomesClientes as $j => $nmCliente) 
        {
            foreach ($parcelas as $parcela)
            {   
                if ($j == $parcela['nm_pessoa'])
                {
                    if ($limite > 0)
                    {
                        $listaQuebrada[$indice][] = $parcela;
                        $limite--;
                    } else {
                        $indice++;
                        $listaQuebrada[$indice][] = $parcela;
                        $limite = 50;
                    }
                } 
            }
            
            $limite = 50;
            $indice++;
        }

        //ordena os boletos por quantidade em ordem crescente.
        sort($listaQuebrada);

        return $listaQuebrada;
    }

    /**
     * Recebe uma lista de parcelas e quebra a mesma para que a quantidade de parcelas de uma cliente caiba em um bloco de 50.
     * Ex: caso ? lista de parcelas tenha 20 de Jo?o, 20 de Maria e 15 de Fernanda, o sistema deve gerar um bloco de 40 parcelas,
     * e outro bloco de 15 parcelas, pois o total de parcelas ultrapassa o limite de 50, e as parcelas de Fernanda n?o podem
     * ficar em dois blocos.
     */
    public static function ordenacaoDeBoletosPadrao($parcelas)
    {
        $listaQuebrada = self::ordenacaoDeBoletosPorCliente($parcelas);
        
        $aux = 0;
        $lista = [];
        $achou = false;

        for ($aux = 0; $aux < count($listaQuebrada);)
        {   
            $contador = count($listaQuebrada[$aux]);
            
            for ($i = $aux + 1; $i < count($listaQuebrada); $i++)
            {
                if (($contador + count($listaQuebrada[$i])) < 51)
                {
                    if (!$lista)
                    {
                        $lista[] = array_merge($listaQuebrada[$aux], $listaQuebrada[$i]);
                    } else {
                        foreach ($listaQuebrada[$i] as $dados)
                        {
                            // $lista[] = array_merge($lista[$aux], $dados);
                            array_push($lista[$aux], $dados);
                        }
                    }

                    $achou = true;
                    $contador += count($listaQuebrada[$i]);
                    unset($listaQuebrada[$i]); 
                    // sort($listaQuebrada);
                } else {
                    $aux++;
                    // sort($listaQuebrada);
                }
            }
            
            if ($achou)
            {
                unset($listaQuebrada[$aux]);
                // sort($listaQuebrada);
                $achou = false;
            }
        }
        
        $lista = array_merge($lista, $listaQuebrada);

        return $lista;
    }

    public function buscaNrBoletosAvulsosParcela($idBancoConta, $idBanco) {
        
        $minNrBoleto = (int)(new BancoConta())->fetchRow('id_banco_conta = ' . $idBancoConta)->nr_boleto;
        
        $minEmaxNrBoletoParcela = Parcela::getDefaultAdapter()->select();
        
        if ($minNrBoleto) {
            $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela->from(['p' => TB_PARCELA], ['maxNrBoleto' => 'MAX(p.nr_boleto)'])
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '');
        } else {
            $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela->from(['p' => TB_PARCELA], ['minNrBoleto' => 'MIN(p.nr_boleto)', 'maxNrBoleto' => 'MAX(p.nr_boleto)'])
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '');
        }
        
        $minEmaxNrBoletoParcela = $minEmaxNrBoletoParcela
            ->where("c.id_banco in ('" . $idBanco . "')")
            ->order('p.nr_boleto ASC')
            ->query()->fetch();
            
        if ($minEmaxNrBoletoParcela) {
            /**
             * Essa condio serve para casos em que o valor mnimo  maior ou igual ao o valor mximo,
             * nesse caso deve-se apenas retornar o valor mnimo e somar +1, em formato de array,
             * pois algumas partes do cdigo em EmissaoController,
             * tratam esse retorno como array.
             */
            if ($minNrBoleto >= $minEmaxNrBoletoParcela['maxNrBoleto'])
                return $minNrBoleto + 1;

            if ($minNrBoleto) {
                $minEmaxNrBoletoParcela['minNrBoleto'] = $minNrBoleto;
            }
    
            $buscaNrBoletosParcela = Parcela::getDefaultAdapter()->select()
                ->from(['p' => TB_PARCELA], 'nr_boleto')
                ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '')
                ->where("c.id_banco in ('" . $idBanco . "')")
                ->where('p.nr_boleto is not null')
                ->order('p.nr_boleto ASC')
                ->query()->fetchAll();
    
            $listaParcela = [];
    
            foreach ($buscaNrBoletosParcela as $nrBoleto) {
                $listaParcela[] = (int)$nrBoleto['nr_boleto'];
            }
            
            if ($minEmaxNrBoletoParcela['maxNrBoleto'] > 999999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 1000;
            } elseif ($minEmaxNrBoletoParcela['maxNrBoleto'] > 99999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 100;
            } elseif ($minEmaxNrBoletoParcela['maxNrBoleto'] > 9999) {
                $minEmaxNrBoletoParcela['maxNrBoleto'] = $minEmaxNrBoletoParcela['maxNrBoleto'] / 10;
            }
        
            $rangeParcela = range($minEmaxNrBoletoParcela['minNrBoleto'] + 1, (int)$minEmaxNrBoletoParcela['maxNrBoleto'] + 1);
            $rangeParcela = array_diff($rangeParcela, $listaParcela);

            /**
             * Esse if serve para casos em que no tenham ids livres entre o valor mnimo do nr_boleto da tabela BANCO_CONTA
             * e o valor de nr_boleto mximo das parcelas do banco selecionado, nesse caso o sistema retorno o valor mximo + 1.
             */
            if ($rangeParcela == null)
                return (int)$minEmaxNrBoletoParcela['maxNrBoleto'] + 1;
            
            return $rangeParcela;
        }

        return null;
    }

    public function getNrBoletoParcelaById($id) {

        return Parcela::getDefaultAdapter()->select()
            ->from(['p' => TB_PARCELA], 'nr_boleto')
            ->where('p.nr_boleto = ' . $id)
            ->query()->fetch();
    }

    public function getMaxNrBoletoParcelaEparcelaHistorico($idBanco) {

        $maxNrBoletoParcela = Parcela::getDefaultAdapter()->select()
            ->from(['p' => TB_PARCELA], ['nrBoleto' => 'MAX(nr_boleto)'])
            ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '')
            ->where("c.id_banco in ('" . $idBanco . "')")
            ->query()->fetch();

        $maxNrBoletoParcelaHistorico = (new ParcelaHistorico)->getDefaultAdapter()->select()
            ->from(['p' => TB_PARCELA_HISTORICO], ['nrBoleto' => 'MAX(nr_boleto)'])
            ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '')
            ->where("c.id_banco in ('" . $idBanco . "')")
            ->query()->fetch();

        if ($maxNrBoletoParcela['nrBoleto'] > $maxNrBoletoParcelaHistorico['nrBoleto']) {

            return $maxNrBoletoParcela['nrBoleto'];
        } elseif ($maxNrBoletoParcelaHistorico['nrBoleto'] > $maxNrBoletoParcela['nrBoleto']) {
            
            return $maxNrBoletoParcelaHistorico['nrBoleto'];
        }

        return null;
    }

    public function proximoNrBoletoBanco($banco){

        
        $historico = ParcelaHistorico::getDefaultAdapter()->select()
        ->from(['p' => TB_PARCELA_HISTORICO], ['p.nr_boleto','p.id_parcela_contrato','id_contrato'])
        ->join(['c' => TB_CONTRATO], 'c.id = p.id_contrato and c.id_banco = "' . $banco . '"', '')
        ->where('p.nr_boleto is not null')
        ->order('p.nr_boleto DESC')
        ->query()->fetch();

        $parcela = Parcela::getDefaultAdapter()->select()
        ->from(['p' => TB_PARCELA], ['p.nr_boleto','p.id_parcela_contrato','id_contrato'])
        ->join(['c' => TB_CONTRATO], 'c.id = p.id_contrato and c.id_banco = "' . $banco . '"', '')
        ->where('p.nr_boleto is not null')
        ->order('p.nr_boleto DESC')
        ->query()->fetch();
        
        if(isset($historico['nr_boleto']) && isset($parcela['nr_boleto'])&&$historico['nr_boleto']&& $parcela['nr_boleto']){
            if(intval($parcela['nr_boleto']) > intval($historico['nr_boleto'])){
                return intval($parcela['nr_boleto'])+1;
            }
            return intval($historico['nr_boleto'])+1;
        }
        elseif(isset($parcela['nr_boleto'])&&$parcela['nr_boleto']){
            return intval($parcela['nr_boleto'])+1;
        }
        elseif(isset($historico['nr_boleto'])&&$historico['nr_boleto']){
            return intval($historico['nr_boleto'])+1;
        }
        return 1;
    }
    public function consultaBoletoSemRegistro(){

        $parcela = Parcela::getDefaultAdapter()->select()
        ->from(['p' => TB_PARCELA])
        ->join(['b' => TB_BANCO_CONTA], 'p.id_banco_boleto = b.id_banco_conta')
        ->join(['l' => TB_LAYOUT], 'l.id = b.cod_layout_api')
        ->where('p.data_registro is null')
        ->where('p.nr_boleto is null')
        ->where('p.cod_boleto_api is not null')
        ->query()->fetchAll();
        
        return $parcela;
    }
    public function ultimasRegistradas(){

        $parcela = Parcela::getDefaultAdapter()->select()
        ->from(['p' => TB_PARCELA])
        ->where('p.data_registro is not null')
        ->order('p.data_registro DESC')
        ->query()->fetchAll();
        
        return $parcela;
    }
    public function registroBoleto($id,$nossoNumero,$codBarras,$linhaDigitavel,$qrCodePix){

        $parcela = self::getInstance();
        $parcela = $parcela->fetchRow('id_parcela_contrato = ' . $id);
        $parcela->nr_boleto = $nossoNumero;
        $parcela->cod_barras = $codBarras;
        $parcela->linha_digitavel = $linhaDigitavel; 
        $parcela->qrCode = $qrCodePix;
        $parcela->nosso_numero = $nossoNumero;
        $parcela->data_registro = date("Y-m-d H:i:s"); 
        return $parcela->save();
        
    }
}