<?php
class Ocorrencia{
	
	const ATRASO_MANHA = 1;
	const ATRASO_TARDE = 2;
	const ADIANTADA_MANHA = 3;
	const ADIANTADA_TARDE = 4;
	const FALTA_MANHA = 5;
	const FALTA_TARDE = 6;
	const FALTA_EXPEDIENTE = 7;
	
	private static function getMinutes($hora){
		$hora = explode(':',$hora);
		$minuto = $hora[1];	
		$hora = $hora[0] * 60;
		$minutos = $hora + $minuto;
		return $minutos;
	}
	
	/**
	 * @param Db_Grade $grade
	 * @param YYYY-mm-dd $data
	 * @param horaEntradaA, horaSaidaA ... $horario
	 */
	public static function getOcorrencias($grade, $horario, $data){
		$ocorrencias = array();
				
		if(!$grade instanceof Db_Rh_Grade) $grade = Db_Rh_Grade::find($grade);
		
		$dataAtual = date("Y-m-d");
		
		$expedientes = Ponto::getExpedienteDisponivel($grade, $data );
		
		$horaEntradaA = $horario["horaEntradaA"];
		$horaSaidaA = $horario["horaSaidaA"];
		$horaEntradaB = $horario["horaEntradaB"];
		$horaSaidaB = $horario["horaSaidaB"];
		
		if(in_array(Ponto::EXPEDIENTE_MANHA,$expedientes) && $data <= $dataAtual ){
			#detecta falta no dia
			if (
				empty($horaEntradaA) &&
				empty($horaSaidaA)
			){
				$ocorrencias[] = self::FALTA_MANHA;
			}
		}

		if(in_array(Ponto::EXPEDIENTE_TARDE,$expedientes) && $data <= $dataAtual ){
			#detecta falta no dia
			if (
				empty($horaEntradaB) &&
				empty($horaSaidaB)
			){
				$ocorrencias[] = self::FALTA_TARDE;
			}
		}

		if(in_array(self::FALTA_MANHA,$ocorrencias) && in_array(self::FALTA_TARDE,$ocorrencias)){
			$ocorrencias[] = self::FALTA_EXPEDIENTE;
			unset($ocorrencias[array_search(self::FALTA_MANHA,$ocorrencias)]);
			unset($ocorrencias[array_search(self::FALTA_TARDE,$ocorrencias)]);
			return $ocorrencias;
		}

		if(in_array(Ponto::EXPEDIENTE_MANHA,$expedientes)){
			#Atraso entrada manh
			$difHoraEntradaA = self::getMinutes($horaEntradaA) - self::getMinutes($grade->getHoraEntradaA());
			if($difHoraEntradaA > 0) $ocorrencias[] = self::ATRASO_MANHA;
			
			#Sada antecipada manh
			$difHoraSaidaA = self::getMinutes($horaSaidaA) - self::getMinutes($grade->getHoraSaidaA());
			if($difHoraSaidaA < 0 && !empty($horaSaidaA)) $ocorrencias[] = self::ADIANTADA_MANHA;
		}

		if(in_array(Ponto::EXPEDIENTE_TARDE,$expedientes)){		
			#Atraso entrada tarde
			$difHoraEntradaB = self::getMinutes($horaEntradaB) - self::getMinutes($grade->getHoraEntradaB());
			if($difHoraEntradaB > 0) $ocorrencias[] = self::ATRASO_TARDE;
			
			#Sada antecipada tarde
			$difHoraSaidaB = self::getMinutes($horaSaidaB) - self::getMinutes($grade->getHoraSaidaB());
			if($difHoraSaidaB < 0 && !empty($horaSaidaB)) $ocorrencias[] = self::ADIANTADA_TARDE;
		}
		
		return $ocorrencias;
		
		
	}
	
}