<?php

class Negociacao extends Zend_Db_Table_Abstract
{
    protected $_name = TB_NEGOCIACAO;

    /**
     * Retorna a quantidade de parcelas pertencentes a negociacao pelo ID
     * @param $id
     * @return mixed
     */
    public static function getNumeroParcelasById($id)
    {
        $quantidade = self::getDefaultAdapter()->select()->from(array('n' => TB_NEGOCIACAO), 'nr_quantidade_parcela')
            ->where('n.id = "' . $id . '"')
            ->query()->fetch();

        return $quantidade['nr_quantidade_parcela'];
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        //Feito para ordenar as colunas
        $order = $_POST['order'];

        $array = array(
            0 => 'n.id',
            1 => 'n.id_contrato',
            2 => 'p.nm_pessoa',
            3 => 'n.tp_operacao',
            4 => 'n.data',
            5 => 'n.dataBase',
            6 => 'e.nm_empreendimento',
            7 => 'l.quadra',
            8 => 'l.lote',
        );

        if ($search) {
            if ((int)$search) {
                $where = 'n.id LIKE "%' . (int)$search . '%" ';
            } else {
                $where = 'n.id LIKE "%' . $search . '%" ';
            }
            $where .= 'or n.id_contrato LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or n.data LIKE "%' . $search . '%" ';
            $where .= 'or DAY(n.data) = "' . $search . '" ';
            $where .= 'or MONTH(n.data) = "' . $search . '" ';
            $where .= 'or YEAR(n.data) = "' . $search . '" ';
            $where .= 'or n.dataBase LIKE "%' . $search . '%" ';
            $where .= 'or DAY(n.dataBase) = "' . $search . '" ';
            $where .= 'or MONTH(n.dataBase) = "' . $search . '" ';
            $where .= 'or YEAR(n.dataBase) = "' . $search . '" ';
        }

        $contratos = self::getDefaultAdapter()->select()
            ->from(array('n' => TB_NEGOCIACAO), '*')
            ->join(array('c' => TB_CONTRATO), 'c.id = n.id_contrato', null)
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra','lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'nm_empreendimento')
            ->where('c.fl_distrato = "0"')
            ->where('n.tp_operacao NOT IN ("Q")') // No busca negociacoes de quitacao
            ->order('n.data DESC');

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $contratos->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $contratos = $contratos->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $contratos = $contratos->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];
        //Verificando ainda a ao do distinct!!!
        $contratos = $contratos->order(implode(',', $orderByQuery))->distinct()->group('n.id')->query()->fetchAll();

        return $contratos;
    }


}
