<?php

class Lote extends Zend_Db_Table_Abstract
{

    protected $_name = TB_LOTES;
    static $loteInstacia;

    public function getLote($id)
    {
        return self::getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), '*')
            ->where('l.id = ?', $id)
            ->query()->fetch();
    }

    /**
     *
     * @param int $id_empreendimento
     * @param string $quadra
     * @param int $lote
     * @return  boolean
     */
    public function exist($id_empreendimento, $quadra, $lote)
    {
        $lt = $this->fetchRow($this->select()->where('id_empreendimento = ?', $id_empreendimento)->where('quadra = ?', $quadra)->where('lote = ? ', $lote));
        return ($lt instanceof Zend_Db_Table_Row);
    }

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false, $where = false)
    {
        $result = array();
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = Db::getInstance();
        if ($count && $offset === false && $page === false) {
            $select = "SELECT count(l.id) AS count FROM " . TB_LOTES . " l
				   JOIN " . TB_EMPREENDIMENTO . " e  ON e.id = l.id_empreendimento
				   WHERE CONCAT(l.id,' ',UPPER(e.nm_empreendimento),' ',l.lote,' ',l.quadra) LIKE {$termo}";
            if ($where) {
                $select .= " AND $where";
            }
        } else {
            $select = "SELECT *, l.id as idLote, r.reservado as reserva FROM " . TB_LOTES . " l
				   JOIN " . TB_EMPREENDIMENTO . " e  ON e.id = l.id_empreendimento
				   LEFT JOIN " . TB_CONTRATO . " c  ON c.id_lote = l.id
				   LEFT JOIN " . TB_RESERVA_LOTE . " r  ON l.id = r.cod_lote
				   WHERE CONCAT(l.id,' ',UPPER(e.nm_empreendimento),' ',l.lote,' ',l.quadra) LIKE {$termo} ";
            if ($where) {
                $select .= " AND $where";
            }
            $select .= ' GROUP BY l.id ORDER BY l.quadra, l.lote ';
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($count && $offset === false && $page === false) return $ids;

        return $ids;
    }

    //retorna uma instancia do objeto (Para uso de SINGLETON)
    public static function getInstance()
    {
        if (!self::$loteInstacia) {
            self::$loteInstacia = new Lote();
        }
        return self::$loteInstacia;
    }

    //Procura lote pelo id de lote e retorna o lote encontrado
    public static function loteById($id)
    {
        $lote = self::getInstance();
        $lote = $lote->getAdapter()->select()->from(array('l' => TB_LOTES), array('*'))
            ->where('l.id = ?', $id)->query()->fetch();

        return $lote;
    }

    /**
     *
     * @param integer $id
     * @return array
     */
    public static function findLoteEmpreendimento($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT l.id, l.lote, l.quadra, l.area, l.fl_construcao, l.fl_caucionado, e.nm_empreendimento FROM " . TB_LOTES . " l
				   JOIN " . TB_EMPREENDIMENTO . " e  ON e.id = l.id_empreendimento
		                      WHERE l.id = ?");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS, "Lote");
        return $stmt->fetch();

    }


    //buscar lotes por empreendimento
    public function findLotesByEmpreendimento($id_empreendimento, $group = false)
    {
        $lotes = $this->getAdapter()->select()
            ->from(array('l' => TB_LOTES), array('id', 'id_empreendimento', 'quadra', 'lote'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)
            ->order(array("quadra", "lote"));

        if ($group)
            $lotes = $lotes->group('l.quadra');

        $lotes = $lotes->query()->fetchAll();

        return $lotes;
    }
    public function findLotesEmpreendimento($id_empreendimento, $group = false, $quadra = false)
    {
        $lotes = $this->getAdapter()->select()
            ->from(array('l' => TB_LOTES), array('id', 'id_empreendimento', 'quadra', 'lote'))
            ->where('l.id_empreendimento = ?', $id_empreendimento);
        if ($quadra) {
            $lotes->where('l.quadra= "'.$quadra.'"');
        }
        $lotes = $lotes->order(array("quadra", "lote"));

        if ($group)
            $lotes = $lotes->group('l.quadra');

        $lotes = $lotes->query()->fetchAll();

        return $lotes;
    }

    public function findLotesByEmpreendimentoQuadraLote($id_empreendimento, $quadra, $lote)
    {
        $lotes = $this->getAdapter()->select()
            ->from(array('l' => TB_LOTES), array('id', 'id_empreendimento', 'lote', 'quadra'))
            ->where('l.id_empreendimento = ?', $id_empreendimento)
            ->where('l.quadra LIKE ?', $quadra)
            ->where('l.lote LIKE ?', $lote)
            ->order(array("quadra", "lote"))
            ->query()->fetchAll();

        return $lotes;
    }

    //buscar todos os lotes com todos os dados
    public function findLotesTodos($emp_rl_lote, $quadra, $construcao, $order = false, $lote, $vgv = false, $flCaucinado = null)
    {   
        $lotes = $this->getAdapter()->select()->distinct()
            ->from(array('l' => TB_LOTES), array('quadra', 'lote', 'area', 'valor', 'fl_construcao', 'reservado', 'obs_lote', 'obs_reserva', 'fl_caucionado', 'status'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
            ->joinLeft(array('c' => TB_CONTRATO), "l.id = c.id_lote AND fl_distrato = '0'", array('contrato' => 'id', 'nr_parcela', 'fl_distrato', 'vl_parcela', 'vl_sinal', 'nr_parcela_sinal', 'vl_intercalada', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'fl_aprovar_contrato', 'fl_itens_contrato'))
            ->joinLeft(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')
            ->joinLeft(array('rl' => TB_RESERVA_LOTE), 'l.id = rl.cod_lote AND rl.reservado = "1"', array('reservado as reserva', 'nome_pessoa'));

        if ($vgv)
            $lotes = $lotes
                ->joinLeft(array('tb' => TB_TABELA_PRECO), 'tb.id_empreendimento = e.id AND tb.fl_padrao = "1"', array())
                ->joinLeft(array('tbl' => TB_TABELA_PRECO_LOTES), 'l.id = tbl.id_lote AND tbl.id_tabela_preco = tb.id_tabela_preco', array('valorTabela' => 'vl_total'));

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra'));
        } else {
            $lotes = $lotes->order(array('quadra', 'lote'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ' . $emp_rl_lote);

        //Busca relatrio por quadra!
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra . "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = '" . $lote . "'");



        if ( $flCaucinado != '' && ( $flCaucinado[0] == 1 || $flCaucinado[1] == 0 ) ) {
            // Conta quantoss Opes foram selecionadas
            if ( count($flCaucinado) < 2 ) {
                $lotes = $lotes->where( "l.fl_caucionado = '" . $flCaucinado[0] . "'" );
            }
        }
        
        if ( $construcao != '' && ( $construcao[0] == 1 || $construcao[1] == 0 ) ) {
            // Conta quantoss Opes foram selecionadas
            if ( count($construcao) < 2 ) {
                $lotes = $lotes->where( "l.fl_construcao = '" . $construcao[0] . "'" );
            }
        }
        
        return $lotes->query()->fetchAll();
    }

    //buscar lotes vendidos
    public function findLotesVendidos($emp_rl_lote, $quadra, $construcao, $order = false, $lote, $juridico = false)
    {
        $lotes = $this->getAdapter()->select()
            ->from(array('l' => TB_LOTES), array('quadra', 'lote', 'area', 'valor', 'fl_construcao', 'obs_lote', 'fl_caucionado', 'status'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
            ->join(array('c' => TB_CONTRATO), "l.id = c.id_lote", array('contrato' => 'id', 'nr_parcela', 'vl_parcela', 'vl_sinal', 'nr_parcela_sinal', 'vl_intercalada', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'fl_itens_contrato', 'dt_contrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'nr_telefone', 'nr_celular','nr_recado', 'email'))
            ->where('fl_distrato = "0"')
            ->where('fl_aprovar_contrato= "1"')
            ->where('l.status = "V"');

        if($juridico){
            $lotes = $lotes->joinLeft(array('j' => TB_JURIDICO), 'c.id = j.id_contrato', array('id_juridico', 'id_tipo_audiencia')) 
            ->joinLeft(array('ag' => TB_AGRUPADA), 'j.id_tipo_audiencia = ag.idCampo AND ag.idTabela = "18"', array('descricao', 'idTabela'));
        }

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra', 'nm_pessoa', 'nr_telefone', 'nr_celular', 'email'));
        } else if ($order == '1') {
            $lotes = $lotes->order(array('quadra', 'lote', 'nm_pessoa', 'nr_telefone', 'nr_celular', 'email'));
        } else if ($order == '2') {
            $lotes = $lotes->order(array('nm_pessoa', 'quadra', 'lote', 'nm_pessoa', 'nr_telefone', 'nr_celular', 'email'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ' . $emp_rl_lote);


        //Busca relat�rio por quadra!
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra . "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        return $lotes->query()->fetchAll();
    }

    //buscar lotes quitados
    public function findLotesQuitados($emp_rl_lote, $quadra, $construcao, $order = false, $lote, $parcelaSinal = false, $quitado = true)
    {
        $lotes = $this->getAdapter()->select()->from(array('l' => TB_LOTES), array('id', 'quadra', 'lote', 'area', 'valor', 'fl_construcao', 'obs_lote', 'status'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
            ->join(array('c' => TB_CONTRATO), "l.id = c.id_lote AND fl_distrato = '0' AND fl_aprovar_contrato= '1'", array('contrato' => 'id', 'nr_parcela', 'vl_parcela', 'vl_sinal', 'nr_parcela_sinal', 'vl_intercalada', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'fl_itens_contrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')
            ->where('l.status = "Q"');

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra'));
        } else {
            $lotes = $lotes->order(array('quadra', 'lote'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ' . $emp_rl_lote);

        // Busca de relat�rio feito por quadra
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra. "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        $lotes = $lotes->query()->fetchAll();

        $auxLotes = array();
        foreach ($lotes as $lote) {
            if ($parcelaSinal) {
                if (Parcela::verificaQuitacaoSinal($lote['contrato'])) {
                    $auxLotes[] = $lote;
                }else{
                    $naoQuitado[] = $lote;
                }
            } else {
                if (Parcela::verificaQuitacao($lote['contrato'])) {
                    $auxLotes[] = $lote;
                }else{
                    $naoQuitado[] = $lote;
                }
            }
        }
        if($quitado){
            return $auxLotes;
        }else{
            return $naoQuitado;
        }
    }


    //buscar lotes Price
    public function findLotesPrice($emp_rl_lote, $quadra, $construcao, $order = false, $lote, $juridico = false)
    {
        $lotes = $this->getAdapter()->select()
            ->from(array('l' => TB_LOTES), array('quadra', 'lote', 'area', 'valor', 'fl_construcao', 'obs_lote', 'fl_caucionado', 'status'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
            ->join(array('c' => TB_CONTRATO), "l.id = c.id_lote", array('contrato' => 'id', 'nr_parcela', 'vl_parcela', 'vl_sinal', 'nr_parcela_sinal', 'vl_intercalada', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'fl_itens_contrato', 'dt_contrato', 'vl_divida'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa', 'nr_telefone', 'nr_celular','nr_recado', 'email'))
            ->where('fl_distrato = "0"')
            ->where('vl_divida != "NULL"')
            ->where('fl_aprovar_contrato= "1"');

        if($juridico){
            $lotes = $lotes->joinLeft(array('j' => TB_JURIDICO), 'c.id = j.id_contrato', array('id_juridico', 'id_tipo_audiencia')) 
            ->joinLeft(array('ag' => TB_AGRUPADA), 'j.id_tipo_audiencia = ag.idCampo AND ag.idTabela = "18"', array('descricao', 'idTabela'));
        }

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra', 'nm_pessoa', 'nr_telefone', 'nr_celular', 'email'));
        } else if ($order == '1') {
            $lotes = $lotes->order(array('quadra', 'lote', 'nm_pessoa', 'nr_telefone', 'nr_celular', 'email'));
        } else if ($order == '2') {
            $lotes = $lotes->order(array('nm_pessoa', 'quadra', 'lote', 'nm_pessoa', 'nr_telefone', 'nr_celular', 'email'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ' . $emp_rl_lote);


        //Busca relat�rio por quadra!
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra . "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        return $lotes->query()->fetchAll();
    }

    /**
     * Retorna o lote pelo id do contrato
     * @param $contrato
     * @return Lote|mixed
     */
    public static function findLoteByContrato($contrato)
    {
        $lote = self::getInstance();
        $lote = $lote->getAdapter()->select()->from(array('l' => TB_LOTES), array('id_empreendimento', 'quadra', 'lote'))
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('c.id'))
            ->where('c.fl_distrato = "0"')
            ->where('c.id = ?', $contrato)
            ->query()->fetch();

        return $lote;
    }

    //buscar lotes em negociacao
    public function findLotesEmNegociacao($emp_rl_lote, $quadra, $construcao, $order = false, $lote)
    {

        $lotes = $this->getAdapter()->select()->from(array('l' => TB_LOTES), array('quadra', 'lote', 'area', 'valor', 'fl_construcao', 'obs_lote', 'fl_caucionado', 'status'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
            ->join(array('c' => TB_CONTRATO), "l.id = c.id_lote AND fl_distrato = '0' AND fl_aprovar_contrato= '0'", array('contrato' => 'id', 'id_lote', 'nr_parcela', 'vl_parcela', 'vl_sinal', 'nr_parcela_sinal', 'vl_intercalada', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'fl_itens_contrato'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')
            ->where('l.status = "N"');

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra'));
        } else {
            $lotes = $lotes->order(array('quadra', 'lote'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ' . $emp_rl_lote);

        // Busca de relat�rio feito por quadra
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra. "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        return $lotes->query()->fetchAll();
    }


    //buscar lotes reservados cliente
    public function findLotesReservadosCliente($emp_rl_lote, $quadra, $construcao, $order = false, $lote)
    {
        //busca no model de contrato os ids dos lotes por empreendimento que possuem contratos ativos
        $contratos = (new Contrato())->loteByEmpreendimento($emp_rl_lote, null, true, null, false);
        if (!$contratos)
            $contratos = array(array('id_lote' => 0));
        $arrayContratos = array();
        foreach ($contratos as $contrato) {
            $arrayContratos[] = $contrato['id_lote'];
        }

        $lotes = $this->getAdapter()->select()->from(array('l' => TB_LOTES), array('quadra', 'lote', 'area', 'valor', 'fl_construcao', 'obs_lote', 'status'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento','temp_reserva'))
            ->join(array('rl' => TB_RESERVA_LOTE), "l.id = rl.cod_lote AND rl.reservado = '1' AND (rl.comprado <> '1' OR rl.comprado IS NULL) ", '*')
            ->join(array('p' => TB_PESSOA), 'rl.corretor = p.id', 'nm_pessoa')
            ->where('l.status = "RC"');

        if (count($arrayContratos))
            $lotes = $lotes->where('l.id NOT IN(?)', $arrayContratos);

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra'));
        } else {
            $lotes = $lotes->order(array('quadra', 'lote'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ' . $emp_rl_lote);

        // Busca de relat�rio feito por quadra
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra. "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        return $lotes->query()->fetchAll();
    }

    //buscar lotes em reserva tecnica
    public function findLotesReservaTecnica($emp_rl_lote, $quadra, $construcao, $order = false, $lote)
    {
        $lotes = $this->getAdapter()->select()
            ->from(array('l' => TB_LOTES), array('id', 'quadra', 'lote', 'area', 'valor', 'fl_construcao', 'obs_lote', 'obs_reserva','data_reserva','fl_caucionado', 'status'))
            ->where("l.id_empreendimento = '" . $emp_rl_lote . "' AND (l.reservado = '1' OR l.status = 'RT')");

        // Busca de relat�rio feito por quadra
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra. "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        if ($order == '0') {
            $lotes = $lotes->order(array('l.lote', 'l.quadra'));
        } else {
            $lotes = $lotes->order(array('l.quadra', 'l.lote'));
        }
        
        return $lotes->query()->fetchAll();
    }

    //buscar todos os lotes com todos os dados
    public function findLotesLocalizacao($emp_rl_lote, $quadra, $construcao, $order = false, $lote)
    {
        $lotes = $this->getAdapter()->select()->distinct()->from(array('l' => TB_LOTES), array('quadra', 'lote', 'area', 'conf_frente', 'conf_fundo', 'conf_esquerda', 'conf_direita', 'frente', 'fundo', 'esquerda', 'direita','ds_geral','rgi', 'obs_lote', 'status'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
            ->joinLeft(array('c' => TB_CONTRATO), "l.id = c.id_lote AND fl_distrato = '0'", array('contrato' => 'id', 'nr_parcela', 'fl_distrato', 'vl_parcela', 'vl_sinal', 'nr_parcela_sinal', 'vl_intercalada', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'fl_aprovar_contrato', 'fl_itens_contrato'))
            ->joinLeft(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'nm_pessoa')
            ->joinLeft(array('rl' => TB_RESERVA_LOTE), 'l.id = rl.cod_lote AND rl.reservado = "1"', array('reservado as reserva', 'nome_pessoa'));

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra'));
        } else {
            $lotes = $lotes->order(array('quadra', 'lote'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ' . $emp_rl_lote);

        // Busca de relat�rio feito por quadra
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra. "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        return $lotes->query()->fetchAll();
    }

    //buscar lotes disponiveis
    public function findLotesDisponiveis($Idemp, $quadra, $construcao, $order = false, $tabela = false, $lote = null)
    {
        //busca no model de contrato os ids dos lotes por empreendimento que possuem contratos ativos
        $contratos = (new Contrato())->loteByEmpreendimento($Idemp, null, true, null, false);
        foreach ($contratos as $contrato) {
            $arrayContratos[] = $contrato['id_lote'];
        }

        //constroi lista de lotes reservados (id) pelo id do empreendimento
        $reservaLote = (new ReservaLote())->findReservaEmpreendimento($Idemp);

        $lotes = $this->getAdapter()->select()
            ->from(array('l' => TB_LOTES), array('id', 'quadra', 'lote', 'area', 'valor', 'fl_construcao', 'reservado', 'obs_lote', 'fl_caucionado', 'status'));

        if ($tabela)
            $lotes = $lotes
                ->joinLeft(array('tb' => TB_TABELA_PRECO), 'tb.fl_padrao = "1" AND tb.id_empreendimento = "' . $Idemp . '"', 'fl_padrao')
                ->joinLeft(array('tbl' => TB_TABELA_PRECO_LOTES), 'tbl.id_tabela_preco = tb.id_tabela_preco AND l.id = tbl.id_lote', array('valorTabela' => 'vl_total'));

        if ($order == '0') {
            $lotes = $lotes->order(array('lote', 'quadra'));
        } else {
            $lotes = $lotes->order(array('quadra', 'lote'));
        }

        $lotes = $lotes->where('l.id_empreendimento = ?', $Idemp)
            ->where('l.reservado = "0"')
            ->where('l.status = "D"');

        if (count($arrayContratos))
            $lotes = $lotes->where('l.id NOT IN(?)', $arrayContratos);

        if ($reservaLote)
        {
            foreach ($reservaLote as $reserva)
            {
                $aux[] = $reserva['id'];
            }

            $aux = implode('","', $aux);

            $lotes = $lotes->where('l.id NOT IN ("' . $aux . '")');
        }

        // Busca de relat�rio feito por quadra
        if ($quadra && $quadra != '*') $lotes->where("l.quadra = '" . $quadra. "'");

        //Busca relat�rio por lote
        if ($lote && $lote != '*') $lotes->where("l.id = " . $lote);

        if ($construcao != '') $lotes = $lotes->where("l.fl_construcao = '" . $construcao . "'");

        return $lotes->group('l.id')->query()->fetchAll();
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'l.id',
            1 => 'e.nm_empreendimento',
            2 => 'l.quadra',
            3 => 'l.lote',
            4 => 'l.fl_construcao',
            5 => 'l.fl_caucionado'
        );

        if ($search) {
            $where = 'l.id LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
            $where .= 'or l.fl_construcao LIKE "%' . $search . '%" ';
            $where .= 'or l.fl_caucionado LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), array('l.id', 'l.quadra', 'l.lote', 'l.area', 'l.fl_construcao', 'l.reservado', 'l.fl_caucionado'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('e.nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $itens->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        $orderByQuery = array();
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $itens = $itens->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $itens;
    }

    public static function lotes($idEmpreendimento = null) {
        $ano = date('Y');
        $mes = date('m');

        //constroi lista de lotes reservados (id) pelo id do empreendimento
        $reservaLote = (new ReservaLote())->findReservaEmpreendimento(false);

        $lotesMesAtual = self::getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), 'l.id')
            ->joinLeft(array('c' => TB_CONTRATO), 'c.id_lote = l.id', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', null)
            ->where("l.id NOT IN (SELECT cc.id_lote FROM CONTRATO cc 
                    INNER JOIN LOTES ll ON cc.id_lote = ll.id 
                    WHERE ll.reservado = '0' 
                    AND cc.dt_contrato <= '".$ano."-".$mes."-31' 
                    AND cc.fl_distrato = '0' 
                    GROUP BY ll.id)")
            ->where('l.reservado = "0"')
            ->group('l.id');

        if ($reservaLote)
        {
            foreach ($reservaLote as $reserva)
            {
                $aux[] = $reserva['id'];
            }

            $aux = implode('","', $aux);

            $lotesMesAtual = $lotesMesAtual->where('l.id NOT IN ("' . $aux . '")');
        }

        if ($idEmpreendimento)
            $lotesMesAtual = $lotesMesAtual->where('l.id_empreendimento = ?', $idEmpreendimento);

        return ['qtdMesAtual' => count(Helper::filtraPorUsuario($lotesMesAtual))];
    }

    public static function getLotesEmpreendimentoQuadraNumero($idEmpreendimento, $quadra, $numero)
    {
        $lote = self::getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), array('*'))
            ->joinLeft(array('ttpl' => TB_TABELA_PRECO_LOTES), 'l.id = ttpl.id_lote', array('id_lote', 'id_tabela_preco'))
            ->joinLeft(array('ttp' => TB_TABELA_PRECO), 'ttp.id_tabela_preco = ttpl.id_tabela_preco', array('id_tabela_preco'))
            ->where('l.id_empreendimento = ?', $idEmpreendimento)
            ->where('quadra = "'.$quadra.'"')
            ->where('lote = "'.$numero.'"')
            ->query()->fetch();
            
        return $lote;
    }

    public function getEmpreendimentosUsuario($verificarPermissao = true)
    {

        //Buscando a lista de empreendimentos para o select
        $listaEmpreendimentos = $this->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if (Login::getUsuario() && $verificarPermissao) {

            $instanceUsuarioEmpreendimento = new UsuarioEmpreendimento();
            $idsUsuarioEmpreendimento = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante(Login::getUsuario());

            if ($idsUsuarioEmpreendimento) {
                $idsUsuarioEmpreendimento = implode(',', $idsUsuarioEmpreendimento);
                $listaEmpreendimentos = $listaEmpreendimentos->where("e.id IN({$idsUsuarioEmpreendimento})");
            }

        }

        return $listaEmpreendimentos->order('e.nm_empreendimento')->query()->fetchAll();
    }
}
