<?php

class LogAcesso extends Zend_Db_Table_Abstract{
    
    protected $_name = TB_LOG_ACESSO;

    const TABLE_NAME = "LOG_ACESSO";

    public static function buscaAcessos($post, $count =  false)
    {
        $search = utf8_decode($_POST['search']['value']);
        
        if ($search) {
            $where = 'p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or a.id_usuario LIKE "%'. $search .'%" ';
            $where .= 'or a.dt_acesso LIKE "%' . $search . '%" ';
        }
        
        $log = (new LogAcesso)->getAdapter()->select()
            ->from(array('a' => TB_LOG_ACESSO), '*')
            ->join(array('p' => TB_PESSOA), 'p.id = a.id_usuario', array('nm_pessoa'));

        if (isset($where)) {
            $log = $log->where($where);
        }

        if (!$count) {
            if (isset($post['start']) && $post['length'] != '-1') {
                $log = $log->limit($post['length'], $post['start']);
            }
        }
        
        $log = $log->order('dt_acesso DESC')->query()->fetchAll();

        return $log;
    }
    public static function ultimoAcesso()
    {
        $ulimoAcesso = self::getDefaultAdapter()
            ->select()
            ->from(['l'=> TB_LOG_ACESSO],[ 'id_usuario', 'dt_acesso'])
            ->join(array('c'=>TB_USUARIO),'l.id_usuario = c.id','login')
            ->where('super != "1"')
            ->order('dt_acesso desc')
            ->query()
            ->fetch();


        return $ulimoAcesso;
    }
    public static function registraFimDaSessao() {
        //Salva o log de sada do usurio ao deslogar do sistema.
        $tb_log_acesso = new LogAcesso();
        
        try {
            $logDoDia = $tb_log_acesso->fetchRow('id_usuario = "' . Login::getUsuario()->getId() . '" AND dt_acesso = "' . date('Y-m-d') . '" AND dt_saida is null', ['dt_acesso DESC', 'hr_acesso DESC']);
            
            if ($logDoDia) {
                $logDoDia->dt_saida = date('Y-m-d');
                $logDoDia->hr_saida = date("H:i:s");
        
                $logDoDia->save();
            }
        } catch (\Throwable $th) {
            return;
        }
    }
}
?>