<?php

class Layout extends Zend_Db_Table_Abstract
{
    protected $_name = TB_LAYOUT;
     /***
     * Busca uma tabela de preo pelo ID
     * @param $id
     * @return mixed|Zend_Db_Adapter_Abstract
     */
    public static function getTabelaById($id){
        $tabela = self::getDefaultAdapter();
        $tabela = $tabela->select()->from(array('tp' => TB_LAYOUT))->where('id = "' . $id . '"')
            ->query()->fetch();

        return $tabela;
    }

    //Setando o Select com o tipo de Layout API
     public function getListaApiLayoutBanco($verificarPermissao = true)
     {
         //Buscando a lista de layouts para o select
         $listaLayout = $this->getDefaultAdapter()->select()
             ->from(array('e' => TB_LAYOUT), array('id', 'nm_layout'));

         return $listaLayout->order('e.nm_layout')->query()->fetchAll();
     }

    public static function getTabelaRemessaByCodBanco($id){
        $tabela = self::getDefaultAdapter();
        $tabela = $tabela->select()->from(array('tp' => TB_LAYOUT),array('nm_layout','id'))
            ->where('id = "' . $id . '"')
            ->where('tipo_layout = "REM"')
            ->query()->fetch();

        return $tabela;
    }
    public static function getTabelaRetornoByCodBanco($id){
        $tabela = self::getDefaultAdapter();
        $tabela = $tabela->select()->from(array('tp' => TB_LAYOUT),array('nm_layout','id'))->where('id = "' . $id . '" and tipo_layout = "RET"')
            ->query()->fetch();

        return $tabela;
    }
    public static function getNomeById($id)
    {
        return self::getDefaultAdapter()->fetchRow('SELECT nm_layout FROM LAYOUT where id="'.$id.'"');
    }
    public static function setInsertLayout($nm_layout,$desc_layout,$tipo,$pp_token=null,$password=null, $access_token=null, $req_cliente_id = null)
    {

        if($nm_layout) {
            $campos = array(
                'nm_layout' => $nm_layout,
                'desc_layout' => $desc_layout,
                'tipo_layout' => $tipo,
                'dt_layout' => date('Y-m-d'),
                'log' => Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i'
            );
            if($pp_token){
                $campos['pp_token'] = $pp_token;
            }
            if($password){
                $campos['password'] = $password;
            }
            if($access_token){
                $campos['gerar_token'] = $access_token;
            }
            if($req_cliente_id){
                $campos['req_cliente_id'] = $req_cliente_id;
            }
            $auxTabela = self::getDefaultAdapter();
            $auxTabela->insert(TB_LAYOUT, $campos);
            return self::getDefaultAdapter()->lastInsertId();
        }
    }

    public static function setUpdateLayout($id,$nm_layout,$tipo,$desc_layout,$url_api,$pp_token,$password,$req_cliente_id,$tipo_retorno,$tipo_header,$gerar_token,$uri_param,$url_api_listar=null)
    {
        if($nm_layout) {
            $auxTabela = self::getDefaultAdapter();
            $auxTabela->update(array('tp' => TB_LAYOUT), array(
                'nm_layout' => $nm_layout,
                'tipo_layout' => $tipo,
                'desc_layout' => $desc_layout,
                'tipo_retorno' => $tipo_retorno,
                'tipo_header' => $tipo_header,
                'gerar_token' => $gerar_token,
                'url_api' => $url_api,
                'url_api_listar' => $url_api_listar,
                'uri_param' => $uri_param,
                'pp_token' => $pp_token,
                'password' => $password,
                'req_cliente_id' => $req_cliente_id,
                'dt_layout' => date('Y-m-d')
            ), 'id = ' . $id);

        }
    }

    public static function copiaLayout($idlayout)
    {
        if($idlayout) {
            $tabela = self::getDefaultAdapter();
            $select = $tabela->select()
                ->from(array('tp' => TB_LAYOUT))
                ->where('id = "' . $idlayout . '"')->query()->fetch();
            $campos = array(
                'nm_layout' => $select['nm_layout'],
                'desc_layout' => $select['desc_layout'],
                'tipo_layout' => $select['tipo_layout'],
                'dt_layout' => date('Y-m-d'),
                'log' => Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i'
            );

            $auxTabela = self::getDefaultAdapter();
            $auxTabela->insert(TB_LAYOUT, $campos);

        }
    }

    public static function getListLayout()
    {
        return self::getDefaultAdapter()->fetchAll('SELECT * FROM LAYOUT');
    }

    public function getListaRemessaLayoutBanco()
    {
        //Buscando a lista de empreendimentos para o select
        $listaEmpreendimentos = $this->getDefaultAdapter()->select()
            ->from(array('e' => TB_LAYOUT), array('id', 'nm_layout'))->where('tipo_layout = "REM"');

        return $listaEmpreendimentos->order('e.nm_layout')->query()->fetchAll();
    }
    
    public function getListaRetornoLayoutBanco()
    {
        //Buscando a lista de empreendimentos para o select
        $listaEmpreendimentos = $this->getDefaultAdapter()->select()
            ->from(array('e' => TB_LAYOUT), array('id', 'nm_layout'))->where('tipo_layout = "RET"');

        return $listaEmpreendimentos->order('e.nm_layout')->query()->fetchAll();
    }
    public static function setInsertLayoutItens($id_layout,$linha,$tamanho,$conteudo,$log)
    {
        if($id_layout) {
            $remessa = new LayoutItens();
            $remessa = $remessa->createRow();
            $remessa->id_layout = $id_layout;
            $remessa->tamanho = $tamanho;
            $remessa->linha = $linha;
            $remessa->conteudo = $conteudo;
            $remessa->log = $log;
            $remessa->linha = $linha;
            $idRemessa = $remessa->save();

            return $idRemessa;

        }
    }
}
?>
