<?php

class Juridico extends Zend_Db_Table_Abstract
{
    protected $_name = TB_JURIDICO;
    static $thisInstancia;

    /**
     * Funo para retornar uma instancia do objeto, usada como singleton para evitar conflitos de
     * acessos multiplos a classe ao realizar um update, find, add ou delete
     * @return Juridico
     */
    public static function getInstance()
    {
        if (!self::$thisInstancia) {
            self::$thisInstancia = new Juridico();
        }
        return self::$thisInstancia;
    }

    public static function getLista($idEmpreendimento, $tipoContrato = 0)
    {
        $itens = self::getDefaultAdapter()->select()
            ->from(array("j" => TB_JURIDICO), array('*'))
            ->join(array('ta' => TB_AGRUPADA), ' ta.idTabela = 18 AND ta.idCampo = j.id_tipo_audiencia', array('tipoAudiencia'=>'descricao'))
            ->join(array("c" => TB_CONTRATO), "j.id_contrato = c.id", array('id','fl_distrato'))
            ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", array("nm_pessoa"))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'nm_empreendimento');

        if ($idEmpreendimento) {
            $itens = $itens->where('e.id = ?', $idEmpreendimento);
        }

        if ($tipoContrato == "1") {
            $itens = $itens->where('c.fl_distrato = "0"');
        } elseif ($tipoContrato == "2") {
            $itens = $itens->where('c.fl_distrato = "1"');
        }

        $contatos = $itens->order(array("c.id DESC"))
            ->query()->fetchAll();

        return $contatos;
    }

    public static function getListaRelatorio($idEmpreendimento, $idJuridico = null, $fl_tipo = null, $tp_audiencia = null)
    {
        $itens = self::getDefaultAdapter()->select()
            ->from(array("j" => TB_JURIDICO), array('*'))
            ->join(array('ta' => TB_AGRUPADA), ' ta.idTabela = 18 AND ta.idCampo = j.id_tipo_audiencia', array('tipoAudiencia'=>'descricao'))
            ->join(array("c" => TB_CONTRATO), "j.id_contrato = c.id", array('id'))
            ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", array("nm_pessoa"))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'nm_empreendimento');

        if ($idEmpreendimento) {
            $itens = $itens->where('e.id = ?', $idEmpreendimento);
        }
        if($idJuridico && $idJuridico != '*'){
            $itens = $itens->where('j.id_juridico = ?', $idJuridico);
        }
        if($fl_tipo){
            $itens = $itens->where('j.fl_tipo IN ' . $fl_tipo);
        }
        if($tp_audiencia && $tp_audiencia != '*'){
            $itens = $itens->where('j.id_tipo_audiencia = ?', $tp_audiencia);
        }

        $contatos = $itens->order(array("c.id DESC"))
            ->query()->fetchAll();

        return $contatos;
    }

    public static function getDados($id)
    {
        $item = self::getDefaultAdapter()->select()
            ->from(array("j" => TB_JURIDICO), array('*'))
            ->join(array("c" => TB_CONTRATO), "j.id_contrato = c.id", array())
            ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", array("nm_pessoa"))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote', 'id_empreendimento'))
            ->join(array('agr' => TB_AGRUPADA), 'j.id_tipo_audiencia = agr.idCampo AND idTabela = "18"', array('descricao'))
            ->where('j.id_juridico = ?', $id)
            ->query()->fetch();

        return $item;
    }

    public static function listarJuridicos($idEmpreendimento = null) {

        $juridicos = self::getDefaultAdapter()->select()
            ->from(array('j' => TB_JURIDICO), ['j.id_juridico', 'j.dt_notificacao', 'j.dt_audiencia'])
            ->join(array('c' => TB_CONTRATO), 'c.id = j.id_contrato', 'c.id as id_contrato')
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', ['l.quadra', 'l.lote'])
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', ['nm_empreendimento'])
            ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', 'p.nm_pessoa')
            ->where('j.dt_audiencia = "'.date('Y-m-d').'"');
            if($idEmpreendimento) {
                $juridicos = $juridicos->where('l.id_empreendimento IN (?)', $idEmpreendimento);
            }
            
        $juridicos = Helper::filtraPorUsuario($juridicos);
        
        return $juridicos;
    }

    public static function getJuridicoPeloIdContrato ($idContrato)
    {
        $juridico = self::getDefaultAdapter()->select()
            ->from(array('j' => TB_JURIDICO), '')
            ->join(array('ag' => TB_AGRUPADA), 'j.id_tipo_audiencia = ag.idCampo', ['ag.descricao'])
            ->where('j.id_contrato = ' . $idContrato)
            ->where('ag.idTabela = "18"')
            ->query()->fetch();

        return $juridico;
    }
}
