<?php

class IndiceGeral extends Zend_Db_Table_Abstract
{

    protected $_name = TB_INDICE_GERAL;

    public static function listar()
    {
        return Controller::getAdapterAcadeGeral()->fetchAll('SELECT * FROM indice_geral');
    }

    public static function getIndices($indiceEmpreendimento = null, $dataInicioIndices = null, $dataFinalIndices = null)
    {
        $listaIndices = Controller::getAdapterAcadeGeral()->select()
            ->from(array('i' => TB_INDICE_GERAL), array('*'))
            ->join(['t' => TB_AGRUPADA_GERAL], 't.idCampo = i.agr_descricaoIndice and t.idTabela = 12', ['descricao', 'idCampo']);
        if ($indiceEmpreendimento)
            $listaIndices = $listaIndices->where('agr_descricaoIndice = ' . $indiceEmpreendimento);

        if ($dataInicioIndices && $dataFinalIndices) {
            $listaIndices = $listaIndices
                ->where("concat(ano,mes) >= $dataInicioIndices")
                ->where("concat(ano,mes) <= $dataFinalIndices")
                ->order('concat(ano,mes) ASC');
        }

        return $listaIndices->query()->fetchAll();
    }
}
