<?php

class IndiceEmpreendimento extends Zend_Db_Table_Abstract
{

    protected $_name = TB_INDICE_EMPREENDIMENTO;
    static $instancia;
    /**
     * @return Contrato
     */
    public static function getInstance()
    {
        if (!self::$instancia) {
            self::$instancia = new IndiceEmpreendimento();
        }
        return self::$instancia;
    }

    /**
     * Funo que retorna todos indices do empreendimento com nome do empreendimento
     */
    public function getIndiceEmpreendimento($idEmpreendimento, $ativo = false)
    {
        $indices = self::getInstance()->getDefaultAdapter()->select()
            ->from(array('ie' => TB_INDICE_EMPREENDIMENTO), array('*'))
            ->joinLeft(array('c'=>TB_CONTRATO),'c.id_indice = ie.id_indice_empreendimento',array('idContrato'=>'id'))
            ->where('ie.id_empreendimento = '.$idEmpreendimento)
            ->group('id_indice_empreendimento');

            if($ativo){
                $indices = $indices->where('ie.fl_ativo = 1');
            }
            $indices = $indices->query()->fetchAll();
            
        foreach ($indices as &$indice) {
            $tbAgrupada = AgrupadaGeral::buscar('12', $indice['id_indice']);
            $indice['descricao'] = $tbAgrupada['descricao'];
        }

        return $indices;     
    }

}