<?php

class Indice extends Zend_Db_Table_Abstract
{
    protected $_name = TB_INDICE;

    public static function findLista($post, $count = false)
    {
        $search = $_POST['search']['value'];
        $order = $_POST['order'];

        $array = array(
            'i.ano',
            'i.mes',
            'agr.descricao',
            'i.valor'
        );

        $meses = array(
            '01' => 'Janeiro',
            '02' => 'Fevereiro',
            '03' => 'Maro',
            '04' => 'Abril',
            '05' => 'Maio',
            '06' => 'Junho',
            '07' => 'Julho',
            '08' => 'Agosto',
            '09' => 'Setembro',
            '10' => 'Outubro',
            '11' => 'Novembro',
            '12' => 'Dezembro'
        );

        if ($search) {
            //procurar pelo nome do ms, retirar caracteres do termo
            $auxMeses = array();
            foreach ($meses as $k => $mes) {
                if (strpos(Helper::str2Upper($mes), Helper::str2Upper($search)) !== false)
                    $auxMeses[] = $k;
            }

            $where = 'UPPER(agr.descricao) LIKE "%' . mb_strtoupper($search, 'UTF-8') . '%" ';
            $where .= 'or i.ano LIKE "%' . $search . '%" ';
            $where .= 'or i.valor LIKE "%' . $search . '%" ';
            if (count($auxMeses) > 0)
                $where .= 'or i.mes IN (' . implode($auxMeses, ',') . ')';
        }

        $itens = Controller::getAdapterAcadeGeral()->select()
            ->from(array('i' => TB_INDICE_GERAL), array('*'));

        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord) {
            $itens->order($array[$ord['column']] . ' ' . $ord['dir']);
        }

        $itens = $itens->query()->fetchAll();

        foreach ($itens as &$indice) {
            $tb_agrupada = self::getDefaultAdapter()->select()
            ->from(array('a' => TB_AGRUPADA), array('descricao','idCampo'))
            ->where('a.idCampo = ' . $indice['agr_descricaoIndice'])
            ->where('a.idTabela = "12"')
            ->query()->fetch();

            $indice['descricao'] = $tb_agrupada['descricao'];
            $indice['idCampo'] = $tb_agrupada['idCampo'];
        }

        return $itens;
    }
}
