<?php

class Graficos {

    //Busca as vendas realizadas por ano e ms
    public static function vendasPorMesEano($idEmpreendimento) {
        
        $whereEmpreendimento = "";

        if($idEmpreendimento != '0') {
            $whereEmpreendimento = " AND e.id = " . $idEmpreendimento;
        } else {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $whereEmpreendimento = " AND e.id IN ({$id}) ";
                } 
            } catch (Exception $e) {}
        }

        $vendas = (new Lote())->getDefaultAdapter()->fetchAll("
            SELECT DATE_FORMAT(c.dt_contrato, '%Y-%m') as data,
            COUNT(c.dt_contrato) as total
            FROM LOTES l
            INNER JOIN EMPREENDIMENTO e ON l.id_empreendimento = e.id
            INNER JOIN CONTRATO c ON l.id = c.id_lote
            AND c.fl_aprovar_contrato = '1'".
            $whereEmpreendimento ."
            AND YEAR(c.dt_contrato) BETWEEN " . (date('Y') - 1) . " AND " . date('Y') . "
            GROUP BY
                MONTH(c.dt_contrato),
                YEAR(c.dt_contrato)
            ORDER BY
                YEAR(c.dt_contrato),
                MONTH(c.dt_contrato) ASC
        ");

        return Graficos::criaArrayDadosGraficos($vendas);
    }

    //Busca as parcelas pagas do ms
    public static function parcelasPagasNoMes($idEmpreendimento) {
        
        $whereEmpreendimento = "";
        $joinEmpreendimento = "
                INNER JOIN CONTRATO c ON c.id = p.id_contrato
                INNER JOIN LOTES l ON c.id_lote = l.id
                INNER JOIN EMPREENDIMENTO e ON e.id = l.id_empreendimento    
        ";

        if ($idEmpreendimento != '0') {
            $whereEmpreendimento = " AND e.id = " . $idEmpreendimento;
        } else {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $whereEmpreendimento = " AND e.id IN ({$id}) ";
                } 
            } catch (Exception $e) {

            }
        }
        
        $parcelas = (new Parcela())->getDefaultAdapter()->fetchAll("
            SELECT DATE_FORMAT(dt_pagamento, '%m') AS data,
            COUNT(p.id_parcela_contrato) AS total,
            SUM(p.vl_parcela) AS totalVlParcela,
            SUM(p.vl_juros) AS juros,
            SUM(p.vl_multa) AS multa,
            SUM(p.desconto) AS desconto
            FROM PARCELA p " .
            $joinEmpreendimento . "
            WHERE pago = '1'
            AND YEAR(p.dt_pagamento) = " . date('Y') . 
            $whereEmpreendimento . "
            GROUP BY
                MONTH(p.dt_pagamento)
            ORDER BY
                MONTH(p.dt_pagamento) ASC
        ");

        $parcelasHistorico = (new ParcelaHistorico())->getDefaultAdapter()->fetchAll("
            SELECT DATE_FORMAT(dt_pagamento, '%m') AS data,
            COUNT(p.id_parcela_contrato) AS total,
            SUM(p.vl_parcela) AS totalVlParcela,
            SUM(p.vl_juros) AS juros,
            SUM(p.vl_multa) AS multa,
            SUM(p.desconto) AS desconto
            FROM PARCELA_HISTORICO p " .
            $joinEmpreendimento . "
            WHERE pago = '1'
            AND YEAR(p.dt_pagamento) = " . date('Y') . 
            $whereEmpreendimento . "
            GROUP BY
                MONTH(p.dt_pagamento)
            ORDER BY
                MONTH(p.dt_pagamento) ASC
        ");
        
        foreach($parcelasHistorico as $k => $historico) {
            
            foreach($parcelas as $j => $parcela) {
                
                if($historico['data'] == $parcela['data']) {
                    $parcelas[$j]['total'] += $historico['total'];
                    $parcelas[$j]['totalVlParcela'] += $historico['totalVlParcela'];
                    $parcelas[$j]['juros'] += $historico['juros'];
                    $parcelas[$j]['multa'] += $historico['multa'];
                    $parcelas[$j]['desconto'] += $historico['desconto'];
                    unset($parcelasHistorico[$k]);
                }
            }
        }

        if($parcelasHistorico) {
            $parcelas = array_merge($parcelas, $parcelasHistorico);
        }
        
        $array = [
            'total' => [0,0,0,0,0,0,0,0,0,0,0,0],
            'vlTotalParcela' => [0,0,0,0,0,0,0,0,0,0,0,0]
        ];

        foreach($parcelas as $k => $parcela) {
            $array['total'][(int)$parcela['data'] - 1] = (int)$parcela['total'];
            $array['vlTotalParcela'][(int)$parcela['data'] - 1] = (float)$parcela['totalVlParcela'] + (float)$parcela['juros'] + (float)$parcela['multa'] - (float)$parcela['desconto'];
        }
        
        return $array;
    }

    //Busca os distratos do ano e ms
    public static function distratosPorMesEano($idEmpreendimento) {
        
        $whereEmpreendimento = "";
        $joinEmpreendimento = "
                INNER JOIN CONTRATO c ON c.id = d.id_contrato
                INNER JOIN LOTES l ON c.id_lote = l.id
                INNER JOIN EMPREENDIMENTO e ON e.id = l.id_empreendimento    
        ";

        if ($idEmpreendimento != '0') {
            $whereEmpreendimento = " AND e.id = " . $idEmpreendimento;
        } else {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $whereEmpreendimento = " AND e.id IN ({$id}) ";
                } 
            } catch (Exception $e) {}
        }

        $distratos = (new Lote())->getDefaultAdapter()->fetchAll("
            SELECT DATE_FORMAT(d.dt_distrato, '%Y-%m') as data,
            COUNT(d.id_contrato) as total
            FROM DISTRATO d ".
            $joinEmpreendimento . "
            WHERE YEAR(d.dt_distrato) BETWEEN " . (date('Y') - 1) . " AND " . date('Y') . 
            $whereEmpreendimento . "
            GROUP BY
                MONTH(d.dt_distrato),
                YEAR(d.dt_distrato)
            ORDER BY
                YEAR(d.dt_distrato),
                MONTH(d.dt_distrato) ASC
        ");
        
        return Graficos::criaArrayDadosGraficos($distratos);
    }

    public static function totaisSituacaoLote($idEmpreendimento) {
        
        // faz os clculos dos totais pra exibir no final
        $totalLotesVendidos = 0;
        $totalLotesAbertos = 0;
        $totalLotesQuitados = 0;
        $totalLotesNegociacao = 0;
        $totalLotesRT = 0;
        $totalLotesReservado = 0;
        
        $lotes = (new Lote())->getDefaultAdapter()->select()->distinct()
        ->from(array('l' => TB_LOTES), array('idLote' => 'id', 'reservadoLote' => 'reservado'))
        ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id', 'temp_reserva'))
        ->joinLeft(array('c' => TB_CONTRATO), 'c.id_lote = l.id AND c.fl_distrato = "0"', array('idContrato' => 'id', 'fl_distrato', 'fl_aprovar_contrato'))
        ->joinLeft(array('rl' => TB_RESERVA_LOTE), 'rl.cod_lote = l.id AND rl.reservado = 1', array('idReserva' => 'id', 'data_reserva', 'reservadoReservaLote' => 'reservado', 'data_final' => 'data_final'))
        //->joinLeft(array('tpl' => TB_TABELA_PRECO_LOTES), 'tpl.id_lote = l.id', array(''))
        //->joinLeft(array('tl' => TB_TIPO_LOTEAMENTO), 'tl.id_tipo_loteamento = e.id_tipo_loteamento', array('*'))
        ->group('l.id')
        ->group('l.quadra');

        if ($idEmpreendimento != '0') {
            $lotes = $lotes->where('l.id_empreendimento = ' . $idEmpreendimento);
        } else {
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $lotes->where("e.id IN({$id})");
                    } else {
                        $lotes->where("1");
                    }
                } catch (Exception $e) {
    
                }
            }
        }

        $listaLotes = $lotes->query()->fetchAll();
        
        $totalLotesQuitados = 0;
        $totalLotesVendidos = 0;
        $$totalLotesNegociacao = 0;
        $totalLotesRT = 0;
        $totalLotesReservado = 0;
        $totalLotesAbertos = 0;
        
        foreach ($listaLotes as $lote) {

            $idContrato = $lote['idContrato'];
            $reservadoLote = $lote['reservadoLote'];
            $reservadoReservaLote = $lote['reservadoReservaLote'];
            $flAprovarContrato = $lote['fl_aprovar_contrato'];

            //Se nao houver contrato e não estiver reservado o status é Disponivel
            if (!$idContrato && !$reservadoLote && !$reservadoReservaLote) {
                $totalLotesAbertos++;

                //Se houver contrato e o contrato tiver sido aprovado o status é Vendido
            } else if ($idContrato && $flAprovarContrato) {
                $totalLotesVendidos++;

                //se o contrato no for distratado e se a verificao de quitao for positiva, o lote est quitado
                if($lote['fl_distrato'] == '0') {
                    if (Parcela::verificaQuitacao($lote['idContrato'])) {
                        $totalLotesQuitados++;
                        $totalLotesVendidos--;
                    }
                }

                //Se houver contrato e o contrato naõ tiver sido aprovado o status é Negociação
            } else if ($idContrato && !$flAprovarContrato) {
                $totalLotesNegociacao++;

                //Se não houver contrato e não estiver reservado o status é Reservado
            } else if (!$idContrato && ($reservadoLote || $reservadoReservaLote)) {
                $totalLotesRT++;

                //Faz o calculo da data de reserva, caso estiver expirado, automaticamente o lote mudará para disponivel
                //Lotes com reserva tecnica não entram na condição
                if ($lote['temp_reserva'] && $lote['data_reserva'] && !$reservadoLote) {
                    $totalLotesReservado++;
                    $timeZone = new DateTimeZone('UTC');

                    if($lote['data_final']){
                        //A data de expiracao da reserva
                        $dataExpiracao = Helper::dataParaBrasil($lote['data_final']);
                    }else{
                        //Data da reserva somado à quantidade de dias de reserva
                        $dataExpiracao = date('d/m/Y', strtotime("+" . $lote['temp_reserva'] . " days", strtotime($lote['data_reserva'])));
                    }

                    //Data atual em time
                    $dataAtualTime = DateTime::createFromFormat('d/m/Y', date('d/m/Y', strtotime("now")), $timeZone);

                    //Data de expiração em time
                    $dataExpiracaoTime = DateTime::createFromFormat('d/m/Y', $dataExpiracao, $timeZone);

                    if ($dataExpiracaoTime < $dataAtualTime) {
                        $totalLotesAbertos++;
                    }

                }
            }
        }

        $todosLotes = $totalLotesQuitados + $totalLotesVendidos + $$totalLotesNegociacao + $totalLotesRT + $totalLotesReservado + $totalLotesAbertos;
        
        return ['vendidos' => $totalLotesVendidos, 'disponiveis' => $totalLotesAbertos, 'quitados' => $totalLotesQuitados, 'negociacao' => $totalLotesNegociacao, 'reservaTecnica' => $totalLotesRT, 'reservados' => $totalLotesReservado, 'todosLotes' => $todosLotes];
    }

    public static function totaisStatusLotes($idEmpreendimento) {
        
        Graficos::verificaDataReserva();
        $empreendimentos = '';
        $totalEmpreendimentos = '';

        if ($idEmpreendimento != '0') {
            $empreendimentos = ' AND id_empreendimento = ' . $idEmpreendimento;
            $totalEmpreendimentos = 'WHERE id_empreendimento = ' . $idEmpreendimento;
        } else {
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $empreendimentos = ' AND id_empreendimento IN (' . implode("','", $ids) . ')';
                        $totalEmpreendimentos = 'WHERE id_empreendimento IN (' . implode("','", $ids) . ')';
                    }
                } catch (Exception $e) {
    
                }
            }
        }

        $lotes = (new Lote())->getDefaultAdapter()->fetchAll(
            "SELECT 
                (SELECT COUNT(status) FROM LOTES WHERE status = 'D' AND reservado = '0' " .$empreendimentos. ") AS disponiveis,
                (SELECT COUNT(status) FROM LOTES l INNER JOIN CONTRATO c ON c.id_lote = l.id WHERE l.status = 'V' AND c.fl_distrato = '0' AND c.fl_aprovar_contrato = '1' " .$empreendimentos. ") AS vendidos,
                (SELECT COUNT(status) FROM LOTES WHERE status = 'Q' " .$empreendimentos. ") AS quitados,
                (SELECT COUNT(status) FROM LOTES l INNER JOIN CONTRATO c ON c.id_lote = l.id WHERE l.status = 'N' AND c.fl_distrato = '0' AND c.fl_aprovar_contrato= '0' " .$empreendimentos. ") AS negociacao,
                (SELECT COUNT(status) FROM LOTES WHERE status = 'RT' " .$empreendimentos. ") AS reservaTecnica,
                (SELECT COUNT(status) FROM LOTES WHERE status = 'RC' " .$empreendimentos. ") AS reservados,
                (SELECT COUNT(status) FROM LOTES " .$totalEmpreendimentos. ") AS todosLotes
                FROM LOTES
                LIMIT 1
            "
        );

        return ['vendidos' => $lotes[0]['vendidos'], 'disponiveis' => $lotes[0]['disponiveis'], 'quitados' => $lotes[0]['quitados'], 'negociacao' => $lotes[0]['negociacao'], 'reservaTecnica' => $lotes[0]['reservaTecnica'], 'reservados' => $lotes[0]['reservados'], 'todosLotes' => $lotes[0]['todosLotes']];
    }

    //Monta o array para enviar para o framework
    public static function criaArrayDadosGraficos($dados) {
        
        $array = [
            'anoAnterior' => [0,0,0,0,0,0,0,0,0,0,0,0],
            'anoAtual' => []
        ];

        $mes = (int)date('m');

        for ($i = 0; $i < $mes; $i++) {
            $array['anoAtual'][$i] = 0;
        }
        
        foreach($dados as $dado) {
            $data = explode('-', $dado['data']);
            $ano = $data[0];
            $mes = (int)$data[1];

            if ($ano == (date('Y')-1)) {
                $array['anoAnterior'][$mes-1] = (int)$dado['total'];
            } elseif ($ano == date('Y')) {
                $array['anoAtual'][$mes-1] = (int)$dado['total'];
            } 
        }
        
        return $array;
    }

    public static function verificaDataReserva() {

        $lotes = (new Lote())->getDefaultAdapter()->select()->distinct()
        ->from(array('l' => TB_LOTES), array('idLote' => 'id', 'reservadoLote' => 'reservado'))
        ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id', 'temp_reserva'))
        ->joinLeft(array('c' => TB_CONTRATO), 'c.id_lote = l.id AND c.fl_distrato = "0"', array('idContrato' => 'id', 'fl_distrato', 'fl_aprovar_contrato'))
        ->joinLeft(array('rl' => TB_RESERVA_LOTE), 'rl.cod_lote = l.id AND rl.reservado = 1', array('idReserva' => 'id', 'data_reserva', 'reservadoReservaLote' => 'reservado', 'data_final' => 'data_final'))
        ->where('rl.reservado = ?', 1)
        ->group('l.id')
        ->group('l.quadra')
        ->query()->fetchAll();
        
        $totalLotesReservado = [];
        
        foreach ($lotes as $k => $lote) {

            $idContrato = $lote['idContrato'];
            $reservadoLote = $lote['reservadoLote'];
            $reservadoReservaLote = $lote['reservadoReservaLote'];

            if (!$idContrato && ($reservadoLote || $reservadoReservaLote)) {
                $totalLotesRT[] = $lote['idLote'];

                if ($lote['temp_reserva'] && $lote['data_reserva'] && !$reservadoLote) {
                    $totalLotesReservado[] = $lote['idLote'];
                    $timeZone = new DateTimeZone('UTC');

                    if($lote['data_final']){
                        //A data de expiracao da reserva
                        $dataExpiracao = Helper::dataParaBrasil($lote['data_final']);
                    }else{
                        //Data da reserva somado  quantidade de dias de reserva
                        $dataExpiracao = date('d/m/Y', strtotime("+" . $lote['temp_reserva'] . " days", strtotime($lote['data_reserva'])));
                    }

                    //Data atual em time
                    $dataAtualTime = DateTime::createFromFormat('d/m/Y', date('d/m/Y', strtotime("now")), $timeZone);

                    //Data de expirao em time
                    $dataExpiracaoTime = DateTime::createFromFormat('d/m/Y', $dataExpiracao, $timeZone);

                    if ($dataExpiracaoTime < $dataAtualTime) {
                        $reserva_lote = new Lote();
                        $reserva_lote = $reserva_lote->fetchRow('id = ' . $lote['idLote']);
                        $reserva_lote->reservado = '0';
                        $reserva_lote->status = 'D';
                        $reserva_lote->obs_reserva = null;
                        $reserva_lote->save();

                        $reserva = new ReservaLote();
                        $registros = $reserva->fetchAll('cod_lote = ' . $lote['idLote']);
                        foreach ($registros as $registro) {
                            $registro->delete();
                        }
                    }

                }
            }
        }
    }
    
    public static function retornaQuerySql() {
        
        $lotes = (new Lote())->getDefaultAdapter()->select()->distinct()
        ->from(array('l' => TB_LOTES), array('idLote' => 'id', 'reservadoLote' => 'reservado'))
        ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id', 'temp_reserva'))
        ->joinLeft(array('c' => TB_CONTRATO), 'c.id_lote = l.id AND c.fl_distrato = "0"', array('idContrato' => 'id', 'fl_distrato', 'fl_aprovar_contrato'))
        ->joinLeft(array('rl' => TB_RESERVA_LOTE), 'rl.cod_lote = l.id AND rl.reservado = 1', array('idReserva' => 'id', 'data_reserva', 'reservadoReservaLote' => 'reservado', 'data_final' => 'data_final'))
        // ->joinLeft(array('tpl' => TB_TABELA_PRECO_LOTES), 'tpl.id_lote = l.id', array(''))
        // ->joinLeft(array('tl' => TB_TIPO_LOTEAMENTO), 'tl.id_tipo_loteamento = e.id_tipo_loteamento', array('*'))
        ->group('l.id')
        ->group('l.quadra')
        ->query()->fetchAll();
        
        $totalLotesQuitados = [];
        $totalLotesVendidos = [];
        $$totalLotesNegociacao = [];
        $totalLotesRT = [];
        $totalLotesReservado = [];
        $totalLotesAbertos = [];
        
        foreach ($lotes as $k => $lote) {

            $idContrato = $lote['idContrato'];
            $reservadoLote = $lote['reservadoLote'];
            $reservadoReservaLote = $lote['reservadoReservaLote'];
            $flAprovarContrato = $lote['fl_aprovar_contrato'];

            //Se nao houver contrato e no estiver reservado o status  Disponivel
            if (!$idContrato && !$reservadoLote && !$reservadoReservaLote) {
                $totalLotesAbertos[] = $lote['idLote'];

                //Se houver contrato e o contrato tiver sido aprovado o status  Vendido
            } else if ($idContrato && $flAprovarContrato) {
                $totalLotesVendidos[] = $lote['idLote'];

                //se o contrato n?o for distratado e se a verifica??o de quita??o for positiva, o lote est? quitado
                if($lote['fl_distrato'] == '0') {
                    if (Parcela::verificaQuitacao($lote['idContrato'])) {
                        $totalLotesQuitados[] = $lote['idLote'];
                        unset($totalLotesVendidos[$k]);
                    }
                }

                //Se houver contrato e o contrato na tiver sido aprovado o status  Negociao
            } else if ($idContrato && !$flAprovarContrato) {
                $totalLotesNegociacao[] = $lote['idLote'];

                //Se no houver contrato e no estiver reservado o status  Reservado
            } else if (!$idContrato && ($reservadoLote || $reservadoReservaLote)) {
                $totalLotesRT[] = $lote['idLote'];

                //Faz o calculo da data de reserva, caso estiver expirado, automaticamente o lote mudar para disponivel
                //Lotes com reserva tecnica no entram na condio
                if ($lote['temp_reserva'] && $lote['data_reserva'] && !$reservadoLote) {
                    $totalLotesReservado[] = $lote['idLote'];
                    $timeZone = new DateTimeZone('UTC');

                    if($lote['data_final']){
                        //A data de expiracao da reserva
                        $dataExpiracao = Helper::dataParaBrasil($lote['data_final']);
                    }else{
                        //Data da reserva somado  quantidade de dias de reserva
                        $dataExpiracao = date('d/m/Y', strtotime("+" . $lote['temp_reserva'] . " days", strtotime($lote['data_reserva'])));
                    }

                    //Data atual em time
                    $dataAtualTime = DateTime::createFromFormat('d/m/Y', date('d/m/Y', strtotime("now")), $timeZone);

                    //Data de expirao em time
                    $dataExpiracaoTime = DateTime::createFromFormat('d/m/Y', $dataExpiracao, $timeZone);

                    if ($dataExpiracaoTime < $dataAtualTime) {
                        $totalLotesAbertos[] = $lote['idLote'];
                    }

                }
            }
        }
        print_r('-- LOTES VENDIDOS');
        print_r('</br>');
        $totalLotesVendidos = implode('","', $totalLotesVendidos);
        print_r('UPDATE LOTES SET status = "V" WHERE id IN ("' . $totalLotesVendidos . '");');
        print_r('</br>');
        print_r('</br>');
        print_r('-- LOTES DISPON?VEIS');
        print_r('</br>');
        $totalLotesAbertos = implode('","', $totalLotesAbertos);
        print_r('UPDATE LOTES SET status = "D" WHERE id IN ("' . $totalLotesAbertos . '");');
        print_r('</br>');
        print_r('</br>');
        print_r('-- LOTES QUITADOS');
        print_r('</br>');
        $totalLotesQuitados = implode('","', $totalLotesQuitados);
        print_r('UPDATE LOTES SET status = "Q" WHERE id IN ("' . $totalLotesQuitados . '");');
        print_r('</br>');
        print_r('</br>');
        print_r('-- LOTES EM NEGOCIA??O');
        print_r('</br>');
        $totalLotesNegociacao = implode('","', $totalLotesNegociacao);
        print_r('UPDATE LOTES SET status = "N" WHERE id IN ("' . $totalLotesNegociacao . '");');
        print_r('</br>');
        print_r('</br>');
        print_r('-- LOTES EM RESERVA T?CNICA');
        print_r('</br>');
        $totalLotesRT = implode('","', $totalLotesRT);
        print_r('UPDATE LOTES SET status = "RT" WHERE id IN ("' . $totalLotesRT . '");');
        print_r('</br>');
        print_r('</br>');
        print_r('-- LOTE RESERVADO');
        print_r('</br>');
        $totalLotesReservado = implode('","', $totalLotesReservado);
        print_r('UPDATE LOTES SET status = "RC" WHERE id IN ("' . $totalLotesReservado . '");');
    }
}