<?php

class Filesystem
{

    public static function upload($from, $to)
    {
        $path = pathinfo($to)['dirname'];
        if (!is_dir($path)) {
            mkdir($path);
        }
        return move_uploaded_file($from, $to);
    }

    /**
     * @author erkethan at free dot fr
     */
    public static function delete($dir)
    {
        if (!file_exists($dir)) return true;
        chmod($dir , 0777);
        if (!is_dir($dir) || is_link($dir)) return unlink($dir);
        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..') continue;
            if (!self::delete($dir . DIRECTORY_SEPARATOR . $item)) {
                chmod($dir . DIRECTORY_SEPARATOR . $item, 0777);
                if (!self::delete($dir . DIRECTORY_SEPARATOR . $item)) return false;
            };
        }
        return rmdir($dir);
    }


}

