<?php

class EmpreendimentoContabeis extends Zend_Db_Table_Abstract
{
    protected $_name = TB_EMPREENDIMENTO_CONTABEIS;

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'e.id',
            1 => 'e.nm_empreendimento',
            2 => 'pcont.nmContador',
            3 => 'pJuri.nmPessoaJuridica',
        );

        if ($search) {
            $where = 'e.id LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or pcont.nmContador LIKE "%' . $search . '%" ';
            $where .= 'or pJuri.nmPessoaJuridica LIKE "%' . $search . '%" ';
        }

        $lista = self::getDefaultAdapter()->select()
            ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), '*')
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = ec.id_empreendimento', 'nm_empreendimento')
            ->join(array('pCont' => TB_PESSOA), 'pCont.id = ec.id_contador', array('nmContador'=>'nm_pessoa'))
            ->join(array('pJuri' => TB_PESSOA), 'pJuri.id = ec.id_pessoa_juridica', array('nmPessoaJuridica'=>'nm_pessoa'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
            $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
            if (count($ids)) {
                $id = implode(',', $ids);
                $lista->where("e.id IN({$id})");
            }
        }

        if (isset($where)) {
            $lista = $lista->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $lista = $lista->limit($post['length'], $post['start']);
            }
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $lista = $lista->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $lista;
    }

    public static function getDadosContabeis($idEmpreendimento,$idRespJuridico,$idContador)
    {
        return self::getDefaultAdapter()->select()
            ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), '*')
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = ec.id_empreendimento', 'nm_empreendimento')
            ->join(array('pCont' => TB_PESSOA), 'pCont.id = ec.id_contador', array('nmContador'=>'nm_pessoa','idContador'=>'id'))
            ->join(array('pJuri' => TB_PESSOA), 'pJuri.id = ec.id_pessoa_juridica', array('nmPessoaJuridica'=>'nm_pessoa','idPessoaJuridica'=>'id'))
            ->joinLeft(array('pContab' => TB_PESSOA), 'pContab.id = ec.id_contabilidade', array('nmContabilidade'=>'nm_pessoa','idContabilidade'=>'id'))
            ->joinLeft(array('pRFB' => TB_PESSOA), 'ec.id_pessoa_fisica_RFB = pRFB.id', array('nmPessoaRFB' => 'nm_pessoa'))
            ->where('id_pessoa_juridica = '.$idRespJuridico)
            ->where('id_empreendimento = '.$idEmpreendimento)
            ->where('id_contador = '.$idContador)
            ->query()->fetch(); 
    }

    public static function getRespJuridicos()
    {
        $respJuridicos = self::getDefaultAdapter()->select()
            ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), '*')
            ->join(array('p' => TB_PESSOA), 'p.id = ec.id_pessoa_juridica', array('nm_pessoa','id'))
            ->group('ec.id_pessoa_juridica');

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if (Login::getUsuario()) {
            if (Login::getUsuario()->getSuper() == '0') {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $respJuridicos->where("ec.id_empreendimento IN({$id})");
                } else {
                    $respJuridicos->where("1");
                }
            }
        }

        return $respJuridicos->query()->fetchAll();
    }

    public static function findPorcentagemDeclarada($idEmpreendimento)
    {
        $listaEmpreendimentoContabeis = self::getDefaultAdapter()->select()
            ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), '*')
            ->where('id_empreendimento = '.$idEmpreendimento)
            ->query()->fetchAll();

        $porcDeclarada = 0;
        foreach ($listaEmpreendimentoContabeis as $empreendimentoContabeis) {
            $porcDeclarada += $empreendimentoContabeis['vl_porc_declarada'];
        }

        return $porcDeclarada;
    }

    public static function findPjResponsavelCorretor($idRespJuridico,$idEmpreendimento,$idContador)
    {
        $empreendimentoContabeis = self::getDefaultAdapter()->select()
            ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), '*')
            ->where('id_pessoa_juridica = '.$idRespJuridico)
            ->where('id_empreendimento = '.$idEmpreendimento)
            ->where('id_contador = '.$idContador)
            ->query()->fetch();

        return ($empreendimentoContabeis)?1:0;
    }
}



