<?php

class Empreendimento extends Zend_Db_Table_Abstract
{

    protected $_name = TB_EMPREENDIMENTO;

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false)
    {
        $result = array();
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = Db::getInstance();

        if ($count && $offset === false && $page === false) {
            $select = "SELECT count(e.id) AS count FROM " . TB_EMPREENDIMENTO . " e  WHERE e.nm_empreendimento LIKE {$termo}";
        } else {
            $select = "SELECT e.id FROM " . TB_EMPREENDIMENTO . " e  WHERE e.nm_empreendimento LIKE {$termo}";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($count && $offset === false && $page === false) return $ids;

        if (is_array($ids) && count($ids)) {
            foreach ($ids as $id) {
                $result[] = self::findEmpreendimento($id['id']);
            }
        }
        return $result;
    }

    /**
     * Busca a pessoa relacionada a parceria do empreendimento
     * @param $idEmp
     * @return mixed|Zend_Db_Adapter_Abstract
     */
    public static function getPessoaJuridica($idEmp)
    {
        $pessoa = self::getDefaultAdapter();
        $pessoa = $pessoa->select()->from(array('e' => TB_EMPREENDIMENTO), array('id'))
            ->join(array('pa' => TB_PARCERIA), 'pa.id_empreendimento = e.id')
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = pa.id_pessoa', array('pe.nm_pessoa', 'tp_pessoa'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = pe.id', 'nr_cpf')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', 'pj.nr_cnpj')
            ->where('e.id = ?', $idEmp)->query()->fetch();

        return $pessoa;
    }

    /**
     * Busca uma instancia da classe Empreendimento pelo id do mesmo
     * @param integer $id
     * @return Empreendimento
     */
    public static function findEmpreendimento($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT * FROM " . TB_EMPREENDIMENTO . " e WHERE e.id = ?");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS, "Empreendimento");
        return $stmt->fetch();
    }

    /**
     * Busca os dados do Empreendimento
     * @param integer $id
     * @return array
     */
    public static function findEmpreendimentoDados($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT * FROM " . TB_EMPREENDIMENTO . " e WHERE e.id = ?");
        $stmt->execute(array($id));
        return $stmt->fetch();
    }

    /**
     * Busca os dados do Empreendimento pelo nome
     * @param string $nome
     * @return array
     */
    public static function findEmpreendimentosByNome($nome)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare('SELECT * FROM ' . TB_EMPREENDIMENTO . ' e WHERE e.nm_empreendimento LIKE "%' . $nome . '%"');
        $stmt->execute();
        $stmt->setFetchMode(PDO::FETCH_ASSOC);
        return $stmt->fetchAll();
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'e.id',
            1 => 'e.nm_empreendimento'
        );

        if ($search) {
            $where = 'e.id LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']->getSuper() != '1') {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if ($ids && count($ids)) {
                    $id = implode(',', $ids);
                    $itens->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $itens = $itens->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $itens;
    }

    /**
     * Funo que retorna os empreendimentos cadastrados e que o usurio tem permisso de acessar
     */
    public static function getEmpreendimentos($exibirContabeis = false) {

        $empreendimento = self::getDefaultAdapter();
        $listaEmpreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));
        if ($exibirContabeis) {
            $listaEmpreendimento->joinLeft(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), 'ec.id_empreendimento = e.id', array('*'))
                ->joinLeft(array('p' => TB_PESSOA), 'p.id = ec.id_pessoa_juridica', array('nmRespJuridico'=>'nm_pessoa'));
        }

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if (Login::getUsuario()) {
            if (Login::getUsuario()->getSuper() == '0') {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaEmpreendimento->where("e.id IN({$id})");
                } else {
                    $listaEmpreendimento->where("1");
                }
            }
        }
        return $listaEmpreendimento->order('nm_empreendimento')->query()->fetchAll();
    }

    public static function listarAgendamentos($idEmpreendimento = null) {

        $agendamentos = self::getDefaultAdapter()->select()
            ->from(array('r' => TB_RELACIONAMENTO), ['idRelacionamento' => 'id','data', 'dt_retorno'])
            ->join(array('c' => TB_CONTRATO), 'c.id = r.idContrato', ['c.id as id_contrato'])
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'p.nm_pessoa')
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', ['l.quadra', 'l.lote'])
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', ['l.quadra', 'l.lote', 'nm_empreendimento'])
            ->where("r.dt_retorno = '".date('Y-m-d')."'")
            ->where("r.fl_encerrado = '0'");
        
        if($idEmpreendimento)
            $agendamentos = $agendamentos->where("l.id_empreendimento = ?", $idEmpreendimento);

        if ($_SESSION['usuario']->getSuper() != '1' && $_SESSION['usuario']->getPerfilId() != '1' && !Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'Visualizar_agenda')) {
            $agendamentos->where("r.usuario = '".Login::getUsuario()->getId()."'");
        }
        $agendamentos = Helper::filtraPorUsuario($agendamentos);

        return $agendamentos;
    }

    /**
     * Busca um empreendimento pelo id do contrato.
     */
    public static function getEmpreendimentoByContrato ($idContrato)
    {
        return self::getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), '')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '')
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', '*')
            ->where('c.id = ' . $idContrato)
            ->query()->fetch();
    }

    public function getEmpreendimentosUsuario($verificarPermissao = true)
    {

        //Buscando a lista de empreendimentos para o select
        $listaEmpreendimentos = $this->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if (Login::getUsuario() && $verificarPermissao) {

            $instanceUsuarioEmpreendimento = new UsuarioEmpreendimento();
            $idsUsuarioEmpreendimento = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante(Login::getUsuario());

            if ($idsUsuarioEmpreendimento) {
                $idsUsuarioEmpreendimento = implode(',', $idsUsuarioEmpreendimento);
                $listaEmpreendimentos = $listaEmpreendimentos->where("e.id IN({$idsUsuarioEmpreendimento})");
            }

        }

        return $listaEmpreendimentos->order('e.nm_empreendimento')->query()->fetchAll();
    }

    public function alteraQuantidadeDownloads($qtdDownload)
    {
        $empreendimentos = self::fetchAll();

        foreach ($empreendimentos as $emp)
        {
            $emp->qtd_download = $qtdDownload;
            $emp->save();
        }
    }

    public function verificaQuantidadeDownloads($empreendimento)
    {
        $qtdDownloads = self::fetchRow('id = ' . $empreendimento);
        
        return $qtdDownloads['qtd_download'];
    }
    public function getLista()
    {
        return self::getDefaultAdapter()->select()
        ->from(array(TB_EMPREENDIMENTO))
        ->query()->fetchAll();
    }
}