<?php

class ContratoException extends Exception
{

}

class Contrato extends Zend_Db_Table_Abstract
{
    const CONTRATO_GERADO = '1';
    const CONTRATO_NAO_GERADO = '0';
    const CONTRATO_TODOS = '3';

    static $contratoInstacia;
    protected $_name = TB_CONTRATO;

    /**
     * Busca os contratos pelo id do empreendimento
     *
     * @param $empreendimento = id do empreendimento
     * @param string $tipo = tipo de contrato (gerados, nao gerados ou todos)
     * @param null $distratado = true para contratos distratos ou false para no distratados
     * @param null $order = ordenao da lista
     * @param bool $aprovados = true para contratos aprovados ou false para no aprovados
     * @return array|Zend_Db_Select = lista dos contratos
     */
    public function getContrato($id)
    {
        return self::getInstance()->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), '*')
            ->where('c.id = ?', $id)
            ->query()->fetch();
    }
    public static function contratos($idEmpreendimento = null) {

    $ano = date('Y');
    $mes = date('m');

    $contratosMesAtual = self::getDefaultAdapter()->select()
        ->from(array('c' => TB_CONTRATO), 'c.id', null)
        ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
        ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', null)
        ->where("c.fl_distrato = '0'")
        ->where("c.fl_aprovar_contrato = '1'")
        ->where("dt_contrato <= '".$ano."-".$mes."-31'");

    if($idEmpreendimento)
        $contratosMesAtual = $contratosMesAtual->where("l.id_empreendimento = ?", $idEmpreendimento);

        $contratosMesAtual = count(Helper::filtraPorUsuario($contratosMesAtual));

        if ($mes == 1) {
            $mes = 12;
            $ano--;
        } else {
            $mes--;
        }

        $contratosMesAnterior = self::getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), 'c.id', null)
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', null)
            ->where("c.fl_distrato = '0'")
            ->where("c.fl_aprovar_contrato = '1'")
            ->where("dt_contrato <= '".$ano."-".$mes."-31'");

        if($idEmpreendimento)
            $contratosMesAnterior = $contratosMesAnterior->where("l.id_empreendimento = ?", $idEmpreendimento);

        $contratosMesAnterior = count(Helper::filtraPorUsuario($contratosMesAnterior));

        if ($contratosMesAtual > 0) {

            return Helper::calculaPorcentagem($contratosMesAtual, $contratosMesAnterior);
        } else if ($contratosMesAtual == 0 && $contratosMesAnterior > 0) {

            return Helper::calculaPorcentagem($contratosMesAtual, $contratosMesAnterior);
        } else {

            return array('qtdMesAtual' => 0, 'total' => 0, 'aviso' => 'Quantidade igual ao ms anterior');
        }
    }
}
