<?php

class Download extends Zend_Db_Table_Abstract
{

    protected $_name = TB_DOWNLOAD;

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'e.nm_empreendimento',
            1 => 'd.nm_download',
            2 => 'd.dt_cadastro'
        );

        if ($search) {
            $where = 'e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or d.nm_download LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('d' => TB_DOWNLOAD), array('*'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'd.id_emp = e.id', array('e.nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $itens->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        $orderByQuery = array();
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $itens = $itens->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $itens;
    }

    public static function buscaQtdDownloads($idEmpreendimento)
    {
        $qtdDownload = (new Download())->fetchAll('id_emp = ' . $idEmpreendimento)->toArray();
        return count($qtdDownload);
    }
}
