<?php

class DocusignEventos extends Zend_Db_Table_Abstract
{

    protected $_name = TB_DOCUSIGN_EVENTO;

    public function adicionar($envelopeId,$envelopeDataEvento,$envelopeEvento,$destinatarioNome,$destinatarioEmail,$destinatarioId,$remetenteEmail,$remetenteNome,$remetenteId)
    {
        $docusign = $this->createRow();
        $docusign->envelopeId = $envelopeId;
        $docusign->envelopeDataEvento = $envelopeDataEvento;
        $docusign->envelopeEvento = $envelopeEvento;
        $docusign->destinatarioNome = $destinatarioNome;
        $docusign->destinatarioEmail = $destinatarioEmail;
        $docusign->destinatarioId = $destinatarioId;
        $docusign->remetenteEmail = $remetenteEmail;
        $docusign->remetenteNome = $remetenteNome;
        $docusign->remetenteId = $remetenteId;
        
        return $docusign->save();
    }

    public function getLista($limit,$offset,$filtro,$contrato)
    {
        $where = "where de.envelopeEvento != 'envelope-sent'";
        $group = "group by de.envelopeEvento";
        if($filtro){
            $where = " and (de.destinatarioEmail = '".$filtro."' or de.envelopeEvento = '".$filtro."')";
        }
        $data = $this->getDefaultAdapter()->query("SELECT SQL_CALC_FOUND_ROWS `de`.*, `dv`.`id_contrato`,e.nm_empreendimento, CONCAT('[',GROUP_CONCAT(JSON_OBJECT(
            'nome', IFNULL(destinatarioNome,envelopeDataEvento),
            'data', envelopeDataEvento
          )),']') as assinaturas ,GROUP_CONCAT(destinatarioEmail SEPARATOR ',<br>') as emails 
        FROM `DOCUSIGN_EVENTOS` AS `de`
        INNER JOIN `DOCUSIGN_VINCULO` AS `dv` ON dv.id_envelope = de.envelopeId AND dv.id_contrato = '$contrato'
        INNER JOIN `CONTRATO` AS `c` ON c.id = dv.id_contrato
        INNER JOIN `LOTES` AS `l` ON c.id_lote = l.id
        INNER JOIN `EMPREENDIMENTO` AS `e` ON e.id = l.id_empreendimento
        $where
        $group
        ORDER BY de.envelopeDataEvento DESC
        LIMIT 	$limit OFFSET $offset;")->fetchAll();
        $count = $this->getDefaultAdapter()->fetchOne("select FOUND_ROWS()");
        return array('data'=>$data,'recordsTotal'=>$count,'recordsFiltered'=> $count);
    }
    public function getById($id,$evento)
    {
        $eventos = $this->getDefaultAdapter()->select()
            ->from(['de' => TB_DOCUSIGN_EVENTO])
            ->where("de.envelopeId = '{$id}'");
        if($evento){
            $eventos->where("de.envelopeEvento = '{$evento}'");
        }
        return $eventos->query()->fetchAll();
    }
}