<?php

class DocusignCadastro extends Zend_Db_Table_Abstract
{

    const TABLE_NAME = "DOCUSIGN";
    protected $_name = TB_DOCUSIGN;

    public function adicionar($dados)
    {
        $docusign = $this->createRow();
        $docusign->docusign_id_cliente = $dados['docusign_id_cliente'];
        $docusign->docusign_integration_key = $dados['docusign_integration_key'];
        $docusign->docusign_secret_key = $dados['docusign_secret_key'];
        $docusign->docusign_code = $dados['docusign_code'];
        $docusign->docusign_access_token = $dados['docusign_access_token'];
        $docusign->docusign_refresh_token = $dados['docusign_refresh_token'];
        $docusign->docusign_empreendimento = $dados['docusign_empreendimento'];
        $docusign->docusign_email = $dados['docusign_email'];
        $docusign->docusign_nome = $dados['docusign_nome'];
        return $docusign->save();
    }
    public function atualizar($docusignId,$dados)
    {
        $docusign = $this->fetchRow("id = '{$docusignId}'");

        $docusign->docusign_id_cliente = $dados['docusign_id_cliente'];
        $docusign->docusign_integration_key = $dados['docusign_integration_key'];
        $docusign->docusign_secret_key = $dados['docusign_secret_key'];
        $docusign->docusign_code = $dados['docusign_code'];
        $docusign->docusign_access_token = $dados['docusign_access_token'];
        $docusign->docusign_refresh_token = $dados['docusign_refresh_token'];
        $docusign->docusign_empreendimento = $dados['docusign_empreendimento'];
        $docusign->docusign_email = $dados['docusign_email'];
        $docusign->docusign_nome = $dados['docusign_nome'];
        return $docusign->save();
    }

    public function atualizarCode($docusignId,$code)
    {
        $docusign = $this->fetchRow("id = '{$docusignId}'");

        $docusign->docusign_code = $code;
        return $docusign->save();
    }
    public function atualizarToken($docusignId,$access,$refresh)
    {
        $docusign = $this->fetchRow("id = '{$docusignId}'");

        $docusign->docusign_access_token = $access;
        $docusign->docusign_refresh_token = $refresh;
        return $docusign->save();
    }
    public function getLista($id = false,$empreendimento=false)
    {
        $query =$this->getDefaultAdapter()->select()
        ->from(['d' => TB_DOCUSIGN])
            ->joinLeft(['e' => TB_EMPREENDIMENTO],'e.id = d.docusign_empreendimento',['e.nm_empreendimento'])
            ->order('d.id desc');
        if($id){
            $query->where('d.id = ?',$id);
        }
        if($empreendimento){
            $query->where('d.docusign_empreendimento = ? or d.docusign_empreendimento = -1',$empreendimento);
            $docusign = $query->query()->fetchAll();
            $infoEmpreendimento =$this->getDefaultAdapter()->select()
                ->from(['e' => TB_EMPREENDIMENTO])
                ->where('e.id = ?',$empreendimento)->query()->fetchAll();
            return array('docusign'=>$docusign,'empreendimento'=>$infoEmpreendimento[0]);
        }
        return $query->query()->fetchAll();
        
        
    }

    public function delete($id){
        $db = Db::getInstance();
        $delete  = "DELETE FROM ".self::TABLE_NAME."
					WHERE id = ?";
        $stmt = $db->prepare($delete);
        return $stmt->execute(array($id));
    }
}