<?php
class Distrato extends Zend_Db_Table_Abstract {

    protected $_name = TB_DISTRATO;

    static $distratoInstancia;

    //retorna uma instancia do objeto para uso de SINGLETON
    public static function getInstance()
    {
        if (!self::$distratoInstancia) {
            self::$distratoInstancia = new ContratoPessoa();
        }
        return self::$distratoInstancia;
    }

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false, $where = null) {
        $result = array();
        $termo = "'%".strtoupper($termo)."%'";
        $db = DB::getInstance();
        if($count && $offset === false && $page === false) {
            $select = "SELECT count(d.id_contrato) AS count  FROM ".TB_DISTRATO." d
                    JOIN ".TB_CONTRATO." c  ON c.id = d.id_contrato
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                    JOIN ".TB_LOTES." l  ON c.id_lote = l.id
                    JOIN ".TB_EMPREENDIMENTO." e  ON l.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento), ' ', l.lote, l.quadra, c.id,' ',UPPER(p.nm_pessoa)) LIKE {$termo}";
            if ($where) {
                $select .= " AND $where";
            }
        } else {
            $select = "SELECT d.id_contrato AS id, l.quadra FROM ".TB_DISTRATO." d
                    JOIN ".TB_CONTRATO." c  ON c.id = d.id_contrato
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                    JOIN ".TB_LOTES." l  ON c.id_lote = l.id
                    JOIN ".TB_EMPREENDIMENTO." e  ON l.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento), ' ', l.lote, l.quadra, c.id, ' ',UPPER(p.nm_pessoa)) LIKE {$termo} ";
            if ($where) {
                $select .= " AND $where";
            }
            if($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }

        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if($count && $offset === false && $page === false) return  $ids;

        if(is_array($ids) && count($ids)) {
            foreach ($ids as $id) {
                $result[] = self::findDistrato($id['id']);
            }
        }
        return $result;
    }

    /**
     *
     * @param integer $id
     * @return array
     */
    public static function findDistrato($id) {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT d.id_contrato AS id, e.nm_empreendimento, l.lote, p.nm_pessoa , l.quadra FROM ".TB_DISTRATO." d
                                JOIN ".TB_CONTRATO." c  ON c.id = d.id_contrato
                                JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                                JOIN ".TB_LOTES." l  ON c.id_lote = l.id
                                JOIN ".TB_EMPREENDIMENTO." e  ON l.id_empreendimento = e.id
                              WHERE d.id_contrato = ?");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS,"Distrato");
        return $stmt->fetch();
    }

    //Retorna os contratos_pessoa pelo contrato
    public static function findByContrato($contrato)
    {
        $distrato = self::getInstance();
        $distrato = $distrato->getDefaultAdapter()->select()->from(array('d' => TB_DISTRATO), array('*'))
            ->where('d.id_contrato = ?', $contrato)->query()->fetch();

        return $distrato;
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'c.id',
            1 => 'e.nm_empreendimento',
            2 => 'l.quadra',
            3 => 'l.lote',
            4 => 'p.nm_pessoa',
            5 => 'd.dt_distrato'
        );

        if ($search) {
            $where = 'c.id LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or d.dt_distrato LIKE "%' . $search . '%" ';
            $where .= 'or YEAR(d.dt_distrato) = "' . $search. '" ';
            $where .= 'or MONTH(d.dt_distrato) = "' . $search. '" ';
            $where .= 'or DAY(d.dt_distrato) = "' . $search. '" ';
        }

        $contratos = self::getDefaultAdapter()->select()
            ->from(array('d' => TB_DISTRATO), '*')
            ->join(array('c' => TB_CONTRATO), 'c.id = d.id_contrato', '*')
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'p.nm_pessoa')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.lote', 'l.quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'e.nm_empreendimento')
            ->where('fl_distrato = "1"');


        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $contratos->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $contratos = $contratos->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $contratos = $contratos->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $contratos = $contratos->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $contratos;
    }

    public static function distratos($idEmpreendimento = null) {

        $ano = date('Y');
        $mes = date('m');

        $distratosMesAtual = self::getDefaultAdapter()->select()
            ->from(array('d' => TB_DISTRATO), 'd.id_contrato')
            ->join(array('c' => TB_CONTRATO), 'c.id = d.id_contrato', null)
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', null)
            ->where("d.dt_distrato <= '".$ano."-".$mes."-31'");

        if ($idEmpreendimento)
            $distratosMesAtual = $distratosMesAtual->where("l.id_empreendimento = ?", $idEmpreendimento);

        return ['qtdMesAtual' => count(Helper::filtraPorUsuario($distratosMesAtual))];
    }
}