<?php
/**
 * Created by PhpStorm.
 * User: usuario
 * Date: 23/10/19
 * Time: 16:41
 */

class Dimob extends Zend_Db_Table_Abstract
{
    protected $name = TB_DIMOB;

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'd.id_dimob',
            1 => 'e.nm_empreendimento',
            2 => 'd.dt_geracao',
            3 => 'd.ds_ano',
            4 => 'd.ds_arquivo',
        );

        if ($search) {
            $where = 'd.id_dimob LIKE "%'.$search.'%"';
            $where .= 'or e.nm_empreendimento LIKE "%'.$search.'%"';
            $where .= 'or d.ano_contrato = "'.$search.'"';
            $where .= 'or d.ano_recebimento = "'.$search.'"';
            $where .= 'or d.ds_arquivo LIKE "%'.$search.'%"';
            $where .= 'or DAY(d.dt_geracao) = "'.$search.'"';
            $where .= 'or MONTH(d.dt_geracao) = "'.$search.'"';
            $where .= 'or YEAR(d.dt_geracao) = "'.$search.'"';
        }

        $lista = self::getDefaultAdapter()->select()
            ->from(array('d' => TB_DIMOB), '*')
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = d.id_empreendimento', 'nm_empreendimento');

        //verifica se o usurio tem o perfil de usurio de empreendimento
        if (Login::getUsuario()->getSuper() == '0') {
            $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
            $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
            if (count($ids)) {
                $id = implode(',', $ids);
                $lista->where("e.id IN({$id})");
            }
        }

        if (isset($where)) {
            $lista = $lista->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $lista = $lista->limit($post['length'], $post['start']);
            }
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']].' '.$ord['dir'];

        $lista = $lista->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $lista;
    }
}