<?php

class Db_Modulo
{

    private $id;
    private $nome;
    private $path;
    private $ds_icon;
    private $fl_painel_venda;
    private $fl_acade_ged;
    private $fl_exibir_menu;
    private $fl_senhaportal;
    private $log;

    const TABLE_NAME = "SC_MODULO";

    public function getId()
    {
        return $this->id;
    }

    public function getNome()
    {
        return $this->nome;
    }

    public function getFlPainelVenda()
    {
        return $this->fl_painel_venda;
    }

    public function setFlPainelVenda($flPainelVenda)
    {
        $this->fl_painel_venda = $flPainelVenda;
    }

    public function getFlAcadeGed()
    {
        return $this->fl_acade_ged;
    }

    public function setFlAcadeGed($fl_acade_ged)
    {
        $this->fl_acade_ged = $fl_acade_ged;
    }

    public function getFlExibirMenu()
    {
        return $this->fl_exibir_menu;
    }

    public function setFlExibirMenu($fl_exibir_menu)
    {
        $this->fl_exibir_menu = $fl_exibir_menu;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function setNome($nome)
    {
        $this->nome = $nome;
    }

    public function setPath($path)
    {
        $this->path = $path;
    }
    
        public function getFlSenhaPortal()
    {
        return $this->fl_senhaportal;
    }

    public function setFlSenhaPortal($fl_senhaportal)
    {
        $this->fl_senhaportal = $fl_senhaportal;
    }

    /**
     * @param $log the $log to set
     */
    public function setLog($log)
    {
        $this->log = $log;
    }

    public function getPath()
    {
        return $this->path;
    }

    /**
     * @return mixed
     */
    public function getIcon()
    {
        return $this->ds_icon;
    }

    /**
     * @param mixed $icon
     */
    public function setIcon($icon)
    {
        $this->ds_icon = $icon;
    }

    /**
     * @return the $log
     */
    public function getLog()
    {
        return $this->log;
    }

    public function save()
    {
        $db = Db::getInstance();
        $insert = "INSERT INTO " . self::TABLE_NAME . " VALUES (:id, :nome, :path, :log)";
        $insert .= " ON DUPLICATE KEY UPDATE nome = :nome, path = :path, log = :log ;";

        $stmt = $db->prepare($insert);

        $param = array(
            "id" => $this->getId(),
            "nome" => $this->getNome(),
            "path" => $this->getPath(),
            "log" => $this->getLog(),
        );
        $save = $stmt->execute($param);
        if (!$this->getId()) $this->setId($db->lastInsertId());
        return $save;
    }

    public static function find($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT * FROM " . self::TABLE_NAME . "
		                      WHERE id = ?");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS, __CLASS__);
        return $stmt->fetch();
    }

    public static function fullSearch($termo, $count = false, $offset = false, $page = false)
    {
        $result = array();
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = DB::getInstance();

        if ($count && $offset === false && $page === false) {
            $select = "SELECT count(*) AS count FROM " . self::TABLE_NAME . "
				   WHERE id <> 1 AND CONCAT(id,' ',UPPER(nome),' ',UPPER(path)) LIKE {$termo}";
        } else {
            $select = "SELECT * FROM " . self::TABLE_NAME . "
				   WHERE id <> 1 AND CONCAT(id,' ',UPPER(nome),' ',UPPER(path)) LIKE {$termo} ";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }

        $stmt = $db->prepare($select);
        $stmt->execute();
        $stmt->setFetchMode(PDO::FETCH_CLASS, __CLASS__);
        return $stmt->fetchAll();
    }

    public static function delete($id)
    {
        $db = Db::getInstance();
        $delete = "DELETE FROM " . self::TABLE_NAME . "
					WHERE id = ?";
        $stmt = $db->prepare($delete);
        return $stmt->execute(array($id));
    }

    public static function fetchAll($count = false, $offset = false, $page = false)
    {
        $db = Db::getInstance();
        if ($count && $offset === false && $page === false) {
            $stmt = $db->prepare("SELECT count(*) AS count FROM " . self::TABLE_NAME . " WHERE id <> 1");
        } else {
            $select = "SELECT * FROM " . self::TABLE_NAME . " WHERE id <> 1 ";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page}";
            $stmt = $db->prepare($select);
        }
        $stmt->execute();
        $stmt->setFetchMode(PDO::FETCH_CLASS, __CLASS__);
        return $stmt->fetchAll();
    }

    public static function findAllLotear($count = false, $offset = false, $page = false)
    {
        $db = Db::getInstance();
        if ($count && $offset === false && $page === false) {
            $stmt = $db->prepare("SELECT count(*) AS count FROM " . self::TABLE_NAME . " WHERE id <> 1");
        } else {
            $select = "SELECT * FROM " . self::TABLE_NAME . " WHERE fl_painel_venda = '0' AND fl_acade_ged = '0' AND fl_acade_expert = '0'";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page}";
            $select .= ' ORDER BY ' . self::TABLE_NAME . '.nome';
            $stmt = $db->prepare($select);
        }
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public static function findAllPainel($count = false, $offset = false, $page = false)
    {
        $db = Db::getInstance();
        if ($count && $offset === false && $page === false) {
            $stmt = $db->prepare("SELECT count(*) AS count FROM " . self::TABLE_NAME . " WHERE id <> 1");
        } else {
            $select = "SELECT * FROM " . self::TABLE_NAME . " WHERE fl_painel_venda = '1'";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page}";
            $select .= ' ORDER BY ' . self::TABLE_NAME . '.nome';
            $stmt = $db->prepare($select);
        }
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public static function findAllGED($count = false, $offset = false, $page = false)
    {
        $db = Db::getInstance();
        if ($count && $offset === false && $page === false) {
            $stmt = $db->prepare("SELECT count(*) AS count FROM " . self::TABLE_NAME . " WHERE id <> 1");
        } else {
            $select = "SELECT * FROM " . self::TABLE_NAME . " WHERE fl_acade_ged = '1'";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page}";
            $select .= ' ORDER BY ' . self::TABLE_NAME . '.nome';
            $stmt = $db->prepare($select);
        }
        $stmt->execute();
        return $stmt->fetchAll();
    }
    public static function findAllExpert($count = false, $offset = false, $page = false)
    {
        $db = Db::getInstance();
        if ($count && $offset === false && $page === false) {
            $stmt = $db->prepare("SELECT count(*) AS count FROM " . self::TABLE_NAME . " WHERE id <> 1");
        } else {
            $select = "SELECT * FROM " . self::TABLE_NAME . " WHERE fl_acade_expert = '1'";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page}";
            $select .= ' ORDER BY ' . self::TABLE_NAME . '.nome';
            $stmt = $db->prepare($select);
        }
        $stmt->execute();
        return $stmt->fetchAll();
    }
    // criado por railan portal
     public static function findAllPortal($count = false, $offset = false, $page = false)
    {
      $db = Db::getInstance();
      if ($count && $offset === false && $page === false) {
          $stmt = $db->prepare("SELECT count(*) AS count FROM " . self::TABLE_NAME . " WHERE id <> 1");
      } else {
          $select = "SELECT * FROM " . self::TABLE_NAME . " WHERE fl_painel_venda = '0' AND fl_acade_ged = '0' AND fl_senhaportal = '1'";
          if ($offset !== false && $page !== false)
              $select .= " LIMIT {$offset}, {$page}";
          $select .= '  ORDER BY ' . self::TABLE_NAME . '.nome';
          $stmt = $db->prepare($select);
      }
      $stmt->execute();
      return $stmt->fetchAll();
    }


    public static function findByPath($path)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT * FROM " . self::TABLE_NAME . "
		                      WHERE path = ?");
        $stmt->execute(array($path));
        $stmt->setFetchMode(PDO::FETCH_CLASS, __CLASS__);
        return $stmt->fetch();
    }

}