<?php

class Corretor_Empreendimento extends Zend_Db_Table_Abstract
{
    protected $_name = TB_CORRETOR_EMPREENDIMENTO;

    /**
     * Busca o registro de corretor empreendimento e retorna uma instancia da classe
     * @param integer $id
     * @return Corretor_empreendimento
     */
    public static function findCorretorDados($idCorretor,$idEmpreendimento)
    {
        return self::getDefaultAdapter()->select()
            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), array('id_imobiliaria','nr_creci','nr_creci_pj', 'tp_comissao', 'pc_comissao'))
            ->join(array('p' => TB_PESSOA), 'p.id = ce.id_corretor', array('nm_pessoa','nr_telefone', 'nr_celular', 'nr_fax', 'nr_recado', 'nr_cep', 'nr_endereco', 'endereco','nm_bairro','ds_complemento'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf', 'nr_rg', 'est_civil', 'nm_nacionalidade'))
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nm_cidade'=>'nome', 'uf'))
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = ce.id_imobiliaria', array('pessoaImob'=>'nm_pessoa','telefoneImob'=>'nr_telefone', 'celularImob'=>'nr_celular', 'faxImob'=>'nr_fax', 'recadoImob'=>'nr_recado', 'cepImob'=>'nr_cep', 'nrEnderecoImob'=>'nr_endereco', 'enderecoImob'=>'endereco','nmBairroImob'=>'nm_bairro','complementoImob'=>'ds_complemento'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = ce.id_imobiliaria', array('cnpj'=>'nr_cnpj','nm_fantasia'))
            ->where('ce.id_corretor = '. $idCorretor)
            ->where('ce.id_empreendimento = '. $idEmpreendimento)
            ->query()->fetch();
    }

    /**
     * Busca os dados de corretor empreendimento e retorna um array
     * @param integer $id
     * @return array
     */
    public static function findCorretorEmpreendimentoDados($id)
    {
        $db = Db::getInstance();
        $select = "SELECT ce.*, e.nm_empreendimento, p.nm_pessoa, i.nm_fantasia, i.id_pessoa as id_imobiliaria
                        FROM " . TB_CORRETOR_EMPREENDIMENTO . " ce
                        JOIN " . TB_PESSOA . " p  ON ce.id_corretor = p.id
                        LEFT JOIN " . TB_PESSOA_JURIDICA . " i  ON ce.id_imobiliaria = i.id_pessoa
                        JOIN " . TB_EMPREENDIMENTO . " e  ON ce.id_empreendimento = e.id
                        WHERE ce.id_corretor_empreendimento =" . $id;
        $stmt = $db->prepare($select);
        $stmt->execute();
        return $stmt->fetch();
    }

    /**
     * Monta um array com os tipos de parcela do corretor pelo empreendimento
     * @param $id
     * @param $idEmpreendimento
     * @return array
     */
    public static function getArrayTiposParcela($idCorretorEmpreendimento = false,$idEmpreendimento = false, $idCorretor = false)
    {
        $corretorEmpreendimento = self::getDefaultAdapter()->select()
            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), array('*'));
        if ($idCorretorEmpreendimento) {
            $corretorEmpreendimento->where('ce.id_corretor_empreendimento = '. $idCorretorEmpreendimento);
        }
        if ($idCorretor) {
            $corretorEmpreendimento->where('ce.id_corretor = '. $idCorretor);
        }
        if ($idEmpreendimento) {
            $corretorEmpreendimento->where('ce.id_empreendimento = '. $idEmpreendimento);
        }
        $corretorEmpreendimento = $corretorEmpreendimento->query()->fetch();

        $arrayParcelas = array();
        if ($corretorEmpreendimento['fl_parcela_normal'] == '1')
            $arrayParcelas[] = 'N';
        if ($corretorEmpreendimento['fl_parcela_sinal'] == '1')
            $arrayParcelas[] = 'S';
        if ($corretorEmpreendimento['fl_parcela_intercalada'] == '1')
            $arrayParcelas[] = 'I';
        if ($corretorEmpreendimento['fl_parcela_chave'] == '1')
            $arrayParcelas[] = 'C';
        if ($corretorEmpreendimento['fl_parcela_negociada'] == '1')
            $arrayParcelas[] = 'G';
        if ($corretorEmpreendimento['fl_parcela_quitacao'] == '1')
            $arrayParcelas[] = 'Q';

        return $arrayParcelas;
    }

    /**
     * Testa se existe corretor cadastrado para o empreendimento
     * @param $idCorretor
     * @param $idEmpreendimento
     * @return bool
     */
    public static function verificaByPessoaEmpreendimento($idCorretor, $idEmpreendimento)
    {
        $corretorEmpreendimento = self::getDefaultAdapter()->select()
            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), array('*'))
            ->where('ce.id_corretor = ?', $idCorretor)
            ->where('ce.id_empreendimento = ?', $idEmpreendimento)
            ->query()->fetchAll();

        return (count($corretorEmpreendimento) > 0);
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'e.nm_empreendimento',
            1 => 'p.nm_pessoa',
            2 => 'i.nm_fantasia'
        );

        if ($search) {
            $where = 'e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or i.nm_fantasia LIKE "%' . $search . '%" ';
        }

        $corretores = self::getDefaultAdapter()->select()
            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), array('*'))
            ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('p.nm_pessoa'))
            ->joinLeft(array('i' => TB_PESSOA_JURIDICA), 'ce.id_imobiliaria = i.id_pessoa', array('i.nm_fantasia'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'ce.id_empreendimento = e.id', array('e.nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $corretores->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $corretores = $corretores->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $corretores = $corretores->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $corretores = $corretores->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $corretores;
    }

}