<?php
class Corretor extends Zend_Db_Table_Abstract {

    protected $_name = TB_CORRETOR;

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false) {
        $result = array();
        $termo = "'%".strtoupper($termo)."%'";
        $db = DB::getInstance();
        if($count && $offset === false && $page === false) {
            $select = "SELECT count(c.id_pessoa) AS count FROM ".TB_CORRETOR." c
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                  WHERE CONCAT(c.cd_creci, ' ',UPPER(p.nm_pessoa),' ', UPPER(p.email)) LIKE {$termo}";
        } else {
            $select = "SELECT c.id_pessoa AS id FROM ".TB_CORRETOR." c
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                  WHERE CONCAT(c.cd_creci, ' ',UPPER(p.nm_pessoa),' ', UPPER(p.email)) LIKE {$termo} ";
            if($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if($count && $offset === false && $page === false) return  $ids;

        if(is_array($ids) && count($ids)) {
            foreach ($ids as $id) {
                $result[] = self::findCorretor($id['id']);
            }
        }
        return $result;
    }

    /**
     * Busca o corretor retornando uma instacia da classe
     * @param integer $id
     * @return Corretor
     */
    public static function findCorretor($id) {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT c.cd_creci, p.nm_pessoa, p.email, c.id_pessoa FROM ".TB_CORRETOR." c
                                JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                              WHERE c.id_pessoa = ?");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS,"Corretor");
        return $stmt->fetch();
    }


    /**
     * RETORNA OS DADOS DO CORRETOR
     * @param integer $id
     * @return array
     */
    public static function findCorretorDados($id) {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT c.*, p.nm_pessoa, p.email FROM ".TB_CORRETOR." c
                                JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                              WHERE c.id_pessoa = ?");
        $stmt->execute(array($id));
        return $stmt->fetch();
    }
}