<?php

//Classe de Pessoas relacionadas com o contrato (Pessoas Envolvidas)
class ContratoPessoa extends Zend_Db_Table_Abstract
{
    protected $_name = TB_CONTRATO_PESSOA;
    static $contratoPessoaInstancia;

    //retorna uma instancia do objeto para uso de SINGLETON
    public static function getInstance()
    {
        if (!self::$contratoPessoaInstancia) {
            self::$contratoPessoaInstancia = new ContratoPessoa();
        }
        return self::$contratoPessoaInstancia;
    }

    //Retorna os dados pelo id
    public static function findById($id)
    {
        $contrato_pessoa = self::getInstance();
        $contrato_pessoa = $contrato_pessoa->getDefaultAdapter()->select()->from(array('cp' => TB_CONTRATO_PESSOA), array('id_contrato_pessoa', 'id_contrato', 'id_pessoa', 'porcentagem_participacao_contrato'))
            ->where('cp.id_contrato_pessoa = ?', $id)->query()->fetch();

        return $contrato_pessoa;
    }

    //Retorna os contratos_pessoa pelo contrato
    public static function findByContrato($contrato)
    {
        $contrato_pessoa = self::getInstance();
        $contrato_pessoa = $contrato_pessoa->getDefaultAdapter()->select()->from(array('cp' => TB_CONTRATO_PESSOA), array('id_contrato_pessoa', 'id_contrato', 'id_pessoa', 'porcentagem_participacao_contrato'))
            ->where('cp.id_contrato = ?', $contrato)->query()->fetchAll();

        return $contrato_pessoa;
    }

    //Retorna os contratos_pessoa pela pessoa
    public static function findByPessoa($pessoa)
    {
        $contrato_pessoa = self::getInstance();
        $contrato_pessoa = $contrato_pessoa->getDefaultAdapter()->select()->from(array('cp' => TB_CONTRATO_PESSOA), array('id_contrato_pessoa', 'id_contrato', 'id_pessoa', 'porcentagem_participacao_contrato'))
            ->where('cp.id_pessoa = ?', $pessoa)->query()->fetchAll();

        return $contrato_pessoa;
    }

    /*
     * Adiciona registro � tabela CONTRATO_PESSOA
     * @param: dados (id_contrato e id_pessoa)
    */
    public function addContratoPessoa($dados)
    {
        $contrato_pessoa = self::createRow();
        foreach ($dados as $campo => $valor) {
            $contrato_pessoa->$campo = $valor;
        }
        return $contrato_pessoa->save();
    }

    /*
     * Apaga registro na tabela CONTRATO_PESSOA
     * @param: dados (id_contrato e id_pessoa)
    */
    public function deleteContratoPessoa($dados)
    {
        if ($dados->id_contrato && $dados->id_pessoa)
            return self::delete("id_contrato = $dados->id_contrato AND id_pessoa = $dados->id_pessoa");
        else
            return false;
    }

    /*
     * Apaga todos os registros na tabela CONTRATO_PESSOA
     * @param: dados (id_contrato)
    */
    public function deleteByContrato($contrato)
    {
        return self::delete("id_contrato = $contrato");
    }

}
