<?php

class ContratoHistorico extends Zend_Db_Table_Abstract {

    protected $_name = TB_CONTRATO_HISTORICO;

    /**
     * Busca dados de empreendimento, lote e pessoa pelo id do contrato histrico
     * @param integer $id
     * @return array
     */
    public static function findContratoHistorico($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT c.id, e.nm_empreendimento, e.id AS idEmpreendimento, e.porcDev, l.lote, p.nm_pessoa, pf.nr_cpf FROM " . TB_CONTRATO_HISTORICO . " c
                                JOIN " . TB_PESSOA . " p  ON c.id_pessoa = p.id
                                JOIN " . TB_LOTES . " l  ON c.id_lote = l.id
                                LEFT JOIN " . TB_PESSOA_FISICA . " pf ON p.id = pf.id_pessoa 
                                JOIN " . TB_EMPREENDIMENTO . " e  ON l.id_empreendimento = e.id
                              WHERE c.id = ?");
        $stmt->execute(array($id));
        return $stmt->fetch();
    }


    /**
     * Busca todos os dados de pessoa do Contrato
     * @param $id
     * @return mixed
     */
    public static function findContratoById($id)
    {
        $contrato = self::getDefaultAdapter()->select()->from(array('c' => TB_CONTRATO_HISTORICO), array('*', 'idContrato' => 'c.id'))
            ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', array('*','idPessoa' => 'p.id'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', '*')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', '*')
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', '*')
            ->where('c.id = ?', $id);


        $contrato = $contrato->query()->fetch();
        return $contrato;
    }
}