<?php

class Confissao extends Zend_Db_Table_Abstract {

    protected $_name = TB_CONFISSAO;

    public static function findConfissao($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'cont.id_lote',
            1 => 'p.nm_pessoa',
            2 => 'l.quadra',
            3 => 'l.lote',
            4 => 'c.dtVencimento',
            5 => 'c.dtPagamento',
        );
        if ($search) {
            $where = 'cont.id_lote LIKE "%' . $search . '%" ';
            $where .= 'or cont.id_lote LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
            $where .= 'or c.dtVencimento LIKE "%' . $search . '%" ';
            $where .= 'or c.dtPagamento LIKE "%' . $search . '%" ';
            $where .= 'or DAY(c.dtVencimento) = "' . $search . '" ';
            $where .= 'or MONTH(c.dtVencimento) = "' . $search . '" ';
            $where .= 'or YEAR(c.dtVencimento) = "' . $search . '" ';
            $where .= 'or DAY(c.dtPagamento) = "' . $search . '" ';
            $where .= 'or MONTH(c.dtPagamento) = "' . $search . '" ';
            $where .= 'or YEAR(c.dtPagamento) = "' . $search . '" ';
        }
        $clientes = self::getDefaultAdapter()->select()
            ->from(array('c' => TB_CONFISSAO), array('*', 'idConfissao' => 'id'))
            ->join(array('cl' => TB_CONFISSAO_LOTE), 'cl.idConfissao = c.id', null)
            ->join(array('cont' => TB_CONTRATO), 'cont.id_lote = cl.idLote', array('idContrato' => 'cont.id' ))
            ->join(array('l' => TB_LOTES), 'l.id = cl.idLote')
            ->join(array('p' => TB_PESSOA), 'p.id = cont.id_pessoa', 'nm_pessoa')
            ->where("cont.fl_distrato != '1'");

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $clientes->where("e.id IN({$id})");
                } else {
                    $clientes->where("1");
                }
            } catch (Exception $e) {

            }
        }
        if (isset($where)) {
            $clientes = $clientes->where($where);
        }
        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $clientes = $clientes->limit($post['length'], $post['start']);
            }
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $clientes = $clientes->order(implode(',', $orderByQuery))->group('c.id')->query()->fetchAll();

        return $clientes;
    }
}