<?php

class Comunicacao extends Zend_Db_Table_Abstract
{

    const TABLE_NAME = "COMUNICACAO";
    protected $_name = TB_COMUNICACAO;

    public function adicionar($idEmail,$idContrato,$nome,$email,$assuntoEmail,$diretorioEmail,$data=null,$id_parcela=null,$idBanco=null,$segundaVia=false)
    {
        $email_agendado = $this->verificaExistencia($idContrato, $id_parcela,$idEmail);
        if($idContrato=="*" && $id_parcela){
            $parcela = $this->getDefaultAdapter()->query("SELECT id_contrato
            FROM PARCELA
            where id_parcela_contrato ='".$id_parcela."';")->fetch();
            $idContrato=$parcela['id_contrato'];
        }
        if ($email_agendado==0) {
            $agenda = $this->createRow();
            $agenda->id_comunicacao_email = $idEmail;
            $agenda->id_contrato = $idContrato;
            $agenda->nomeDestinatario = $nome;
            $agenda->emailDestinatario = $email;
            $agenda->assunto = $assuntoEmail;
            $agenda->arquivoEmail = $diretorioEmail;
            $agenda->id_banco = $idBanco;
            $agenda->agendado = $data;
            $agenda->id_parcela_contrato = $id_parcela;

        }
        elseif($segundaVia){
            return array("status"=>"Atualizado","id"=>$this->atualizar($email_agendado,0,false,false,$data));
        } else {
            return array("status"=>"J existia um agendamento para esta parcela","id"=>$email_agendado);
        }

        return array("status"=>"Agendado","id"=>$agenda->save());
    }

    public function atualizar($id, $statusAgendamento = 0 , $dt_envio = false, $dt_lido = false, $dt_agendamento = false)
    {
        $agenda = $this->fetchRow("id = {$id}");
        if($dt_agendamento){
            $agenda->agendado = $dt_agendamento;
        }
        $agenda->statusAgendamento = $statusAgendamento;
        if($dt_envio){
            $agenda->enviado = $dt_envio;
        }
        if($dt_lido){
            $agenda->lido = $dt_lido;
        }
        return $agenda->save();
    }

    public function verificaExistencia($idContrato, $id_parc_contrato=null,$conta= false)
    {
        if(!$id_parc_contrato){
            return 0;
        }
        $filtro  = "";
        if($conta){
            $filtro = "and id_comunicacao_email = ".$conta;
        }
        $agendamento = $this->fetchRow("
            id_parcela_contrato = {$id_parc_contrato} AND
            agendado is NOT NULL
            {$filtro}
        ");

        if ($agendamento)
            return $agendamento['id'];

        return 0;
    }

    public function getLista($limit,$offset,$filtros,$tipo = false)
    {
        $where = "";
        $group = "";
        $filtros=explode(";",$filtros);
        if(count($filtros)==1&&$filtros[0]){
            $where = " WHERE `ca`.`id_contrato` = '".$filtros[0]."'  OR  `ca`.`agendado` like '%" . $filtros[0]."%'";
        }
        if($tipo){
            if($tipo == "1"){
                $where = " WHERE `ca`.`id_parcela_contrato` IS NULL";

            }
            elseif($tipo =="2"){
                $where = " WHERE `ca`.`id_parcela_contrato` IS NOT NULL";
            }
        }
        if(count($filtros)>1){
            $where = " WHERE ";
            foreach($filtros as $key=>$filtro){
                $filtroSeparado = explode(":",$filtro);
                if($filtroSeparado[0]=='Empreendimento'){
                    $where = $where . "`e`.`nm_empreendimento` like '%".$filtroSeparado[1]."%'";
                }
                elseif($filtroSeparado[0]=='Agendado'){
                    $where = $where . "`ca`.`agendado` like '%".$filtroSeparado[1]."%'";
                }
                elseif($filtroSeparado[0]=='Nome'){
                    $where = $where . "`ca`.`nomeDestinatario` like '%".$filtroSeparado[1]."%'";
                }
                elseif($filtroSeparado[0]=='data'){
                    $where = $where . " (date(`ca`.`agendado`) = '".$filtroSeparado[1]."' or date(`ca`.`enviado`) = '".$filtroSeparado[1]."') ";
                }
                elseif($filtroSeparado[0]=='Contrato' ||$filtroSeparado[0]=='p'){
                    $where = $where . " `ca`.`id_contrato` = '".$filtroSeparado[1]."' ";
                }
                elseif($filtroSeparado[0]=='Contato'){
                    $where = $where . " `ca`.`emailDestinatario` like '%".$filtroSeparado[1]."%' ";
                }
                elseif($filtroSeparado[0]=='Local'){
                    if($filtroSeparado[1]=="WhatsApp"){
                        $where = $where . " `ca`.`emailDestinatario` not like '%@%' ";
                    }
                    elseif($filtroSeparado[1]=="E-mail"){
                        $where = $where . " `ca`.`emailDestinatario` like '%@%' ";

                    }
                    
                }
                elseif($filtroSeparado[0]=='Status'){
                    if($filtroSeparado[1]=="Enviado"){
                        $where = $where . " `ca`.`enviado` is not null ";
                    }
                    elseif($filtroSeparado[1]=="Agendado"){
                        $where = $where . " `ca`.`agendado` is not null ";
                    }
                    else{
                        $where = $where . "1=1";
                    }
                }
                if((count($filtros)-2)>$key){
                    $where = $where . " and ";
                }
                
            }
        }
        $data = $this->getDefaultAdapter()->query("SELECT SQL_CALC_FOUND_ROWS `ca`.*, `l`.`quadra`, `l`.`lote`, `e`.`nm_empreendimento`, `co`.`email`, `co`.`setor`, `p`.`id_parcela`, `p`.`tp_parcela`, `p`.`dt_parcela`, `p`.`vl_parcela`
        FROM `COMUNICACAO` AS `ca`
        INNER JOIN `CONTRATO` AS `c` ON c.id = ca.id_contrato
        INNER JOIN `LOTES` AS `l` ON l.id = c.id_lote
        INNER JOIN `EMPREENDIMENTO` AS `e` ON l.id_empreendimento = e.id
        LEFT JOIN `COMUNICACAO_EMAIL` AS `co` ON ca.id_comunicacao_email = co.id
        LEFT JOIN `PARCELA` AS `p` ON ca.id_parcela_contrato = p.id_parcela_contrato
        $where
        $group
        ORDER BY ca.id DESC
        LIMIT 	$limit OFFSET $offset;")->fetchAll();
        $count = $this->getDefaultAdapter()->fetchOne("select FOUND_ROWS()");
        return array('data'=>$data,'recordsTotal'=>$count,'recordsFiltered'=> $count);
    }
    public function getPendentes()
    {
        $agora = date('Y-m-d H:i:s');
        return $this->getDefaultAdapter()->select()
            ->from(['ca' => TB_COMUNICACAO])
            ->where("ca.agendado <= '{$agora}' and ca.agendado is NOT NULL")
            ->where("ca.statusAgendamento = 0")
            ->query()->fetchAll();
    }
    public function getInfo($id)
    {
        return $this->getDefaultAdapter()->select()
            ->from(['ca' => TB_COMUNICACAO])
            ->join(['c' => TB_CONTRATO], 'c.id = ca.id_contrato', '')
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', ['quadra', 'lote'])
            ->join(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id', ['nm_empreendimento'])
            ->joinLeft(['co' => TB_COMUNICACAO_EMAIL], 'ca.id_comunicacao_email = co.id', ['email','setor','host','senha','porta'])
            ->joinLeft(['p' => TB_PARCELA], 'ca.id_parcela_contrato = p.id_parcela_contrato', ['id_parcela','tp_parcela','dt_parcela','vl_parcela'])
            //->joinLeft(['a' => TB_AGRUPADA], 'ca.setor = a.idCampo AND idTabela = 30', ['setorDescricao' => 'descricao'])
            
            ->where("ca.id = {$id}")
            ->query()->fetch();
    }

    public function getRelatorio($de,$ate,$idEmpreendimento,$separarEmpreendimento,$tipoEnvio = null)
    {
        $filtroEmpreendimento="";
        if($idEmpreendimento!="*"){
            $filtroEmpreendimento=" and l.id_empreendimento = ".$idEmpreendimento;
        }
        $select = $this->getDefaultAdapter()->select()
            ->from(['ca' => TB_COMUNICACAO],['date(agendado) as agendado','date(enviado) as enviado','count(*) as contador'])
            ->join(['c' => TB_CONTRATO], 'c.id = ca.id_contrato', '')
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', '')
            ->join(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id '.$filtroEmpreendimento, ['nm_empreendimento'])
            ->where("date(enviado) >= '".$de."' and date(enviado) <= '".$ate."'")
            ->orWhere("date(agendado) >= '".$de."' and date(agendado) <= '".$ate."'");
            //var_dump($tipoEnvio);die;
        if($tipoEnvio){
            if($tipoEnvio=="2"){
                $select->where( "ca.emailDestinatario not like ?","%@%");
            }
            elseif($tipoEnvio=="1"){
                $select->where( "ca.emailDestinatario like ?","%@%");
            }
        }
        if($separarEmpreendimento=="1"){
            $select = $select->group("l.id_empreendimento");
        }    
        return $select->group("date(agendado)")
            ->group("date(enviado)")
            ->query()->fetchAll();            
    }

    public function delete($id){
        $db = Db::getInstance();
        $delete  = "DELETE FROM ".self::TABLE_NAME."
					WHERE id = ?";
        $stmt = $db->prepare($delete);
        return $stmt->execute(array($id));
    }
    public function deleteParcela($id){
        $db = Db::getInstance();
        $delete  = "DELETE FROM ".self::TABLE_NAME."
					WHERE agendado is not null and id_parcela_contrato = ?";
        $stmt = $db->prepare($delete);
        return $stmt->execute(array($id));
    }
    public function verificaAgendado($data){
        $query = $this->getDefaultAdapter()->query('SELECT DATE(agendado) as agendado, count(*) AS quantidade
            FROM COMUNICACAO where DATE(agendado) = "'.$data.'" group by DATE(agendado);')->fetch();
        return $query;
    }
    public function verificaEnviado($data){
        $query = $this->getDefaultAdapter()->query('SELECT DATE(enviado) as enviado, count(*) AS quantidade
            FROM COMUNICACAO where DATE(enviado) = "'.$data.'" group by DATE(enviado);')->fetch();
        return $query;
    }
}