<?php

class CobrancaParcelas extends Zend_Db_Table_Abstract
{
    protected $_name = TB_COBRANCA_PARCELAS;

    public static function findByParcela($idCobranca) {

        $itens = self::getDefaultAdapter()->select()
            ->from(array('cp' => TB_COBRANCA_PARCELAS), array('id_contrato as contrato', 'nr_parcela as parcela', 'tp_parcela as tipo', 'dt_parcela as vencimento', 'vl_parcela as valor', 'tp_status as status','nr_tipo_parcela'))
            ->join(array('c' => TB_CONTRATO), 'cp.id_contrato = c.id', null)
            ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('nm_pessoa as cliente'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('lote', 'quadra'))
            ->where('cp.id_cobranca = ?', $idCobranca)
            ->query()->fetchAll();

        foreach ($itens as &$i) {
            $i['cliente'] = utf8_encode($i['cliente']);
        }

        return $itens;
    }
}