<?php

class Cobranca extends Zend_Db_Table_Abstract
{
    protected $_name = TB_COBRANCA;

    public static function findCobranca($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'c.id_cobranca',
            1 => 'c.id_empreendimento',
            2 => 'c.dt_abertura',
            3 => 'c.dt_encerramento',
            4 => 'c.tp_ordenacao'
        );

        if ($search) {
            $where = 'c.id_cobranca LIKE "%' . $search . '%" ';
            $where .= 'or c.id_empreendimento LIKE "%'. $search .'%" ';
            $where .= 'or c.dt_abertura LIKE "%' . $search . '%" ';
            $where .= 'or c.dt_encerramento LIKE "%' . $search . '%" ';
            $where .= 'or c.tp_ordenacao LIKE "%'.$search.'%" ';
        }

        $cobranca = self::getDefaultAdapter()->select()
            ->from(array('c' => TB_COBRANCA), '*');

        if (isset($where)) {
            $cobranca = $cobranca->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $cobranca = $cobranca->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $cobranca = $cobranca->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $cobranca;
    }

    public function getCobrancas($id){

        $cobranca = self::getDefaultAdapter()->select()
            ->from(array("c" => TB_COBRANCA), array('*'))
            ->join(array("e" => TB_EMPREENDIMENTO), "c.id_empreendimento = e.id", array('nm_empreendimento'))
            ->where('c.id_cobranca = ?', $id)
            ->query()->fetch();


        if ($cobranca) {
            $cobranca['nm_empreendimento'] = utf8_encode($cobranca['nm_empreendimento']);

            $cobrancaParcelas = CobrancaParcelas::findByParcela($id);
        }

        return array($cobranca, $cobrancaParcelas);
    }
}