<?php

class Cidade extends Zend_Db_Table_Abstract
{

    protected $_name = TB_CIDADE;
    static $cidadeInstancia;

    //retorna uma instancia do objeto para uso de SINGLETON
    public static function getInstance() {
        if (!self::$cidadeInstancia) {
            self::$cidadeInstancia = new Cidade();
        }
        return self::$cidadeInstancia;
    }

    /**
     * Funo para retornar o string no formato: nomeDaCidade - Uf
     * @param $id
     * @return string
     */
    public static function getNomeById($id) {
        $cidade = self::getInstance();
        $cidade = $cidade->getDefaultAdapter()->select()->from(array('c' => TB_CIDADE), array('nome', 'uf'))
            ->where('c.id = ?',$id)->query()->fetch();

        return $cidade['nome'] . ' - ' . $cidade['uf'];
    }

    //Retorna os dados da cidade pelo id
    public static function byId($id) {
        $cidade = self::getInstance();
        $cidade = $cidade->getDefaultAdapter()->select()->from(array('c' => TB_CIDADE), array('id', 'nome', 'uf'))
            ->where('c.id = ?',$id)->query()->fetch();

        return $cidade;
    }

    public static function findByNome($termo){
        $lista = Pessoa::getDefaultAdapter()->select()
            ->from(array('c' => TB_CIDADE), array('*'))
            ->where('c.nome LIKE "%' . $termo . '%"');

        return $lista->query()->fetchAll();
    }
}



