<?php

class CartaHistorico extends Zend_Db_Table_Abstract
{

    protected $_name = TB_CARTA_HISTORICO;

    public function findById($id)
    {
        $carta = self::find($id);
        if (count($carta))
            $carta = $carta->toArray();

        return $carta;
    }

    public function findByEmpreendimentoTipo($idEmp, $tipo, $dtInicial, $dtFinal)
    {
        $carta = self::getDefaultAdapter()->select()
            ->from(array("h" => TB_CARTA_HISTORICO), array("*"))
            ->join(array("cc" => TB_MODELO), 'h.id_carta_cobranca = cc.cd_modelo', 'nm_titulo')
            ->join(array("c" => TB_CONTRATO), "c.id = h.id_contrato", null)
            ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
            ->join(array("l" => TB_LOTES), "c.id_lote = l.id AND l.id_empreendimento = '" . $idEmp . "'", array('quadra', 'lote', 'id_empreendimento'))
            ->where('h.dt_carta_gerada BETWEEN "' . Helper::getInputDate($dtInicial) . '" AND "' . Helper::getInputDate($dtFinal) . '"');
        if ($tipo != '*')
            $carta = $carta->where('h.id_carta_cobranca = ?', $tipo);
        $carta = $carta->order('h.dt_carta_gerada')
            ->query()->fetchAll();

        return $carta;
    }

    public function findByContrato($idContrato, $dtInicial, $dtFinal)
    {
        $carta = self::getDefaultAdapter()->select()
            ->from(array("h" => TB_CARTA_HISTORICO), array("*"))
            ->join(array("cc" => TB_MODELO), 'h.id_carta_cobranca = cc.cd_modelo', 'nm_titulo')
            ->join(array("c" => TB_CONTRATO), "c.id = h.id_contrato", null)
            ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
            ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('quadra', 'lote', 'id_empreendimento'))
            ->where('h.dt_carta_gerada BETWEEN "' . Helper::getInputDate($dtInicial) . '" AND "' . Helper::getInputDate($dtFinal) . '"')
            ->where('h.id_contrato = ?', $idContrato)
            ->order('h.dt_carta_gerada')
            ->query()->fetchAll();

        return $carta;
    }
}