<?php
class Carta_Cobranca extends Zend_Db_Table_Abstract {

    protected $_name = TB_CARTA_COBRANCA;
    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false) {
        $result = array();
        $termo = "'%".strtoupper($termo)."%'";
        $db = DB::getInstance();

        if($count && $offset === false && $page === false) {
            $select = "SELECT count(c.id) AS count FROM ".TB_CONTRATO." c
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                    JOIN ".TB_LOTES." AS l ON l.id = c.id_lote
                    JOIN ".TB_EMPREENDIMENTO." e  ON l.id_empreendimento = e.id
                  WHERE c.fl_distrato = '0' AND c.id IN(SELECT DISTINCT id_contrato from PARCELA where dt_parcela < NOW()) AND CONCAT(UPPER(e.nm_empreendimento), ' ', UPPER(p.nm_pessoa),' ', l.lote) LIKE {$termo}";
        } else {
            $select = "SELECT c.id AS contrato, e.id AS empreendimento, p.id AS pessoa, l.id AS lote  FROM ".TB_CONTRATO." c
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                    JOIN ".TB_LOTES." AS l ON l.id = c.id_lote
                    JOIN ".TB_EMPREENDIMENTO." e  ON l.id_empreendimento = e.id
                  WHERE c.fl_distrato = '0' AND c.id IN(SELECT DISTINCT id_contrato from PARCELA where dt_parcela < NOW()) AND CONCAT(UPPER(e.nm_empreendimento), ' ', UPPER(p.nm_pessoa),' ', l.lote) LIKE {$termo}";
            if($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }

        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);


        if($count && $offset === false && $page === false) return  $ids;

        if(is_array($ids) && count($ids)) {
            foreach ($ids as $id) {
                $result[] = self::findCartaCobranca($id['contrato'], $id['empreendimento'], $id['pessoa'], $id['lote']);
            }
        }
        return $result;
    }

    /**
     *
     * @param integer $id
     * @return array
     */
    public static function findCartaCobranca($contrato, $empreendimento, $pessoa, $lote) {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT c.id, e.nm_empreendimento, p.nm_pessoa, l.lote FROM ".TB_CONTRATO." c
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                    JOIN ".TB_LOTES." AS l ON l.id = c.id_lote
                    JOIN ".TB_EMPREENDIMENTO." e  ON l.id_empreendimento = e.id
                              WHERE c.id = ? AND e.id = ? AND p.id = ? AND l.id = ?");
        $stmt->execute(array($contrato, $empreendimento, $pessoa, $lote));
        $stmt->setFetchMode(PDO::FETCH_CLASS,"Carta_Cobranca");
        return $stmt->fetch();
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'c.id',
            1 => 'e.nm_empreendimento',
            2 => 'l.quadra',
            3 => 'l.lote',
            4 => 'p.nm_pessoa'
        );

        if ($search) {
            $where = 'c.id LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
        }

        $contratos = self::getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('c.id'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'p.nm_pessoa')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.lote','l.quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'e.nm_empreendimento')
            ->where('c.fl_distrato = ?', '0');

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $contratos->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $contratos = $contratos->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $contratos = $contratos->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $contratos = $contratos->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $contratos;
    }
}