<?php

/**
 * Class Boleto
 */
class Boleto
{

    public static function gerarBoleto($dados, $banco)
    {
        if($dados['nr_boleto']){
            $dados['nosso_numero']=$dados['nr_boleto'];
            //$dados['numero_documento']=$dados['nr_boleto'];
        }

        $param = http_build_query($dados);

        $url = 'http://' . $_SERVER['HTTP_HOST'];
        if ($_SERVER['HTTP_HOST'] != 'localhost') {
            $url = 'http://' . $_SERVER['HTTP_HOST'];
        }

        //Setando o cdigo da API para imprimir o boleto caso o Banco usa API para emitir os boletos.
        if($dados['conta_corrente']){
            $dados_api = BancoConta::listBancoContas($dados['agencia'],$dados['conta_corrente']);
        }else{
            $dados_api = BancoConta::listBancoContas($dados['agencia'],$dados['conta']);
        }
        $urlRequisicao = "";
        
        switch ($banco){
            case '104': //Caixa Economica Federal (CEF)
                $urlRequisicao = $url.BOLETO_PATH.'boleto_cef_sigcb.php';
                $dados['logoBoleto']='logocaixa.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_cef_sigcb.php?'.$param.'&logoBoleto=logocaixa.jpg');
                break;
            case '001': //Banco do Brasil (BB)
                $urlRequisicao = $url.BOLETO_PATH.'boleto_bb.php';
                $dados['logoBoleto']='logobb.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_bb.php?'.$param.'&logoBoleto=logobb.jpg');
                break;
            case '237': //Bradesco
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_bradesco.php';
                $dados['logoBoleto']='logobradesco.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_bradesco.php?'.$param.'&logoBoleto=logobradesco.jpg');
                break;
            case '741': //Banco Ribeiro Preto
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_ribeirao_preto.php';
                $dados['logoBoleto']='logoribeiraopreto.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_ribeirao_preto.php?'.$param.'&logoBoleto=logoribeiraopreto.jpg');
                break;
            case '033': //Santander
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_santander_banespa.php';
                $dados['logoBoleto']='logosantander.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_santander_banespa.php?'.$param.'&logoBoleto=logosantander.jpg');
                break;
            case '748': //Sicredi
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_sicredi.php';
                $dados['logoBoleto']='sicredi.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_sicredi.php?'.$param.'&logoBoleto=sicredi.jpg');
                break;
            case '756': //Sicoob
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_bancoob.php';
                $dados['logoBoleto']='logosicoob.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_bancoob.php?'.$param.'&logoBoleto=logosicoob.jpg');
                break;
            case '341': //Banco Ita
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_itau.php';
                $dados['logoBoleto']='logoitau.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_itau.php?'.$param.'&logoBoleto=logoitau.jpg');
                break;
            case '004': // Banco Nordeste (BNB)
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_bnb.php';
                $dados['logoBoleto']='logobnb.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_bnb.php?'.$param.'&logoBoleto=logobnb.jpg');
                break;
            case '037': // Banpara
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_banpara.php';
                $dados['logoBoleto']='logobanpara.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_banpara.php?'.$param.'&logoBoleto=logobanpara.jpg');
                break;
            case '422': //Banco Safra
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_safra.php';
                $dados['logoBoleto']='logobancosafra.png';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_safra.php?'.$param.'&logoBoleto=logobancosafra.png');
                break;
            case '085': //Banco Ailos
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_ailos.php';
                $dados['logoBoleto']='logoailos.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_ailos.php?'.$param.'&logoBoleto=logoailos.jpg');
                break;
            case '133': //Banco Cresol
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_cresol.php';
                $dados['logoBoleto']='logocresol.jpg';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_cresol.php?'.$param.'&logoBoleto=logocresol.jpg');
                break;
            case '136': //Banco unicred
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_unicred.php';
                $dados['logoBoleto']='logounicred.png';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_unicred.php?'.$param.'&logoBoleto=logounicred.png');
                break;
            case '077': //Banco Inter
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_inter.php';
                $dados['logoBoleto']='logointer.png';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_inter.php?'.$param.'&logoBoleto=logointer.png');
                break;
            case '274': //Banco Grafeno
                
                $urlRequisicao = $url.BOLETO_PATH.'boleto_grafeno.php';
                $dados['logoBoleto']='logo_grafeno.png';
                //$content = file_get_contents($url.BOLETO_PATH.'boleto_grafeno.php?'.$param.'&logoBoleto=logo_grafeno.png');
                break;
            case '099': //Banco Uniprime
        
                $urlRequisicao = $url.BOLETO_PATH.'boleto_uniprime.php';
                $dados['logoBoleto']='logouniprime.png';
                break;
            default :
                return false;
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => $urlRequisicao,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>  $dados,
        ));
        
        $content = curl_exec($curl);
        
        curl_close($curl);

        $content = str_replace('imagens/logo_empresa.png', $url . BOLETO_LOGO, $content);
        $content = str_replace('imagens/', $url . BOLETO_PATH . 'imagens/', $content);
        
        return $content;
    }
}