<?php

class BancoConta extends Zend_Db_Table_Abstract
{

    protected $_name = TB_BANCO_CONTA;

    public function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'bc.cd_banco',
            1 => 'a.descricao',
            2 => 'nr_agencia',
            3 => 'nr_conta',
            4 => 'fl_ativo',
            5 => 'nm_cedente',
        );

        if ($search) {
            $where = 'bc.id_banco_conta LIKE "%' . $search.'%"';
            $where .= ' or a.descricao LIKE "%' . $search . '%"';
            $where .= ' or bc.nr_conta LIKE "%' . $search . '%"';
            $where .= ' or bc.nr_agencia LIKE "%' . $search . '%"';
            $where .= ' or CONCAT(bc.nr_conta-bc.nr_conta_dv) LIKE "%' . $search . '%"';
            $where .= ' or CONCAT(bc.nr_agencia-bc.nr_agencia_dv) LIKE "%' . $search . '%"';
            $where .= ' or bc.nm_cedente LIKE "%' . $search .'%"';

            $empreendimentos = self::getDefaultAdapter()->select()
                ->from(array('b' => TB_BANCO), 'id_banco_conta')
                ->join(array('e' => TB_EMPREENDIMENTO), 'b.id_empreendimento = e.id', '')
                ->where('e.nm_empreendimento LIKE "%'.$search.'%"')
                ->query()->fetchAll();

            $idsBancoConta = [];
            foreach ($empreendimentos as $e) {
                $idsBancoConta[] = $e['id_banco_conta'];
            }
            if ($idsBancoConta) {
                $idsBancoConta = implode(',',$idsBancoConta);
                $where .= ' or bc.id_banco_conta IN ('.$idsBancoConta.')';
            }
        }

        $lista = self::getDefaultAdapter()->select()
            ->from(array('bc' => TB_BANCO_CONTA), array('cd_banco', 'nr_agencia', 'nr_agencia_dv', 'nr_conta',
                'nr_conta_dv', 'fl_ativo', 'id_banco_conta', 'nm_cedente'))
            ->join(array('a' => TB_AGRUPADA), 'a.idCampo = bc.cd_banco AND idTabela = "9"', array('a.descricao'));

        if (isset($where)) {
            $lista = $lista->where($where);
        }

        if (!$count) {
            if (isset($post['start']) && $post['length'] != '-1') {
                $lista = $lista->limit($post['length'], $post['start']);
            }
        }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $lista = $lista->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $lista;
    }

    public function getBancoContas($idBancoConta = false)
    {
        $lista = self::getDefaultAdapter()->select()
        // ->from(array('bc' => TB_BANCO_CONTA), array('cd_banco','cod_cedente_api','cod_layout_api','cod_layout_rem','cod_layout_ret','nr_agencia', 'nr_agencia_dv', 'nr_conta',
            ->from(array('bc' => TB_BANCO_CONTA), array('cd_banco','cod_layout_api','cod_layout_rem','cod_layout_ret','nr_agencia', 'nr_agencia_dv', 'nr_conta',
                'nr_conta_dv', 'fl_ativo', 'id_banco_conta', 'nr_cedente','nr_carteira','nr_carteira_variacao',
                'ds_especie', 'cnpj_cedente', 'cpf_cedente', 'nm_cedente', 'nr_boleto', 'nr_remessa', 'fl_ativo','nr_dias_permanencia', 'fl_boleto','nr_cooperativa'))
            ->join(array('a' => TB_AGRUPADA), 'a.idCampo = bc.cd_banco AND idTabela = "9"', array('a.descricao'))
            ->order('a.descricao');

        if ($idBancoConta) {
            $lista = $lista->where('id_banco_conta = ?',$idBancoConta)->query()->fetch();
        } else {
            $lista = $lista->query()->fetchAll();
        }

        return $lista;
    }

    public function listBancoContas($agencia,$conta)
    {
        $lista = self::getDefaultAdapter()->select()
            ->from(array('bc' => TB_BANCO_CONTA), array('cd_banco','cod_layout_rem','cod_layout_api','cod_layout_ret','nr_agencia', 'nr_agencia_dv', 'nr_conta', 'nr_conta_dv'))
            ->where('nr_agencia like "%'.$agencia.'%" and nr_conta like "%'.$conta.'%"')->query()->fetch();

        return $lista;
    }
}