<?php

class Banco extends Zend_Db_Table_Abstract
{

    protected $_name = TB_BANCO;
    const BANCO_DO_BRASIL = '001';
    const BANCO_BRADESCO = '237';
    const BANCO_CAIXA_ECONOMICA = '104';
    const BANCO_SANTANDER = '033';
    const BANCO_SICREDI = '748';
    const BANCO_ITAU = '341';
    const BANCO_SICOOB = '756';
    const BANCO_NORDESTE = '004';
    const BANCO_BANPARA = '037';
    const BANCO_SAFRA = '422';
    const BANCO_RIBEIRAO_PRETO = '741';
    const BANCO_AILOS = '085';
    const BANCO_CRESOL = '133';
    const BANCO_UNIPRIME = '099';

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false, $where = false)
    {
        $result = array();
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = DB::getInstance();
        if ($count && $offset === false && $page === false) {
            $select = "SELECT count(b.id) AS count FROM " . TB_BANCO . " b
                    JOIN " . TB_EMPREENDIMENTO . " e  ON b.id_empreendimento = e.id
                    JOIN " . Db_TabelaAgrupada::TABLE_NAME . " t  ON b.cd_banco = t.idCampo AND t.idTabela = " . Db_TabelaAgrupada::TABLE_BANCO . "
                  WHERE CONCAT(UPPER(t.descricao),' ', UPPER(e.nm_empreendimento),' ',CONCAT(b.agencia,'/',b.conta_corrente)) LIKE {$termo}";
            if ($where) {
                $select .= " AND $where";
            }
        } else {
            $select = "SELECT b.id FROM " . TB_BANCO . " b
                    JOIN " . TB_EMPREENDIMENTO . " e  ON b.id_empreendimento = e.id
                    JOIN " . Db_TabelaAgrupada::TABLE_NAME . " t  ON b.cd_banco = t.idCampo AND t.idTabela = " . Db_TabelaAgrupada::TABLE_BANCO . "
                  WHERE CONCAT(UPPER(t.descricao),' ', UPPER(e.nm_empreendimento),' ',CONCAT(b.agencia,'/',b.conta_corrente)) LIKE {$termo} ";
            if ($where) {
                $select .= " AND $where";
            }
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }

        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($count && $offset === false && $page === false) return $ids;

        if (is_array($ids) && count($ids)) {
            foreach ($ids as $id) {
                $result[] = self::findBanco($id['id']);
            }
        }
        return $result;
    }

    /**
     * Busca a multa pelo id do contrato
     * @param $idContrato
     * @return mixed
     */
    public static function getMultaByContrato($idContrato)
    {
        $multa = self::getDefaultAdapter()->select()->from(array('c' => TB_CONTRATO))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id')
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id')
            ->join(array('b' => TB_BANCO), 'e.id = b.id_empreendimento', 'multa')
            ->query()->fetch();

        return $multa['multa'];
    }

    /**
     *
     * @param integer $id
     * @return array
     */
    public static function findBanco($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT *, b.id AS idBanco FROM " . TB_BANCO . " b
                                JOIN " . TB_EMPREENDIMENTO . " e  ON b.id_empreendimento = e.id
                                JOIN " . Db_TabelaAgrupada::TABLE_NAME . " t  ON b.cd_banco = t.idCampo AND t.idTabela = " . Db_TabelaAgrupada::TABLE_BANCO . "
                              WHERE b.id = ?");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS, "Banco");
        return $stmt->fetch();
    }

    public static function findBancoByInfo($info)
    {
        $banco = new Banco();
        $sql = '';
        if (isset($info['banco']))
            $info['cod_banco'] = $info['banco'];
        
        if (isset($info['cod_banco'])) {
            if (strlen($sql) > 1)
                $sql .= ', ';
            $sql .= 'cd_banco = "' . $info['cod_banco'] . '"';
        }
        if ($info['cod_banco'] == '104') {
            if (isset($info['conta_corrente'])) {
                
                if (strlen($sql) > 1)
                    $sql .= ' AND ';
                $sql .= 'cd_cedente LIKE "%' . (int)substr($info['conta_corrente'], 0, 6) . '%"' . ' AND agencia LIKE "%' . (int)$info['agencia'] . '%"';
            }
        } elseif ($info['cod_banco'] == '741') {
            if (isset($info['agencia'])) {
                if (strlen($sql) > 1)
                    $sql .= ' AND ';
                $sql .= 'agencia LIKE "%' . $info['agencia'] . '%"';
            }

            if (isset($info['conta_corrente'])) {
                if (strlen($sql) > 1)
                    $sql .= ' AND ';
                $sql .= 'cd_cedente = "' . $info['conta_corrente'] . '"';
            }

        } else {
            if (isset($info['agencia'])) {
                if (strlen($sql) > 1)
                    $sql .= ' AND ';
                $sql .= 'agencia LIKE "%' . (int)$info['agencia'] . '%"';
            }
            if (isset($info['codigo_empresa'])) {
                if (strlen($sql) > 1)
                    $sql .= ' AND ';
                $sql .= 'cd_cedente = "' . (int)$info['codigo_empresa'] . '"';
            }
            if (isset($info['conta_corrente'])) {
                if (strlen($sql) > 1)
                    $sql .= ' AND ';
                $sql .= 'conta_corrente LIKE "%' . (int)$info['conta_corrente'] . '%"';
            }
        }
        return self::getDefaultAdapter()->fetchRow($banco->select()->where($sql));
    }

    /**
     * Retorna um banco especifico ou uma lista de todos bancos
     * @param bool $id
     * @return array|mixed|Zend_Db_Select
     * @throws Zend_Db_Statement_Exception
     */
    public function getBanco($id = false, $idBancoConta = false)
    {
        $lista = self::getDefaultAdapter()->select()
            ->from(array('b' => TB_BANCO), array('*'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = b.id_empreendimento', array('idEmp' => 'id','nm_empreendimento'));

        if ($idBancoConta) {
            $lista->where('id_banco_conta = ?', $idBancoConta);
        }

        $lista->order('nm_empreendimento');

        if ($id) {
            $lista = $lista->where('b.id = ?', $id)->query()->fetch();
        } else {
            $lista = $lista->query()->fetchAll();
        }

        return $lista;
    }

    /**
     * Retorna o nome do banco
     * @param $id
     * @return mixed
     * @throws Zend_Db_Statement_Exception
     */
    public static function findBancoNome($id)
    {
        $banco = self::getDefaultAdapter()->select()->from(array('t' => TB_AGRUPADA, 't.descricao'))
            ->where('t.idTabela = "9"')
            ->where('idCampo = ?', $id)
            ->query()->fetch();
        return $banco['descricao'];
    }

    /**
     * Incrementa o id da parcela de acordo com o incremento
     * @param $id
     * @param int $incremento
     * @return bool
     */
    public static function incrementaRemessa($ids, $incremento = 1)
    {
        //Para contas Associadas
        try {
            $banco = new Banco();
            $banco = $banco->fetchAll('id IN (' . $ids .')');
            foreach ($banco as $idBancos){
                $idBancos->nr_remessa = (int)$idBancos->nr_remessa + ($incremento);
                $idBancos->save();
            }
        } catch (Exception $e) {
            return false;
        }
        return true;
    }
    public static function incrementoRemessa($id, $incremento = 1)
    {
        //Para Gerar a Remessa
        try {
            $banco = new Banco();
            $banco = $banco->fetchRow('id = ' . $id);

            $banco->nr_remessa = (int)$banco->nr_remessa + ($incremento);
            $banco->save();
        } catch (Exception $e) {
            return false;
        }

        return true;
    }

    /**
     * Retorna o banco pelo contrato
     * @param $idContrato
     * @return mixed
     */
    public static function findByContrato($idContrato)
    {
        $banco = self::getDefaultAdapter()->select()->from(array('c' => TB_CONTRATO), array(null))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('*'))
            ->where('c.id = ?', $idContrato)
            ->query()->fetch();

        return $banco;
    }

    public static function findByBancoContrato($idContrato,$idBancoConta)
    {
        $banco = self::getDefaultAdapter()->select()->from(array('c' => TB_CONTRATO), array(null))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id')
            ->join(array('b' => TB_BANCO), 'b.id_empreendimento = l.id_empreendimento and b.id_banco_conta = '.$idBancoConta, array('*'))
            ->where('c.id = ?', $idContrato)
            ->query()->fetch();

        return $banco;
    }
    /**
     * Busca os bancos do empreendimento
     * @param $empreendimento
     * @return array
     */
    public static function findByEmpreendimento($empreendimento,$ativo=false, $ativoBaixaManual=false, $ativoRemessa=false, $ativoBoleto=false)
    {
        $bancos = self::getDefaultAdapter()->select()->from(array('b' => TB_BANCO), array('*'))
            ->where('b.id_empreendimento = ?', $empreendimento);
        //Acrescentado busca por banco ativos!!!
        if($ativo == true){
            $bancos=$bancos->join(array('bc' => TB_BANCO_CONTA), 'b.id_banco_conta = bc.id_banco_conta', array(''))->where('bc.fl_ativo = "1"');
        }
        if($ativoBaixaManual == true){
            $bancos=$bancos->where('b.fl_ativo_baixamanual = "1"');
        }
        if($ativoRemessa == true){
            $bancos=$bancos->where('b.fl_ativo_remessa = "1"');
        }
        if($ativoBoleto){
            $bancos=$bancos->where('b.fl_ativo_boleto = "1"');
        }
        $bancos = $bancos->query()->fetchAll();

        return $bancos;
    }
    public static function findByBancoConta($id,$ativo = false)
    {
        $bancos = self::getDefaultAdapter()->select()->from(array('b' => TB_BANCO), array('*'))
            ->where('b.id_banco_conta = ?', $id);
        //Acrescentado busca por banco ativos!!!
        if($ativo == true){
            $bancos=$bancos->where('fl_ativo = "1"')->query()->fetchAll();
        }else{
            $bancos=$bancos->query()->fetchAll();
        }

        return $bancos;
    }

    public static function findBancoByContaAgencia ($cdBanco, $cedente, $agencia)
    {
        $banco = self::getDefaultAdapter()->select()
            ->from(['b' => TB_BANCO], '*')
            ->where('b.cd_banco = ' . $cdBanco)
            ->where('b.cd_cedente = ' . $cedente . ' OR b.conta_corrente = ' . $cedente)
            ->where('b.agencia = ' . $agencia)
            ->query()->fetch();

        return $banco;
    }

    public function findBancoByIdBancoConta($idBancoConta) {
        
        $bancos = self::getDefaultAdapter()->select()
            ->from(['b' => TB_BANCO], 'id')
            ->where('b.id_banco_conta = ' . $idBancoConta)
            ->query()->fetchAll();
        
        foreach ($bancos as $banco) {
            $lista[] = $banco['id'];
        }

        $banco = implode("','", $lista);
        
        return $banco; 
    }

    public function buscarBancosComApi() {
        
        $bancos = self::getDefaultAdapter()->select()
            ->from(['bc' => TB_BANCO_CONTA])
            ->where('bc.cod_layout_api is not null')
            ->query()->fetchAll();
        
        foreach ($bancos as $banco) {
            $lista[] = array('id'=>$banco['id_banco_conta'],'text'=>'Banco: '.$banco['cd_banco'].', Ag: '.$banco['nr_agencia'].'-'.$banco['nr_agencia_dv'].', Ag: '.$banco['nr_conta'].'-'.$banco['nr_conta_dv'].', Cedente: '.$banco['nm_cedente']);
        }
        return $lista; 
    }

    public function buscarBancosContaComId($id) {
        
        $banco = self::getDefaultAdapter()->select()
            ->from(['bc' => TB_BANCO_CONTA])
            ->where('bc.id_banco_conta = ?', $id)
            ->joinLeft(array('b' => TB_BANCO), 'bc.id_banco_conta = b.id_banco_conta',array('cd_cedente','carteira_variacao'))
            ->joinLeft(array('la' => TB_LAYOUT), 'bc.cod_layout_api = la.id',array('pp_token','password','gerar_token','req_cliente_id'))
            ->query()->fetch();
        
        
        return $banco; 
    }

    public static function buscaNomeBanco($codBanco) {

        switch ($codBanco) {
            case '001':
                return 'Banco do Brasil';
            case '237':
                return 'Bradesco';
            case '104': 
                return 'Caixa';
            case '033': 
                return 'Santander';
            case '748':
                return 'Sicredi';
            case  '341':
                return 'Ita';
            case '756': 
                return 'Sicoob';
            case '004':
                return 'Nordeste';
            case '037':
                return 'Banpar';
            case '422':
                return 'Safra';
            case '741':
                return 'Ribeiro Preto';
            case '085':
                return 'Ailos';
            case '133':
                return 'Cresol';
            default:
                return '';
                
        }
    }
}

