<?php
class Aviso extends Zend_Db_Table_Abstract {

    protected $_name = TB_AVISO;

    /**
     *
     */
    public static function getTodosAvisos($idCliente, $ultimoId = 0, $atualizacao = 0) {

        $limitInicio = 0 + $ultimoId;
        $limitFinal = 10 + $ultimoId;
        $limit = $limitInicio.','.$limitFinal;
        $cliente = (new Db_Cliente)->getCliente();
        $avisos = Controller::getAdapterAcadeGeral()->fetchAll('SELECT * FROM aviso
                                                                WHERE fl_lotear = "1"
                                                                AND fl_ativo = "1"
                                                                AND fl_atualizacao = "' . $atualizacao . '"
                                                                ORDER BY dt_aviso DESC, id_aviso
                                                                DESC LIMIT '.$limit);

        $avisosNaoVisualizados = self::avisosVisualizados($idCliente);

        if ($avisos) {
            foreach ($avisos as $k => &$a) {

                if ($a['fl_permanente'] == '0' && strtotime($a['dt_aviso']) < strtotime($cliente['dt_contrato'])) {
                    unset($avisos[$k]);
                    continue;
                }

                $a['flVisualizado'] = false;

                foreach ($avisosNaoVisualizados as $aNV) {
                    if ($a['id_aviso'] == $aNV['id_aviso']) {
                        $a['flVisualizado'] = true;
                    }
                }
            }
        }
        return $avisos;
    }

//busca todos os avisos visualizados e seta a flag flVisualizado como true.
    private static function avisosVisualizados($idCliente) {
        $idUsuario = Login::getUsuario()->getId();
        $avisos = Controller::getAdapterAcadeGeral()->fetchAll("SELECT * FROM aviso as a
                                                                INNER JOIN aviso_usuario as au ON au.id_aviso = a.id_aviso
                                                                WHERE au.id_cliente = '".$idCliente."'
                                                                AND au.id_usuario = '".$idUsuario."'
                                                                AND fl_lotear = '1'
                                                                AND fl_ativo = '1'
                                                                AND fl_atualizacao = '0'
                                                                ORDER BY dt_aviso");

        foreach ($avisos as &$aviso) {
            $aviso['flVisualizado'] = true;
        }

        return $avisos;
    }

    //busca todos os avisos que no foram visualizados e seta a flag flVisualizado como false.
    private static function avisos($ultimoId) {

        $where = ($ultimoId)?'AND id_aviso < '.$ultimoId:'';
        $avisos = Controller::getAdapterAcadeGeral()->fetchAll("SELECT * FROM aviso WHERE fl_lotear = '1' AND fl_ativo = '1' AND fl_atualizacao = '0' ".$where." ORDER BY dt_aviso DESC LIMIT 10");

        if (count($avisos) > 0) {

            foreach ($avisos as &$a) {
                $a['flVisualizado'] = false;
            }

            return $avisos;
        } else {
            return null;
        }
    }

    public static function getAviso() {
        return $_SESSION['avisos'];
    }

    public static function contaAvisos() {

        $clienteAcade = self::pegaDadosCliente();
        $visualizados = self::avisosVisualizados($clienteAcade['id_cliente']);
        $cliente = (new Db_Cliente)->getCliente();
        $nVisualizados = Controller::getAdapterAcadeGeral()->fetchAll("SELECT * FROM aviso WHERE fl_lotear = '1' AND fl_ativo = '1' AND fl_atualizacao = '0' ORDER BY dt_aviso");

        foreach ($nVisualizados as $k => &$nVisualizado) {

            if ($nVisualizado['fl_permanente'] == '0' && strtotime($nVisualizado['dt_aviso']) < strtotime($cliente['dt_contrato'])) {
                unset($nVisualizados[$k]);
                continue;
            }

            foreach ($visualizados as $k => &$visualizado) {

                if ($visualizado['fl_permanente'] == '0' && strtotime($visualizado['dt_aviso']) < strtotime($cliente['dt_contrato'])) {
                    unset($visualizados[$k]);
                    continue;
                }

                if($nVisualizado['id_aviso'] == $visualizado['id_aviso']) {
                    $nVisualizado['flVisualizado'] = $visualizado['flVisualizado'];
                }
            }
        }

        $i = 0;
        foreach ($nVisualizados as $aviso) {
            if($aviso['flVisualizado'] == false) {
                $i++;
            }
        }

        return $i;
    }

    //exibe a mensagem completa para o usurio.
    public static function exibeAviso($idAviso) {
        $aviso = Controller::getAdapterAcadeGeral()->fetchRow("SELECT * FROM aviso as a
                                                               WHERE a.id_aviso = ".$idAviso." AND fl_lotear = '1'");
        $idCliente = self::pegaDadosCliente();
        $aviso['dt_aviso'] = str_replace('-', '/', $aviso['dt_aviso']);
        $aviso['dt_aviso'] = date("d/m/Y", strtotime($aviso['dt_aviso']));

        return $aviso;
    }

    //salva a mensagem que foi lida na tabela aviso_usuario.
    public static function mensagemLida($idAviso) {

        $idCliente = self::pegaDadosCliente();
        $idUsuario = Login::getUsuario()->getId();
        $dsLog = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
        $verificador = Controller::getAdapterAcadeGeral()->fetchRow("SELECT id_cliente, id_aviso, id_usuario
                                                                      FROM aviso_usuario
                                                                      WHERE id_cliente = '".$idCliente['id_cliente']."'
                                                                      AND id_aviso = '".$idAviso."'
                                                                      AND id_usuario = '".$idUsuario."'");

        if(!$verificador) {
            $campos = array(
                'id_cliente' => $idCliente['id_cliente'],
                'id_aviso' => $idAviso,
                'id_usuario' => $idUsuario,
                'ds_log' => $dsLog
            );

            $dbAvisoUsuairo = Controller::getAdapterAcadeGeral();
            $dbAvisoUsuairo->insert(TB_AVISO_USUARIO, $campos);

            echo json_encode($campos['id_aviso']);
        }
    }

    //pega o id do cliente para ser usado no mtodo contaAvisos.
    public static function pegaDadosCliente() {
        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }

        $clienteAcade = Controller::getAdapterAcadeGeral()->fetchRow('SELECT * FROM cliente WHERE nm_dominio = "'.$nmDominio.'"');

        return $clienteAcade;
    }

    public static function findAviso($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];
        $array = array(
            0 => 'a.id_aviso',
            1 => 'a.dt_aviso',
            2 => 'a.ds_titulo',
            3 => 'a.ds_aviso'
        );

        if ($search) {
            $where = 'a.id_aviso LIKE "%' . $search . '%" ';
            $where .= 'or a.dt_aviso LIKE "% '. $search .' %" ';
            $where .= 'or a.ds_aviso LIKE "%' . $search . '%" ';
            $where .= 'or a.ds_titulo LIKE "%' . $search . '%" ';
        }

        $aviso = Controller::getAdapterAcadeGeral()->select()
            ->from(array('a' => TB_AVISO), '*');

        if (isset($where)) {
            $aviso = $aviso->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $aviso = $aviso->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $aviso = $aviso->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $aviso;
    }

    public static function buscaAtualizacoes()
    {
        $atualizacao = Controller::getAdapterAcadeGeral()->select()
            ->from(array('a' => TB_AVISO), ['id_aviso', 'ds_aviso', 'ds_titulo'])
            ->where('fl_atualizacao = "1"')
            ->order('id_aviso DESC')
            ->query()->fetch();

        if (!$atualizacao) {
            return false;
        }

        $_SESSION['idAvisoAtualizacao'] = $atualizacao['id_aviso'];

        $idCliente = self::pegaDadosCliente();
        $idUsuario = Login::getUsuario()->getId();
        
        $verificaMensagemLida = Controller::getAdapterAcadeGeral()->select()
            ->from(array('au' => TB_AVISO_USUARIO), ['id_cliente', 'id_aviso', 'id_usuario'])
            ->where('id_aviso = ' . $atualizacao['id_aviso'])
            ->where('id_cliente = ' . $idCliente['id_cliente'])
            ->where('id_usuario = ' . $idUsuario)
            ->query()->fetch();

        if (!$verificaMensagemLida) {
            return $atualizacao;
        }
    }

    public static function atualizaStatusMensagemAtualizacao($idAviso)
    {
        $idCliente = self::pegaDadosCliente();
        $idUsuario = Login::getUsuario()->getId();
        $dsLog = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';

        $campos = array(
            'id_cliente' => $idCliente['id_cliente'],
            'id_aviso' => $idAviso,
            'id_usuario' => $idUsuario,
            'ds_log' => $dsLog
        );

        try {
            $dbAvisoUsuairo = Controller::getAdapterAcadeGeral();
            $dbAvisoUsuairo->insert(TB_AVISO_USUARIO, $campos);

            return true;
        } catch (Exception $e) {
            return false;
        }
    }

    public static function getAvisosAtualizacoes()
    {
        $avisos = Controller::getAdapterAcadeGeral()->select()
            ->from(array('a' => TB_AVISO), ['id_aviso', 'ds_aviso', 'dt_aviso', 'ds_titulo'])
            ->where('fl_atualizacao = "1"')
            ->order('id_aviso DESC')
            ->query()->fetchAll();

        $idCliente = self::pegaDadosCliente();
        $idUsuario = Login::getUsuario()->getId();

        foreach ($avisos as $k => $aviso) {

            $avisos[$k]['flVisualizado'] = false;

            $verificaMensagemLida = Controller::getAdapterAcadeGeral()->select()
                ->from(array('au' => TB_AVISO_USUARIO), ['id_cliente', 'id_aviso', 'id_usuario'])
                ->where('id_aviso = ' . $aviso['id_aviso'])
                ->where('id_cliente = ' . $idCliente['id_cliente'])
                ->where('id_usuario = ' . $idUsuario)
                ->query()->fetch();

            if ($verificaMensagemLida) {
                $avisos[$k]['flVisualizado'] = true;
            }
        }
        
        return $avisos;
    }
}
