<?php
class Assinatura extends Zend_Db_Table_Abstract {

    protected $_name = TB_ASSINATURA;
    static $assinaturaInstacia;

    /**
     * Funo para retornar uma instancia do objeto, usada como singleton para evitar conflitos de
     * acessos multiplos a classe ao realizar um update, find, add ou delete
     * @return Assinatura
     */
    public static function getInstance()
    {
        if (!self::$assinaturaInstacia) {
            self::$assinaturaInstacia = new Assinatura();
        }
        return self::$assinaturaInstacia;
    }

    /*
     * Procura as assinaturas referentes ao empreendimento pelo Id
     * @param integer $idEmpreendimento
     * @return Array(Obj) $assinaturas
     */
    public static function findAssinaturaByEmpreendimento($idEmpreendimento)
    {
        $assinaturas = self::getInstance();

        $assinaturas = $assinaturas->select()->from(array('a' => TB_ASSINATURA), '*')
            ->where('a.id_empreendimento = ?', $idEmpreendimento)
            ->query()->fetchAll();

        if($assinaturas){
            return $assinaturas;
        } else {
            return false;
        }
    }

}

