<?php
/*
 * @descr: Gera o arquivo de sped para cobranca no padrao CNAB 240 vers. 10.01 FEBRABAN
 */
class ArquivoSped extends Zend_Db_Table_Abstract
{
    protected $_name = TB_SPED;
    /**
     * Limita e trata as palavras e numeros para o formato dos campos
     * @param string $valor
     * @param integer $limite
     * @param string $tipoFiltro
     * @return string $valor
     */
    private static function filtrarValor($valor, $limite, $tipoFiltro = '')
    {
        if ($tipoFiltro == 'texto') {
            $valor = Helper::removeAcentos($valor);
            $valor = str_replace("_", " ", $valor);
            $valor = str_replace(array("-", ",", "."), "", $valor);
        }
        if ($tipoFiltro == 'numero') {
            $valor = Helper::apenasNumeros($valor);
        }
        if ($tipoFiltro == 'decimal') {
            if ($valor) {
                $valor = str_replace('.',',',number_format($valor, 2, ",", ""));
            } else {
                $valor = 0;
            }
        }
        if (strlen($valor) >= $limite && $limite > 0) {
            $valor = substr($valor, 0, $limite);
        }
        return $valor;
    }
    /**
     * Fun??o responsavel por gerar informa??es os todos blocos do arquivo SPED
     * @param array $dados
     * @return string $conteudo
     */
    public function gerarBlocos ($dados) {
        $conteudo = self::gerarBloco0($dados);
        $conteudo .= self::gerarBlocoACD();
        $conteudo .= self::gerarBlocoF($dados);
        $conteudo .= self::gerarBlocoI();
        $conteudo .= self::gerarBlocoM($dados);
        $conteudo .= self::gerarBlocoP19($dados);
        return $conteudo;
    }
    /**
     * Fun??o responsavel por gerar informa??es do Bloco 0 do SPED
     * BLOCO 0: Abertura, Identifica??o e Refer?ncias.
     * @param array $dados
     * @return string $conteudo
     */
    public function gerarBloco0 ($dados) {
        $cep = ($dados['infoEmpreendimento'][0]['nrCepContabilidade'])?$dados['infoEmpreendimento'][0]['nrCepContabilidade']:$dados['infoEmpreendimento'][0]['nrCepContador'];
        $endereco = ($dados['infoEmpreendimento'][0]['enderecoContabilidade'])?$dados['infoEmpreendimento'][0]['enderecoContabilidade']:$dados['infoEmpreendimento'][0]['enderecoContador'];
        $nrEndereco = ($dados['infoEmpreendimento'][0]['nrEnderecoContabilidade'])?$dados['infoEmpreendimento'][0]['nrEnderecoContabilidade']:$dados['infoEmpreendimento'][0]['nrEnderecoContador'];
        $dsComplemento = ($dados['infoEmpreendimento'][0]['dsComplementoContabilidade'])?$dados['infoEmpreendimento'][0]['dsComplementoContabilidade']:$dados['infoEmpreendimento'][0]['dsComplementoContador'];
        $nmBairro = ($dados['infoEmpreendimento'][0]['nmBairroContabilidade'])?$dados['infoEmpreendimento'][0]['nmBairroContabilidade']:$dados['infoEmpreendimento'][0]['nmBairroContador'];
        $nrTelefone = ($dados['infoEmpreendimento'][0]['nrTelefoneContabilidade'])?$dados['infoEmpreendimento'][0]['nrTelefoneContabilidade']:$dados['infoEmpreendimento'][0]['nrTelefoneContador'];
        $email = ($dados['infoEmpreendimento'][0]['emailContabilidade'])?$dados['infoEmpreendimento'][0]['emailContabilidade']:$dados['infoEmpreendimento'][0]['emailContador'];
        $cdCidade = ($dados['infoEmpreendimento'][0]['cdCidadeContabilidade'])?$dados['infoEmpreendimento'][0]['cdCidadeContabilidade']:$dados['infoEmpreendimento'][0]['cdCidadeContador'];
        $dtFinal = explode('/',$dados['post']['dtFinal']);
        $versaoLeiaute = ($dtFinal[2] < 2019)?'005':'006';
        $scp = $dados['filial'] ? '05' : '00';
        
        if ($dados['parcelasFilial'] == 'N') {
            $scp = '03';
        }
        
        /*
         * Registro 0000 - pagina 59
         * Abertura do Arquivo Digital e Identifica??o da Pessoa Jur?dica
         */
        $reg0000 = array(
            // 01 REG - Texto fixo contendo 0000. C 004* - S
            '0000',
            // 02 COD_VER - C?digo da vers?o do leiaute conforme a tabela 3.1.1. N 003
            $versaoLeiaute,
            // 03 TIPO_ESCRIT - Tipo de escritura??o: 0 - Original; 1 - Retificadora
            '0',
            // 04 IND_SIT_ESP - Indicador de situa??o especial: 0 - Abertura 1 - Cis?o 2 - Fus?o 3 - Incorpora??o 4 - Encerramento
            '',
            // 05 NUM_REC_ANTERIOR N?mero do Recibo da Escritura??o anterior a ser retificada, utilizado quando TIPO_ESCRIT for igual a 1
            '',
            // 06 DT_INI Data inicial das informa??es contidas no arquivo.
            self::filtrarValor($dados['post']['dtInicial'],8,'numero'),
            // 07 DT_FIN Data final das informa??es contidas no arquivo.
            self::filtrarValor($dados['post']['dtFinal'],8,'numero'),
            // 08 NOME Nome empresarial da pessoa jur?dica C 100 - S
            self::filtrarValor(Helper::removeCaracteresEspeciaisSped($dados['infoEmpreendimento'][0]['nmPjResponsavel']),100,'texto'),
            // 09 CNPJ N?mero de inscri??o do estabelecimento matriz da pessoa jur?dica no CNPJ.
            self::filtrarValor($dados['infoEmpreendimento'][0]['cnpJuridica'],14,'numero'),
            // 10 UF Sigla da Unidade da Federa??o da pessoa jur?dica.
            self::filtrarValor($dados['infoCliente']['ufCliente'],2),
            // 11 COD_MUN C?digo do munic?pio do domic?lio fiscal da pessoa jur?dica, conforme a tabela IBGE
            self::filtrarValor($dados['infoCliente']['cd_municipio'],7,'numero'),
            // 12 SUFRAMA Inscri??o da pessoa jur?dica na Suframa
            '000000000',
            //13 IND_NAT_PJ Indicador da natureza da pessoa jur?dica:
            //00 - Pessoa jur?dica em geral
            //01 - Sociedade cooperativa
            //02 - Entidade sujeita ao PIS/Pasep exclusivamente com base na Folha de Sal?rios
            // Indicador da natureza da pessoa jur?dica, a partir do ano-calend?rio de 2014:
            //00 - Pessoa jur?dica em geral (n?o participante de SCP como s?cia ostensiva)
            //01 - Sociedade cooperativa (n?o participante de SCP como s?cia ostensiva)
            //02 - Entidade sujeita ao PIS/Pasep exclusivamente com base na Folha de Sal?rios
            //03 - Pessoa jur?dica em geral participante de SCP como s?cia ostensiva
            //04 - Sociedade cooperativa participante de SCP como s?cia ostensiva
            //05 - Sociedade em Conta de Participa??o - SCP
            $scp,
            // 14 IND_ATIV Indicador de tipo de atividade preponderante:
            //0 - Industrial ou equiparado a industrial;
            //1 - Prestador de servi?os;
            //2 - Atividade de com?rcio;
            //3 - Pessoas jur?dicas referidas nos ?? 6?, 8? e 9? do art. 3? da Lei n? 9.718, de 1998;
            //4 - Atividade imobili?ria;
            //9 - Outros.
            '4'
        );
        $conteudo = '|' . implode('|', $reg0000) .'|'. chr(13) . chr(10);
        /*
         * Registro 0001 - pagina 62
         * Abertura do Bloco 0
         */
        $reg0001 = array(
            // 01 REG Texto fixo contendo 0001.
            '0001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados.
            '0'
        );
        $conteudo .= '|' . implode('|', $reg0001) .'|'. chr(13) . chr(10);
        /**
         * Registro 0035
         * Dados da filial
         */
        if($dados['filial']){
            foreach($dados['infoEmpreendimento'] as $empreendimentos){
                if($empreendimentos['cnpjFilial']){
                    $reg0035 = array (
                        // 01 REG Texto fixo contendo 0035.
                        '0035',
                        // 02 REG CNPJ da pessoa jurdica
                        str_replace(array('.', '/', '-'), '', $empreendimentos['cnpjFilial']),
                        // 03 REG Nome da pessoa jurdica
                        Helper::removeCaracteresEspeciaisSped($empreendimentos['nmFilial'])
                    );
                    if ($dados['infoEmpreendimento'][0]['cnpjFilial'])
                        $conteudo .= '|' . implode('|', $reg0035) . '||' . chr(13) . chr(10);
                }
            }
        }
        /*
         * Registro 0100 - pagina 64
         * Dados do Contabilista
         */
        $reg0100 = array(
            // 01 REG Texto fixo contendo 0100
            '0100',
            // 02 NOME Nome do contabilista
            self::filtrarValor(Helper::removeCaracteresEspeciaisSped($dados['infoEmpreendimento'][0]['nmContador']),100,'texto'),
            // 03 CPF N?mero de inscri??o do contabilista no CPF
            self::filtrarValor($dados['infoEmpreendimento'][0]['cpfContador'],11,'numero'),
            // 04 CRC N?mero de inscri??o do contabilista no Conselho Regional de Contabilidade.
            self::filtrarValor($dados['infoEmpreendimento'][0]['nr_crc'],15,''),
            // 05 CNPJ N?mero de inscri??o do escrit?rio de contabilidade no CNPJ, se houver.
            self::filtrarValor($dados['infoEmpreendimento'][0]['cnpjContabilidade'],14,'numero'),
            // 06 CEP C?digo de Endere?amento Postal
            self::filtrarValor(($cep)?$cep:'',8,'numero'),
            // 07 END Logradouro e endere?o do im?vel
            self::filtrarValor(($endereco) ? Helper::removeCaracteresEspeciaisSped($endereco) : '',60,'texto'),
            // 08 NUM N?mero do im?vel.
            self::filtrarValor(($nrEndereco)?$nrEndereco:'',10,'numero'),
            // 9 COMPL Dados complementares do endere?o
            self::filtrarValor(($dsComplemento) ? Helper::removeCaracteresEspeciaisSped($dsComplemento) : '',60,'texto'),
            // 10 BAIRRO Bairro em que o im?vel est? situado.
            self::filtrarValor(($nmBairro)?$nmBairro:'',60,'texto'),
            // 11 FONE N?mero do telefone.
            self::filtrarValor(($nrTelefone)?$nrTelefone:'',11,'numero'),
            // 12 FAX N?mero do fax
            '',
            // 13 EMAIL Endere?o do correio eletr?nico.
            ($email)?$email:'',
            // 14 COD_MUN C?digo do munic?pio, conforme tabela IBGE.
            self::filtrarValor(($cdCidade)?$cdCidade:'',7)
        );
        $conteudo .= '|' . implode('|', $reg0100) .'|'. chr(13) . chr(10);
        /*
         * Registro 0110 - pagina 65
         * Regimes de Apura??o da Contribui??o Social e de Apropria??o de Cr?dito
         */
        $reg0110 = array(
            // 01 REG Texto fixo contendo 0110.
            '0110',
            // 02 COD_INC_TRIB C?digo indicador da incid?ncia tribut?ria no per?odo:
            // 1 - Escritura??o de opera??es com incid?ncia exclusivamente no regime n?o-cumulativo;
            // 2 - Escritura??o de opera??es com incid?ncia exclusivamente no regime cumulativo;
            // 3 - Escritura??o de opera??es com incid?ncia nos regimes n?o-cumulativo e cumulativo.
            '2',
            // 03 IND_APRO_CR ED C?digo indicador de mtodo de apropria??o de cr?ditos comuns, no caso de incid?ncia
            // no regime n?o-cumulativo (COD_INC_TRIB = 1 ou 3):
            // 1 - Mtodo de Apropria??o Direta;
            // 2 - Mtodo de Rateio Proporcional (Receita Bruta)
            '',
            // 04 COD_TIPO_CO NT C?digo indicador do Tipo de Contribui??o Apurada no Per?odo
            // 1 - Apura??o da Contribui??o Exclusivamente a Al?quota B?sica
            // 2 - Apura??o da Contribui??o a Al?quotas Espec?ficas (Diferenciadas e/ou por Unidade de Medida de Produto)
            '1',
            // 05 IND_REG_CUM C?digo indicador do crit?rio de escritura??o e apura??o adotado, no caso de incid?ncia
            // exclusivamente no regime cumulativo (COD_INC_TRIB = 2), pela pessoa jur?dica submetida ao regime de
            // tributa??o com base no lucro presumido:
            // 1 - Regime de Caixa e Escritura??o consolidada (Registro F500);
            // 2 - Regime de Compet?ncia - Escritura??o consolidada (Registro F550);
            // 9 - Regime de Compet?ncia - Escritura??o detalhada, com base nos registros dos Blocos A, C, D e F.
            '1'
        );
        $conteudo .= '|' . implode('|', $reg0110) .'|'. chr(13) . chr(10);
        /*
         * Registro 0140 - pagina 72
         * Tabela de Cadastro de Estabelecimentos
         */
        $reg0140 = array(
            // 01 REG Texto fixo contendo 0140
            '0140',
            // 02 COD_EST C?digo de identifica??o do estabelecimento
            self::filtrarValor($dados['infoEmpreendimento'][0]['cnpJuridica'],14,'numero'),
            // 03 NOME Nome empresarial do estabelecimento
            self::filtrarValor(Helper::removeCaracteresEspeciaisSped($dados['infoEmpreendimento'][0]['nmPjResponsavel']),100,'texto'),
            // 04 CNPJ N?mero de inscri??o do estabelecimento no CNPJ.
            self::filtrarValor($dados['infoEmpreendimento'][0]['cnpJuridica'],14,'numero'),
            // 05 UF Sigla da unidade da federa??o do estabelecimento
            self::filtrarValor($dados['infoCliente']['ufCliente'],2),
            // 06 IE Inscri??o Estadual do estabelecimento, se contribuinte de ICMS
            self::filtrarValor($dados['infoEmpreendimento'][0]['nr_inscricao_estadual'],14,'texto'),
            // 07 COD_MUN C?digo do munic?pio do domic?lio fiscal do estabelecimento, conforme a tabela IBGE
            self::filtrarValor(($dados['infoCliente']['cd_municipio'])?$dados['infoCliente']['cd_municipio']:'',7),
            // 08 IM Inscri??o Municipal do estabelecimento, se contribuinte do ISS.
            self::filtrarValor($dados['infoEmpreendimento'][0]['nr_inscricao_municipal'],60,'texto'),
            // 09 SUFRAMA Inscri??o do estabelecimento na Suframa C 009* -
            '000000000',
        );

        $conteudo .= '|' . implode('|', $reg0140) .'|'. chr(13) . chr(10);

        /*
         * Registro 0500 - pagina 82
         * Plano de Contas Cont?beis
         */
        $nrReg0550 = 0;
        if ($dados['infoEmpreendimento'][0]['fl_natureza_conta'] &&
            $dados['infoEmpreendimento'][0]['fl_tipo_conta'] &&
            $dados['infoEmpreendimento'][0]['nr_nivel_conta'] &&
            $dados['infoEmpreendimento'][0]['nr_codigo_conta'] &&
            $dados['infoEmpreendimento'][0]['ds_nome_conta'] &&
            $dados['infoEmpreendimento'][0]['nr_conta_receita']) {
            $nrReg0550 = 1;
            $reg0500 = array(
                // 01 REG Texto fixo contendo 0500
                '0500',
                // 02 DT_ALT Data da inclus?o/altera??o
                self::filtrarValor(Helper::getDate($dados['infoEmpreendimento'][0]['dt_inclusao_conta']),8,'numero'),
                // 03 COD_NAT_CC C?digo da natureza da conta/grupo de contas:
                // 01 - Contas de ativo; 02 - Contas de passivo; 03 - Patrimnio lquido;
                // 04 - Contas de resultado; 05 - Contas de compensao; 09 - Outras;
                $dados['infoEmpreendimento'][0]['fl_natureza_conta'],
                // 04 IND_CTA Indicador do tipo de conta: S - Sinttica (grupo de contas); A - Analtica (conta).
                $dados['infoEmpreendimento'][0]['fl_tipo_conta'],
                // 05 N?VEL N?vel da conta anal?tica/grupo de contas.
                $dados['infoEmpreendimento'][0]['nr_nivel_conta'],
                // 06 COD_CTA C?digo da conta anal?tica/grupo de contas
                self::filtrarValor($dados['infoEmpreendimento'][0]['nr_codigo_conta'],255,'numero'),
                // 07 NOME_CTA Nome da conta anal?tica/grupo de contas.
                self::filtrarValor($dados['infoEmpreendimento'][0]['ds_nome_conta'],60,'texto'),
                // 08 COD_CTA_REF C?digo da conta correlacionada no Plano de Contas Referenciado, publicado pela RFB.
                self::filtrarValor($dados['infoEmpreendimento'][0]['nr_conta_receita'],60,''),
                // 09 CNPJ_EST CNPJ do estabelecimento, no caso da conta informada no campo COD_CTA ser espec?fica de um estabelecimento.
                self::filtrarValor($dados['infoEmpreendimento'][0]['cnpJuridica'],14,'numero'),
            );
            $conteudo .= '|' . implode('|', $reg0500) .'|'. chr(13) . chr(10);
        }

        $adicionaLinha0035reg0990 = count($dados['filial']);
        /*
         * Registro 0990 - pagina 85
         * Encerramento do Bloco 0
         */
        $reg0990 = array(
            // 01 REG Texto fixo contendo 0500
            '0990',
            // 02 QTD_LIN_0 Quantidade total de linhas do Bloco 0
            6 + $nrReg0550 + $adicionaLinha0035reg0990
        );
        $conteudo .= '|' . implode('|', $reg0990) .'|'. chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Fun??o responsavel por gerar informa??es do Bloco A, C e D do SPED
     * BLOCO A: Documentos Fiscais - Servi?os (ISS)
     * BLOCO C: Documentos Fiscais - I - Mercadorias (ICMS/IPI)
     * @return string $conteudo
     */
    public function gerarBlocoACD () {
        /*
         * Registro A001: Abertura do Bloco A - pagina 85
         */
        $regA001 = array(
            // 01 REG - Texto fixo contendo 0000. C 004* - S
            'A001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '1'
        );
        $conteudo = '|' . implode('|', $regA001) .'|'. chr(13) . chr(10);
        /*
         * Registro A990: Encerramento do Bloco A - pagina 62
         */
        $regA090 = array(
            // 01 REG Texto fixo contendo 0001.
            'A990',
            // 02 QTD_LIN_A Quantidade total de linhas do Bloco A
            '2'
        );
        $conteudo .= '|' . implode('|', $regA090) .'|'. chr(13) . chr(10);
        /*
         * Registro C001: Abertura do Bloco C - pagina 94
         */
        $regC001 = array(
            // 01 REG Texto fixo contendo C001.
            'C001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '1'
        );
        $conteudo .= '|' . implode('|', $regC001) .'|'. chr(13) . chr(10);
        /*
         * Registro C990: Fechamento do Bloco C - pagina 174
         */
        $regC990 = array(
            // 01 REG Texto fixo contendo C990.
            'C990',
            // 02 QTD_LIN_A Quantidade total de linhas do Bloco C
            '2'
        );
        $conteudo .= '|' . implode('|', $regC990) .'|'. chr(13) . chr(10);
        /*
         * Registro D001: Abertura do Bloco D - pagina 175
         */
        $regD001 = array(
            // 01 REG Texto fixo contendo D001.
            'D001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '1'
        );
        $conteudo .= '|' . implode('|', $regD001) .'|'. chr(13) . chr(10);
        /*
         * Registro D990: Fechamento do Bloco D - pagina 207
         */
        $regD990 = array(
            // 01 REG Texto fixo contendo D990.
            'D990',
            // 02 QTD_LIN_A Quantidade total de linhas do Bloco D
            '2'
        );
        $conteudo .= '|' . implode('|', $regD990) .'|'. chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Fun??o responsavel por gerar informa??es do Bloco F do SPED
     * BLOCO F: Demais Documentos e Opera??es
     * @param array $dados
     * @return string $conteudo
     */
    public function gerarBlocoF ($dados) {
        /*
         * Registro F001: Abertura do Bloco F - pagina 208
         */
        $regF001 = array(
            // 01 REG - Texto fixo contendo F001
            'F001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '0'
        );
        $conteudo = '|' . implode('|', $regF001) .'|'. chr(13) . chr(10);
        /*
         * Registro F010: Identifica??o do Estabelecimento - pagina 209
         */
        $regF010 = array(
            // 01 REG Texto fixo contendo F010.
            'F010',
            // 02 CNPJ N?mero de inscri??o do estabelecimento no CNPJ
            self::filtrarValor($dados['infoEmpreendimento'][0]['cnpJuridica'],14,'numero')
        );
        $conteudo .= '|' . implode('|', $regF010) .'|'. chr(13) . chr(10);
        /*
         * Registro F200: Opera??es da Atividade Imobili?ria - Unidade Imobili?ria Vendida - pagina 226
         */
        foreach ($dados['listaParcelas'] as $parcela) {
            $regF200 = array(
                // 01 REG Texto fixo contendo F200.
                'F200',
                // 02 IND_OPER Indicador do Tipo da Opera??o: 01 - Venda a Vista de Unidade Conclu?da;
                //  02 - Venda a Prazo de Unidade Conclu?da; 03 - Venda a Vista de Unidade em Constru??o;
                //  04 - Venda a Prazo de Unidade em Constru??o; 05 - Outras
                $dados['infoEmpreendimento'][0]['ind_oper'],
                // 03 UNID_IMOB Indicador do tipo de unidade imobili?ria Vendida: 01 - Terreno adquirido para venda;
                //  02 - Terreno decorrente de loteamento; 03 - Lote oriundo de desmembramento de terreno;
                //  04 - Unidade resultante de incorpora??o imobili?ria; 05 - Pr?dio constru?do/em constru??o para venda;
                //  06 - Outras.
                $dados['infoEmpreendimento'][0]['unid_imob'],
                // 04 IDENT_EMP Identifica??o/Nome do Empreendimento
                self::filtrarValor(Helper::removeCaracteresEspeciaisSped($parcela['nm_empreendimento']),100,'texto'),
                // 05 DESC_UNID_IMOB Descri??o resumida da unidade imobili?ria vendida
                self::filtrarValor('Quadra = '.$parcela['quadra'].' Lote = '.$parcela['lote'],90,'texto'),
                // 06 NUM_CONT N?mero do Contrato/Documento que formaliza a Venda da Unidade Imobili?ria
                $parcela['contrato'],
                // 07 CPF_CNPJ_ADQU Identifica??o da pessoa f?sica (CPF) ou da pessoa jur?dica (CNPJ) adquirente da unidade imobiliria
                self::filtrarValor($parcela['cpf_cnpj'],14,'numero'),
                // 08 DT_OPER Data da opera??o de venda da unidade imobiliria
                self::filtrarValor($parcela['dt_contrato'],8,'numero'),
                // 09 VL_TOT_VEND Valor total da unidade imobili?ria vendida atualizado at? o per?odo da escriturao
                self::filtrarValor($parcela['vlVenda'],0,'decimal'),
                // 10 VL_REC_ACUM Valor recebido acumulado ate o mes anterior ao da escrituracao
                self::filtrarValor($parcela['valorRecebido'],0,'decimal'),
                // 11 VL_TOT_REC Valor total recebido no m?s da escritura??o
                self::filtrarValor($parcela['vl_total_pago'],0,'decimal'),
                // 12 CST_PIS C?digo da Situa??o Tribut?ria referente ao PIS/PASEP, conforme a Tabela indicada no item 4.3.3
                '01',
                // 13 VL_BC_PIS Base de C?lculo do PIS/PASEP
                self::filtrarValor($parcela['vl_total_pago'],0,'decimal'),
                // 14 ALIQ_PIS Al?quota do PIS/PASEP (em percentual)
                self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_pis_pasep'],8,'decimal'),
                // 15 VL_PIS Valor do PIS/PASEP
                self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_pis_pasep']*$parcela['vl_total_pago']/100,8,'decimal'),
                // 16 CST_COFINS C?digo da Situa??o Tribut?ria referente a COFINS, conforme a Tabela indicada no item 4.3.4.
                '01',
                // 17 VL_BC_COFINS Base de C?lculo da COFINS
                self::filtrarValor(($parcela['vl_total_pago'])?$parcela['vl_total_pago']:0,0,'decimal'),
                // 18 ALIQ_COFINS Al?quota da COFINS (em percentual)
                self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_cofins'],8,'decimal'),
                // 19 VL_COFINS Valor da COFINS
                self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_cofins']*$parcela['vl_total_pago']/100,8,'decimal'),
                // 20 PERC_REC_RECEB Percentual da receita total recebida at? o m?s, da unidade imobili?ria vendida
                // ((Campo 10 + Campo 11) / Campo 09)
                self::filtrarValor((($parcela['valorRecebido']+$parcela['vl_total_pago'])/$parcela['vlVenda'])*100,0,'decimal'),
                // 21 IND_NAT_EMP Indicador da Natureza Espec?fica do Empreendimento: 1 - Cons?rcio 2 - SCP
                // 3 - Incorpora??o em Condom?nio 4 - Outras
                '4',
                // 22 INF_COMP Informa??es Complementares
                '',
            );
            $conteudo .= '|' . implode('|', $regF200) .'|'. chr(13) . chr(10);
        }
        /*
         * Registro F990: Encerramento do Bloco F - pagina 257
         */
        $regF990 = array(
            // 01 REG Texto fixo contendo F990.
            'F990',
            // 02 QTD_LIN_F Quantidade total de linhas do Bloco F
            count($dados['listaParcelas'])+3
        );
        $conteudo .= '|' . implode('|', $regF990) .'|'. chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Fun??o responsavel por gerar informa??es do Bloco I do SPED
     * BLOCO I: Opera??es das Institui??es Financeiras, Seguradoras, Entidades de
     * Previdencia Privada, Operadoras de Planos de Assist?ncia ? Sa?de e Demais Pessoas
     * Jur?dicas Referidas nos ?? 6?, 8? e 9? do art. 3? da lei n? 9.718/98.
     * @return string $conteudo
     */
    public function gerarBlocoI () {
        /*
         * Registro I001: Abertura do Bloco I - pagina 258
         */
        $regI001 = array(
            // 01 REG - Texto fixo contendo I001
            'I001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '1'
        );
        $conteudo = '|' . implode('|', $regI001) .'|'. chr(13) . chr(10);
        /*
         * Registro I990: Encerramento do Bloco I - pagina 266
         */
        $regI990 = array(
            // 01 REG Texto fixo contendo I990.
            'I990',
            // 02 QTD_LIN_I Quantidade total de linhas do Bloco I
            '2'
        );
        $conteudo .= '|' . implode('|', $regI990) .'|'. chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Fun??o responsavel por gerar informa??es do Bloco  M do SPED
     * BLOCO M - Apura??o da Contribui??o e Cr?dito do PIS/Pasep e da Cofins
     * @param array $dados
     * @return string $conteudo
     */
    public function gerarBlocoM ($dados) {
        $vlTotalPago = $vlTotalConfins = $vlTotalPisPasep = 0;
        foreach ($dados['listaParcelas'] as $parcela) {
            $vlTotalPago += $parcela['vl_total_pago'];
        }
        $vlTotalPisPasep = (($vlTotalPago * $dados['infoEmpreendimento'][0]['vl_aliquota_pis_pasep'])/100);
        $vlTotalConfins = (($vlTotalPago * $dados['infoEmpreendimento'][0]['vl_aliquota_cofins'])/100);
        $dtFinal = explode('/',$dados['post']['dtFinal']);
        $leiauteAntigo = ($dtFinal[2] < 2019)?true:false;
        /*
         * Registro M001: Abertura do Bloco M - pagina 267
         */
        $regM001 = array(
            // 01 REG - Texto fixo contendo M001
            'M001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '0'
        );
        $conteudo = '|' . implode('|', $regM001) .'|'. chr(13) . chr(10);
        /*
         * Registro M200: Consolida??o da Contribui??o para o PIS/Pasep do Per?odo - pagina 277
         */
        $regM200 = array(
            // 01 REG Texto fixo contendo M200.
            'M200',
            // 02 VL_TOT_CONT_NC_PER Valor Total da Contribui??o N?o Cumulativa do Per?odo (recuperado do campo
            // 13 do Registro M210, quando o campo COD_CONT = 01, 02, 03, 04, 32 e 71)
            '0',
            // 03 VL_TOT_CRED_DESC Valor do Cr?dito Descontado, Apurado no Pr?prio Per?odo da Escritura??o
            // (recuperado do campo 14 do Registro M100)
            '0',
            // 04 VL_TOT_CRED_DESC_ANT Valor do Cr?dito Descontado, Apurado em Per?odo de Apura??o Anterior
            // (recuperado do campo 13 do Registro 1100)
            '0',
            // 05 VL_TOT_CONT_NC_DEV Valor Total da Contribui??o N?o Cumulativa Devida (02 - 03 - 04)
            '0',
            // 06 VL_RET_NC Valor Retido na Fonte Deduzido no Per?odo
            '0',
            // 07 VL_OUT_DED_NC Outras Dedu??es no Per?odo
            '0',
            // 08 VL_CONT_NC_REC Valor da Contribui??o N?o Cumulativa a Recolher/Pagar (05 - 06 - 07)
            '0',
            // 09 VL_TOT_CONT_CUM_PER Valor Total da Contribui??o Cumulativa do Per?odo
            // (recuperado do campo 13/16 do Registro M210, quando o campo COD_CONT = 31, 32, 51, 52, 53, 54 e 72)
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
            // 10 VL_RET_CUM Valor Retido na Fonte Deduzido no Per?odo
            '0',
            // 11 VL_OUT_DED_CUM Outras Dedu??es no Per?odo
            '0',
            // 12 VL_CONT_CUM_REC Valor da Contribui??o Cumulativa a Recolher/Pagar (09 - 10 - 11)
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
            // 13 VL_TOT_CONT_REC Valor Total da Contribui??o a Recolher/Pagar no Per?odo (08 + 12)
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
        );
        $conteudo .= '|' . implode('|', $regM200) .'|'. chr(13) . chr(10);
        /*
         * Registro M205: Contribui??o para o PIS/Pasep a Recolher Detalhamento por C?digo de Receita - pagina 280
         */
        $regM205 = array(
            // 01 REG Texto fixo contendo M205.
            'M205',
            // 02 NUM_CAMPO Informar o n?mero do campo do registro M200 (Campo 08 (contribui??o n?o cumulativa)
            // ou Campo 12 (contribui??o cumulativa)), objeto de detalhamento neste registro.
            '12',
            // 03 COD_REC Informar o c?digo da receita referente ? contribui??o a recolher, detalhada neste registro.
            '810902',
            // 04 VL_DEBITO Valor do D?bito correspondente ao c?digo do Campo 03, conforme informa??o na DCTF.
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
        );
        $conteudo .= '|' . implode('|', $regM205) .'|'. chr(13) . chr(10);
        /*
         * Registro M210 aplic?vel aos Fatos Geradores ocorridos ANTES de 01 de janeiro de 2019 - pagina 285
         */
        $regM210Antigo = array(
            // 01 REG Texto fixo contendo M210.
            'M210',
            // 02 COD_CONT C?digo da contribui??o social apurada no per?odo, conforme a Tabela 4.3.5.
            '54',
            // 03 VL_REC_BRT Valor da Receita Bruta
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 04 VL_BC_CONT Valor da Base de C?lculo da Contribui??o, antes de ajustes
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 05 ALIQ_PIS Alquota do PIS/PASEP (em percentual)
            self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_pis_pasep'],8,'decimal'),
            // 06 QUANT_BC_PIS Quantidade ? Base de clculo PIS
            '0',
            // 07 ALIQ_PIS_QUANT Alquota do PIS (em reais)
            '',
            // 08 VL_CONT_APUR Valor total da contribui??o social apurada
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
            // 09 VL_AJUS_ACRES Valor total dos ajustes de acr?scimo
            '0',
            // 10 VL_AJUS_REDUC Valor total dos ajustes de redu??o
            '0',
            // 11 VL_CONT_DIFER Valor da contribui??o a diferir no per?odo
            '0',
            // 12 VL_CONT_DIFER_ANT Valor da contribui??o diferida em per?odos anteriores
            '0',
            // 13 VL_CONT_PER Valor Total da Contribui??o do Per?odo (08 + 09 - 10 - 11+12)
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
        );
        /*
         * Leiaute do Registro M210 aplicvel aos Fatos Geradores ocorridos a partir de 01 de janeiro de 2019: - pagina 292
         */
        $regM210Novo = array(
            // 01* REG Texto fixo contendo M210.
            'M210',
            // 02* COD_CONT C?digo da contribui??o social apurada no per?odo, conforme a Tabela 4.3.5.
            '54',
            // 03* VL_REC_BRT Valor da Receita Bruta
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 04* VL_BC_CONT Valor da Base de C?lculo da Contribui??o, antes de ajustes
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 05* VL_AJUS_ACRES_BC_PIS Valor do total dos ajustes de acr?scimo da base de c?lculo da contribui??o a
            // que se refere o Campo 04
            '0',
            // 06* VL_AJUS_REDUC_BC_PIS Valor do total dos ajustes de reducao da base de c?lculo da contribui??o a
            // que se refere o Campo 04
            '0',
            // 07* VL_BC_CONT_AJUS Valor da Base de Clculo da Contribuio, aps os ajustes.
            // (Campo 07 = Campo 04 + Campo 05 - Campo 06)
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 08 ALIQ_PIS Alquota do PIS/PASEP (em percentual)
            self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_pis_pasep'],8,'decimal'),
            // 09 QUANT_BC_PIS Quantidade ? Base de clculo PIS
            '0',
            // 10 ALIQ_PIS_QUANT Alquota do PIS (em reais)
            '',
            // 11 VL_CONT_APUR Valor total da contribuio social apurada
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
            // 12 VL_AJUS_ACRES Valor total dos ajustes de acrscimo da contribuio social apurada
            '0',
            // 13 VL_AJUS_REDUC Valor total dos ajustes de reduo da contribuio social apurada
            '0',
            // 14 VL_CONT_DIFER Valor da contribuio a diferir no perodo
            '0',
            // 15 VL_CONT_DIFER_ANT Valor da contribuio diferida em perodos anteriores
            '0',
            // 16 VL_CONT_PER Valor Total da Contribuio do Perodo (11 + 12 - 13 - 14+15)
            self::filtrarValor($vlTotalPisPasep,0,'decimal'),
        );
        $regM210 = ($leiauteAntigo)?$regM210Antigo:$regM210Novo;
        $conteudo .= '|' . implode('|', $regM210) .'|'. chr(13) . chr(10);
        /*
         * Registro M600: Consolida??o da Contribui??o para a Seguridade Social - Cofins do Per?odo - pagina 310
         */
        $regM600 = array(
            // 01 REG Texto fixo contendo M600.
            'M600',
            // 02 VL_TOT_CONT_NC_PER Valor Total da Contribui??o N?o Cumulativa do Per?odo (recuperado do
            // campo 13 do Registro M610, quando o campo COD_CONT = 01, 02, 03, 04, 32 e 71)
            '0',
            // 03 VL_TOT_CRED_DESC Valor do Cr?dito Descontado, Apurado no Pr?prio Per?odo da Escritura??o
            // (recuperado do campo 14 do Registro M500)
            '0',
            // 04 VL_TOT_CRED_DESC_ANT Valor do Cr?dito Descontado, Apurado em Per?odo de Apura??o Anterior
            // (recuperado do campo 13 do Registro 1500)
            '0',
            // 05 VL_TOT_CONT_NC_DEV Valor Total da Contribui??o N?o Cumulativa Devida (02 - 03 - 04)
            '0',
            // 06 VL_RET_NC Valor Retido na Fonte Deduzido no Per?odo
            '0',
            // 07 VL_OUT_DED_NC Outras Dedu??es no Per?odo
            '0',
            // 08 VL_CONT_NC_REC Valor da Contribui??o N?o Cumulativa a Recolher/Pagar (05 - 06 - 07)
            '0',
            // 09 VL_TOT_CONT_CUM_PER Valor Total da Contribui??o Cumulativa do Per?odo (recuperado do campo 13
            // do Registro M610, quando o campo COD_CONT = 31, 32, 51, 52, 53, 54 e 72)
            self::filtrarValor($vlTotalConfins,0,'decimal'),
            // 10 VL_RET_CUM Valor Retido na Fonte Deduzido no Per?odo
            '0',
            // 11 VL_OUT_DED_CUM Outras Dedu??es no Per?odo
            '0',
            // 12 VL_CONT_CUM_REC Valor da Contribui??o Cumulativa a Recolher/Pagar (09 - 10 - 11)
            self::filtrarValor($vlTotalConfins,0,'decimal'),
            // 13 VL_TOT_CONT_REC Valor Total da Contribui??o a Recolher/Pagar no Per?odo (08 + 12)
            self::filtrarValor($vlTotalConfins,0,'decimal'),
        );
        $conteudo .= '|' . implode('|', $regM600) .'|'. chr(13) . chr(10);
        /*
         * Registro M605: Cofins a Recolher  Detalhamento por C?digo de Receita - pagina 313
         */
        $regM605 = array(
            // 01 REG Texto fixo contendo M605.
            'M605',
            // 02 NUM_CAMPO Informar o n?mero do campo do registro M600 (Campo 08 (contribui??o n?o cumulativa)
            // ou Campo 12 (contribui??o cumulativa)), objeto de detalhamento neste registro
            '12',
            // 03 COD_REC Informar o c?digo da receita referente ? contribui??o a recolher, detalhada neste registro.
            '217201',
            // 04 VL_DEBITO Valor do D?bito correspondente ao c?digo do Campo 03, conforme informa??o na DCTF.
            self::filtrarValor($vlTotalConfins,0,'decimal'),
        );
        $conteudo .= '|' . implode('|', $regM605) .'|'. chr(13) . chr(10);
        /*
         * Registro M610: Detalhamento da Contribui??o para a Seguridade Social - Cofins do Per?odo - pagina 314
         */
        $regM610Antigo = array(
            // 01 REG Texto fixo contendo M610.
            'M610',
            // 02 COD_CONT C?digo da contribui??o social apurada no per?odo, conforme a Tabela 4.3.5.
            '54',
            // 03 VL_REC_BRT Valor da Receita Bruta
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 04 VL_BC_CONT Valor da Base de C?lculo da Contribui??o
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 05 ALIQ_COFINS Al?quota do COFINS (em percentual)
            self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_cofins'],8,'decimal'),
            // 06 QUANT_BC_COFINS Quantidade da Base de c?lculo COFINS
            '0',
            // 07 ALIQ_COFINS_QUANT Al?quota do COFINS (em reais)
            '',
            // 08 VL_CONT_APUR Valor total da contribui??o social apurada
            self::filtrarValor($vlTotalConfins,0,'decimal'),
            // 09 VL_AJUS_ACRES Valor total dos ajustes de acr?scimo
            '0',
            // 10 VL_AJUS_REDUC Valor total dos ajustes de redu??o
            '0',
            // 11 VL_CONT_DIFER Valor da contribui??o a diferir no per?odo
            '0',
            // 12 VL_CONT_DIFER_ANT Valor da contribui??o diferida em per?odos anteriores
            '0',
            // 13 VL_CONT_PER Valor Total da Contribui??o do Per?odo (08 + 09 - 10 - 11 +12)
            self::filtrarValor($vlTotalConfins,0,'decimal'),
        );
        /*
         * Leiaute do Registro M610 aplicvel aos Fatos Geradores ocorridos a partir de 01 de janeiro de 2019 - pagina 314
         */
        $regM610Novo = array(
            // 01 REG Texto fixo contendo M610.
            'M610',
            // 02 COD_CONT C?digo da contribui??o social apurada no per?odo, conforme a Tabela 4.3.5.
            '54',
            // 03 VL_REC_BRT Valor da Receita Bruta
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 04 VL_BC_CONT Valor da Base de C?lculo da Contribui??o, antes de ajustes
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 05 VL_AJUS_ACRES_BC_COFINS Valor do total dos ajustes de acrscimo da base de clculo da contribuio a
            // que se refere o Campo 04
            '0',
            // 06 VL_AJUS_REDUC_BC_COFINS Valor do total dos ajustes de redu??o da base de c?lculo da contribui??o a
            // que se refere o Campo 04
            '0',
            // 07 VL_BC_CONT_AJUS Valor da Base de Clculo da Contribuio, aps os ajustes.
            // (Campo 07 = Campo 04 + Campo 05 - Campo 06)
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 08 ALIQ_COFINS Alquota do PIS/PASEP (em percentual)
            self::filtrarValor($dados['infoEmpreendimento'][0]['vl_aliquota_cofins'],8,'decimal'),
            // 09 QUANT_BC_COFINS Quantidade ? Base de clculo PIS
            '0',
            // 10 ALIQ_COFINS_QUANT Alquota do PIS (em reais)
            '',
            // 11 VL_CONT_APUR Valor total da contribuio social apurada
            self::filtrarValor($vlTotalConfins,0,'decimal'),
            // 12 VL_AJUS_ACRES Valor total dos ajustes de acrscimo da contribuio social apurada
            '0',
            // 13 VL_AJUS_REDUC Valor total dos ajustes de reduo da contribuio social apurada
            '0',
            // 14 VL_CONT_DIFER Valor da contribuio a diferir no perodo
            '0',
            // 15 VL_CONT_DIFER_ANT Valor da contribuio diferida em perodos anteriores
            '0',
            // 16 VL_CONT_PER Valor Total da Contribuio do Perodo (11 + 12 - 13 - 14+15)
            self::filtrarValor($vlTotalConfins,0,'decimal'),
        );
        $regM610 = ($leiauteAntigo)?$regM610Antigo:$regM610Novo;
        $conteudo .= '|' . implode('|', $regM610) .'|'. chr(13) . chr(10);
        /*
         * Registro M990: Encerramento do Bloco M - pagina 332
         */
        $regM990 = array(
            // 01 REG Texto fixo contendo M990.
            'M990',
            // 02 QTD_LIN_M Quantidade total de linhas do Bloco M
            '8',
        );
        $conteudo .= '|' . implode('|', $regM990) .'|'. chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Funo responsavel por gerar informa??es do Bloco  P, 1 e 9 do SPED
     * BLOCO P: Apura??o da Contribui??o Previdenci?ria Sobre a Receita Bruta (CPRB)
     * BLOCO 1: Complemento da Escritura??o - Controle de Saldos de Cr?ditos e de Reten??es, Opera??es
    Extempor?neas e Outras Informa??es
     * BLOCO 9: Controle e Encerramento do Arquivo Digital.
     * @param array $dados
     * @return string $conteudo
     */
    public function gerarBlocoP19 ($dados) {
        $vlTotalPago = $vlTotalConfins = 0;
        foreach ($dados['listaParcelas'] as $parcela) {
            $vlTotalPago += $parcela['vl_total_pago'];
            $vlTotalConfins += $parcela['vl_total_pago'] * ($dados['infoEmpreendimento'][0]['vl_aliquota_cofins']/100);
        }
        /*
         * Registro P001: Abertura do Bloco P - pagina 337
         */
        $regP001 = array(
            // 01 REG - Texto fixo contendo P001
            'P001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '1'
        );
        $conteudo = '|' . implode('|', $regP001) .'|'. chr(13) . chr(10);
        /*
         * Registro P990: Encerramento do Bloco P - pagina 337
         */
        $regP990 = array(
            // 01 REG - Texto fixo contendo P990
            'P990',
            // 02 QTD_LIN_P Quantidade total de linhas do Bloco P
            '2'
        );
        $conteudo .= '|' . implode('|', $regP990) .'|'. chr(13) . chr(10);
        /*
         * Registro 1001: Abertura do Bloco 1 - pagina 345
         */
        $reg1001 = array(
            // 01 REG - Texto fixo contendo 1001
            '1001',
            // 02 IND_MOV Indicador de movimento: 0 - Bloco com dados informados; 1 - Bloco sem dados informados
            '0'
        );
        $conteudo .= '|' . implode('|', $reg1001) .'|'. chr(13) . chr(10);
        /*
         * Registro 1900: Consolida??o dos Documentos Emitidos no Per?odo por Pessoa Jur?dica Submetida ao Regime de
         * Tributa??o com Base no Lucro Presumido Regime de Caixa ou de Compet?ncia - pagina 375
         */
        $reg1900 = array(
            // 01 REG - Texto fixo contendo 1900
            '1900',
            // 02 CNPJ CNPJ do estabelecimento da pessoa jur?dica, emitente dos documentos geradores de receita
            self::filtrarValor($dados['infoEmpreendimento'][0]['cnpJuridica'],14,'numero'),
            // 03 COD_MOD C?digo do modelo do documento fiscal conforme a Tabela 4.1.1, ou:
            // 98 - Nota Fiscal de Presta??o de Servi?os (ISSQN) 99 - Outros Documentos
            '99',
            // 04 SER S?rie do documento fiscal
            '',
            // 05 SUB_SER Subserie do documento fiscal
            '',
            // 06 COD_SIT C?digo da situa??o do documento fiscal: 00 - Documento regular 02 - Documento cancelado
            // 99 - Outros
            '00',
            // 07 VL_TOT_REC Valor total da receita, conforme os documentos emitidos no per?odo, representativos da
            // venda de bens e servi?os
            self::filtrarValor($vlTotalPago,0,'decimal'),
            // 08 QUANT_DOC Quantidade total de documentos emitidos no per?odo
            '',
            // 09 CST_PIS C?digo da Situa??o Tribut?ria do PIS/Pasep
            '01',
            // 10 CST_COFINS C?digo da Situa??o Tribut?ria da Cofins
            '01',
            // 11 CFOP C?digo fiscal de opera??o e presta??o
            '',
            // 12 INF_COMPL Informa??es complementares
            '',
            // 13 COD_CTA C?digo da conta anal?tica cont?bil representativa da receita
            '',
        );
        $conteudo .= '|' . implode('|', $reg1900) .'|'. chr(13) . chr(10);
        /*
         * Registro 1990: Encerramento do Bloco 1
         */
        $reg1990 = array(
            // 01 REG - Texto fixo contendo 1990
            '1990',
            // 02 QTD_LIN_P Quantidade total de linhas do Bloco P
            '3'
        );
        $conteudo .= '|' . implode('|', $reg1990) .'|'. chr(13) . chr(10);
        /*
         * Registro 9001: Abertura do Bloco 9 - pagina 379
         */
        $reg9001 = array(
            // 01 REG - Texto fixo contendo 9001
            '9001',
            // 02 IND_MOV Indicador de movimento: 0- Bloco com dados informados; 1- Bloco sem dados informados
            '0'
        );
        $conteudo .= '|' . implode('|', $reg9001) .'|'. chr(13) . chr(10);
        
        /*
         * Registro 9900: Registros do Arquivo - pagina 379
         */
        $reg9900 = array(
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '0000',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '0001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '0035',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            count($dados['infoEmpreendimento']),'' . chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '0100',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '0110',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '0140',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
        );
        
        //Caso no tenha filial, remove o modulo 0035 do da lista
        if (!$dados['filial'])
        {
            unset($reg9900[8]);
            unset($reg9900[9]);
            unset($reg9900[10]);
            unset($reg9900[11]);
        }

        $conteudo .= '|' . implode('|', $reg9900);

        $reg0500 = 0;
        if ($dados['infoEmpreendimento'][0]['fl_natureza_conta'] &&
            $dados['infoEmpreendimento'][0]['fl_tipo_conta'] &&
            $dados['infoEmpreendimento'][0]['nr_nivel_conta'] &&
            $dados['infoEmpreendimento'][0]['nr_codigo_conta'] &&
            $dados['infoEmpreendimento'][0]['ds_nome_conta'] &&
            $dados['infoEmpreendimento'][0]['nr_conta_receita']) {
            $reg9900 = array(
                // 01 REG - Texto fixo contendo 9900
                '9900',
                // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
                '0500',
                // QTD_REG_BLC Total de registros do tipo informado no campoanterior
                '1',''. chr(13) . chr(10),
            );
            $conteudo .= '|' . implode('|', $reg9900);
            $reg0500 = 1;
        }

        $totalRegistros9900 = $dados['infoEmpreendimento'][0]['cnpjFilial'] ? '37' : '36';

        $reg9900 = array(
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '0990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '1001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '1900',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '1990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '9001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '9990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '9999',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'A001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'A990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'C001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'C990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900            '9900',
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'D001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'D990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900            '9900',
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'F001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'F010',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'F200',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            count($dados['listaParcelas']),''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'F990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'I001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'I990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M200',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M205',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M210',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M600',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M605',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M610',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'M990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'P001',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            'P990',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            '1',''. chr(13) . chr(10),
            // 01 REG - Texto fixo contendo 9900
            '9900',
            // 02 REG_BLC Registro que ser? totalizado no pr?ximo campo
            '9900',
            // QTD_REG_BLC Total de registros do tipo informado no campoanterior
            $totalRegistros9900,
        );
        $conteudo .= '|' . implode('|', $reg9900) .'|'. chr(13) . chr(10);
        /*
         * Registro 9990: Encerramento do Bloco 9 - pag 379
         */
        $adicionaLinha0035Ao9990 = $dados['filial']?1:0;
        $reg9990 = array(
            // 01 REG - Texto fixo contendo 9990
            '9990',
            // 02 QTD_LIN_9 Quantidade total de linhas do Bloco 9.
            38 + $reg0500 + $adicionaLinha0035Ao9990
        );
        $conteudo .= '|' . implode('|', $reg9990) .'|'. chr(13) . chr(10);
        /*
         * Registro 9999: Encerramento do Arquivo Digital - pag 380
         */

        //Se tem filial adiciona a linha 0035 ao total
        $adicionaLinha0035AoTotal = $dados['filial']?count($dados['filial'])+1:0;
        $reg9999 = array(
            // 01 REG - Texto fixo contendo 9999
            '9999',
            // 02 QTD_LIN Quantidade total de linhas do arquivo digital.
            68 + count($dados['listaParcelas']) + ($reg0500*2) + $adicionaLinha0035AoTotal
        );
        $conteudo .= '|' . implode('|', $reg9999) .'|'. chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Gera arquivo sped para inclusao sem gravar registro no banco de dados
     * @param array $dados
     */
    public static function gerarSped($dados)
    {
        //Cria os diretorios para onde o arquivo vai ser gravado
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        if ($dados['post']['tipoGeracao'] == 'E') {
            $nmEmpreendimento = Helper::removeCaracteresEspeciaisSped($dados['infoEmpreendimento'][0]['nm_empreendimento']);
            $filename = self::filtrarValor($nmEmpreendimento,100,'texto').'_'.date('dmY_his').'.'.'txt';
        } else {
            $filename = 'SPED_'.date('dmY_his').'.'.'txt';
        }
        $spedPath = DIRETORIO_DOWNLOAD . "sped/";
        $filepath = $spedPath.'/'.$path;
        $pathAno = DIRETORIO_DOWNLOAD . "sped/" . $path . '/' . date('Y');

        if (is_dir($filepath)) {
            if (!is_dir($pathAno)) mkdir($pathAno);
        } else {
            mkdir($spedPath);
            mkdir($filepath);
            mkdir($pathAno);
        }

        $conteudo = self::gerarBlocos($dados);
        $retorno['erro'] = false;
        $retorno['msgErro'] = '';
        $retorno['path'] = $pathAno . '/' . $filename;
        if (!$handle = fopen($pathAno . '/' . $filename, 'w+')) {
            $retorno['msgErro'] = "No foi possvel abrir o arquivo ($filename)";
            $retorno['erro'] = true;
        } elseif (fwrite($handle, "$conteudo") === FALSE) {
            // Escreve $conteudo no nosso arquivo aberto.
            $retorno['msgErro'] = "No foi possvel escrever no arquivo ($filename)";
            $retorno['erro'] = true;
        }
        fclose($handle);
        return $retorno;
    }
}