<?php
/**
 * Created by PhpStorm.
 * User: usuario
 * Date: 31/10/19
 * Time: 10:11
 */

class ArquivoDimob extends Zend_Db_Table_Abstract
{
    protected $_name = TB_DIMOB;
    /**
     * Limita e trata as palavras e numeros para o formato dos campos
     * @param string $valor
     * @param integer $limite
     * @param string $tipoFiltro
     * @return string $valor
     */
    private static function filtrarValor($valor, $limite, $tipoFiltro = '')
    {
        if ($tipoFiltro == 'texto') {
            $valor = Helper::removeAcentos($valor);
            $valor = str_replace("_", " ", $valor);
            $valor = str_replace(array("-", ",", "."), "", $valor);
        }
        if ($tipoFiltro == 'numero') {
            $valor = Helper::apenasNumeros($valor);
        }
        if ($tipoFiltro == 'decimal') {
            if ($valor) {
                $valor = str_replace('.',',',number_format($valor, 2, ",", ""));
            } else {
                $valor = 0;
            }
        }
        if (strlen($valor) >= $limite && $limite > 0) {
            $valor = substr($valor, 0, $limite);
        }
        return $valor;
    }
    /**
     * Fun??o responsavel por gerar informa??es os todos blocos do arquivo SPED
     * @param array $dados
     * @return string $conteudo
     */
    public function gerarBlocos ($dados) {
        $conteudo = self::gerarBlocoHead();
        $conteudo .= self::gerarBlocoR01($dados);
        $conteudo .= self::gerarBlocoR03($dados);
        $conteudo .= self::gerarBlocoT9();
        return $conteudo;
    }

    //Mtodo responsvel por preencher o arquivo com os dados do cabealho do dimob
    public function gerarBlocoHead () {

        $conteudo = '';

        //Abertura do Arquivo Digital e Identificao da Pessoa Jurdica
        $regHead = array(
            //Fixo DIMOB
            str_pad('DIMOB', 374),
        );

        $conteudo .= '' . implode('', $regHead) . chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Funo responsavel por gerar informaes do Bloco R01 do DIMOB
     * BLOCO R01: Dados Iniciais. Neste registro so geradas as informaes da filial matriz.
     * @param array $dados
     * @return string $conteudo
     */
    public function gerarBlocoR01 ($dados) {

        $conteudo = '';
        $enderecoContribuinte = Helper::removeCaracteresEspeciaisSped($dados['infoEmpreendimento'][0]['enderecoContribuinte'].', '.$dados['infoEmpreendimento'][0]['complementoContribuinte'].', '.$dados['infoEmpreendimento'][0]['endNumeroContribuinte'].', '.$dados['infoEmpreendimento'][0]['bairroContribuinte']);
        //Cabealho do documento
        $regR01 = array(
            //Tipo: Constante "R01"
            'R01',
            //CNPJ do declarante
            self::filtrarValor($dados['infoEmpreendimento'][0]['nrCnpjPessoaJuridica'],14,'numero'),
            //Ano-Calendrio
            $_POST['anoRecebimento'],
            //Declarao Retificadora
            '0',
            //Nmero do Recibo
            str_pad(' ', 10),
            //Situao Especial
            str_pad('0', 1),
            //Data do Evento Situao Especial
            str_pad(' ', 8),
            //Cdigo da Situao especial
            '00',
            //Nome do Empresarial
            str_pad(self::filtrarValor(Helper::str2Upper($dados['infoEmpreendimento'][0]['nomeEmpresarial']), 60, 'texto'), 60),
            //CPF do responsvel pela pessoa jurdica perante  RFB
            $dados['infoEmpreendimento'][0]['cpfPessoaResponsavelRFB'] ? 
                self::filtrarValor($dados['infoEmpreendimento'][0]['cpfPessoaResponsavelRFB'], 11, 'numero') : 
                self::filtrarValor($dados['infoEmpreendimento'][0]['cpfContador'], 11, 'numero'),
            //Endereo completo do contribuinte
            //Helper::removeAcentosremove os acentos, primeiro argumento: string; segundo argumento: com/sem underline.
            //Helper::str2Upper muda os caracteres da string para maisculo.
            str_pad(self::filtrarValor(Helper::str2Upper(Helper::removeCaracteresEspeciaisSped($enderecoContribuinte, false)), 120), 120),
            //UF do contribuinte
            self::filtrarValor($dados['infoEmpreendimento'][0]['ufIbgePJ'], 2),
            //Cdigo do municpio do contribuinte
            self::filtrarValor($dados['infoEmpreendimento'][0]['cdIbgePJ'] ? $dados['infoEmpreendimento'][0]['cdIbgePJ'] : '0000', 4),
            //Reservado: Espaos em branco
            str_pad(' ', 20),
            //Reservado: Espaos em branco
            str_pad(' ', 10)
        );

        $conteudo .= '' . implode('', $regR01) . chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Funo responsavel por gerar informaes do Bloco R03 do DIMOB
     * Neste registro so apresentadas as informaes das operaes de construo,
     * incorporao e loteamento contratadas no ano de referncia.As informaes so
     * relativas a todos os imveis comercializados por pessoas jurdicas e equiparadas
     * que construrem, incorporarem e lotearem, mesmo que tenha havido a intermediao de terceiros.
     * Alm da construo de imveis por pessoas jurdicas constitudas para este fim em nome prprio,
     * de seus condminos ou scios.So exibidas todas as vendas independentemente de terem sido
     * efetuadas antes, durante ou aps a construo.
     * @return string $conteudo
     */
    public function gerarBlocoR03 ($dados) {

        $conteudo = '';
        $sequencialVenda = 1;
        foreach ($dados['listaParcelas'] as $parcela) {

            $vlPagoAno = self::filtrarValor($parcela['vl_total_pago_por_ano'] ? number_format($parcela['vl_total_pago_por_ano'], 2) : 0, 14, 'numero');
            $vlOperacao = self::filtrarValor($parcela['vlVenda'] ? number_format($parcela['vlVenda'], 2) : 0, 14, 'numero');
            $cep = $parcela['nr_cep'] ? str_replace('-','', $parcela['nr_cep']) : '00000000';
            $codMunicipio = self::filtrarValor($parcela['cdIbge'], 4, 'numero') ? self::filtrarValor($parcela['cdIbge'], 4, 'numero') : '0000';
            $regR03 = array(
                // Tipo: Constante "R03"
                'R03',
                // CNPJ do declarante
                self::filtrarValor($dados['infoEmpreendimento'][0]['nrCnpjPessoaJuridica'],14,'numero'),
                //Ano-calendrio - Ano do campo EdatIni da entrada do relatrio
                self::filtrarValor($_POST['anoRecebimento'],4,'number'),
                //Sequancial da venda
                str_repeat('0', 5 - (strlen($sequencialVenda))).''.$sequencialVenda,
                //CPF/CNPJ do Comprador
                str_pad(self::filtrarValor($parcela['nrCpf_nrCnpj'],14,'numero'), 14),
                //Nome/Nome empresarial do comprador
                //Helper::removeAcentosremove os acentos, primeiro argumento: string; segundo argumento: com/sem underline.
                //Helper::str2Upper muda os caracteres da string para maisculo.
                str_pad(Helper::str2Upper(Helper::removeCaracteresEspeciaisSped(self::filtrarValor($parcela['cliente'],60,'texto'), false)),60),
                //Nmero do contrato
                str_pad(self::filtrarValor($parcela['contrato'], '5', 'numero'), 6),
                //Data do contrato
                self::filtrarValor($parcela['dt_contrato'],8,'numero'),
                //Valor da operao
                str_repeat('0', 14 - (strlen($vlOperacao))).''.$vlOperacao,
                //Valor pago no ano
                str_repeat('0', 14 - (strlen($vlPagoAno))).''.$vlPagoAno,
                //Tipo do imvel
                'U',
                //Endereo do imvel
                //Helper::removeAcentosremove os acentos, primeiro argumento: string; segundo argumento: com/sem underline.
                //Helper::str2Upper muda os caracteres da string para maisculo.
                str_pad(self::filtrarValor('QD '.$parcela['quadra'].' LT '.$parcela['lote'].' EMPREENDIMENTO '.Helper::str2Upper(Helper::removeCaracteresEspeciaisSped($parcela['nm_empreendimento'], false)), 60, 'texto'), 60),
                //CEP
                self::filtrarValor($cep,8,'numero'),
                //Cdigo do municpio do imvel
                str_pad($codMunicipio, 24),
                //UF
                self::filtrarValor($parcela['ufIbge'], 2, 'texto'),
                //Reservado - Apenas espaos em branco
                str_pad('', 10),
            );
            $conteudo .= '' . implode('', $regR03) . chr(13) . chr(10);

            $sequencialVenda++;
        }
        
        return $conteudo;
    }
    /**
     * Funo responsavel por gerar as informaes finais do bloco DIMOB
     * @return string $conteudo
     */
    public function gerarBlocoT9 () {
        $conteudo = '';

        $regT9 = array(
            //Texto fixo contendo T9
            'T9',
            //CNPJ do declarante
            str_pad(' ', 100),
        );

        $conteudo .= '' . implode('', $regT9) . chr(13) . chr(10);
        return $conteudo;
    }
    /**
     * Gera arquivo dimob para inclusao sem gravar registro no banco de dados
     * @param array $dados
     */
    public static function gerarDimob ($dados)
    {
        //Cria os diretorios para onde o arquivo vai ser gravado
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        if ($dados['post']['tipoGeracao'] == 'E') {
            $nmEmpreendimento=  Helper::removeCaracteresEspeciaisSped($dados['infoEmpreendimento'][0]['nm_empreendimento']);
            $filename = self::filtrarValor($nmEmpreendimento,100,'texto').'_'.date('dmY_his').'.'.'txt';
        } else {
            $filename = 'DIMOB_'.date('dmY_his').'.'.'txt';
        }
        $dimobPath = DIRETORIO_DOWNLOAD . "dimob/";
        $filepath = $dimobPath.'/'.$path;
        $pathAno = DIRETORIO_DOWNLOAD . "dimob/" . $path . '/' . date('Y');
        if (is_dir($filepath)) {
            if (!is_dir($pathAno)) mkdir($pathAno);
        } else {
            mkdir($dimobPath);
            mkdir($filepath);
            mkdir($pathAno);
        }

        $conteudo = self::gerarBlocos($dados);
        $retorno['erro'] = false;
        $retorno['msgErro'] = '';
        $retorno['path'] = $pathAno . '/' . $filename;
        if (!$handle = fopen($pathAno . '/' . $filename, 'w+')) {
            $retorno['msgErro'] = "No foi possvel abrir o arquivo ($filename)";
            $retorno['erro'] = true;
        } elseif (fwrite($handle, "$conteudo") === FALSE) {
            // Escreve $conteudo no nosso arquivo aberto.
            $retorno['msgErro'] = "No foi possvel escrever no arquivo ($filename)";
            $retorno['erro'] = true;
        }
        fclose($handle);
        return $retorno;
    }
}