<?php
require 'vendor/guzzlehttp/guzzle/src/functions.php';
require 'vendor/guzzlehttp/psr7/src/functions.php';
require 'vendor/guzzlehttp/promises/src/functions.php';

use GuzzleHttp\Psr7;

class API
{
    public static function geraBoletos($uri,$uri_param,$dados,$tipoheader,$gerar_token,$pp_token,$password,$dados_body,$cliente_id,$gerar_cliente)
    {

        $client = new \GuzzleHttp\Client();
        /**
         * Integra??o com API que necessita te token tempor?rio para gerar a autentica??o junto ao servidor
         * Desenvolvido por: Jonathan Luiz - Outubro/2021
         */


        if (($gerar_token)){
            $response = $client->post(''.$gerar_token.'?pp_token='.$pp_token.'&password='.$password.'');
            //  echo $response->getBody(); // '{"id": 1420053, "name": "guzzle", ...}'
            $body = $response->getBody();
            $string = explode('":"',$body);
            $token = str_replace('"','',$string[1]);
        }

        /**
         * Caso a API requeira um token de valida??o / algum argumento extra na URI
         */
        //Condi??o se o tipo do Header for MULTIPART/FORM_DATA

        if  ($tipoheader = 'MULTIPART'){

            for ($i = 0; $i < count($dados_body); $i++) {
                $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                $valor=explode(".",$posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista


                if (strpos($expressao2[0], 'boletovencimento') !== false) {
                    $array=[['name' => $valor[1],'contents' => '' . $dados['dt_parcela'] . '']];
                }
                if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                    $array[]=['name' => $valor[1],'contents' => ''. $dados['vl_parcela'].''];
                }
                if (strpos($expressao2[0], 'boletoctexterno') !== false) {
                    $array[]=['name' => $valor[1],'contents' => ''. $dados['id_parcela_contrato'].''];
                }
                if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                    $array[]=['name' => $valor[1],'contents' => '' . $dados['nr_cpf'] . ''];
                }
                if (strpos($expressao2[0], 'boletodtnascimento') !== false) {
                    $array[]=['name' => $valor[1],'contents' => '' . $dados['dt_nascimento'] . ''];
                }
            }

            if ($gerar_token) {
                try{
                    $response = $client->request('POST', '' . $uri .'?token='.$token.'', ['multipart' => $array]);
                    $body = $response->getBody();
                    return $body;
                }catch (RequestException  $e) {
                    if ($e->hasResponse()){
                        if ($e->getResponse()->getStatusCode() == '400') {
                            $response = $e->getResponse();
                            $retorno =  $response->getBody()->getContents();
                            $retornoPost2 = '400';
                            return $retorno;
                        }
                    }

                }

            }else {
                try{
                    $response = $client->request('POST', '' . $uri . '', ['multipart' => $array]);
                    $body = $response->getBody();
                    return $body;
                }catch (RequestException  $e) {
                    if ($e->hasResponse()){
                        if ($e->getResponse()->getStatusCode() == '400') {
                            $response = $e->getResponse();
                            $retorno =  $response->getBody()->getContents();
                            $retornoPost2 = '400';
                            return $retorno;
                        }
                    }

                }

            }
        }
        if ($tipoheader = 'JSON') {
            if ($cliente_id) {
                //N?o faz nada. Pega o ID que acabou de ser gerado via API eenvia para ser gerado o boleto.
            } else {
                $cliente_id = $dados['id_pessoa_api_asaas'];
            }

            // Gera as parcelas do carn?. Caso n?o atenda o IF gera o boleto ?nico
            if (strpos($dados['tipo'], '1') !== false) {

                for ($i = 0; $i < count($dados_body); $i++) {
                    $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                    $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                    $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                    $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista
                    // var_dump($$cliente_id.'-'.$dados['vl_parcela']);exit;

                    $array_json['billingType'] = 'BOLETO';

                    if (strpos($expressao2[0], 'boletoclienteid') !== false) {
                        $array_json[$valor[1]] = '' . $cliente_id . '';
                    }
                    if (strpos($expressao2[0], 'boletovencimento') !== false) {
                        $array_json[$valor[1]] = '' . $dados['dt_parcela'] . '';
                    }
                    if (strpos($expressao2[0], 'boletovalortotalparcelamento') !== false) {
                        $array_json[$valor[1]] = '' . $dados['vl_parcela']  . '';
                    }

                }
                if ($uri_param) {
                    // try {
                    $response = $client->request('POST', '' . $uri . '', [
                        'headers' => ['access_token' => $uri_param, 'Content-Type' => 'application/json'],
                        'json' => [$array_json],
                    ]);
                    return $response->getBody();

                } else {
                    // try {
                    $response = $client->request('POST', '' . $uri . '', [
                        'json' => [$array],
                    ]);
                    //$response = $client->request('POST', ''.$uri.'', $array2);
                    return $response->getBody();

                }

            }else{

                for ($i = 0; $i < count($dados_body); $i++) {
                    $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                    $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                    $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                    $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista


                    $array_json['billingType'] = 'BOLETO';

                    if (strpos($expressao2[0], 'boletoclienteid') !== false) {
                        $array_json[$valor[1]] = '' . $cliente_id . '';
                    }
                    if (strpos($expressao2[0], 'boletovencimento') !== false) {
                        $array_json[$valor[1]] = '' . $dados['dt_parcela'] . '';
                    }
                    if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                        $array_json[$valor[1]] = '' . $dados['vl_parcela'] . '';
                    }
                }

                if ($uri_param) {
                    // try {
                    $response = $client->request('POST', '' . $uri . '', [
                        'headers' => ['access_token' => $uri_param, 'Content-Type' => 'application/json'],
                        'json' => [$array_json],
                    ]);
                    return $response->getBody();
                    /*  } catch (RequestException  $e) {
                          if ($e->hasResponse()) {
                              if ($e->getResponse()->getStatusCode() == '') {
                                  $response = $e->getResponse();
                                  $retorno = $response->getBody()->getContents();
                                  $retornoPost2 = '400';
                                  echo $retorno;
                              }
                          }

                      }*/
                } else {
                    try {
                        $response = $client->request('POST', '' . $uri . '', [
                            'json' => [$array],
                        ]);
                        //$response = $client->request('POST', ''.$uri.'', $array2);
                        return $response->getBody();
                    } catch (RequestException  $e) {
                        if ($e->hasResponse()) {
                            if ($e->getResponse()->getStatusCode() <> '') {
                                $response = $e->getResponse();
                                $retorno = $response->getBody()->getContents();
                                $retornoPost2 = '400';
                                return $retorno;
                            }
                        }

                    }
                }
            }
        }
    }
    public static function geraCliente($uri,$uri_param,$dados,$tipoheader,$gerar_token,$pp_token,$password,$dados_body,$req_cliente_id,$gerar_cliente)
    {

        $client = new \GuzzleHttp\Client(array(
            'allow_redirects' => false,
            'request.options' => array('exceptions' => false)));
        /**
         * Integra??o com API que necessita te token tempor?rio para gerar a autentica??o junto ao servidor
         * Desenvolvido por: Jonathan Luiz - Outubro/2021
         */

        if (($gerar_token)) {
            $response = $client->post('' . $gerar_token . '?pp_token=' . $pp_token . '&password=' . $password . '');
            //  echo $response->getBody(); // '{"id": 1420053, "name": "guzzle", ...}'
            $body = $response->getBody();
            $string = explode('":"', $body);
            $token = str_replace('"', '', $string[1]);
        }


        /**
         * Caso a API requeira um token de valida??o / algum argumento extra na URI
         *///Condi??o se o tipo do Header for MULTIPART
        ;


        if ($tipoheader = 'MULTIPART') {

            if (strpos($dados['tipo'], '1') !== false) {
                $array[] = ['name' => 'carne[parcelas]', 'contents' => '' . $dados['qtd_parcelas'] . ''];
                $valor_total = ($dados['qtd_parcelas']) * ($dados['valor']) ;
                for ($i = 0; $i < count($dados_body); $i++) {
                    $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                    $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                    $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                    $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista



                        if (strpos($expressao2[0], 'boletovencimento') !== false) {
                            // $data_n = str_replace("/", "-", $dados['data']);
                            // $dt_vencimento = date("Y-m-d", strtotime($data_n));
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['data'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $valor_total . ''];
                        }
                        if (strpos($expressao2[0], 'boletoctexterno') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => 'rec_' . $dados['id'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['nr_cpf'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletodtnascimento') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['dt_nascimento'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletoinstrucoes') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '"' . $instrucoes . '"'];
                        }
                }
            }else{
                for ($i = 0; $i < count($dados_body); $i++) {
                    $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                    $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                    $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                    $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista


                        if (strpos($expressao2[0], 'boletovencimento') !== false) {
                            // $data_n = str_replace("/", "-", $dados['data']);
                            // $dt_vencimento = date("Y-m-d", strtotime($data_n));
                            $array = [['name' => $valor[1], 'contents' => '' . $dados['data'] . '']];
                        }
                        if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['valor'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletoctexterno') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => 'rec_' . $dados['id'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['nr_cpf'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletodtnascimento') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['dt_nascimento'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletoinstrucoes') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $instrucoes . ''];
                        }
                    }


            }


            if ($gerar_token) {
                try {
                    $response = $client->request('POST', '' . $uri . '?token=' . $token . '', ['multipart' => $array]);
                    $body = $response->getBody();
                    return $body;

                } catch (RequestException  $e) {
                    if ($e->hasResponse()){
                        if ($e->getResponse()->getStatusCode() == '400') {
                            $response = $e->getResponse();
                            $retorno =  $response->getBody()->getContents();
                            $retornoPost2 = '400';
                            return $retorno;
                        }
                    }

                }
            } else {
                try {
                    $response = $client->request('POST', '' . $uri . $uri_param . '', ['multipart' => $array]);
                    $body = $response->getBody();
                    return $body;
                }catch (RequestException  $e) {
                    $responseBody = $e->getResponse()->getBody(true);
                    $exception = json_decode($responseBody);
                }
            }

        }
        if   ($tipoheader = 'JSON') {
            for ($i = 0; $i < count($dados_body); $i++) {
                $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista


                if (strpos($expressao2[0], 'boletonomecliente') !== false) {
                    $array_json[$valor[1]] = '' . $dados['nm_pessoa'] . '';
                }
                if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                    $array_json[$valor[1]] = '' . $dados['nr_cpf'] . '';
                }

            }
            if ($uri_param) {
                $response = $client->request('POST', '' . $gerar_cliente . '', [
                    'headers' => ['access_token' => $uri_param, 'Content-Type' => 'application/json'],
                    'json' => [$array_json],
                ]);
                return $response->getBody();
            } else {
                $response = $client->request('POST', '' . $gerar_cliente . '', [
                    'json' => [$array_json],
                ]);
                //$response = $client->request('POST', ''.$uri.'', $array2);
                return $response->getBody();
            }

        } 


                if ($uri_param) {
                    // try {
                    $response = $client->request('POST', '' . $uri . '', [
                        'headers' => ['access_token' => $uri_param, 'Content-Type' => 'application/json'],
                        'json' => [$array_json],
                    ]);
                    return $response->getBody();
                    /*  } catch (RequestException  $e) {
                          if ($e->hasResponse()) {
                              if ($e->getResponse()->getStatusCode() == '') {
                                  $response = $e->getResponse();
                                  $retorno = $response->getBody()->getContents();
                                  $retornoPost2 = '400';
                                  echo $retorno;
                              }
                          }

                      }*/
                } else {
                    try {
                        $response = $client->request('POST', '' . $uri . '', [
                            'json' => [$array],
                        ]);
                        //$response = $client->request('POST', ''.$uri.'', $array2);
                        return $response->getBody();
                    } catch (RequestException  $e) {
                        if ($e->hasResponse()) {
                            if ($e->getResponse()->getStatusCode() <> '') {
                                $response = $e->getResponse();
                                $retorno = $response->getBody()->getContents();
                                $retornoPost2 = '400';
                                return $retorno;
                            }
                        }

                    }
                }
            }
    public static function geraCliente1($uri,$uri_param,$dados,$tipoheader,$gerar_token,$pp_token,$password,$dados_body,$req_cliente_id,$gerar_cliente)
    {

        $client = new \GuzzleHttp\Client(array(
            'allow_redirects' => false,
            'request.options' => array('exceptions' => false)));
        /**
         * Integra??o com API que necessita te token tempor?rio para gerar a autentica??o junto ao servidor
         * Desenvolvido por: Jonathan Luiz - Outubro/2021
         */
        //var_dump($uri);


        if (($gerar_token)) {
            $response = $client->post('' . $gerar_token . '?pp_token=' . $pp_token . '&password=' . $password . '');
            //  echo $response->getBody(); // '{"id": 1420053, "name": "guzzle", ...}'
            $body = $response->getBody();
            $string = explode('":"', $body);
            $token = str_replace('"', '', $string[1]);
        }


        /**
         * Caso a API requeira um token de valida??o / algum argumento extra na URI
         *///Condi??o se o tipo do Header for MULTIPART
        ;


        if ($tipoheader = 'MULTIPART') {

            if (strpos($dados['tipo'], '1') !== false) {
                $array[] = ['name' => 'carne[parcelas]', 'contents' => '' . $dados['qtd_parcelas'] . ''];
                $valor_total = ($dados['qtd_parcelas']) * ($dados['valor']) ;
                for ($i = 0; $i < count($dados_body); $i++) {
                    $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                    $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                    $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                    $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista

                    //Caso o doador seja an?nimo
                    if ($cpfa) {
                        //Se o numero de boletos for maior do que 1 inicia o array com o n?mero de parcelas

                        if (strpos($expressao2[0], 'boletovencimento') !== false) {

                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['data'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $valor_total . ''];
                        }
                        if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $cpfa . ''];
                        }
                        if (strpos($expressao2[0], 'boletodtnascimento') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dtnasca . ''];
                        }
                        if (strpos($expressao2[0], 'boletoinstrucoes') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '"' . $instrucoes . '"'];
                        }

                    } else {

                        if (strpos($expressao2[0], 'boletovencimento') !== false) {
                            // $data_n = str_replace("/", "-", $dados['data']);
                            // $dt_vencimento = date("Y-m-d", strtotime($data_n));
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['data'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $valor_total . ''];
                        }
                        if (strpos($expressao2[0], 'boletoctexterno') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => 'rec_' . $dados['id'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['nr_cpf'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletodtnascimento') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['dt_nascimento'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletoinstrucoes') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '"' . $instrucoes . '"'];
                        }
                    }
                }
            }else{
                for ($i = 0; $i < count($dados_body); $i++) {
                    $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                    $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                    $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                    $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista


                    //Caso o doador seja an?nimo
                    if ($cpfa) {
                        //Se o numero de boletos for maior do que 1 inicia o array com o n?mero de parcelas

                        if (strpos($expressao2[0], 'boletovencimento') !== false) {

                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['data'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['valor'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $cpfa . ''];
                        }
                        if (strpos($expressao2[0], 'boletodtnascimento') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dtnasca . ''];
                        }
                        if (strpos($expressao2[0], 'boletoinstrucoes') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '"' . $instrucoes . '"'];
                        }

                    }else {

                        if (strpos($expressao2[0], 'boletovencimento') !== false) {
                            // $data_n = str_replace("/", "-", $dados['data']);
                            // $dt_vencimento = date("Y-m-d", strtotime($data_n));
                            $array = [['name' => $valor[1], 'contents' => '' . $dados['data'] . '']];
                        }
                        if (strpos($expressao2[0], 'boletovalortotal') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['valor'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletoctexterno') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => 'rec_' . $dados['id'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['nr_cpf'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletodtnascimento') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $dados['dt_nascimento'] . ''];
                        }
                        if (strpos($expressao2[0], 'boletoinstrucoes') !== false) {
                            $array[] = ['name' => $valor[1], 'contents' => '' . $instrucoes . ''];
                        }
                    }
                }

            }


            if ($gerar_token) {
                try {
                    $response = $client->request('POST', '' . $uri . '?token=' . $token . '', ['multipart' => $array]);
                    $body = $response->getBody();
                    return $body;

                } catch (RequestException  $e) {
                    if ($e->hasResponse()){
                        if ($e->getResponse()->getStatusCode() == '400') {
                            $response = $e->getResponse();
                            $retorno =  $response->getBody()->getContents();
                            $retornoPost2 = '400';
                            return $retorno;
                        }
                    }

                }
            } else {
                try {
                    $response = $client->request('POST', '' . $uri . $uri_param . '', ['multipart' => $array]);
                    $body = $response->getBody();
                    return $body;
                }catch (RequestException  $e) {
                    $responseBody = $e->getResponse()->getBody(true);
                    $exception = json_decode($responseBody);
                }
            }

        }
        if   ($tipoheader = 'JSON') {
            for ($i = 0; $i < count($dados_body); $i++) {
                $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
                $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
                $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
                $valor = explode(".", $posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista


                if (strpos($expressao2[0], 'boletonomecliente') !== false) {
                    $array_json[$valor[1]] = '' . $dados['nm_pessoa'] . '';
                }
                if (strpos($expressao2[0], 'boletonrcpf') !== false) {
                    $array_json[$valor[1]] = '' . $dados['nr_cpf'] . '';
                }

            }
            if ($uri_param) {
                $response = $client->request('POST', '' . $gerar_cliente . '', [
                    'headers' => ['access_token' => $uri_param, 'Content-Type' => 'application/json'],
                    'json' => [$array_json],
                ]);
                return $response->getBody();
            } else {
                $response = $client->request('POST', '' . $gerar_cliente . '', [
                    'json' => [$array_json],
                ]);
                //$response = $client->request('POST', ''.$uri.'', $array2);
                return $response->getBody();
            }

        }
    }
    public static function listaBoletos ($uri,$uri_param,$gerar_token,$pp_token,$password,$cod_boleto) {
        $client = new \GuzzleHttp\Client();
        /**
         * Integra??o com API que necessita te token tempor?rio para gerar a autentica??o junto ao servidor
         * Desenvolvido por: Jonathan Luiz - Outubro/2021
         */
        if (($gerar_token)){
            $response = $client->post(''.$gerar_token.'?pp_token='.$pp_token.'&password='.$password.'');
            //  echo $response->getBody(); // '{"id": 1420053, "name": "guzzle", ...}'
            $body = $response->getBody();
            $string = explode('":"',$body);
            $token = str_replace('"','',$string[1]);
        }
        /**
         * Caso a API requeira um token de valida??o / algum argumento extra na URI
         */
        if ($gerar_token) {
            $response = $client->request('GET', '' . $uri .'', [
                //Informa o c?digo id_parcela_contrato da tabela parcelas para pesquisar o boleto.
                'query' => [
                    'token'=>''.$token.'',
                    'filtrar_boleto_controle_externo' =>''.$cod_boleto.''
                ]
            ]);
        }else {
            $response = $client->request('GET', '' . $uri . '', [
                'query' => [
                    'filtrar_boleto_controle_externo' =>''.$cod_boleto.''
                ]
            ]);

        }
        $body = $response->getBody();
        return $body;

    }

    public static function listaBoletos2($uri,$uri_param,$gerar_token,$pp_token,$password,$cod_boleto,$cod_barras,$dados_body,$boleto_id) {

        $client = new \GuzzleHttp\Client();

        if (($gerar_token)){
            $response = $client->post(''.$gerar_token.'?pp_token='.$pp_token.'&password='.$password.'');
            $body = $response->getBody();
            $string = explode('":"',$body);
            $token = str_replace('"','',$string[1]);
        }

        for ($i = 0; $i < count($dados_body); $i++) {
            $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
            $valor=explode(".",$posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista

            if (strpos($expressao2[0], 'filtrar_cod_externo') !== false) {
                $array=[[$valor[1] => $cod_boleto]];
            }
            if (strpos($expressao2[0], 'ordenar_boleto_created') !== false) {
                $array[]=[$valor[1] => '1'];
            }
            if (strpos($expressao2[0], 'itens_por_pagina') !== false) {
                $array[]=[$valor[1] => '1'];
            }
        }
        if ($gerar_token) {
            $response = $client->request('GET', '' . $uri .'', [
                //Informa o c?digo id_parcela_contrato da tabela parcelas para pesquisar o boleto.
                'query' => [
                    'token'=>''.$token.'',
                    $array

                ]
            ]);
        }else {
            $response = $client->request('GET', '' . $uri . '', [
                'query' => [
                    $array

                ]
            ]);

        }
        $body = $response->getBody();
        return $body;

    }

    public static function listaBoletosPagos ($uri,$uri_param,$gerar_token,$pp_token,$password,$cod_boleto,$cod_barras,$dados_body,$boleto_id,$tipo_layout) {
        $client = new \GuzzleHttp\Client();

        if (($gerar_token)){
            $response = $client->post(''.$gerar_token.'?pp_token='.$pp_token.'&password='.$password.'');
            $body = $response->getBody();
            $string = explode('":"',$body);
            $token = str_replace('"','',$string[1]);
        }


        for ($i = 0; $i < count($dados_body); $i++) {
            $expressao2 = explode(":", $dados_body[$i]); //Quebra a express?o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express?o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express?o novamente pegando a coluna final e o preenchimento
            $valor=explode(".",$posicaof[1]); //Quebra a express?o novamente pegando o valor definido caso exista

            if (strpos($expressao2[0], 'filtrar_boleto_id') !== false) {
                $array[]=[$valor[1] => $boleto_id];
            }
            if (strpos($expressao2[0], 'itens_por_pagina') !== false) {
                $array[] = ['name' => 'itens_por_pagina', 'contents' => '1'];
            }
        }

        if($tipo_layout === 'APIASAAS'){
            if ($uri_param) {
                $response = $client->request('GET', '' . $uri .$boleto_id. '', [
                    'headers' => ['access_token' => $uri_param, 'Content-Type' => 'application/json'],
                    //'json' => [$array_json],
                ]);
                return $response->getBody();
            } else {
                $response = $client->request('POST', '' . $uri .$boleto_id. '', [
                    //  'json' => [$array_json],
                ]);
                //$response = $client->request('POST', ''.$uri.'', $array2);
                return $response->getBody();
            }
        }else {
            if ($gerar_token) {

                $response = $client->request('GET', '' . $uri . '', [
                    //Informa o c?digo id_parcela_contrato da tabela parcelas para pesquisar o boleto.
                    'query' => [
                        'token' => '' . $token . '',
                        'filtrar_boleto_id' => '' . $boleto_id . ''
                    ]
                ]);
            } else {
                $response = $client->request('GET', $uri, [
                    'query' => [
                        'filtrar_boleto_id' => '' . $boleto_id . ''
                    ]
                ]);

            }

            $body = $response->getBody();
            return $body;
        }

    }

}