<?php
class ACL extends Zend_Db_Table_Abstract {


    public static function hasPermission($usuario, $action) {
        $tb_usuario = new Db_Usuario();
        if(!$usuario instanceof Db_Usuario) $usuario = $tb_usuario->find($usuario);
        if($usuario->getSuper() == '1') return true;
        $perfil = Db_Perfil::find($usuario->getPerfilId());
        return (Db_ACL::find($perfil,$action) instanceof Db_ACL);
    }

    public static function verificaPerfilAcesso($idPerfil) {

        $acl = self::getDefaultAdapter()->select()
            ->from(array('acl' => TB_ACL), '*')
            ->join(array('ac' => TB_ACTION), 'acl.actionId = ac.id', '')
            ->join(array('c' => TB_CONTROLLER), 'ac.controllerId = c.id', '')
            ->where('acl.perfilId = ?', $idPerfil)
            ->where('c.fl_painel_venda = ?', '0')
            ->where('c.fl_acade_ged = ?', '0')
            ->where('c.fl_exibir_menu = ?', '1')
            ->where('c.moduloId != ?', '1')
            ->query()->fetchAll();

        return $acl;
    }
}