<?php

class Helper
{

    private $mensagem;

    static $DIAS = array("Domingo", "Segunda", "Tera", "Quarta", "Quinta", "Sexta", "Sbado");
    static $MESES = array("01" => "Janeiro", "02" => "Fevereiro",
        "03" => "Maro", "04" => "Abril",
        "05" => "Maio", "06" => "Junho",
        "07" => "Julho", "08" => "Agosto",
        "09" => "Setembro", "10" => "Outubro",
        "11" => "Novembro", "12" => "Dezembro");

    public function __construct()
    {
        $this->mensagem = array();
    }

    public static function calculaPorcentagem($qtdMesAtual, $qtdMesAnterior) {

        $total = ($qtdMesAnterior * 100) / $qtdMesAtual;

        if ($total < 100) {
            $total = 100 - $total;
            $total = number_format($total, 2, '.', '');
            $aviso = 'maior que o ms anterior';

            return array('qtdMesAtual' => $qtdMesAtual,
                'total' => $total,
                'aviso' => $aviso,
                'seta' => '1');

        } else if ($total > 100) {
            $total -= 100;
            $total = number_format($total, 2, '.', '');
            $aviso = 'menor que o ms anterior';

            return array('qtdMesAtual' => $qtdMesAtual,
                'total' => $total,
                'aviso' => $aviso,
                'seta' => '0');
        } else {

            return array('qtdMesAtual' => $qtdMesAtual, 'total' => 0, 'aviso' => 'Quantidade igual ao ms anterior');
        }
    }

    public static function filtraPorUsuario($query) {

        $query_clone = clone $query;
        $query = $query->query()->fetchAll();

        if ($_SESSION['usuario']->getSuper() != '1') {
            $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
            $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
            if ($ids) {
                $id = implode(',', $ids);
                $query = $query_clone->where("e.id IN({$id})")->query()->fetchAll();
            }
        } 

        return $query;
    }

    public static function getNextMonth($data, $level = 1, $monthInc = true)
    {
        $data = explode('-', $data);
        $data['year'] = (int)$data[0];
        $data['month'] = (int)$data[1];
        $data['day'] = (int)$data[2];

        if (!$data['year'] || !$data['month'] || !$data['day'])
            return false;

        if ($monthInc)
            $data['month'] = $data['month'] + $level;
        while ($data['month'] > 12) {
            $data['month'] = $data['month'] - 12;
            $data['year'] = $data['year'] + 1;
        }

        if (checkdate($data['month'], $data['day'], $data['year'])) {
            $month = str_pad($data['month'], 2, '0', STR_PAD_LEFT);
            $day = str_pad($data['day'], 2, '0', STR_PAD_LEFT);
            $year = str_pad($data['year'], 2, '0', STR_PAD_LEFT);
            return $year . '-' . $month . '-' . $day;
        } else {
            $data['day'] = $data['day'] - 1;
            $d = $data['year'] . '-' . $data['month'] . '-' . $data['day'];
            return self::getNextMonth($d, $level, false);
        }
    }

    public static function getNomePeriodo($sigla)
    {
        switch ($sigla) {
            case 'A':
                $periodo = 'Anual';
                break;
            case 'AM':
                $periodo = 'Anual+Mensal';
                break;
            case 'M':
                $periodo = 'Mensal';
                break;
            case 'S':
                $periodo = 'Semestral';
                break;
            case 'T':
                $periodo = 'Trimestral';
                break;
            case 'B':
                $periodo = 'Bimestral';
                break;
            default:
                $periodo = '';
                break;
        }
        return $periodo;
    }
    public static function my_file_get_contents( $site_url ){
        $ch = curl_init();
        $timeout = 5; // set to zero for no timeout
        curl_setopt ($ch, CURLOPT_URL, $site_url);
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        ob_start();
        curl_exec($ch);
        curl_close($ch);
        $file_contents = ob_get_contents();
        ob_end_clean();
        return $file_contents;
    }
    public static function formataDataBoleto($data)
    {
        if (trim($data) != '' && (int)$data != '0') {
            return substr($data, 0, 2) . '/' . substr($data, 2, 2) . '/' . substr($data, 4, 4);
        } else {
            return '';
        }
    }

    public static function formataHora($hora)
    {
        if (trim($hora) != '' && (int)$hora != '0') {
            return substr($hora, 0, 2) . ':' . substr($hora, 2, 2) . ':' . substr($hora, 4, 2);
        } else {
            return '';
        }
    }

    /**
     * Ordena o array de contratos ou lotes em quadra e lote
     * @param $array
     * @return mixed
     */
    public static function sortQuadraLote($array)
    {
        // Compara se $a � maior que $b
        function cmp($a, $b)
        {
            if ($a['quadra'] == $b['quadra']) {
                return ($a['lote'] < $b['lote']) ? -1 : 1;
            }
            return ($a['quadra'] < $b['quadra']) ? -1 : 1;
        }

        usort($array, 'cmp');

        return $array;
    }

    public static function dataParaBrasil($d)
    {
        $data = new Zend_Date($d);
        $data->setLocale('pt_BR');
        return $data->get('dd/MM/y');
    }

    //Exibe a data por extenso
    public static function dataExtenso($data = 'today')
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        return strftime('%d de %B de %Y', strtotime($data));
    }

    function dataPorExtenso($data) 
    {
        $meses = [
            '01' => 'Janeiro', '02' => 'Fevereiro', '03' => 'Maro',
            '04' => 'Abril',   '05' => 'Maio',      '06' => 'Junho',
            '07' => 'Julho',   '08' => 'Agosto',    '09' => 'Setembro',
            '10' => 'Outubro', '11' => 'Novembro',  '12' => 'Dezembro'
        ];
    
        list($d, $m, $y) = explode('/', $data);
        return "$d de " . utf8_encode($meses[$m]) . " de $y";
    }

    public static function dataParaAmericano($d)
    {
        $data = new Zend_Date($d);
        $data->setLocale('en_US');
        return $data->get('yyyy-MM-dd');
    }

    public static function getDia($k)
    {
        return self::$DIAS[$k];
    }

    public static function getMes($k)
    {
        return self::$MESES[$k];
    }

    public function getLink(array $param = array())
    {
        $url = "?";
        $vars = array();
        foreach ($param as $k => $v)
            $vars[] = "{$k}={$v}";
        return $url . implode("&", $vars);
    }

    public function getMensagem($k)
    {
        if (array_key_exists($k, $this->mensagem))
            return $this->mensagem[$k];
    }

    public function addMensagem($k, $v)
    {
        $this->mensagem[$k] = $v;
    }

    public function removerMensagem($k)
    {
        unset($this->mensagem[$k]);
    }

    public function getMensagens()
    {
        return $this->mensagem;
    }

    public static function getDate($data, $flagHora = true)
    {
        $dt = null;
        if ($data) {
            $hora = "";
            $data_br = explode("-", $data);
            if (strpos($data_br[2], " ") && $flagHora) {
                $hora = explode(" ", $data_br[2]);
                $data_br[2] = $hora[0];
                $hora = " " . $hora[1];
            } else {
                $hora = explode(" ", $data_br[2]);
                $data_br[2] = $hora[0];
                $hora = "";
            }
            $dt = $data_br[2] . "/" . $data_br[1] . "/" . $data_br[0] . $hora;
        }
        return $dt;
    }

    public static function dateIsValid($date)
    {
        $date = date_parse($date);
        return checkdate($date['month'], $date['day'], $date['year']);
    }

    public static function getInputDate($data)
    {
        $data_br = explode("/", $data);
        return (count($data_br) > 1) ? $data_br[2] . "-" . $data_br[1] . "-" . $data_br[0] : $data;
    }

    /**
     * Trata as datas enviadas pela API do PHPExcel, transformando em formato americano
     * @param $d
     * @return string
     */
    public static function dataAbreviadaFromExcel($d)
    {
        if ($d != '') {
            if (count(explode('/', $d)) > 1) {
                $ret = self::dataParaAmericano($d);
            } else {
                $data = explode('-', $d);
                if (strlen($data[2]) == 2) {
                    if ((int)$data[2] <= 50)
                        $data[2] = '20' . $data[2];
                    else
                        $data[2] = '19' . $data[2];
                }

                $ret = $data[2] . '-' . $data[0] . '-' . $data[1];
            }
        } else {
            $ret = '';
        }
        return $ret;
    }

    public static function formatoReal($valor)
    {
        $valor = (string)$valor;
        $regra = "/^[0-9,-]{1,3}([.]([0-9]{3}))*[,]([.]{0})[0-9]{0,4}$/";
        if (preg_match($regra, $valor)) {
            return true;
        } else {
            return false;
        }
    }

    public static function getInputMoney($money)
    {
        $money = str_replace("R$ ", "", $money);
        $money = str_replace(".", "", $money);
        $money = str_replace(",", ".", $money);
        return $money;
    }

    public static function getInputMoney2($money)
    {
        $money = str_replace("R$ ", ",", $money);
        $money = str_replace(".", ",", $money);
        $money = str_replace(",", ".", $money);
        return $money;
    }

    public static function getMoney($money, $precisao = 2, $naoGerarZero = null)
    {
        if ($naoGerarZero) {
            if ($money == '' || $money == '0,00' || $money == null || $money == '0' || $money == 0) {
                return '';
            }
        }
        $money = (float)$money;
        $retorno = number_format($money, $precisao, ",", ".");
        if ($retorno == '-0,00') {
            return number_format(0, $precisao, ",", ".");
        } else {
            return $retorno;
        }
    }

    /*
     * Retorna os valores em float
     */
    public static function parseFloat($number)
    {

        if (!$number || $number == '') {
            return 0;
        }
        /*
         * Se o numero tiver ponto e virgula
         * ex: 1.000,00 - 100.000.000,00
         * retorna: 1000.00 - 100000000.00
         */
        if (strripos($number, '.') && strripos($number, ',')) {
            $number = str_replace(',', '.', str_replace('.', '', $number));
            return $number;
        }

        /*
         * Se o numero tiver virgula e nao tiver ponto
         * ex: 500,00 - 10,00 - 5,9
         * retorna: 500.00 - 10.00 - 5.9
         */
        if (strripos($number, ',') && strripos($number, '.') == false) {
            $number = str_replace(',', '.', $number);
            return (float)$number;
        }

        return (float)$number;

    }

    public static function validaCPF($cpf)
    {
        // Extrai somente os n�meros
        $cpf = preg_replace( '/[^0-9]/is', '', $cpf );

        // Verifica se foi informado todos os digitos corretamente
        if (strlen($cpf) != 11) {
            return false;
        }
        // Verifica se foi informada uma sequ�ncia de digitos repetidos. Ex: 111.111.111-11
        if (preg_match('/(\d)\1{10}/', $cpf)) {
            return false;
        }
        // Faz o calculo para validar o CPF
        for ($t = 9; $t < 11; $t++) {
            for ($d = 0, $c = 0; $c < $t; $c++) {
                $d += $cpf{$c} * (($t + 1) - $c);
            }
            $d = ((10 * $d) % 11) % 10;
            if ($cpf{$c} != $d) {
                return false;
            }
        }
        return true;
    }

    /**
     * @return CNPJ com Mascara
     */
    public function cnpjMask($cnpj)
    {
        return $cnpj[0] . $cnpj[1] . "."
            . $cnpj[2] . $cnpj[3] . $cnpj[4] . "."
            . $cnpj[5] . $cnpj[6] . $cnpj[7] . "/"
            . $cnpj[8] . $cnpj[9] . $cnpj[10] . $cnpj[11] . "-"
            . $cnpj[12] . $cnpj[13];
    }

    public static function getMaskCNPJ($val)
    {
        $verify = explode(".", $val);
        $maskared = '';
        if($verify[1]){
            $maskared = $val;
        }else{
            $mask = "##.###.###/####-##";
            $k = 0;
            for ($i = 0; $i <= strlen($mask) - 1; $i++) {
                if ($mask[$i] == '#') {
                    if (isset($val[$k]))
                        $maskared .= $val[$k++];
                } else {
                    if (isset($mask[$i]))
                        $maskared .= $mask[$i];
                }
            }
        }
        return $maskared;
    }
    public static function getMaskCPF($val)
    {
        $mask = "###.###.###-##";
        $maskared = '';
        $k = 0;
        for ($i = 0; $i <= strlen($mask) - 1; $i++) {
            if ($mask[$i] == '#') {
                if (isset($val[$k]))
                    $maskared .= $val[$k++];
            } else {
                if (isset($mask[$i]))
                    $maskared .= $mask[$i];
            }
        }
        return $maskared;
    }

    public static function getMaskTel($val)
    {
        if (strlen($val) == 9) {
            $mask = "(##)#####-####";
        } else {
            $mask = "(##)9####-####";
        }

        $maskared = '';
        $k = 0;
        for ($i = 0; $i <= strlen($mask) - 1; $i++) {
            if ($mask[$i] == '#') {
                if (isset($val[$k]))
                    $maskared .= $val[$k++];
            } else {
                if (isset($mask[$i]))
                    $maskared .= $mask[$i];
            }
        }
        return $maskared;
    }

    public static function getMaskCEP($val)
    {
        $mask = "##.###-###";
        $maskared = '';
        $k = 0;
        for ($i = 0; $i <= strlen($mask) - 1; $i++) {
            if ($mask[$i] == '#') {
                if (isset($val[$k]))
                    $maskared .= $val[$k++];
            } else {
                if (isset($mask[$i]))
                    $maskared .= $mask[$i];
            }
        }
        return $maskared;
    }

    /**
     * @return boolean
     */
    public function validaCNPJ($cnpj)
    {
        $cnpj = preg_replace('/[^0-9]/', '', (string) $cnpj);
        // Valida tamanho
        if (strlen($cnpj) != 14)
            return false;
        // Valida primeiro d�gito verificador
        for ($i = 0, $j = 5, $soma = 0; $i < 12; $i++)
        {
            $soma += $cnpj{$i} * $j;
            $j = ($j == 2) ? 9 : $j - 1;
        }
        $resto = $soma % 11;
        if ($cnpj{12} != ($resto < 2 ? 0 : 11 - $resto))
            return false;

        // Verifica se todos os digitos s�o iguais
        if (preg_match('/(\d)\1{13}/', $cnpj))
            return false;

        // Valida segundo d�gito verificador
        for ($i = 0, $j = 6, $soma = 0; $i < 13; $i++)
        {
            $soma += $cnpj{$i} * $j;
            $j = ($j == 2) ? 9 : $j - 1;
        }
        $resto = $soma % 11;
        return $cnpj{13} == ($resto < 2 ? 0 : 11 - $resto);
    }

    /**
     * @return seconds
     */
    public static function date_diff($from, $to, $type = 'day')
    {
        $diff = strtotime($to) - strtotime($from);
        switch ($type) {
            case "day":
                return (int)($diff / 60 / 60 / 24);
            case "month":
                return (int)($diff / 60 / 60 / 24 / 31);
        }
    }
    
    /**
     * Remove acentua��o das palavras passadas
     *
     * @param $value = palavra que vai ser retirada a acentua��o
     * @return string = retorna a palavra sem acentua��o
     */
    public static function tirarAcentos($string){
        return preg_replace(array(
            "/(||||)/",
            "/(||||)/",
            "/(|||)/",
            "/(|||)/",
            "/(|||)/",
            "/(|||)/",
            "/(||||)/",
            "/(||||)/",
            "/(|||)/",
            "/(|||)/",
            "/()/",
            "/()/"),
            explode(" ","a A e E i I o O u U n N"),
            $string);
    }

    public static function removeCaracteresEspeciais($string) {

        // matriz de entrada
        $stringDeEntrada = array( 
        '','','','','',
        '','','','',
        '','','',
        '','','','','',
        '','','','',
        '','','','',
        '','','',
        '','','',
        '','','','',
        '','','',
        '','',
        '','',
        ' ','-','(',')',',',';',':','|','!','"','#','$','%','&','/','=','?','~','^','>','<','','' );
    
        // matriz de sada
        $stringDeSaida   = array(
        'a','a','a','a','a',
        'e','e','e','e',
        'i','i','i',
        'o','o','o','o','o',
        'u','u','u','u',
        'A','A','A','A',
        'E','E','E',
        'I','I','I',
        'O','O','O','O',
        'U','U','U',
        'n','n',
        'c','C',
        '_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_' );
    
        // devolver a string
        return str_replace($stringDeEntrada, $stringDeSaida, $string);
    }

    public static function removeCaracteresEspeciaisSped($string) {

        // matriz de entrada
        $stringDeEntrada = array( 
        '','','','','',
        '','','','',
        '','','',
        '','','','','',
        '','','','',
        '','','','',
        '','','',
        '','','',
        '','','','',
        '','','',
        '','',
        '','',
        ';','|','"','#','=','~','^','','' );
    
        // matriz de sada
        $stringDeSaida   = array(
        'a','a','a','a','a',
        'e','e','e','e',
        'i','i','i',
        'o','o','o','o','o',
        'u','u','u','u',
        'A','A','A','A',
        'E','E','E',
        'I','I','I',
        'O','O','O','O',
        'U','U','U',
        'n','n',
        'c','C',
        '_','_','_','_','_','_','_','_','_' );
    
        // devolver a string
        return str_replace($stringDeEntrada, $stringDeSaida, $string);
    }

    /**
     * @return string sem acento e com hifem entre espacos
     */
    public static function removeAcentos($arq, $comUnderline = true)
    {
        $a = array(
            '/[�����]/' => 'A',
            '/[�����]/' => 'a',
            '/[����]/' => 'E',
            '/[����]/' => 'e',
            '/[����]/' => 'I',
            '/[����]/' => 'i',
            '/[�����]/' => 'O',
            '/[�����]/' => 'o',
            '/[����]/' => 'U',
            '/[����]/' => 'u',
            '/�/' => 'n',
            '/�/' => 'c',
            '/�/' => 'C',
            '/�/' => '',
            '/\'/' => '',
            '/ /' => '_',
            '/  /' => '_',
            '/   /' => '_'
        );
        if (!$comUnderline) {
            unset($a['/ /'], $a['/  /'], $a['/   /']);
        }
        return preg_replace(array_keys($a), array_values($a), $arq);
    }

    public static function retirar_caracteres_especiais($string)
    {
        $palavra = strtr($string, "???????��������������������������������������������������������������", "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
        $palavranova = str_replace("_", " ", $palavra);
        return $palavranova;
    }
    
    /**
     * Complementa os registros de acordo com as normas do febraban
     * @param $int
     * @param $tipo ('zeros','brancos')
     * @return string
     */
    private static function complementoRegistro($int, $tipo)
    {
        $space = '';
        if ($tipo == "zeros") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= '0';
            }
        } else if ($tipo == "brancos") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= ' ';
            }
        }
        return $space;
    }

    /**
     * Limita e trata as palavras e numeros para o formato dos campos
     * @param $palavra
     * @param $limite
     * @param $comp
     * @param $antecede
     * @return string
     */
    public static function limit($palavra, $limite, $comp = 'brancos', $antecede = false, $caracterEspecial = true)
    {
        $var = '';
        if ($caracterEspecial)
            $palavra = strtoupper(self::retirar_caracteres_especiais($palavra));

        if (strlen($palavra) >= $limite) {
            $var = substr($palavra, 0, $limite);
        } else {
            $max = (int)($limite - strlen($palavra));
            if ($comp == 'brancos') {
                if ($antecede) {
                    $var = self::complementoRegistro($max, "brancos") . $palavra;
                } else {
                    $var = $palavra . self::complementoRegistro($max, "brancos");
                }
            } elseif ($comp == 'zeros') {
                $var = self::complementoRegistro($max, "zeros") . $palavra;
            }
        }
        return $var;
    }

    public static function valorPorExtenso2($valor = 0, $maiusculas = false)
    {
        // verifica se tem virgula decimal
        if (strpos($valor, ",") > 0) {
            // retira o ponto de milhar, se tiver
            $valor = str_replace(".", "", $valor);

            // troca a virgula decimal por ponto decimal
            $valor = str_replace(",", ".", $valor);
        }
        $singular = array("centavo", "real", "mil", "milho", "bilho", "trilho", "quatrilho");
        $plural = array("centavos", "reais", "mil", "milhes", "bilhes", "trilhes", "quatrilhes");


        $c = array("", "cem", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
        $d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa");
        $d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezesete", "dezoito", "dezenove");

        $u = array("", "um", "dois", "trs", "quatro", "cinco", "seis", "sete", "oito", "nove");

        $errado = array(" e cento", " e duzentos", " e trezentos", " e quatrocentos", " e quinhentos", " e seissentos", " e setecentos", " e oitocentos", " e novecentos", " e mil");
        $certo = array(", cento", ", duzentos", ", trezentos", ", quatrocentos", ", quinhentos", ", seissentos", ", setecentos", ", oitocentos", ", novecentos", ", mil");

        $z = 0;

        $valor = number_format($valor, 2, ".", ".");
        $inteiro = explode(".", $valor);
        $cont = count($inteiro);
        for ($i = 0; $i < $cont; $i++)
            for ($ii = strlen($inteiro[$i]); $ii < 3; $ii++)
                $inteiro[$i] = "0" . $inteiro[$i];

        $fim = $cont - ($inteiro[$cont - 1] > 0 ? 1 : 2);
        for ($i = 0; $i < $cont; $i++) {
            $valor = $inteiro[$i];
            $rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
            $rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
            $ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";

            $r = $rc . (($rc && ($rd || $ru)) ? " e " : "") . $rd . (($rd &&
                    $ru) ? " e " : "") . $ru;
            $t = $cont - 1 - $i;
            $r .= $r ? " " . ($valor > 1 ? $plural[$t] : $singular[$t]) : "";
            if ($valor == "000"

            ) $z++; elseif ($z > 0)
                $z--;
            if (($t == 1) && ($z > 0) && ($inteiro[0] > 0))
                $r .= (($z > 1) ? " de " : "") . $plural[$t];
            if ($r)
                $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? (($i < $fim) ? ", " : " e ") : " ") . $r;
        }

        $rt = str_replace($errado, $certo, $rt);
        $rt = str_replace(' ,', ',', $rt);

        if (!$maiusculas) {
            return ($rt ? $rt : "zero");
        } elseif ($maiusculas == "2") {
            return (strtoupper($rt) ? strtoupper($rt) : "Zero");
        } else {
            return (ucwords($rt) ? ucwords($rt) : "Zero");
        }
    }

    /**
     * Fun��o que transforma n�meros/valores em reais em n�meros/valores por extenso
     *
     * @param int $valor -> N�mero que vai ficar por extenso
     * @param bool $maiusculas -> caso queira as letras em maicusculas poe true
     * @param bool $soNumero -> caso queira apenas os n�meros por extenso sem que apare�a a moeda no final
     * @return mixed|string -> retorna o numero por extenso
     */
    public static function valorPorExtenso($valor = 0, $maiusculas = false, $soNumero = false, $porcentagem = false, $feminino = false)
    {
        // verifica se tem virgula decimal
        if (strpos($valor, ",") > 0) {
            // retira o ponto de milhar, se tiver
            $valor = str_replace(".", "", $valor);
            // troca a virgula decimal por ponto decimal
            $valor = str_replace(",", ".", $valor);
        }
        $singular = array("centavo", "real", "mil", "milho", "bilho", "trilho", "quatrilho");
        $plural = array("centavos", "reais", "mil", "milhes", "bilhes", "trilhes", "quatrilhes");

        $c = array("", "cem", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
        $d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa");
        $d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezesete", "dezoito", "dezenove");
        if ($porcentagem) {
            if ($feminino) {
                $u = array("zero", "uma", "duas", "trs", "quatro", "cinco", "seis", "sete", "oito", "nove");
            } else {
                $u = array("zero", "um", "dois", "trs", "quatro", "cinco", "seis", "sete", "oito", "nove");
            }
        } else {
            if ($feminino) {
                $u = array("", "uma", "duas", "trs", "quatro", "cinco", "seis", "sete", "oito", "nove");
            } else {
                $u = array("", "um", "dois", "trs", "quatro", "cinco", "seis", "sete", "oito", "nove");
            }
        }
        $errado = array(" e cento", " e duzentos", " e trezentos", " e quatrocentos", " e quinhentos", " e seissentos", " e setecentos", " e oitocentos", " e novecentos", " e mil");
        $certo = array(", cento", ", duzentos", ", trezentos", ", quatrocentos", ", quinhentos", ", seissentos", ", setecentos", ", oitocentos", ", novecentos", ", mil");

        $z = 0;

        $valor = number_format($valor, 2, ".", ".");
        $inteiro = explode(".", $valor);
        $cont = count($inteiro);
        for ($i = 0; $i < $cont; $i++)
            for ($ii = strlen($inteiro[$i]); $ii < 3; $ii++)
                $inteiro[$i] = "0" . $inteiro[$i];

        $fim = $cont - ($inteiro[$cont - 1] > 0 ? 1 : 2);
        $rt = '';

        if ($inteiro[1] == 0 && $porcentagem) $cont = 1;

        for ($i = 0; $i < $cont; $i++) {
            $valor = $inteiro[$i];
            $rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
            $rd = ($valor[1] < 2) ? "" : $d[$valor[1]];

            if ($porcentagem) {
                $ru = ($valor >= 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : (($valor == 0) ? 'zero' : (($valor[2] != '0' && $valor[1] == '0' && $i == 1) ? 'zero ' . $u[$valor[2]] : (($valor[2] != '0') ? $u[$valor[2]] : '')))) : "";
            } else {
                $ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
            }

            $r = $rc . (($rc && ($rd || $ru)) ? " e " : "") . $rd . (($rd && $ru) ? " e " : "") . $ru;
            $t = $cont - 1 - $i;
            //Condi��o est� com problemas, n�o trazendo a sua funcionalidade(Para valores acima de 1000, passar como false)
            //VERIFICAR ESSA CONDI��O POSTERIORMENTE!
            if (!$soNumero) {
                $r .= $r ? " " . ($valor > 1 ? $plural[$t] : $singular[$t]) : "";
            }

            if ($valor == "000")
                $z++; elseif ($z > 0)
                $z--;

            if (($t == 1) && ($z > 0) && ($inteiro[0] > 0))
                $r .= (($z > 1) ? " de " : "") . $plural[$t];
            if ($r) {
                if ($porcentagem) {
                    $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] >= 0) && ($z < 1)) ? (($i < $fim) ? ", " : " e ") : ($i > 0 ? " " : "")) . $r;
                } else {
                    $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? (($i < $fim) ? ", " : " e ") : ($i > 0 ? " " : "")) . $r;
                }
            }
            $nomes[] = ((($i > 0) && ($i <= $fim) && ($inteiro[0] >= 0) && ($z < 1)) ? (($i < $fim) ? ", " : " e ") : ($i > 0 ? " " : "")) . $r;;
        }
        $rt = str_replace($errado, $certo, $rt);

        if ($porcentagem) {
            $separador = ' virgula ';
            $num2 = strlen(trim($nomes[1]));
            if ($num2 > 0) {
                $str = substr($nomes[1], 3);
                $rt = $nomes[0] . $separador . $str . ' por cento';
            } else {
                $rt = $nomes[0] . ' por cento';
            }
        }
        $rt = str_replace(' ,', ',', $rt);

        if (!$maiusculas) {
            return utf8_encode($rt ? $rt : "zero");
        } elseif ($maiusculas == "2") {
            return utf8_encode(strtoupper($rt) ? strtoupper($rt) : "Zero");
        } else {
            return utf8_encode(ucwords($rt) ? ucwords($rt) : "Zero");
        }
    }

    //passa os caracteres especiais para letra maiscula
    public static function str2Upper($string)
    {
        $caracteresEspeciais = array(
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            '' => '',
            // Adicione outros caracteres especiais conforme necessrio
        );
    
        // Use str_replace para substituir os caracteres especiais pelas verses em maisculas
        $string = str_replace(array_keys($caracteresEspeciais), array_values($caracteresEspeciais), strtoupper($string));
    
        return $string;
    }

    /**
     * @param mixed $options
     * @param $chaveSelecionada
     */
    public static function _select_option($options, $chaveSelecionada = NULL)
    {
        $html_options = '';
        if (is_array($options))
            foreach ($options as $valor => $label) {
                $html_options .= '<option value="' . $valor . '"';
                if ($valor == $chaveSelecionada && $chaveSelecionada)
                    $html_options .= ' selected';
                $html_options .= '>' . $label . '</option>';
            }
        return $html_options;
    }

    public static function randomPassword($limite = 5)
    {
        $carac = '0123456789qwertyuioplkjhgfdsazxcvbnmQWERTYUIOPLKJHGFDSAZXCVBNM';
        $password = '';
        for ($i = 0; $i < $limite; $i++) {
            $password .= $carac[rand(0, strlen($carac) - 1)];
        }
        return $password;
    }

    public static function apenasNumeros($string)
    {
        return preg_replace("/[^0-9]/", "", $string);
    }

    public function removerMensagens()
    {
        $this->mensagem = array();
    }

    /*
     * Exibe o arquivo JS da action atual
     */
    public static function exibeJS()
    {
        $modulo = (isset($_GET['m']) && $_GET['m'] != '') ? '/' . $_GET['m'] : '/sc';
        $controller = (isset($_GET['c'])) ? '/' . $_GET['c'] : '';
        $action = (isset($_GET['a'])) ? '/' . $_GET['a'] : '/index';

        if ($action == '/adicionar' || $action == '/editar' || $action == '/gerar')
            $action = '/formulario';

        $caminho = $modulo . $controller . $action;
        $caminho = 'public/js/modulo' . $caminho . '.js';

        if (file_exists($caminho)) {
            $caminho .= '?'.filemtime($caminho);
            echo '<script type="text/javascript" src="' . $caminho . '"></script>';
        }
    }

    /**
     * Fun��o que gera automaticamente os options de um select
     *
     * @param $lista = Lista vinda do banco com todos dados pra ser exibido no select
     * @param $valueOption = Nome do campo(no DB) � utilizado pra exibir o valor do campo
     * @param $descricaoOption = Texto que vai ser exibido nos options
     * @param null $valueSelected = Caso haja um id pra j� aparecer selecionado
     *
     *  String: � passado o nome do campo que est� no DB para ser exibido no option.
     *  Ex: geraOptionsSelect($listaPessoa, 'cd_pessoa', 'nm_pessoa');
     *
     *  Array: Dois parametros passados na fun��o, onde o primeiro � o texto com os campos entre
     *  cochetes e outro com um array dos nomes de campos.
     *  Ex: geraOptionsSelect($listaPessoa,'cd_pessoa',array('Pessoa: [nm_pessoa] - CPF: [nr_cpf]', array('nm_pessoa','nr_cpf'))
     *  );
     */
    public static function geraOptionsSelect($lista, $valueOption, $descricaoOption, $valueSelected = null)
    {

        if ($lista) {

            if (is_array($descricaoOption)) {
                $textoDescricao = $descricaoOption[0];
                $variaveisDescricao = $descricaoOption[1];
                $divisor = array('[', ']');
            }

            echo '<option value=""> Selecione uma opo...</option>';

            foreach ($lista as $a => $list) {

                $selected = '';

                if (is_array($descricaoOption)) {
                    $textoModificado = $textoDescricao;
                    foreach ($variaveisDescricao as $posicaoVariavel => $nomeCampo) {
                        $textoModificado = str_replace($divisor[0] . $nomeCampo . $divisor[1], $list[$nomeCampo], $textoModificado);
                    }
                } else {
                    $textoModificado = $list[$descricaoOption];
                }

                if ($valueSelected && $valueSelected == $list[$valueOption]) {
                    $selected = 'selected';
                }

                echo '<option value="' . $list[$valueOption] . '" ' . $selected . '>' . $textoModificado . '</option>';
            }
        } else {
            echo '<option value="">No h registros cadastrados.</option>';
        }
    }

    //fun��o para busca em um array pelas chaves dos valores encontrados com termo similar de string, retorna um array com os resultados encontrados
    public static function array_keys_like($array, $termo)
    {
        if ($termo) {
            $values = array();
            foreach ($array as $k => $v) {
                if (strpos(strtolower($v), strtolower($termo)) !== false) {
                    $values[$k] = $v;
                }
            }

            return $values;
        }
        return false;
    }

    /**
     * M�todo respons�vel por filtrar os valores de acordo com o tipo passado
     *
     * @param $value - valor passadopelo post/get
     * @param array $filtros - tipo de filtros
     * @return null|string
     */
    public function filters($value, $filtros = array())
    {
        $value = strip_tags($value);

        if ($value != '') {

            $var = $value;

            if ($filtros) {

                if (!is_array($filtros)) {
                    $filtros = array($filtros);
                }

                foreach ($filtros as $f) {
                    switch ($f) {
                        case 'date':
                            //Tranforma a data no formato americano yyyy-mm-dd
                            $var = $this->getInputDate($value);
                            break;
                        case 'onlyNumber':
                            //retira da string tudo que n�o for n�mero
                            $var = $this->apenasNumeros($value);
                            break;
                        case 'money':
                            //transforma valor em float
                            $var = $this->getInputMoney($value);
                            break;
                    }
                }
            }

            return $var;

        } else {
            return null;
        }
    }

    /**
     * CONTA AS PAGINAS DE UM ARQUIVO PDF
     */
    function countPages($pdfname)
    {
        $pdftext = file_get_contents($pdfname);
        $num = preg_match_all("/\/Page\W/", $pdftext, $dummy);
        return $num;
    }

    /**
     * CONTA AS PAGINAS DE UM ARQUIVO PDF
     */
    public static function exibeAbreviacao($texto)
    {
        if ($texto != '') {
            $texto = substr(str_replace(["a", "e", "i", "o", "u", "A", "E", "I", "O", "U"], "", $texto), 0, 3);
        }
        return $texto;
    }

    /**
     * CONTA AS PAGINAS DE UM ARQUIVO PDF
     */
    public static function criaPastas($path)
    {
        $path = explode('/', $path);

        $pathAtual = '';
        foreach ($path as $p) {
            $pathAtual .= $p.'/';

            if (!is_dir($pathAtual)) {
                mkdir($pathAtual);
            }
        }
    }

    /**
     * RETORNA O ANO, MES DIA DE UMA DATA
     */
    public static function retornaAnoMesDia($data, $formatoAmericano = true)
    {
        if ($data && (int)$data > 0) {
            $formatoAmericano = ($formatoAmericano)?'-':'/';

            $data = explode($formatoAmericano, $data);

            if ($formatoAmericano) {
                $dataArray['dia'] = $data[2];
                $dataArray['mes'] = $data[1];
                $dataArray['ano'] = $data[0];
            } else {
                $dataArray['dia'] = $data[0];
                $dataArray['mes'] = $data[1];
                $dataArray['ano'] = $data[2];
            }
        } else {
            $dataArray = '';
        }

        return $dataArray;
    }

    /**
     * RETORNA O ANO, MES DIA DE UMA DATA
     */
    public static function quebraPalavraGrande($file, $tamanhoFixo = 30)
    {
        $fileQuebrado = '';
        if ($file != '') {
            $tamanhoAlterado = $tamanhoFixo;
            foreach (str_split($file) as $k => $f) {

                if ($k == ($tamanhoAlterado - 1)) {
                    $fileQuebrado .= $f.'<br>';
                    $tamanhoAlterado += $tamanhoFixo;
                } else {
                    $fileQuebrado .= $f;
                }
            }
        }
        return $fileQuebrado;
    }

    public static function arrayParaCondicaoIN($array_para_conversao)
    {
        $retorno = '';
        if(isset($array_para_conversao) && !empty($array_para_conversao))
        {
            $retorno .= "(";
            foreach($array_para_conversao as $item)
            {
                $retorno .= "'" . $item . "',";
            }

            $retorno = chop($retorno, ',');

            $retorno .= ')';

            return $retorno;
        }
        else
        {
            return $retorno;
        }
    }

    /**
	 * Groups an array by a given key.
	 *
	 * Groups an array into arrays by a given key, or set of keys, shared between all array members.
	 *
	 * Based on {@author Jake Zatecky}'s {@link https://github.com/jakezatecky/array_group_by array_group_by()} function.
	 * This variant allows $key to be closures.
	 *
	 * @param array $array   The array to have grouping performed on.
	 * @param mixed $key,... The key to group or split by. Can be a _string_,
	 *                       an _integer_, a _float_, or a _callable_.
	 *
	 *                       If the key is a callback, it must return
	 *                       a valid key from the array.
	 *
	 *                       If the key is _NULL_, the iterated element is skipped.
	 *
	 *                       ```
	 *                       string|int callback ( mixed $item )
	 *                       ```
	 *
	 * @return array|null Returns a multidimensional array or `null` if `$key` is invalid.
	 */
	function array_group_by(array $array, $key)
	{
		if (!is_string($key) && !is_int($key) && !is_float($key) && !is_callable($key) ) {
			trigger_error('array_group_by(): The key should be a string, an integer, or a callback', E_USER_ERROR);
			return null;
		}

		$func = (!is_string($key) && is_callable($key) ? $key : null);
		$_key = $key;

		// Load the new array, splitting by the target key
		$grouped = [];
		foreach ($array as $value) {
			$key = null;

			if (is_callable($func)) {
				$key = call_user_func($func, $value);
			} elseif (is_object($value) && property_exists($value, $_key)) {
				$key = $value->{$_key};
			} elseif (isset($value[$_key])) {
				$key = $value[$_key];
			}

			if ($key === null) {
				continue;
			}

			$grouped[$key][] = $value;
		}

		// Recursively build a nested grouping if more parameters are supplied
		// Each grouped array value is grouped according to the next sequential key
		if (func_num_args() > 2) {
			$args = func_get_args();

			foreach ($grouped as $key => $value) {
				$params = array_merge([ $value ], array_slice($args, 2, func_num_args()));
				$grouped[$key] = call_user_func_array('array_group_by', $params);
			}
		}

		return $grouped;
	}

        /*
     * Verifica se h� uma requisicao ajax e retorna verdadeiro ou falso
     */
    public static function verificaAjax()
    {
        if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            return true;
        } else {
            return false;
        }
    }

    public static function tipoReajuste($tipo, $tabela, $intervalo, $anoInicial, $mesInicial){
        if($tipo == 'T'){
            $tabela = $tabela->where('c.dt_reajuste + INTERVAL ' . $intervalo . ' <= "'.$anoInicial . '-' . $mesInicial . '-31"');
        }
        if($tipo == 'N'){
            $tabela = $tabela->where('c.dt_reajuste_mensal + INTERVAL ' . $intervalo . ' <= "'.$anoInicial . '-' . $mesInicial . '-31"');
        }
        if($tipo == 'I'){
            $tabela = $tabela->where('c.dt_reajuste_intercalada + INTERVAL ' . $intervalo . ' <= "'.$anoInicial . '-' . $mesInicial . '-31"');
        }
        if($tipo == 'C'){
            $tabela = $tabela->where('c.dt_reajuste_chave + INTERVAL ' . $intervalo . ' <= "'.$anoInicial . '-' . $mesInicial . '-31"');
        }

        return $tabela;
    }

    public static function verificaParcelas($tpParcela)
    {
        if($tpParcela == 'T'){
            $tp[0] = 'T';
            $tp[1] = 'Todas';
        }
        if($tpParcela == 'N'){
            $tp[0] = 'N';
            $tp[1] = 'Normais';
        }
        if($tpParcela == 'I'){
            $tp[0] = 'I';
            $tp[1] = 'Intercaladas';
        }
        if($tpParcela == 'C'){
            $tp[0] = 'C';
            $tp[1] = 'Chaves';
        }
        
        return $tp;
        
    }

    public static function dataDoReajuste($tpParcela, $contrato)
    {
        if($tpParcela == 'T'){
            $data = $contrato['dt_reajuste'];
        }
        if($tpParcela == 'N'){
            $data = $contrato['dt_reajuste_mensal'];
        }
        if($tpParcela == 'I'){
            $data = $contrato['dt_reajuste_intercalada'];
        }
        if($tpParcela == 'C'){
            $data = $contrato['dt_reajuste_chave'];
        }
        
        return $data;
        
    }
    /** 
     * Get header Authorization
     * */
    static function getHeader($nome){
        $headers = null;
        if (isset($_SERVER[$nome])) {
            $headers = trim($_SERVER[$nome]);
        }
        else if (isset($_SERVER['HTTP_'.strtoupper($nome)])) { //Nginx or fast CGI
            $headers = trim($_SERVER['HTTP_'.strtoupper($nome)]);
        } elseif (function_exists('apache_request_headers')) {
            $requestHeaders = apache_request_headers();
            // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
            $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
            //print_r($requestHeaders);
            if (isset($requestHeaders[$nome])) {
                $headers = trim($requestHeaders[$nome]);
            }
        }
        return $headers;
    }
    /**
     * get access token from header
     * */
    static function getBearerToken() {
        $headers = Helper::getHeader("Authorization");
        // HEADER: Get the access token from the header
        if (!empty($headers)) {
            if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
                return $matches[1];
            }
        }
        return null;
    }
}
