<?php
use PHPMailer\PHPMailer\PHPMailer;
include 'html2doc.php';

class ControllerPrivateException extends Exception
{

    public function __construct()
    {
        $this->code = 0;
        $this->message = 'Ao privada,  necessrio estar logado para acessar essa rea.';
    }

}

class ControllerNoPrivilegeException extends Exception
{

    public function __construct()
    {
        $this->code = 1;
        $this->message = 'Voc no ter permisso de acessar essa rea.';
    }

}

class Controller
{

    protected $modulo;
    protected $controller;
    protected $action;
    protected $rotina;
    protected $view;
    protected $_isPost;
    protected $_isGet;
    private $_loginController;
    public $_helper;
    protected $_lastView;
    protected $dados;

    public function __construct($request)
    {
        $mod = $request["modulo"];
        $rot = $request["rotina"];
        $cot = $request["controller"];

        $cot[0] = strtolower($cot[0]);

        $this->modulo = $mod;
        $this->rotina = $rot;
        $this->controller = $cot;
        $this->action = $request["action"];

        $this->dados = array();

        $this->_helper = new Helper();

        $this->_isPost = ($_SERVER['REQUEST_METHOD'] == "POST");
        $this->_isGet = ($_SERVER['REQUEST_METHOD'] == "GET");
    }

    private function getInstanceController($controller)
    {
        $instancia = null;
        $controller = ucfirst($controller) . "Controller";
        $controller_path = "modulo/" . $this->modulo . "/controller/{$controller}.php";

        if (file_exists($controller_path) && !is_dir($controller_path)) {
            require_once $controller_path;
        } else {
            throw new Exception("Arquivo do controller no encontrado.");
        }

        if (class_exists($controller)) {
            $request = array("rotina" => $this->rotina, "modulo" => $this->modulo, "controller" => $this->controller, "action" => $this->action);
            $instancia = new $controller($request);
            return $instancia;
        } else {
            JScript::alert("Controlador no encontrado!!!");
        }
    }

    private function execAction($controller, $action)
    {
        $action = $action . "Action";

        if (method_exists($controller, $action)) {
            $controller->$action();
        } else {
            throw new Exception("A action " . $action . " no existe");
        }
    }

    /**
     * Fun��o que abre uma conneccao com o banco de dados de integra��o
     * @return bool|Zend_Db_Adapter_Pdo_Mysql
     */

    public static function getAdapterPainel($dbname=null)
    {
        try {

            $dbAcadeGeral = new Zend_Db_Adapter_Pdo_Mysql(array(
                'host' => DB_HOST,
                'username' => DB_USER,
                'password' => DB_PASSWORD,
                'dbname' => 'acd_lotear_'.$dbname,
                'adapterNamespace' => 'dbAcadeGeral'
            ));
            if (!$dbAcadeGeral->getConnection())
                return false;
        } catch (Exception $e) {
            return false;
        }
        return $dbAcadeGeral;

    }

    public function addUsuarioAcadeGeral() {
        //Captura a URL e separa apena so nome do dominio do cliente
        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }

        //Verifica se existe o dominio do cliente cadastrado, se n�o houver, cadastra o mesmo
        $clienteAcade = Controller::getAdapterAcadeGeral()->fetchRow('SELECT * FROM cliente WHERE nm_dominio = "'.$nmDominio.'"');

        if (!$clienteAcade) {
            $dbAcadeGeral = $this->getAdapterAcadeGeral();

            //Salvando os arquivos no banco acade_geral
            $campos = array(
                'nm_dominio' => $nmDominio,
                'ds_log' => Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i'
            );

            $dbAcadeGeral->insert(TB_CLIENTE_ACADE, $campos);
        }

        //Retorna os dados do usuario: login, senha e id
        return $clienteAcade;
    }
  
      public static function getAdapterIntegracao()
    {
        try {
            $dbIntegracao = new Zend_Db_Adapter_Pdo_Mysql(array(
                'host' => DB_HOST_INTEGRACAO,
                'username' => DB_USER_INTEGRACAO,
                'password' => DB_PASSWORD_INTEGRACAO,
                'dbname' => DB_NAME_INTEGRACAO,
                'driver_options' => ''
            ));
            if (!$dbIntegracao->getConnection())
                return false;
        } catch (Exception $e) {
            return false;
        }

        return $dbIntegracao;
    }

    public function processRequest()
    {
        if (Login::isLogado() && !$this->isAjax()) {
            //Busca os avisos para exibi-los no quadro de avisos
            $clienteAcade = $this->addUsuarioAcadeGeral();
            $avisos = Aviso::getTodosAvisos($clienteAcade['id_cliente']);
            $_SESSION['avisos'] = $avisos;
        }

        //Verifica se existe o controller, se n�o existir exibe msg de erro
        $controller = Db_Controller::findByName(strtolower($this->controller));

        if ($controller) {

            $action = Db_Action::findByNome($this->action, $controller->getId());

            if ($action) {
                if(Login::isLogado()) {
                    if ($action->getPrivate() == '1') {
                        if (ACL::hasPermission(Login::getUsuario(), $action->getId()) || ($_GET['c'] == 'login' && $_GET['a'] == 'alterar')) {
                            $execucao = $this->getInstanceController($controller->getNome());
                            $this->execAction($execucao, $action->getNome());
                        } else {
                            if ($this->controller != "admin")
                                JScript::alert("O usurio no tem permisso de acessar essa rea.");
                            JScript::redir($this->_helper->getLink(array('m' => 'sc', 'c' => 'admin', 'a' => 'index')));
                        }
                    } else {
                        $execucao = $this->getInstanceController($controller->getNome());
                        $this->execAction($execucao, $action->getNome());
                    }
                } else {
                    if($_GET['c'] != 'login' && $_GET['a'] != 'index') {
                        LogAcesso::registraFimDaSessao();
                        $this->redir(array("modulo" => "sc", "controller" => "login", "action" => "index"), array('exception' =>'Sua sesso expirou. Acesse novamente o sistema.'));
                    } else {
                        $this->redir(array("modulo" => "sc", "controller" => "login", "action" => "index"));
                    }
                }
            } else {
                $execucao = $this->getInstanceController($this->controller);
                $this->execAction($execucao, $this->action);
            }
        } else {
            $execucao = $this->getInstanceController($this->controller);
            $this->execAction($execucao, $this->action);
        }
    }

    public function display($view = null)
    {
        if (!$view) {
            $view = $this->action;
        }
        $this->_lastView = $view;

        $view .= '.php';

        $view_path = "modulo/" . $this->modulo . "/view/" . $this->controller . "/";
        if (file_exists($view_path . $view) && !is_dir($view_path . $view)) {
            require_once $view_path . $view;
        } else {
            #throw new Exception("A view n�o pode ser carregada.");
            JScript::alert("A visualiza��o n�o pode ser completada!!!");
        }
    }

    public function infoTokenDocusign($accessToken,$url="https://account.docusign.com"){
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url.'/oauth/userinfo',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer '.$accessToken
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return json_decode($response);
    }

    public function refreshTokenDocusign($refresh_token, $docusign_integration_key, $docusign_secret_key,$url="https://account.docusign.com"){

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url.'/oauth/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('refresh_token' => $refresh_token,'grant_type' => 'refresh_token'),
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic '.base64_encode($docusign_integration_key.":".$docusign_secret_key)
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return json_decode($response);

    }

    public function criarEnvelopeDocusign($accessToken, $clienteId, $base_url, $base64, $assinaturas, $nomeArquivos){

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $base_url.'/restapi/v2.1/accounts/'.$clienteId.'/envelopes',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS =>'{
                "documents": [
                    {
                        "documentBase64": "'.$base64.'",
                        "documentId":1,
                        "fileExtension": "pdf",
                        "name": "'.$nomeArquivos.'"
                    }
                ],
                "emailSubject": "Contrato Digital",
                "recipients": {
                    "signers":'.json_encode($assinaturas).'
                },
                "status": "sent"
            }',
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json',
                'Authorization: Bearer '.$accessToken,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return json_decode($response);

    }

    /**
     * A view que cont�m o layout do PDF deve ser do mesmo nome da action ou pode ser passada
     * como ultimo parametro, caso seja diferente
     */
    public function displayPDF($file = null, $inMemory = true, $orientation = 'P', $format = "A4", $margens = array(5, 5, 5, 20), $viewEscolhida = null, $pageFont = null, $docusign     = false)
    {

        // Foi preciso esconder os erros for�adamente por causa da
        // biblioteca que possui funcoes que entraram em desuso e
        // o programa iria exibir os erros impedindo de exibir o relatorio localmente
        //error_reporting(E_WARNING);
        //ini_set('display_errors', E_WARNING);
        ini_set("memory_limit", "1024M");

        //Verifica��o para gerar o documento do tipo doc.
        if ($_SESSION['tipoDoc'] == 'word')
            $word = new HTML_TO_DOC();

        if (empty($this->_lastView)) {
            if ($viewEscolhida) {
                $this->display($viewEscolhida);
            } else {
                $this->display($this->action);
            }
        }

        $view = $this->_lastView . ".php";

        $view_path = "modulo/" . $this->modulo . "/view/" . $this->controller . "/";
        if (file_exists($view_path . $view) && !is_dir($view_path . $view)) {
            $this->display($this->_lastView);
            $content = ob_get_clean();

            //Verificao para gerar o documento do tipo doc.
            if ($_SESSION['tipoDoc'] == 'word') {
                ob_start();
                $word->createDoc(utf8_encode($content), 'contrato_word_document.doc', true);
                $_SESSION['tipoDoc'] = '';
                exit;
            }
        } else {
            throw new Exception("A view no pode ser carregada.");
        }
        $html2pdf = new HTML2PDF($orientation, $format, 'pt', $margens);
        $html2pdf->WriteHTML($content);
        // forar a limpeza do buffer de sada, fazendo com que o
        // arquivo gerado possua somente o contedo definido
        ob_clean();
        if($docusign){
            return base64_encode($html2pdf->Output($file,true));
        }
        elseif ($inMemory) {
            $html2pdf->Output($file, 'I');
        } else {
            $html2pdf->Output($file);
        }
    }


    public function displayMPDF($file = null, $inMemory = true, $orientation = 'P', $format = "A4", $margens = array(5, 5, 5, 8), $footerflag = TRUE, $pathPdf = false, $pathPdfName = '')
    {
        // Foi preciso esconder os erros for�adamente por causa da
        // biblioteca que possui funcoes que entraram em desuso e
        // o programa iria exibir os erros impedindo de exibir o relatorio localmente
        error_reporting(E_WARNING);
        ini_set('display_errors', E_WARNING);

        if (empty($this->_lastView))
            $this->display($this->action);

        $view = $this->_lastView . ".php";

        $view_path = "modulo/" . $this->modulo . "/view/" . $this->controller . "/";

        if (file_exists($view_path . $view) && !is_dir($view_path . $view)) {
            ini_set("memory_limit", -1);
            $content = ob_get_contents();

            //Verifica��o para gerar o documento do tipo doc.
            if ($_SESSION['tipoDoc'] == 'word') {
                $word = new HTML_TO_DOC();
                $word->createDoc(utf8_encode($content), 'contrato_word_document.doc', true);
                $_SESSION['tipoDoc'] = '';
                exit;
            }

            ob_get_clean();
        } else {
            throw new Exception("A view no pode ser carregada.");
        }

        require_once dirname(__FILE__) . '/MPDF56/mpdf.php';

        if ($orientation == 'L') {
            $mpdf = new mPdf('', 'A4-L', '', '', 15, 15, 20, 20, 5, 5, 'L');
        } else {
            $mpdf = new mPdf('', 'A4', '', '', 15, 15, 20, 20, 5, 5, 'L');
        }
        $mpdf->SetDisplayMode('fullwidth');

        $espaco = 0;

        if (Login::getUsuario()) {
            $cabecalho['impresso'] = 'Impresso por ' . Login::getUsuario()->getLogin() . ' em ' . date('d/m/Y') . ' s ' . date('H:i');
        }

        $footer = "Acade Lotear / Acade Softwares";
        if ($footerflag)
            $mpdf->SetFooter(utf8_encode($cabecalho['impresso'] . '    -    ' . $footer . '  Pgina {PAGENO}'));
        $mpdf->WriteHTML(utf8_encode($content));
        // for�ar a limpeza do buffer de sa�da, fazendo com que o
        // arquivo gerado possua somente o conte�do definido
        ob_clean();

        if ($pathPdf && $pathPdfName) {
            $mpdf->Output($pathPdf.'/'.$pathPdfName, 'F');
        } else {
            $mpdf->Output();
            exit();
        }
    }

    /**
     * Fun��o que gera o header das paginas de acordo com o controller e a action
     * @param $action , $controller
     * @return string
     */
    public function getHeader($action = null, $controller = null, $icon = null)
    {
        if (!$icon)
            switch ($this->action) {
                case 'listar':
                    $icon = 'glyphicon glyphicon-list-alt';
                    break;
                case 'adicionar':
                    $icon = 'fa fa-plus';
                    break;
                case 'editar':
                    $icon = 'fa fa-edit';
                    break;
                case 'gerar':
                    $icon = 'fa fa-file-o';
                    break;
                case 'gerarContrato':
                    $icon = 'fa fa-file-o';
                    break;
                case 'relatorio':
                    $icon = 'fa fa-file-o';
                    break;
                case 'parceria':
                    $icon = 'fa fa-users';
                    break;
                case 'adicionarVarias':
                    $icon = 'fa fa-files-o';
                    $action = 'Adicionar Vrias';
                    break;
                default:
                    $icon = '';
                    break;
            }

            $header = '<h1>' .
            '<i class="' . $icon . '"></i> ' .
            (($action ? $action : ucfirst($this->action)) == 'Form' ? '' : ($action ? $action : ucfirst($this->action))) .
            '<strong> ' . ($controller ? $controller : ucfirst($this->controller)) . '</strong></h1>';
        return $header;
    }

    public function set($k, $v)
    {
        $this->dados[$k] = $v;
    }

    /**
     * Esse m�todo � invocado pela view para recupera��o dos dados do controler
     *
     * @param $k
     * @param boolean $html_espape = false
     */
    public function get($k, $html_espape = false)
    {
        if (array_key_exists($k, $this->dados)) {
            if ($html_espape) {
                return htmlentities($this->dados[$k]);
            } else {
                return $this->dados[$k];
            }
        } else
            return null;
    }

    public function redir(array $request, array $mensagem = array())
    {
        $link = array("m" => $request["modulo"], "c" => $request["controller"], "a" => $request["action"]);
        foreach ($mensagem as $k => $v) {
            $link[$k] = $v;
        }
        header("location: " . $this->_helper->getLink($link));
    }

    public function redirect(array $request, array $mensagem = array())
    {
        $map = array('m' => 'modulo', 'c' => 'controller', 'a' => 'action');
        $link = array();
        foreach ($request AS $ind => $r) {
            if ($m = array_search($ind, $map)) {
                $link[$m] = $r;
            } else {
                $link[$ind] = $r;
            }
        }
        foreach ($mensagem as $k => $v) {
            $link[$k] = $v;
        }
        header("location: " . $this->_helper->getLink($link));
    }

    /**
     * Verifica se uma fun��o chamada � ajax
     * @param $script
     * @return bool
     */
    function isAjax()
    {
        $isAjax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) AND
        strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
        return $isAjax;
    }

    /**
     * Fun��o que abre uma conneccao com o banco de dados acade_geral
     * @return bool|Zend_Db_Adapter_Pdo_Mysql
     */
    public static function getAdapterAcadeGeral()
    {
        try {
            $dbAcadeGeral = new Zend_Db_Adapter_Pdo_Mysql(array(
                'host' => DB_HOST_ACADE_GERAL,
                'username' => DB_USER_ACADE_GERAL,
                'password' => DB_PASSWORD_ACADE_GERAL,
                'dbname' => DB_NAME_ACADE_GERAL,
                'adapterNamespace' => 'dbAcadeGeral'
            ));
            if (!$dbAcadeGeral->getConnection())
                return false;
        } catch (Exception $e) {
            return false;
        }

        return $dbAcadeGeral;
    }

    /**
     * Gera arquivo excel de acordo com as lista de colunas e linhas passadas
     *
     * Formato da lista:
    $colunas = [
    'Nome',
    'Sobrenome',
    'Idade'
    ];
    $linhas = [
    ['Rogerio', 'Nunes', '29 anos'],
    ['Maik', 'Carlos', '28 anos'],
    ['Lilian', 'Lucena', '23 anos'],
    ['Marcio', 'Cialis', '35 anos'],
    ];
     *
     * @param $listaColunas
     * @param $listaLinhas
     * @throws PHPExcel_Exception
     * @throws PHPExcel_Reader_Exception
     * @throws PHPExcel_Writer_Exception
     */
    public function geraExcel($listaColunas, $listaLinhas) {
        $objPHPExcel = new PHPExcel();

        $qtdeColunas = count($listaColunas);
        $qtdeColunas = 50;

        $listaAlfabeto = range('A', 'Z');
        $l = 0;
        //Gera a quantidade letras utilizadas para indentifcar as colunas do arquivo
        for ($i = 0; $i <= $qtdeColunas; $i++) {
            $letra = $listaAlfabeto[$i];
            if ($i > 25) {
                $letra = $listaAlfabeto[$l].$listaAlfabeto[$i-26];
            }
            $alfabeto[] = $letra;
        }

        foreach ($listaColunas as $k => $coluna) {

            // Insere o nome das colunas
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($alfabeto[$k].'1', utf8_encode($coluna));

            foreach ($listaLinhas as $l => $linha) {
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue($alfabeto[$k].($l+2), utf8_encode($linha[$k]));
            }
        }

        // Redirect output to a client?s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$this->controller.date('dmYhis').'.xls"');
        header('Cache-Control: max-age=0');

        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

    public function adicionarValoresTemplate($contratoNumero, $templateProc = null, $transferenciaNumero = null)
    {
        $dados = [];

        $tb_contrato = new Contrato();
        $tb_distrato = new Distrato();


        // Dados vendedores
        $dadosVendedores = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', [''])
            ->join(['pc' => TB_PARCERIA], 'pc.id_empreendimento = l.id_empreendimento', [''])
            ->join(['p' => TB_PESSOA], 'pc.id_pessoa = p.id', [
                'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                'email'
            ])
            ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
            ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
            ])
            ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
            ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia'])
            ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND idTabela = "7"', ['descricao as tipoDocumento'])
            ->where('c.id = ' . $contratoNumero)->query()->fetchAll();

        // Adicionando descri��o tb agrupada em registro de casamento
        foreach ($dadosVendedores as &$vendedor) {
            if ($vendedor['reg_casamento']) {
                $consulta = $tb_contrato->getAdapter()->select()
                    ->from(['tb' => TB_AGRUPADA])
                    ->where('idCampo = "'.$vendedor['reg_casamento'].'"')->query()->fetch();
                $vendedor['reg_casamento'] = $consulta['descricao'];
            }
            //Realiza a jun��o de cidade/uf em naturalidade
            if ($vendedor['naturalidade_cidade']) {
                $vendedor['naturalidade'] = "{$vendedor['naturalidade_cidade']}/{$vendedor['naturalidade_uf']}";
            }
            unset($vendedor['naturalidade_cidade']);
            unset($vendedor['naturalidade_uf']);
        }

        //Por algum motivo inexplicado foreach ocorre bug
        //Foi necess�rio implementar for com sizeof do Array
        $sizeVend = sizeof($dadosVendedores);

        for ($key = 0; $key < $sizeVend; $key++) {
            foreach ($dadosVendedores[$key] as $k => $v) {
                if ($k != 'cd_cidade') {
                    if ($k == 'est_civil' || $k == 'conj_est_civil') {
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$v.'"')->query()->fetch();
                        $v = strtolower($consulta['descricao']);
                    }
                    if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                        if ($v)
                            $v = Helper::dataParaBrasil($v);
                    if ($templateProc != null) {
                        $templateProc->setValue('vendedor' . $key . strval($k), utf8_encode($v));
                        $templateProc->setValue(strtoupper('vendedor' . $key . strval($k)), strtoupper(utf8_encode($v)));
                    }
                    $dados['vendedor'][$key]['vendedor' . $key . strval($k)] = $v;
                }
            }
        }

        //Dados Distratos
        $dadosDistratos = $tb_distrato->getAdapter()->select()
            ->from(['d' => TB_DISTRATO], ['d.id_contrato', 'd.id_banco as idBancoDistrato', 'd.nr_operacao_banco', 'd.tp_distrato', 'd.vl_distrato', 'd.dt_distrato', 'd.local_assinatura', 'd.obs as obsDistrato', 'd.forma_devolucao', 'd.nr_dv_agencia_banco as agencia_dv', 'd.nr_agencia_banco as agencia', 'd.nr_dv_conta_corrente_banco as conta_corrente_dv', 'd.nr_conta_corrente_banco as conta_corrente', 'nm_favorecido', 'nr_cpf_favorecido'])
            ->joinLeft(['c' => TB_CONTRATO], 'c.id = d.id_contrato', '*')
            ->joinLeft(['sc' => TB_AGRUPADA], 'sc.idTabela = "9" and d.id_banco = sc.idCampo', 'descricao')
            // ->joinLeft(['b' => TB_BANCO], 'b.id = d.id_banco', ['b.id as idBanco', 'b.conta_corrente', 'b.conta_corrente_dv', 'b.agencia', 'b.agencia_dv', 'b.cd_banco'])
            ->joinLeft(['l' => TB_LOTES], 'c.id_lote = l.id', '')
            ->joinLeft(['ci' => TB_CONTRATO_ITENS], 'd.id_contrato = ci.id_contrato', ['ci.vl_parcela as vl_parcela_adicional', 'qt_parcelas'])
            ->joinLeft(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id', ['porcDev', 'porcAdmin', 'porcFru'])
            ->joinLeft(['pd' => TB_PARCELA_DISTRATO], 'c.id = pd.id_contrato', ['qtd_parc_dev' => 'COUNT(*)', 'id_parcela as id_parcela_distrato', 'dt_parcela as dt_parcela_distrato'])
            ->group('d.id_contrato')
            ->where('d.id_contrato = ' .$contratoNumero)->query()->fetchAll();
            
        $parcelasDistrato = $tb_distrato->getAdapter()->select()
            ->from(['p' => PARCELA_DISTRATO], '*')
            ->where('p.id_contrato = ' . $contratoNumero)
            ->query()->fetchAll();

        $sizeDistrato = sizeof($dadosDistratos);
        
        for ($key = 0; $key < $sizeDistrato; $key++) {
            foreach ($dadosDistratos[$key] as $k => $d) {
                if ($k == 'dt_distrato') {
                    if ($d)
                        $d = Helper::dataParaBrasil($d);
                }
                if($k == 'dt_parcela_distrato'){
                    if ($d)
                        $d = Helper::dataParaBrasil($d);
                }
                if ($k == 'vl_distrato') {
                    if ($d)
                        $d = Helper::getMoney($d, 2, true);
                }

                if ($templateProc != null) {
                    if ($k != 'dt_distrato') {
                        $templateProc->setValue('distrato' . $key . strval($k), utf8_encode($d));
                        $templateProc->setValue('distrato' . $key . strval($k) . '_extenso', utf8_encode(Helper::valorPorExtenso($d, false, true)));
                        $templateProc->setValue(strtoupper('distrato' . $key . strval($k)), strtoupper(utf8_encode($d)));
                    } else {
                        $templateProc->setValue('distrato' . $key . strval($k), $d);
                        $templateProc->setValue('distrato' . $key . strval($k) . '_extenso', Helper::dataExtenso(Helper::dataParaAmericano($d)));
                    }
                    
                }

                if ($k != 'dt_distrato') {
                    $dados['distrato'][$key]['distrato' . $key . strval($k)] = $d;
                    $dados['distrato'][$key]['distrato' . $key . strval($k) . '_extenso'] = Helper::valorPorExtenso($d);
                }
            }
        }
        
        if ($dadosDistratos[0]['inclui_sinal_contrato'] == 1) {
            $valorTotalContrato = $dadosDistratos[0]['nr_parcela_sinal'] * $dadosDistratos[0]['vl_sinal'] +
                                $dadosDistratos[0]['nr_parcela'] * $dadosDistratos[0]['vl_parcela'] +
                                $dadosDistratos[0]['qt_parcelas'] * $dadosDistratos[0]['vl_parcela_adicional'] +
                                $dadosDistratos[0]['nr_intercalada'] * $dadosDistratos[0]['vl_intercalada'] +
                                $dadosDistratos[0]['nr_parcela_entrega'] * $dadosDistratos[0]['vl_parcela_entrega'];                                
        }
        if ($dadosDistratos[0]['inclui_sinal_contrato'] == 0) {
            $valorTotalContrato = $dadosDistratos[0]['nr_parcela'] * $dadosDistratos[0]['vl_parcela'] +
                                $dadosDistratos[0]['nr_intercalada'] * $dadosDistratos[0]['vl_intercalada'] +
                                $dadosDistratos[0]['qt_parcelas'] * $dadosDistratos[0]['vl_parcela_adicional'] +
                                $dadosDistratos[0]['nr_parcela_entrega'] * $dadosDistratos[0]['vl_parcela_entrega'];
        }
        $firstDate = new DateTime(Helper::dataParaAmericano($dadosDistratos[0]['dt_contrato']));
        $secondDate = new DateTime(Helper::dataParaAmericano($dadosDistratos[0]['dt_distrato']));
        $intvl = $firstDate->diff($secondDate);
        $nrdias = $intvl->days/30;
        $qtMes = intval(round($nrdias));
        $retencao = 100 - $dadosDistratos[0]['porcDev'];
        $fruicao = ($valorTotalContrato * $dadosDistratos[0]['porcFru'] * 0.01) * $qtMes;
        $vlAdm = $dadosDistratos[0]['vl_distrato'] - ($dadosDistratos[0]['vl_distrato'] * ($dadosDistratos[0]['porcDev'] * 0.01));

        $totalDistrato = 0;
        foreach($parcelasDistrato as $pclDistrato){
            $totalDistrato += $pclDistrato['vl_parcela'];
        }
        $dados['distrato'][0]['distrato' . '0' . 'vl_total_dev'] = Helper::getMoney($dadosDistratos[0]['porcDev']*$dadosDistratos[0]['vl_distrato']/100);
        $dados['distrato'][0]['distrato' . '0' . 'vl_restante'] = Helper::getMoney($dadosDistratos[0]['vl_distrato'] - $dados['distrato'][0]['distrato' . '0' . 'vl_total_dev']);
        $dados['distrato'][0]['distrato' . '0' . 'vl_parc_dev'] = Helper::getMoney($totalDistrato / ($dadosDistratos[0]['qtd_parc_dev'] == 0 ? 1 : $dadosDistratos[0]['qtd_parc_dev']));
        $dados['distrato'][0]['distrato' . '0' . 'vl_parc_dev_extenso'] = Helper::valorPorExtenso($dados['distrato'][0]['distrato' . '0' . 'vl_parc_dev']);
        $dados['distrato'][0]['distrato' . '0' . 'qtd_parc_dev_extenso'] = Helper::valorPorExtenso($dadosDistratos[0]['qtd_parc_dev']);
        $dados['distrato'][0]['distrato' . '0' . 'porcent_taxa_adm'] = $dadosDistratos[0]['porcAdmin'] . '%';
        $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_retencao'] = Helper::getMoney($vlAdm);
        $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_retencao_extenso'] = Helper::valorPorExtenso($vlAdm);
        $dados['distrato'][0]['distrato' . '0' . 'porcent_taxa_retencao'] = $retencao . '%';
        $dados['distrato'][0]['distrato' . '0' . 'porcent_fruicao'] = $dadosDistratos[0]['porcFru'] . '%';
        $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_fruicao'] = Helper::getMoney($fruicao);
        $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_fruicao_extenso'] = Helper::valorPorExtenso($fruicao);
        $dados['distrato'][0]['distrato' . '0' . 'qtd_meses_fruicao'] = $qtMes;
        $dados['distrato'][0]['distrato' . '0' . 'vl_total_contrato'] = Helper::getMoney($valorTotalContrato);
        $dados['distrato'][0]['distrato' . '0' . 'nome_banco'] = $dadosDistratos[0]['descricao'];

        //Adicionando dados ao template word
        if ($templateProc != null) {
            $templateProc->setValue('distrato0vl_total_dev', Helper::getMoney($totalDistrato));
            $templateProc->setValue('distrato0vl_total_dev_extenso', Helper::valorPorExtenso(Helper::getMoney($totalDistrato)));
            $templateProc->setValue('distrato0nome_banco', $dadosDistratos[0]['descricao']);
            $templateProc->setValue('distrato' . '0' . 'vl_restante', Helper::getMoney($dadosDistratos[0]['vl_distrato'] - $dados['distrato'][0]['distrato' . '0' . 'vl_total_dev']));
            $templateProc->setValue('distrato' . '0' . 'vl_restante_extenso', Helper::valorPorExtenso(Helper::getMoney($dadosDistratos[0]['vl_distrato'] - $dados['distrato'][0]['distrato' . '0' . 'vl_total_dev'])));
            $templateProc->setValue('distrato' . '0' . 'vl_parc_dev', Helper::getMoney($totalDistrato / ($dadosDistratos[0]['qtd_parc_dev'] == 0 ? 1 : $dadosDistratos[0]['qtd_parc_dev'])));
            $templateProc->setValue('distrato' . '0' . 'vl_parc_dev_extenso', $dados['distrato'][0]['distrato' . '0' . 'vl_parc_dev_extenso']);
            $templateProc->setValue('distrato' . '0' . 'qtd_parc_dev_extenso', $dados['distrato'][0]['distrato' . '0' . 'qtd_parc_dev_extenso']);
            $templateProc->setValue('distrato' . '0' . 'porcent_taxa_adm', $dados['distrato'][0]['distrato' . '0' . 'porcent_taxa_adm']);
            $templateProc->setValue('distrato' . '0' . 'valor_taxa_retencao', $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_retencao']);
            $templateProc->setValue('distrato' . '0' . 'porcent_taxa_retencao', $dados['distrato'][0]['distrato' . '0' . 'porcent_taxa_retencao']);
            $templateProc->setValue('distrato' . '0' . 'porcent_fruicao', $dados['distrato'][0]['distrato' . '0' . 'porcent_fruicao']);
            $templateProc->setValue('distrato' . '0' . 'valor_taxa_fruicao', $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_fruicao']);
            $templateProc->setValue('distrato' . '0' . 'qtd_meses_fruicao', $dados['distrato'][0]['distrato' . '0' . 'qtd_meses_fruicao']);
            $templateProc->setValue('distrato' . '0' . 'vl_total_contrato', $dados['distrato'][0]['distrato' . '0' . 'vl_total_contrato']);
            $templateProc->setValue('distrato' . '0' . 'valor_taxa_fruicao_extenso', $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_fruicao_extenso']);
            $templateProc->setValue('distrato' . '0' . 'valor_taxa_retencao_extenso', $dados['distrato'][0]['distrato' . '0' . 'valor_taxa_retencao_extenso']);
        }
        
        // Dados representantes
        $dadosRepresentantes = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->joinLeft(['l' => TB_LOTES], 'l.id = c.id_lote', [''])
            ->joinLeft(['a' => TB_ASSINATURA], 'a.id_empreendimento = l.id_empreendimento', [''])
            ->joinLeft(['p' => TB_PESSOA], 'a.id_pessoa = p.id', [
                'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                'email'
            ])
            ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
            ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = a.id_pessoa', [
                'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
            ])
            ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
            ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND idTabela = "7"', ['descricao as tipoDocumento'])
            ->where('c.id = ' . $contratoNumero)->query()->fetchAll();

        // Adicionando descri��o tb agrupada em registro de casamento
        foreach ($dadosRepresentantes as &$representante) {
            if ($representante['reg_casamento']) {
                $consulta = $tb_contrato->getAdapter()->select()
                    ->from(['tb' => TB_AGRUPADA])
                    ->where('idCampo = "'.$representante['reg_casamento'].'"')->query()->fetch();
                $representante['reg_casamento'] = $consulta['descricao'];
            }
            if ($representante['naturalidade_cidade']) {
                //Realiza a jun��o de cidade/uf em naturalidade
                $representante['naturalidade'] = "{$representante['naturalidade_cidade']}/{$representante['naturalidade_uf']}";
            }
            unset($representante['naturalidade_cidade']);
            unset($representante['naturalidade_uf']);
        }
        //Por algum motivo inexplicado foreach ocorre bug
        //Foi necess�rio implementar for com sizeof do Array
        $sizeRepre = sizeof($dadosRepresentantes);
        for ($key = 0; $key < $sizeRepre; $key++) {
            foreach ($dadosRepresentantes[$key] as $k => $v) {
                if ($k != 'cd_cidade') {
                    if ($k == 'est_civil' || $k == 'conj_est_civil') {
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$v.'"')->query()->fetch();
                        $v = strtolower($consulta['descricao']);
                    }
                    if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                        if ($v)
                            $v = Helper::dataParaBrasil($v);
                    if ($templateProc != null) {
                        $templateProc->setValue('representante' . $key . strval($k), utf8_encode($v));
                        $templateProc->setValue(strtoupper('representante' . $key . strval($k)), strtoupper(utf8_encode($v)));
                    }
                    $dados['representante'][$key]['representante' . $key . strval($k)] = $v;
                }
            }
        }

        // Dados Comprador
        $dadosCompradores = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['p' => TB_PESSOA], 'c.id_pessoa = p.id', [
                'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                'email'
            ])
            ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
            ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
            ])
            ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
            ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND scTA.idTabela = "7"', ['descricao as tipoDocumento'])
            ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia as fantasia'])
            ->joinLeft(['pC' => TB_PESSOA], 'pf.cd_conjuge = pC.id', [
                'nm_pessoa as conj_nm_pessoa', 'nr_telefone as conj_telefone',
                'nr_celular as conj_celular', 'nr_fax as conj_fax', 'nr_recado as conj_recado',
                'nr_cep as conj_cep', 'nr_endereco as conj_numero',
                'endereco as conj_endereco', 'nm_bairro as conj_nm_bairro', 'ds_complemento as conj_complemento',
                'ds_referencia as conj_referencia', 'email as conj_email'
            ])
            ->joinLeft(['scC' => TB_CIDADE], 'scC.id = pC.cd_cidade', ['nome as conj_cidade', 'uf as conj_uf'])
            ->joinLeft(['pfC' => TB_PESSOA_FISICA], 'pfC.id_pessoa = pC.id', [
                'nr_cpf as conj_cpf',
                'dt_nascimento as conj_dt_nascimento', 'nm_profissao as conj_profissao',
                'nm_nacionalidade as conj_nacionalidade', 'nr_rg as conj_rg', 'est_civil as conj_est_civil', 'reg_casamento as conj_reg_casamento'
            ])
            ->joinLeft(['cdC' => TB_CIDADE], 'cdC.id = pfC.cd_cidade_nasc', ['nome as naturalidade_cidade_cj', 'uf as naturalidade_uf_cj'])
            ->joinLeft(['scTAconj' => TB_AGRUPADA], 'scTAconj.idCampo = pfC.cd_documento AND scTAconj.idTabela = "7"', ['descricao as conj_tipoDocumento'])
            ->where('c.id = ' . $contratoNumero)->query()->fetchAll();

        // Adicionando descri��o tb agrupada em registro de casamento
        foreach ($dadosCompradores as &$comprador) {
            if ($comprador['reg_casamento']) {
                $consulta = $tb_contrato->getAdapter()->select()
                    ->from(['tb' => TB_AGRUPADA])
                    ->where('idCampo = "'.$comprador['reg_casamento'].'"')->query()->fetch();
                $comprador['reg_casamento'] = $consulta['descricao'];
                if ($comprador['conj_reg_casamento']) {
                    $consulta = $tb_contrato->getAdapter()->select()
                        ->from(['tb' => TB_AGRUPADA])
                        ->where('idCampo = "'.$comprador['conj_reg_casamento'].'"')->query()->fetch();
                    $comprador['conj_reg_casamento'] = $consulta['descricao'];
                }
            }
            if ($comprador['naturalidade_cidade']) {
                //Realiza a jun��o de cidade/uf em naturalidade
                $comprador['naturalidade'] = "{$comprador['naturalidade_cidade']}/{$comprador['naturalidade_uf']}";
            }
            if ($comprador['naturalidade_cidade_cj']) {
                //Realiza a jun��o de cidade/uf em naturalidade
                $comprador['naturalidade_conj'] = "{$comprador['naturalidade_cidade_cj']}/{$comprador['naturalidade_uf_cj']}";
            }
            unset($comprador['naturalidade_cidade_cj']);
            unset($comprador['naturalidade_uf_cj']);
            unset($comprador['naturalidade_cidade']);
            unset($comprador['naturalidade_uf']);
        }

        foreach ($dadosCompradores as $key => $comprador) {
            foreach ($comprador as $k => $c) {
                if ($k != 'cd_cidade') {
                    if ($k == 'est_civil' || $k == 'conj_est_civil'){
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$c.'"')->query()->fetch();
                        $c = strtolower($consulta['descricao']);
                    }
                    if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                        if ($c)
                            $c = Helper::dataParaBrasil($c);
                    if ($templateProc != null) {
                        $templateProc->setValue('comprador' . $key . strval($k), utf8_encode($c));
                        $templateProc->setValue(strtoupper('comprador' . $key . strval($k)), strtoupper(utf8_encode($c)));
                    }
                    $dados['comprador'][$key]['comprador' . $key . strval($k)] = $c;
                }
            }
        }

        // Dados Outros Compradores
        $dadosOutrosCompradores = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], ['id as id_contrato'])
            ->join(['cp' => TB_CONTRATO_PESSOA], 'cp.id_contrato = c.id', [''])
            ->join(['p' => TB_PESSOA], 'cp.id_pessoa = p.id', [
                'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                'email'
            ])
            ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
            ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
            ])
            ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
            ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND scTA.idTabela = "7"', ['descricao as tipoDocumento'])
            ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia as fantasia'])
            ->joinLeft(['pC' => TB_PESSOA], 'pf.cd_conjuge = pC.id', [
                'nm_pessoa as conj_nm_pessoa', 'nr_telefone as conj_telefone',
                'nr_celular as conj_celular', 'nr_fax as conj_fax', 'nr_recado as conj_recado',
                'nr_cep as conj_cep', 'nr_endereco as conj_numero',
                'endereco as conj_endereco', 'nm_bairro as conj_nm_bairro', 'ds_complemento as conj_complemento',
                'ds_referencia as conj_referencia', 'ds_referencia as conj_ds_referencia', 'email as conj_email'
            ])
            ->joinLeft(['scC' => TB_CIDADE], 'scC.id = pC.cd_cidade', ['nome as conj_cidade', 'uf as conj_uf'])
            ->joinLeft(['pfC' => TB_PESSOA_FISICA], 'pfC.id_pessoa = pC.id', [
                'nr_cpf as conj_cpf',
                'dt_nascimento as conj_dt_nascimento', 'nm_profissao as conj_profissao',
                'nm_nacionalidade as conj_nacionalidade', 'nm_pai as conj_nm_pai', 'nm_mae as conj_nm_mae',
                'nr_rg as conj_rg', 'est_civil as conj_est_civil', 'reg_casamento as conj_reg_casamento', 'nr_rg as conj_rg'
            ])
            ->joinLeft(['cdC' => TB_CIDADE], 'cdC.id = pfC.cd_cidade_nasc', ['nome as naturalidade_cidade_cj', 'uf as naturalidade_uf_cj'])
            ->joinLeft(['scTAconj' => TB_AGRUPADA], 'scTAconj.idCampo = pfC.cd_documento AND scTAconj.idTabela = "7"', ['descricao as conj_tipoDocumento'])
            ->where('scTA.idTabela = "7"')
            ->where('c.id = ' . $contratoNumero)->query()->fetchAll();

        // Adicionando descri��o tb agrupada em registro de casamento
        foreach ($dadosOutrosCompradores as $comprador) {
            if ($comprador['reg_casamento']) {
                $consulta = $tb_contrato->getAdapter()->select()
                    ->from(['tb' => TB_AGRUPADA])
                    ->where('idCampo = "'.$comprador['reg_casamento'].'"')->query()->fetch();
                $comprador['reg_casamento'] = $consulta['descricao'];
                if ($comprador['conj_reg_casamento']) {
                    $consulta = $tb_contrato->getAdapter()->select()
                        ->from(['tb' => TB_AGRUPADA])
                        ->where('idCampo = "'.$comprador['conj_reg_casamento'].'"')->query()->fetch();
                    $comprador['conj_reg_casamento'] = $consulta['descricao'];
                }
            }
            if ($comprador['naturalidade_cidade']) {
                //Realiza a jun��o de cidade/uf em naturalidade
                $comprador['naturalidade'] = "{$comprador['naturalidade_cidade']}/{$comprador['naturalidade_uf']}";
            }
            if ($comprador['naturalidade_cidade_cj']) {
                //Realiza a jun��o de cidade/uf em naturalidade
                $comprador['naturalidade_conj'] = "{$comprador['naturalidade_cidade_cj']}/{$comprador['naturalidade_uf_cj']}";
            }
            unset($comprador['naturalidade_cidade_cj']);
            unset($comprador['naturalidade_uf_cj']);
            unset($comprador['naturalidade_cidade']);
            unset($comprador['naturalidade_uf']);
        }

        foreach ($dadosOutrosCompradores as $key => $comprador) {
            foreach ($comprador as $k => $c) {
                if ($k != 'cd_cidade') {
                    if ($k == 'est_civil' || $k == 'conj_est_civil'){
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$c.'"')->query()->fetch();
                        $c = strtolower($consulta['descricao']);
                    }
                    if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                        if ($c)
                            $c = Helper::dataParaBrasil($c);
                    if ($templateProc != null) {
                        $templateProc->setValue('comprador' . (intval($key)+1) . strval($k), utf8_encode($c));
                        $templateProc->setValue(strtoupper('comprador' . (intval($key)+1) . strval($k)), strtoupper(utf8_encode($c)));
                    }
                    $dados['outrosCompradores'][$key]['comprador' . (intval($key)+1) . strval($k)] = $c;
                }
            }
        }
        
        if($transferenciaNumero){
            //Dados da transferncia de titularidade
            $dadosTransferencia = $tb_contrato->getAdapter()->select()
                ->from(['t' => TB_TRANSFERENCIA], ['id as idTransferencia', '*'])
                ->join(['p' => TB_PESSOA], 'p.id = t.idCedente', ['nm_pessoa as cedente', '*'])
                ->join(['cd' =>TB_CIDADE], 'p.cd_cidade = cd.id', ['nome as cidade', 'uf'])
                ->where('t.id = ' . $transferenciaNumero)
                ->query()->fetchAll();

            //Dados cedente
            $dadosCedentes = $tb_contrato->getAdapter()->select()
                ->from(['c' => TB_TRANSFERENCIA], [''])
                ->join(['p' => TB_PESSOA], 'c.idCedente = p.id', [
                    'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                    'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                    'email'
                ])
                ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
                ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                    'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                    'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
                ])
                ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
                ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND scTA.idTabela = "7"', ['descricao as tipoDocumento'])
                ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia as fantasia'])
                ->joinLeft(['pC' => TB_PESSOA], 'pf.cd_conjuge = pC.id', [
                    'nm_pessoa as conj_nm_pessoa', 'nr_telefone as conj_telefone',
                    'nr_celular as conj_celular', 'nr_fax as conj_fax', 'nr_recado as conj_recado',
                    'nr_cep as conj_cep', 'nr_endereco as conj_numero',
                    'endereco as conj_endereco', 'nm_bairro as conj_nm_bairro', 'ds_complemento as conj_complemento',
                    'ds_referencia as conj_referencia', 'email as conj_email'
                ])
                ->joinLeft(['scC' => TB_CIDADE], 'scC.id = pC.cd_cidade', ['nome as conj_cidade', 'uf as conj_uf'])
                ->joinLeft(['pfC' => TB_PESSOA_FISICA], 'pfC.id_pessoa = pC.id', [
                    'nr_cpf as conj_cpf',
                    'dt_nascimento as conj_dt_nascimento', 'nm_profissao as conj_profissao',
                    'nm_nacionalidade as conj_nacionalidade', 'nr_rg as conj_rg', 'est_civil as conj_est_civil', 'reg_casamento as conj_reg_casamento'
                ])
                ->joinLeft(['cdC' => TB_CIDADE], 'cdC.id = pfC.cd_cidade_nasc', ['nome as naturalidade_cidade_cj', 'uf as naturalidade_uf_cj'])
                ->joinLeft(['scTAconj' => TB_AGRUPADA], 'scTAconj.idCampo = pfC.cd_documento AND scTAconj.idTabela = "7"', ['descricao as conj_tipoDocumento'])
                ->where('c.id = ' . $transferenciaNumero)->query()->fetchAll();
            // Adicionando descrio tb agrupada em registro de casamento
            foreach ($dadosCedentes as &$cedente) {
                if ($cedente['reg_casamento']) {
                    $consulta = $tb_contrato->getAdapter()->select()
                        ->from(['tb' => TB_AGRUPADA])
                        ->where('idCampo = "'.$cedente['reg_casamento'].'"')->query()->fetch();
                    $cedente['reg_casamento'] = $consulta['descricao'];
                    if ($cedente['conj_reg_casamento']) {
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$cedente['conj_reg_casamento'].'"')->query()->fetch();
                        $cedente['conj_reg_casamento'] = $consulta['descricao'];
                    }
                }
                if ($cedente['naturalidade_cidade']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cedente['naturalidade'] = "{$cedente['naturalidade_cidade']}/{$cedente['naturalidade_uf']}";
                }
                if ($cedente['naturalidade_cidade_cj']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cedente['naturalidade_conj'] = "{$cedente['naturalidade_cidade_cj']}/{$cedente['naturalidade_uf_cj']}";
                }
                unset($cedente['naturalidade_cidade_cj']);
                unset($cedente['naturalidade_uf_cj']);
                unset($cedente['naturalidade_cidade']);
                unset($cedente['naturalidade_uf']);
            }

            foreach ($dadosCedentes as $key => $cedente) {
                foreach ($cedente as $k => $c) {
                    if ($k != 'cd_cidade') {
                        if ($k == 'est_civil' || $k == 'conj_est_civil'){
                            $consulta = $tb_contrato->getAdapter()->select()
                                ->from(['tb' => TB_AGRUPADA])
                                ->where('idCampo = "'.$c.'"')->query()->fetch();
                            $c = strtolower($consulta['descricao']);
                        }
                        if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                            if ($c)
                                $c = Helper::dataParaBrasil($c);
                        if ($templateProc != null) {
                            $templateProc->setValue('cedente' . $key . strval($k), utf8_encode($c));
                            $templateProc->setValue(strtoupper('cedente' . $key . strval($k)), strtoupper(utf8_encode($c)));
                        }
                        $dados['cedente'][$key]['cedente' . $key . strval($k)] = $c;
                    }
                }
            }
            // Dados Outros Cedentes
            if($dadosTransferencia['dt_recebimento_termo']){
                $dadosOutrosCedentes = $tb_contrato->getAdapter()->select()
                    ->from(['c' => TB_TRANSFERENCIA], ['id as id_transferencia'])
                    ->join(['cp' => TB_TRANSFERENCIA_CEDENTES], 'cp.id_transferencia = c.id', [''])
                    ->join(['p' => TB_PESSOA], 'cp.id_pessoa = p.id', [
                        'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                        'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                        'email'
                    ])
                    ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
                    ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                        'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                        'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
                    ])
                    ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
                    ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND scTA.idTabela = "7"', ['descricao as tipoDocumento'])
                    ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia as fantasia'])
                    ->joinLeft(['pC' => TB_PESSOA], 'pf.cd_conjuge = pC.id', [
                        'nm_pessoa as conj_nm_pessoa', 'nr_telefone as conj_telefone',
                        'nr_celular as conj_celular', 'nr_fax as conj_fax', 'nr_recado as conj_recado',
                        'nr_cep as conj_cep', 'nr_endereco as conj_numero',
                        'endereco as conj_endereco', 'nm_bairro as conj_nm_bairro', 'ds_complemento as conj_complemento',
                        'ds_referencia as conj_referencia', 'ds_referencia as conj_ds_referencia', 'email as conj_email'
                    ])
                    ->joinLeft(['scC' => TB_CIDADE], 'scC.id = pC.cd_cidade', ['nome as conj_cidade', 'uf as conj_uf'])
                    ->joinLeft(['pfC' => TB_PESSOA_FISICA], 'pfC.id_pessoa = pC.id', [
                        'nr_cpf as conj_cpf',
                        'dt_nascimento as conj_dt_nascimento', 'nm_profissao as conj_profissao',
                        'nm_nacionalidade as conj_nacionalidade', 'nm_pai as conj_nm_pai', 'nm_mae as conj_nm_mae',
                        'nr_rg as conj_rg', 'est_civil as conj_est_civil', 'reg_casamento as conj_reg_casamento', 'nr_rg as conj_rg'
                    ])
                    ->joinLeft(['cdC' => TB_CIDADE], 'cdC.id = pfC.cd_cidade_nasc', ['nome as naturalidade_cidade_cj', 'uf as naturalidade_uf_cj'])
                    ->joinLeft(['scTAconj' => TB_AGRUPADA], 'scTAconj.idCampo = pfC.cd_documento AND scTAconj.idTabela = "7"', ['descricao as conj_tipoDocumento'])
                    ->where('scTA.idTabela = "7"')
                    ->where('c.id = ' . $transferenciaNumero)->query()->fetchAll();
            }else{
                $dadosOutrosCedentes = $tb_contrato->getAdapter()->select()
                    ->from(['c' => TB_CONTRATO], ['id as id_contrato'])
                    ->join(['cp' => TB_CONTRATO_PESSOA], 'cp.id_contrato = c.id', [''])
                    ->join(['p' => TB_PESSOA], 'cp.id_pessoa = p.id', [
                        'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                        'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                        'email'
                    ])
                    ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
                    ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                        'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                        'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
                    ])
                    ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
                    ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND scTA.idTabela = "7"', ['descricao as tipoDocumento'])
                    ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia as fantasia'])
                    ->joinLeft(['pC' => TB_PESSOA], 'pf.cd_conjuge = pC.id', [
                        'nm_pessoa as conj_nm_pessoa', 'nr_telefone as conj_telefone',
                        'nr_celular as conj_celular', 'nr_fax as conj_fax', 'nr_recado as conj_recado',
                        'nr_cep as conj_cep', 'nr_endereco as conj_numero',
                        'endereco as conj_endereco', 'nm_bairro as conj_nm_bairro', 'ds_complemento as conj_complemento',
                        'ds_referencia as conj_referencia', 'ds_referencia as conj_ds_referencia', 'email as conj_email'
                    ])
                    ->joinLeft(['scC' => TB_CIDADE], 'scC.id = pC.cd_cidade', ['nome as conj_cidade', 'uf as conj_uf'])
                    ->joinLeft(['pfC' => TB_PESSOA_FISICA], 'pfC.id_pessoa = pC.id', [
                        'nr_cpf as conj_cpf',
                        'dt_nascimento as conj_dt_nascimento', 'nm_profissao as conj_profissao',
                        'nm_nacionalidade as conj_nacionalidade', 'nm_pai as conj_nm_pai', 'nm_mae as conj_nm_mae',
                        'nr_rg as conj_rg', 'est_civil as conj_est_civil', 'reg_casamento as conj_reg_casamento', 'nr_rg as conj_rg'
                    ])
                    ->joinLeft(['cdC' => TB_CIDADE], 'cdC.id = pfC.cd_cidade_nasc', ['nome as naturalidade_cidade_cj', 'uf as naturalidade_uf_cj'])
                    ->joinLeft(['scTAconj' => TB_AGRUPADA], 'scTAconj.idCampo = pfC.cd_documento AND scTAconj.idTabela = "7"', ['descricao as conj_tipoDocumento'])
                    ->where('scTA.idTabela = "7"')
                    ->where('c.id = ' . $contratoNumero)->query()->fetchAll();
            }

            // Adicionando descrio tb agrupada em registro de casamento
            foreach ($dadosOutrosCedentes as &$cedente) {
                if ($cedente['reg_casamento']) {
                    $consulta = $tb_contrato->getAdapter()->select()
                        ->from(['tb' => TB_AGRUPADA])
                        ->where('idCampo = "'.$cedente['reg_casamento'].'"')->query()->fetch();
                    $cedente['reg_casamento'] = $consulta['descricao'];
                    if ($cedente['conj_reg_casamento']) {
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$cedente['conj_reg_casamento'].'"')->query()->fetch();
                        $cedente['conj_reg_casamento'] = $consulta['descricao'];
                    }
                }
                if ($cedente['naturalidade_cidade']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cedente['naturalidade'] = "{$cedente['naturalidade_cidade']}/{$cedente['naturalidade_uf']}";
                }
                if ($cedente['naturalidade_cidade_cj']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cedente['naturalidade_conj'] = "{$cedente['naturalidade_cidade_cj']}/{$cedente['naturalidade_uf_cj']}";
                }
                unset($cedente['naturalidade_cidade_cj']);
                unset($cedente['naturalidade_uf_cj']);
                unset($cedente['naturalidade_cidade']);
                unset($cedente['naturalidade_uf']);
            }

            foreach ($dadosOutrosCedentes as $key => $cedente) {
                foreach ($cedente as $k => $c) {
                    if ($k != 'cd_cidade') {
                        if ($k == 'est_civil' || $k == 'conj_est_civil'){
                            $consulta = $tb_contrato->getAdapter()->select()
                                ->from(['tb' => TB_AGRUPADA])
                                ->where('idCampo = "'.$c.'"')->query()->fetch();
                            $c = strtolower($consulta['descricao']);
                        }
                        if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                            if ($c)
                                $c = Helper::dataParaBrasil($c);
                        if ($templateProc != null) {
                            $templateProc->setValue('cedente' . (intval($key)+1) . strval($k), utf8_encode($c));
                            $templateProc->setValue(strtoupper('cedente' . (intval($key)+1) . strval($k)), strtoupper(utf8_encode($c)));
                        }
                        $dados['outrosCedentes'][$key]['cedente' . (intval($key)+1) . strval($k)] = $c;
                    }
                }
            }

            //Dados cessionario
            $dadosCessionario = $tb_contrato->getAdapter()->select()
                ->from(['c' => TB_TRANSFERENCIA], [''])
                ->join(['p' => TB_PESSOA], 'c.idReceptor = p.id', [
                    'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                    'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                    'email'
                ])
                ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
                ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                    'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                    'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
                ])
                ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
                ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND scTA.idTabela = "7"', ['descricao as tipoDocumento'])
                ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia as fantasia'])
                ->joinLeft(['pC' => TB_PESSOA], 'pf.cd_conjuge = pC.id', [
                    'nm_pessoa as conj_nm_pessoa', 'nr_telefone as conj_telefone',
                    'nr_celular as conj_celular', 'nr_fax as conj_fax', 'nr_recado as conj_recado',
                    'nr_cep as conj_cep', 'nr_endereco as conj_numero',
                    'endereco as conj_endereco', 'nm_bairro as conj_nm_bairro', 'ds_complemento as conj_complemento',
                    'ds_referencia as conj_referencia', 'email as conj_email'
                ])
                ->joinLeft(['scC' => TB_CIDADE], 'scC.id = pC.cd_cidade', ['nome as conj_cidade', 'uf as conj_uf'])
                ->joinLeft(['pfC' => TB_PESSOA_FISICA], 'pfC.id_pessoa = pC.id', [
                    'nr_cpf as conj_cpf',
                    'dt_nascimento as conj_dt_nascimento', 'nm_profissao as conj_profissao',
                    'nm_nacionalidade as conj_nacionalidade', 'nr_rg as conj_rg', 'est_civil as conj_est_civil', 'reg_casamento as conj_reg_casamento'
                ])
                ->joinLeft(['cdC' => TB_CIDADE], 'cdC.id = pfC.cd_cidade_nasc', ['nome as naturalidade_cidade_cj', 'uf as naturalidade_uf_cj'])
                ->joinLeft(['scTAconj' => TB_AGRUPADA], 'scTAconj.idCampo = pfC.cd_documento AND scTAconj.idTabela = "7"', ['descricao as conj_tipoDocumento'])
                ->where('c.id = ' . $transferenciaNumero)->query()->fetchAll();

            // Adicionando descrio tb agrupada em registro de casamento
            foreach ($dadosCessionario as &$cessionario) {
                if ($cessionario['reg_casamento']) {
                    $consulta = $tb_contrato->getAdapter()->select()
                        ->from(['tb' => TB_AGRUPADA])
                        ->where('idCampo = "'.$cessionario['reg_casamento'].'"')->query()->fetch();
                    $cessionario['reg_casamento'] = $consulta['descricao'];
                    if ($cessionario['conj_reg_casamento']) {
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$cessionario['conj_reg_casamento'].'"')->query()->fetch();
                        $cessionario['conj_reg_casamento'] = $consulta['descricao'];
                    }
                }
                if ($cessionario['naturalidade_cidade']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cessionario['naturalidade'] = "{$cessionario['naturalidade_cidade']}/{$cessionario['naturalidade_uf']}";
                }
                if ($cessionario['naturalidade_cidade_cj']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cessionario['naturalidade_conj'] = "{$cessionario['naturalidade_cidade_cj']}/{$cessionario['naturalidade_uf_cj']}";
                }
                unset($cessionario['naturalidade_cidade_cj']);
                unset($cessionario['naturalidade_uf_cj']);
                unset($cessionario['naturalidade_cidade']);
                unset($cessionario['naturalidade_uf']);
            }

            foreach ($dadosCessionario as $key => $cessionario) {
                foreach ($cessionario as $k => $c) {
                    if ($k != 'cd_cidade') {
                        if ($k == 'est_civil' || $k == 'conj_est_civil'){
                            $consulta = $tb_contrato->getAdapter()->select()
                                ->from(['tb' => TB_AGRUPADA])
                                ->where('idCampo = "'.$c.'"')->query()->fetch();
                            $c = strtolower($consulta['descricao']);
                        }
                        if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                            if ($c)
                                $c = Helper::dataParaBrasil($c);
                        if ($templateProc != null) {
                            $templateProc->setValue('cessionario' . $key . strval($k), utf8_encode($c));
                            $templateProc->setValue(strtoupper('cessionario' . $key . strval($k)), strtoupper(utf8_encode($c)));
                        }
                        $dados['cessionario'][$key]['cessionario' . $key . strval($k)] = $c;
                    }
                }
            }

            // Dados Outros Cessionarios
            $dadosOutrosCessionarios = $tb_contrato->getAdapter()->select()
                ->from(['c' => TB_TRANSFERENCIA], ['id as id_transferencia'])
                ->join(['cp' => TB_TRANSFERENCIA_CESSIONARIOS], 'cp.id_transferencia = c.id', [''])
                ->join(['p' => TB_PESSOA], 'cp.id_cessionario = p.id', [
                    'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                    'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                    'email'
                ])
                ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
                ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = p.id', [
                    'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                    'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
                ])
                ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
                ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND scTA.idTabela = "7"', ['descricao as tipoDocumento'])
                ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = p.id', ['nr_cnpj as cnpj', 'nm_fantasia as fantasia'])
                ->joinLeft(['pC' => TB_PESSOA], 'pf.cd_conjuge = pC.id', [
                    'nm_pessoa as conj_nm_pessoa', 'nr_telefone as conj_telefone',
                    'nr_celular as conj_celular', 'nr_fax as conj_fax', 'nr_recado as conj_recado',
                    'nr_cep as conj_cep', 'nr_endereco as conj_numero',
                    'endereco as conj_endereco', 'nm_bairro as conj_nm_bairro', 'ds_complemento as conj_complemento',
                    'ds_referencia as conj_referencia', 'ds_referencia as conj_ds_referencia', 'email as conj_email'
                ])
                ->joinLeft(['scC' => TB_CIDADE], 'scC.id = pC.cd_cidade', ['nome as conj_cidade', 'uf as conj_uf'])
                ->joinLeft(['pfC' => TB_PESSOA_FISICA], 'pfC.id_pessoa = pC.id', [
                    'nr_cpf as conj_cpf',
                    'dt_nascimento as conj_dt_nascimento', 'nm_profissao as conj_profissao',
                    'nm_nacionalidade as conj_nacionalidade', 'nm_pai as conj_nm_pai', 'nm_mae as conj_nm_mae',
                    'nr_rg as conj_rg', 'est_civil as conj_est_civil', 'reg_casamento as conj_reg_casamento', 'nr_rg as conj_rg'
                ])
                ->joinLeft(['cdC' => TB_CIDADE], 'cdC.id = pfC.cd_cidade_nasc', ['nome as naturalidade_cidade_cj', 'uf as naturalidade_uf_cj'])
                ->joinLeft(['scTAconj' => TB_AGRUPADA], 'scTAconj.idCampo = pfC.cd_documento AND scTAconj.idTabela = "7"', ['descricao as conj_tipoDocumento'])
                ->where('scTA.idTabela = "7"')
                ->where('c.id = ' . $transferenciaNumero)->query()->fetchAll();

            // Adicionando descrio tb agrupada em registro de casamento
            foreach ($dadosOutrosCessionarios as &$cessionario) {
                if ($cessionario['reg_casamento']) {
                    $consulta = $tb_contrato->getAdapter()->select()
                        ->from(['tb' => TB_AGRUPADA])
                        ->where('idCampo = "'.$cessionario['reg_casamento'].'"')->query()->fetch();
                    $cessionario['reg_casamento'] = $consulta['descricao'];
                    if ($cessionario['conj_reg_casamento']) {
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$cessionario['conj_reg_casamento'].'"')->query()->fetch();
                        $cessionario['conj_reg_casamento'] = $consulta['descricao'];
                    }
                }
                if ($cessionario['naturalidade_cidade']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cessionario['naturalidade'] = "{$cessionario['naturalidade_cidade']}/{$cessionario['naturalidade_uf']}";
                }
                if ($cessionario['naturalidade_cidade_cj']) {
                    //Realiza a juno de cidade/uf em naturalidade
                    $cessionario['naturalidade_conj'] = "{$cessionario['naturalidade_cidade_cj']}/{$cessionario['naturalidade_uf_cj']}";
                }
                unset($cessionario['naturalidade_cidade_cj']);
                unset($cessionario['naturalidade_uf_cj']);
                unset($cessionario['naturalidade_cidade']);
                unset($cessionario['naturalidade_uf']);
            }

            foreach ($dadosOutrosCessionarios as $key => $cessionario) {
                foreach ($cessionario as $k => $c) {
                    if ($k != 'cd_cidade') {
                        if ($k == 'est_civil' || $k == 'conj_est_civil'){
                            $consulta = $tb_contrato->getAdapter()->select()
                                ->from(['tb' => TB_AGRUPADA])
                                ->where('idCampo = "'.$c.'"')->query()->fetch();
                            $c = strtolower($consulta['descricao']);
                        }
                        if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                            if ($c)
                                $c = Helper::dataParaBrasil($c);
                        if ($templateProc != null) {
                            $templateProc->setValue('cessionario' . (intval($key)+1) . strval($k), utf8_encode($c));
                            $templateProc->setValue(strtoupper('cessionario' . (intval($key)+1) . strval($k)), strtoupper(utf8_encode($c)));
                        }
                        $dados['outrosCessionarios'][$key]['cessionario' . (intval($key)+1) . strval($k)] = $c;
                    }
                }
            }
        }

        // Dados do Contrato
        $dadosContrato = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [
                'id as id_contrato', 'dt_contrato', 'nr_proposta as id_proposta', 'dt_reajuste', 'acrescimo', 'desconto', 'nr_meses_financiamento', 'tx_juros', 'vl_divida',
                'obs', 'vl_desc_normal', 'vl_desc_sinal', 'vl_desc_intercalada',
                'vl_desc_chave', 'ds_intermediacao_imobiliaria as intermediacao_imobiliaria'
            ])
            ->join(['ie' => TB_INDICE_EMPREENDIMENTO], 'ie.id_indice_empreendimento = c.id_indice', ['fl_residuo', 'indice_adicional', 'fl_periodo_adc', 'id_indice as idIndice'])
            ->join(['p' => TB_PESSOA], 'c.id_pessoa = p.id', 'ds_observacao as obsPessoa')
            ->joinLeft(['b' => TB_BANCO], 'c.id_banco = b.id', '')
            ->joinLeft(['sc' => TB_AGRUPADA], 'sc.idTabela = "9" and b.cd_banco = sc.idCampo', 'descricao as nome_banco')
            ->where('c.id = ' . $contratoNumero)
            ->query()->fetchAll();
        
        // Adc descri��o do �ndice
        $tbAgrupada = AgrupadaGeral::buscar('12', $dadosContrato[0]['idIndice']);
        unset($dadosContrato[0]['idIndice']);
        $dadosContrato[0]['tipo_reajuste'] = $tbAgrupada['descricao'];

        $comSemResiduo = ($dadosContrato[0]['fl_residuo'] == '1')?' - Com':' - Sem';
        $caracterSoma = Helper::getNomePeriodo($dadosContrato[0]['fl_periodo']) != ''?' +':'';
        $indiceAdicional = ($dadosContrato[0]['indice_adicional'] != '0') ? $caracterSoma . str_replace('.',',',number_format($dadosContrato[0]['indice_adicional'], 2)) . '%' : '';
        $dadosContrato[0]['tipo_reajuste'] = $dadosContrato[0]['tipo_reajuste'] . ' ' . Helper::getNomePeriodo($dadosContrato[0]['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($dadosContrato[0]['fl_periodo_adc']).$comSemResiduo.' Resduo';

        unset($dadosContrato[0]['fl_periodo']);
        unset($dadosContrato[0]['fl_periodo_adc']);
        unset($dadosContrato[0]['idIndice']);
        unset($dadosContrato[0]['indice_adicional']);

        $dadosContrato[0]['vl_divida'];
        $dadosContrato[0]['vl_divida_extenso'] = Helper::valorPorExtenso($dadosContrato[0]['vl_divida']);
        $dadosContrato[0]['nome_banco'] = $dadosContrato[0]['nome_banco'];

        //Adiciona ao array a data por extenso
        if ($dadosContrato[0]['dt_contrato'])
            $dadosContrato[0]['dt_contrato_extenso'] = Helper::dataExtenso($dadosContrato[0]['dt_contrato']);

        foreach ($dadosContrato as $key => $contrato) {
            foreach ($contrato as $k => $c) {
                if ($k == 'indice_adicional')
                    $c = str_replace('.',',',number_format($c, 2));
                if ($k == 'fl_periodo' || $k == 'fl_periodo_adc')
                    $c = Helper::getNomePeriodo($c);
                if ($k == 'residuo')
                    $c = $c == '1' ? 'Com Resduo' : 'Sem Resduo';
                if ($k == 'dt_contrato' || $k == 'dt_primeira_parcela' || $k == 'dt_intercalada' || $k == 'dt_sinal' || $k == 'dt_fim_empreendimento' || $k == 'dt_parcela_entrega' || $k == 'dt_reajuste')
                    if ($c)
                        $c = Helper::dataParaBrasil($c);
                if ($k == 'vl_sinal' || $k == 'vl_intercalada' || $k == 'vl_parcela' || $k == 'vl_parcela_entrega' || $k == 'vl_divida' || $k == 'vl_desc_normal' || $k == 'vl_desc_sinal' || $k == 'vl_desc_intercalada' || $k == 'vl_desc_chave')
                    $c = Helper::getMoney($c, 2, true);
                if ($templateProc != null) {
                    $templateProc->setValue('contrato' . $key . strval($k), utf8_encode($c));
                    $templateProc->setValue(strtoupper('contrato' . $key . strval($k)), strtoupper(utf8_encode($c)));
                }
                $dados['contrato'][$key]['contrato' . $key . strval($k)] = $c;
            }
        }

        // Dados Representantes de COMPRADOR
        $dadosOutrosRepresentantes = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], ['id_pessoa'])
            ->joinLeft(['l' => TB_LOTES], 'l.id = c.id_lote', [''])
            ->joinLeft(['cp' => TB_CONTRATO_PESSOA], 'cp.id_contrato = c.id', ['id_pessoa as id_pessoa_outros'])
            ->where('c.id = "' . $contratoNumero. '"')
            ->query()->fetchAll();

        $outrosWhere = [];
        $outrosWhere[0] = $dadosOutrosRepresentantes[0]['id_pessoa'];
        foreach ($dadosOutrosRepresentantes as $outros) {
            $outrosWhere[] = $outros['id_pessoa_outros'];
        }

        $outrosWhere = implode('","', $outrosWhere);

        $dadosRepresentantes = $tb_contrato->getAdapter()->select()
            ->from(['r' => TB_REPRESENTANTE], [''])
            ->join(['p' => TB_PESSOA], 'r.id_pessoa = p.id', [
                'cd_cidade', 'nm_pessoa', 'nr_telefone as telefone', 'nr_celular as celular',
                'nr_fax as fax', 'nr_recado as recado', 'nr_cep as cep', 'nr_endereco as numero', 'endereco', 'nm_bairro', 'ds_complemento as complemento', 'ds_referencia as referencia',
                'email'
            ])
            ->joinLeft(['sc' => TB_CIDADE], 'sc.id = p.cd_cidade', ['nome as cidade', 'uf'])
            ->joinLeft(['pf' => TB_PESSOA_FISICA], 'pf.id_pessoa = r.id_pessoa', [
                'nr_cpf as cpf', 'dt_nascimento', 'nm_profissao as profissao',
                'nm_nacionalidade as nacionalidade', 'nm_pai', 'nm_mae', 'nr_rg as rg', 'est_civil', 'reg_casamento'
            ])
            ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pj.id_pessoa = r.id_pessoa_juridica','' )
            ->joinLeft(['cd' => TB_CIDADE], 'cd.id = pf.cd_cidade_nasc', ['nome as naturalidade_cidade', 'uf as naturalidade_uf'])
            ->joinLeft(['scTA' => TB_AGRUPADA], 'scTA.idCampo = pf.cd_documento AND idTabela = "7"', ['descricao as tipoDocumento'])
            ->where('r.id_pessoa_juridica IN ("' . $outrosWhere . '")')
            ->query()->fetchAll();

        // Adicionando descri��o tb agrupada em registro de casamento
        foreach ($dadosRepresentantes as &$representante) {
            if ($representante['reg_casamento']) {
                $consulta = $tb_contrato->getAdapter()->select()
                    ->from(['tb' => TB_AGRUPADA])
                    ->where('idCampo = "'.$representante['reg_casamento'].'"')->query()->fetch();
                $representante['reg_casamento'] = $consulta['descricao'];
            }
            if ($representante['naturalidade_cidade']) {
                //Realiza a jun��o de cidade/uf em naturalidade
                $representante['naturalidade'] = "{$representante['naturalidade_cidade']}/{$representante['naturalidade_uf']}";
            }
            unset($representante['naturalidade_cidade']);
            unset($representante['naturalidade_uf']);
        }
        //Por algum motivo inexplicado foreach ocorre bug
        //Foi necess�rio implementar for com sizeof do Array
        $sizeRepre = sizeof($dadosRepresentantes);
        for ($key = 0; $key < $sizeRepre; $key++) {
            foreach ($dadosRepresentantes[$key] as $k => $v) {
                if ($k != 'cd_cidade') {
                    if ($k == 'est_civil' || $k == 'conj_est_civil') {
                        $consulta = $tb_contrato->getAdapter()->select()
                            ->from(['tb' => TB_AGRUPADA])
                            ->where('idCampo = "'.$v.'"')->query()->fetch();
                        $v = strtolower($consulta['descricao']);
                    }
                    if ($k == 'dt_nascimento' || $k == 'conj_dt_nascimento')
                        if ($v)
                            $v = Helper::dataParaBrasil($v);
                    if ($templateProc != null) {
                        $templateProc->setValue('representantecomp' . $key . strval($k), utf8_encode($v));
                        $templateProc->setValue(strtoupper('representantecomp' . $key . strval($k)), strtoupper(utf8_encode($v)));
                    }
                    $dados['representantecomp'][$key]['representantecomp' . $key . strval($k)] = $v;
                }
            }
        }
        // Portal

        $dadosPortal = $tb_contrato->getAdapter()->select()
            ->from(['cl' => TB_CLIENTE], ['ds_url'])
            ->from(['c' => TB_CONTRATO], '')
            ->join(['pt' => TB_PORTAL_SENHA], 'c.id = pt.id_contrato', ['senha', 'login'])
            ->join(['pf' => TB_PESSOA_FISICA], 'c.id_pessoa = pf.id_pessoa', array('id_pessoa', 'nr_cpf'))
            ->where('c.id = ' . $contratoNumero)
            ->query()->fetchAll();

            if (($dadosPortal[0]['nr_cpf'] == NULL)) {
                $dadosPortal = $tb_contrato->getAdapter()->select()
                    ->from(['cl' => TB_CLIENTE], ['ds_url'])
                    ->from(['c' => TB_CONTRATO], '')
                    ->join(['pt' => TB_PORTAL_SENHA], 'c.id = pt.id_contrato', ['senha', 'login'])
                    ->join(['pj' => TB_PESSOA_JURIDICA], 'c.id_pessoa = pj.id_pessoa', array('id_pessoa', 'nr_cnpj'))
                    ->where('c.id = ' . $contratoNumero)
                    ->query()->fetchAll();
            }

        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }

        foreach ($dadosPortal as $portal) {
            foreach ($portal as $k => $l) {
                if ($templateProc != null) {

                    //descriptografa a senha
                    $ciphering = "AES-128-CTR";
                    $options = 0;
                    $decryption_iv = '1234567891011121';
                    $decryption_key = "EncryptedKey";
                    $decryption=openssl_decrypt ($portal['senha'], $ciphering,
                        $decryption_key, $options, $decryption_iv);
                    $templateProc->setValue('link_portal',"https://".$nmDominio.".acadeone.com.br/portal");
                    $templateProc->setValue('senha_portal',$decryption);
                    $templateProc->setValue('login_portal',$portal['login']);
                }

            }
        }


        // Corretor
        $dadosOutros = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', [''])
            ->joinLeft(['i' => TB_COMISSAO_LANCAMENTO],'c.id = i.id_contrato', 'vl_comissao_total')
            ->join(['ce' => TB_CORRETOR_EMPREENDIMENTO], 'ce.id_corretor = c.id_corretor', ['id_corretor_empreendimento','nr_creci', 'nr_creci_pj', 'pc_comissao', 'tp_comissao', 'fl_parcela_normal', 'fl_parcela_sinal', 'fl_parcela_intercalada', 'fl_parcela_chave', 'fl_parcela_negociada', 'fl_parcela_quitacao'])
            ->joinLeft(['p' => TB_PESSOA], 'ce.id_corretor = p.id', ['nm_pessoa', 'nr_telefone as telefone', 'nr_cep', 'nr_endereco', 'endereco', 'nm_bairro', 'ds_complemento', 'email', 'cd_cidade'])
            ->joinLeft(['pI' => TB_PESSOA], 'ce.id_imobiliaria = pI.id', ['nm_pessoa as nm_imobiliaria'])
            ->joinLeft(['pf' => TB_PESSOA_FISICA], 'p.id = pf.id_pessoa', ['nr_cpf as cpf'])
            ->joinLeft(['pj' => TB_PESSOA_JURIDICA], 'pI.id = pj.id_pessoa', ['nr_cnpj as cnpj_imobiliaria'])
            ->joinLeft(['cd' => TB_CIDADE], 'p.cd_cidade = cd.id', ['nome as cidade', 'uf'])
            ->where('c.id = ' . $contratoNumero)
            ->where('ce.id_empreendimento = l.id_empreendimento')
            ->query()->fetchAll();

        $dadosParcelas = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['pc' => TB_PARCELA], 'pc.id_contrato = c.id ', ['*'])
            ->where('c.id = ' . $contratoNumero)
            ->query()->fetchAll();

        if (($dadosOutros[0]['tp_comissao'] == 'F')) {
            $dadosOutros[0]["pc_comissao_extenso"] = Helper::valorPorExtenso($dadosOutros[0]['pc_comissao']);
            $dadosOutros[0]["pc_comissao"] = Helper::getMoney($dadosOutros[0]["pc_comissao"], 2, true);
            $dadosOutros[0]["valor_total_comissao"] = $dadosOutros[0]["pc_comissao"]; 
            $dadosOutros[0]["valor_total_comissao_extenso"] = Helper::valorPorExtenso($dadosOutros[0]["valor_total_comissao"]); 
        } else {
            $dadosOutros[0]["pc_comissao_extenso"] = Helper::valorPorExtenso($dadosOutros[0]['pc_comissao'], false,true,true);
            $dadosOutros[0]["pc_comissao"] = Helper::getMoney($dadosOutros[0]["pc_comissao"], 2, true) . ' %';
            if($dadosOutros[0]['tp_comissao'] == 'P'){
                $total = 0;
                //Verifica se o corretor recebe pela parcea e acrescenta no total de comisso
                if($dadosOutros[0]["fl_parcela_normal"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'N' && $parcela['pago'] == 1){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_sinal"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'S' && $parcela['pago'] == 1){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_intercalada"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'I' && $parcela['pago'] == 1){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_chave"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'C' && $parcela['pago'] == 1){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_negociada"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'G' && $parcela['pago'] == 1){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_quitacao"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'Q' && $parcela['pago'] == 1){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                $dadosOutros[0]["valor_total_comissao"] = Helper::getMoney(( $total / 100) * $dadosOutros[0]["pc_comissao"]);
                $dadosOutros[0]["valor_total_comissao_extenso"] = Helper::valorPorExtenso($dadosOutros[0]["valor_total_comissao"]);
            }
            else{
                $total = 0;
                //Verifica se o corretor recebe pela parcea e acrescenta no total de comisso
                if($dadosOutros[0]["fl_parcela_normal"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'N'){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_sinal"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'S'){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_intercalada"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'I'){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_chave"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'C'){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_negociada"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'G'){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                if($dadosOutros[0]["fl_parcela_quitacao"] == 1){
                    foreach($dadosParcelas as $parcela){
                        if($parcela['tp_parcela'] == 'Q'){
                            $total += $parcela['vl_parcela'];
                        }
                    }
                }
                $dadosOutros[0]["valor_total_comissao"] = Helper::getMoney(($total / 100) * $dadosOutros[0]["pc_comissao"]);
                $dadosOutros[0]["valor_total_comissao_extenso"] = Helper::valorPorExtenso($dadosOutros[0]["valor_total_comissao"]);
            }

        }

        $parcelasIntercaladas = $tb_contrato->getAdapter()->select() 
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['pc' => TB_PARCELA], 'pc.id_contrato = c.id ', ['*'])
            ->where('c.id = ' . $contratoNumero)
            ->where("tp_parcela = 'I'")
            ->query()->fetchAll();

        foreach ($parcelasIntercaladas as $key => $parcelaIntercalada) {
            $dados['parcelaIntercalada'][$key]['parcela' . $key . 'dt_intercalada'] = Helper::dataParaBrasil($parcelasIntercaladas[$key]['dt_parcela']);
            $dados['parcelaIntercalada'][$key]['parcela' . $key . 'dt_intercalada_extenso'] = Helper::dataPorExtenso(Helper::dataParaBrasil($parcelasIntercaladas[$key]['dt_parcela']));
            $dados['parcelaIntercalada'][$key]['parcela' . $key . 'vl_intercalada'] = Helper::getMoney($parcelasIntercaladas[$key]['vl_parcela']);
            $dados['parcelaIntercalada'][$key]['parcela' . $key . 'vl_intercalada_extenso'] = Helper::valorPorExtenso($parcelasIntercaladas[$key]['vl_parcela']);
            if ($templateProc != null) {
                $templateProc->setValue('parcela' . $key . 'dt_intercalada', $dados['parcelaIntercalada'][$key]['parcela' . $key . 'dt_intercalada']);
                $templateProc->setValue('parcela' . $key . 'dt_intercalada_extenso',  $dados['parcelaIntercalada'][$key]['parcela' . $key . 'dt_intercalada_extenso']);
                $templateProc->setValue('parcela' . $key . 'vl_intercalada', $dados['parcelaIntercalada'][$key]['parcela' . $key . 'vl_intercalada']);
                $templateProc->setValue('parcela' . $key . 'vl_intercalada_extenso', $dados['parcelaIntercalada'][$key]['parcela' . $key . 'vl_intercalada_extenso']);
            }
        }

        $totalComissao = $dadosOutros[0]["valor_total_comissao"];

        foreach ($dadosOutros as $key => $corretor) {
            foreach ($corretor as $k => $l) {
                if ($templateProc != null) {
                    $templateProc->setValue('corretor' . $key . strval($k), utf8_encode($l));
                    $templateProc->setValue(strtoupper('corretor' . $key . strval($k)), strtoupper(utf8_encode($l)));
                }
                $dados['corretor'][$key]['corretor' . $key . strval($k)] = $l;

            }
        }

        // Parceria - Acade Vendas
        $dadosParceria = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->joinLeft(['i' => TB_COMISSAO_LANCAMENTO],'c.id = i.id_contrato',['id_parceiro', 'id_pessoa_parceiro', 'vl_comissao_total'])
            ->joinLeft(['p' => TB_PESSOA], 'i.id_pessoa_parceiro = p.id', ['nm_pessoa'])
            ->joinLeft(['ta' => SC_TABELA_AGRUPADA], 'i.id_parceiro = ta.idCampo', ['descricao'])
            ->where('ta.idTabela = 27')
            ->where('c.id = ' . $contratoNumero)
            ->query()->fetchAll();
        
        for ($i = 0; $i < count($dadosParceria); $i++) {
            if (($dadosParceria[$i]['id_parceiro'] != NULL)) {        
                    $dadosParceria[$i]["vl_comissao_extenso"] = Helper::valorPorExtenso($dadosParceria[$i]['vl_comissao_total']);
                    $dadosParceria[$i]["vl_comissao"] = Helper::getMoney($dadosParceria[$i]["vl_comissao_total"], 2, true);
                    $dadosParceria[$i]["nm_comissao"] = $dadosParceria[$i]['nm_pessoa'];
                    $dadosParceria[$i]["tp_comissao"] = $dadosParceria[$i]['descricao'];
            }
        }

        foreach ($dadosParceria as $key => $parceiro) {
            foreach ($parceiro as $k => $l) {
                if ($templateProc != null) {
                    $templateProc->setValue('parceiro' . $key . strval($k), $l);
                    $templateProc->setValue(strtoupper('parceiro' . $key . strval($k)), strtoupper($l));
                }
                $dados['parceiro'][$key]['parceiro' . $key . strval($k)] = $l;
            }
        }

        // Lotes
        $dadosOutros = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', [
                'quadra', 'lote', 'conf_frente',
                'conf_fundo', 'conf_esquerda', 'conf_direita', 'frente', 'fundo', 'esquerda',
                'direita', 'area', 'valor', 'rgi as rgi_individual', 'obs_lote', 'ds_geral'
            ])
            ->where('c.id = ' . $contratoNumero)->query()->fetchAll();

        foreach ($dadosOutros as $key => $lotes) {
            foreach ($lotes as $k => $l) {
                if ($k == 'valor') {
                    $l = Helper::getMoney($l, 2, true);
                    if ($l) {
                        if ($templateProc != null) {
                            $templateProc->setValue('lotes' . $key . strval($k).'_extenso', Helper::valorPorExtenso($l));
                            $templateProc->setValue(strtoupper('lotes' . $key . strval($k).'_extenso'), strtoupper(Helper::valorPorExtenso($l)));
                        }
                        $dados['lotes'][$key]['lotes' . $key . strval($k).'_extenso'] = Helper::valorPorExtenso($l);
                    }
                }
                if ($templateProc != null) {
                    $templateProc->setValue('lotes' . $key . strval($k), utf8_encode($l));
                    $templateProc->setValue(strtoupper('lotes' . $key . strval($k)), strtoupper(utf8_encode($l)));
                }
                $dados['lotes'][$key]['lotes' . $key . strval($k)] = $l;
            }
        }

        // Empreendimento
        $dadosOutros = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['l' => TB_LOTES], 'l.id = c.id_lote', [''])
            ->join(['e' => TB_EMPREENDIMENTO], 'e.id = l.id_empreendimento', [
                'nm_empreendimento',
                'rgi', 'bairro', 'nr_cep as cep', 'dt_conclusao'
            ])
            ->joinLeft(['sc' => TB_CIDADE], 'sc.id = e.cd_cidade', ['nome as cidade', 'uf'])
            ->where('c.id = ' . $contratoNumero)->query()->fetchAll();

        foreach ($dadosOutros as $key => $empreendimento) {
            foreach ($empreendimento as $k => $o) {
                if ($templateProc != null) {
                    $templateProc->setValue('empreendimento' . $key . strval($k), utf8_encode($o));
                    $templateProc->setValue(strtoupper('empreendimento' . $key . strval($k)), strtoupper(utf8_encode($o)));
                }
                $dados['empreendimento'][$key]['empreendimento' . $key . strval($k)] = $o;
            }
        }

        //Dados de Parcelas na tabela parcela (Atividade ACL-2971)
        $tb_parcela = new Parcela();
        $dadosDaTabelaParcela = $tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'tp_parcela',
                'dt_parcela', 'acrescimo', 'desconto', 'vl_parcela', 'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa', 'vl_total_pago', 'tp_baixa', 'id_negociacao','dt_parcela_2avia', 'pago'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('c.nr_parcela', 'idDoContrato' => 'id'))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('juros', "multa", 'tp_juros', 'tp_multa'))
            ->where('p.id_contrato = ' . $contratoNumero)
            ->query()->fetchAll();

        $dadosSinal = $tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela as nr_sinal', 'tp_parcela',
                'dt_parcela as dt_sinal', 'acrescimo', 'desconto', 'vl_parcela as vl_sinal', 'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa', 'vl_total_pago', 'tp_baixa', 'id_negociacao','dt_parcela_2avia', 'pago'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('c.nr_parcela', 'idDoContrato' => 'id'))
            ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('juros', "multa", 'tp_juros', 'tp_multa'))
            ->where('p.id_contrato = ' . $contratoNumero)
            ->where("p.tp_parcela = 'S'")
            ->query()->fetchAll();

        // Dados de Parcelas no contrato
        $dadosParcela = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [
                'nr_parcela', 'nr_parcela_sinal', 'nr_intercalada',
                'nr_parcela_entrega', 'vl_sinal', 'vl_intercalada', 'vl_parcela', 'vl_parcela_entrega',
                'dt_primeira_parcela', 'dt_intercalada', 'dt_sinal', 'dt_parcela_entrega', 'fr_intercalada' 
            ])
            ->joinLeft(['ci' => TB_CONTRATO_ITENS], 'c.id = ci.id_contrato', ['vl_parcela as vl_parcela_adc', 'qt_parcelas as qt_parcela_adc'])
            ->where('c.id = ' . $contratoNumero)
            ->query()->fetchAll();


        $parcelaValorPago = 0;
        $parcelaValorNaoPago = 0;
        $parcelaValorNaoPagoSinal = 0;
        $totaisHonorario = 0;
        $parcelaTotalMultaJuros = 0;

        foreach ($dadosDaTabelaParcela as $parcela)
        {
            if($parcela['pago'] == 1 && $parcela['tp_parcela'] != 'A'){
                $parcelaValorPago += $parcela['vl_parcela'];
                $parcelaTotalMultaJuros += ($parcela['vl_parcela']+$parcela['vl_multa']+$parcela['vl_juros']);
            }

            if($parcela['pago'] == 0 && !in_array($parcela['tp_parcela'], array('A', 'NE', 'SE', 'IE', 'E', 'CE'))){

                $parcelaValorNaoPago += $parcela['vl_parcela'];
                $dataParcela = Helper::dataParaAmericano(Helper::getInputDate($parcela["dt_parcela"]));

                $atraso = Helper::date_diff($dataParcela, date('Y-m-d'));
                $atr = ($atraso >= 0) ? number_format($atraso, 0) : "0";
                
                if($atr>0 && $parcela['dt_parcela'] < date('Y-m-d')){
                    if ($parcela['tp_multa'] != 'S') {
                        $multa = ($parcela['tp_multa'] == 'P') ? $parcela["vl_parcela"] * ($parcela["multa"] / 100) : $parcela['multa'];
                        $multa = number_format($multa, 2, '.', '');
                    } else {
                        $multa = '0';
                    }
                    if ($parcela['tp_juros'] != 'S') {
                        $juros = ($parcela['tp_juros'] == 'P') ? $parcela["vl_parcela"] * ($parcela["juros"] / 100) : $parcela['juros'];
                        $juros *= $atraso;
                    } else {
                        $juros = '0';
                    }
                    $juros = number_format($juros, 2, '.', '');
                    $multa = number_format($multa, 2, '.', '');

                    $totaisHonorario += $parcela['vl_parcela'] + $juros + $multa;
                }else{
                    $multa = "0";
                    $juros = "0";
                }

            }
            if($parcela['pago'] == 0 && $parcela['tp_parcela'] == 'S'){
                $parcelaValorNaoPagoSinal += $parcela['vl_parcela'];
            }

        }
        foreach($dadosSinal as $key => $parcela){
            foreach ($parcela as $k => $p) {
                if ($k == 'nr_parcela_sinal') {
                    if ($templateProc != null) {
                        $templateProc->setValue('parcela' . $key . strval($k).'_extenso', Helper::valorPorExtenso($p, false, true));
                        $templateProc->setValue(strtoupper('parcela' . $key . strval($k).'_extenso'), strtoupper(Helper::valorPorExtenso($p, false, true)));
                    }
                    $dados['parcela'][$key]['parcela' . $key . strval($k).'_extenso'] = Helper::valorPorExtenso($p, false, true);
                }
                if ($k == 'dt_sinal'){
                    if ($p)
                        $p = Helper::getDate($p);

                    if ($templateProc != null && $p) {
                        $templateProc->setValue(strtoupper('parcela' . $key . strval($k)), strtoupper($p));
                        $templateProc->setValue(strtoupper('parcela' . $key . strval($k).'_extenso'), strtoupper(Helper::dataExtenso(Helper::dataParaAmericano($p))));
                        $templateProc->setValue('parcela' . $key . strval($k), strtoupper($p));
                        $templateProc->setValue('parcela' . $key . strval($k).'_extenso', strtoupper(Helper::dataExtenso(Helper::dataParaAmericano($p))));
                    }
                    if ($p)
                        $dados['parcela'][$key]['parcela' . $key . strval($k).'_extenso'] = Helper::dataExtenso(Helper::dataParaAmericano($p));
                        $dados['parcela'][$key]['parcela' . $key . strval($k)] = $p;
                }
            }

        }
        foreach ($dadosParcela as $key => $parcela) {
            foreach ($parcela as $k => $p) {
                if ($k == 'nr_parcela' ||$k == 'nr_parcela_sinal') {
                    if ($templateProc != null) {
                        $templateProc->setValue('parcela' . $key . strval($k).'_extenso', Helper::valorPorExtenso($p, false, true));
                        $templateProc->setValue(strtoupper('parcela' . $key . strval($k).'_extenso'), strtoupper(Helper::valorPorExtenso($p, false, true)));
                    }
                    $dados['parcela'][$key]['parcela' . $key . strval($k).'_extenso'] = Helper::valorPorExtenso($p, false, true);
                }
                if ($k == 'dt_contrato' || $k == 'dt_primeira_parcela' || $k == 'dt_intercalada' || $k == 'dt_fim_empreendimento' || $k == 'dt_parcela_entrega' || $k == 'dt_reajuste'){
                    if ($p)
                        $p = Helper::getDate($p);

                    if ($templateProc != null && $p) {
                        $templateProc->setValue(strtoupper('parcela' . $key . strval($k)), strtoupper($p));
                        $templateProc->setValue(strtoupper('parcela' . $key . strval($k).'_extenso'), strtoupper(Helper::dataExtenso(Helper::dataParaAmericano($p))));
                        $templateProc->setValue('parcela' . $key . strval($k), strtoupper($p));
                        $templateProc->setValue('parcela' . $key . strval($k).'_extenso', strtoupper(Helper::dataExtenso(Helper::dataParaAmericano($p))));
                    }
                    if ($p)
                        $dados['parcela'][$key]['parcela' . $key . strval($k).'_extenso'] = Helper::dataExtenso(Helper::dataParaAmericano($p));
                        $dados['parcela'][$key]['parcela' . $key . strval($k)] = $p;
                }
                if ($k == 'vl_parcela_adc' || $k == 'vl_sinal' || $k == 'vl_intercalada' || $k == 'vl_parcela' || $k == 'vl_parcela_entrega' || $k == 'vl_desc_normal' || $k == 'vl_desc_sinal' || $k == 'vl_desc_intercalada' || $k == 'vl_desc_chave') {
                    $p = Helper::getMoney($p, 2, true);
                    if ($p) {
                        if ($templateProc != null) {
                            $templateProc->setValue('parcela' . $key . strval($k).'_extenso', Helper::valorPorExtenso($p));
                            $templateProc->setValue(strtoupper('parcela' . $key . strval($k).'_extenso'), strtoupper(Helper::valorPorExtenso($p)));
                        }
                        $dados['parcela'][$key]['parcela' . $key . strval($k).'_extenso'] = Helper::valorPorExtenso($p);
                    }
                }
                if ($templateProc != null) {
                    $templateProc->setValue('parcela' . $key . strval($k), utf8_encode($p));
                    $templateProc->setValue(strtoupper('parcela' . $key . strval($k)), strtoupper(utf8_encode($p)));
                    $templateProc->setValue('parcela' . $key . strval($k).'_extenso', Helper::valorPorExtenso($p, false, true));
                    $templateProc->setValue(strtoupper('parcela' . $key . strval($k).'_extenso'), strtoupper(Helper::valorPorExtenso($p, false, true)));
                }
                $dados['parcela'][$key]['parcela' . $key . strval($k)] = $p;
                $dados['parcela'][$key]['parcela' . $key . strval($k).'_extenso'] = Helper::valorPorExtenso($p, false, true);
            }

            $parcelaData =  $dadosParcela['dt_primeira_parcela'];
            $parcelaPagoData = $dadosParcela['dt_primeira_parcela'];
            foreach ($dadosDaTabelaParcela as $parcela){
                if($parcela['dt_parcela'] > $parcelaData){
                    if($parcela['pago'] == 1){
                        $parcelaPagoData = $parcela['dt_parcela'];
                        $parcelaPgmData = $parcela['dt_pagamento'];
                    }
                    $parcelaData = $parcela['dt_parcela'];
                }
            }

            $dados['parcela'][$key]['parcela' . $key . 'dt_ultima_parcela'] = Helper::dataParaBrasil($parcelaData);
            $dados['parcela'][$key]['parcela' . $key . 'dt_ultima_parcela_paga'] = Helper::dataParaBrasil($parcelaPagoData);
            $dados['parcela'][$key]['parcela' . $key . 'dt_pg_ultima_parcela'] = Helper::dataParaBrasil($parcelaPgmData);
            if ($templateProc != null) {
                $templateProc->setValue('parcela' . $key . 'dt_ultima_parcela', $dados['parcela'][$key]['parcela' . $key . 'dt_ultima_parcela']);
                $templateProc->setValue('parcela' . $key . 'dt_ultima_parcela_paga', $dados['parcela'][$key]['parcela' . $key . 'dt_ultima_parcela_paga']);
                $templateProc->setValue('parcela' . $key . 'dt_pg_ultima_parcela', $dados['parcela'][$key]['parcela' . $key . 'dt_pg_ultima_parcela']);
            }
        }


        //Dados parcela sinal
        $dadosSinal = $tb_contrato->getAdapter()->select()
            ->from(['c' => TB_CONTRATO], [''])
            ->join(['s' => TB_SINAL], 's.idContrato = c.id', ['parcela as parcelaSinal', 'valor as valorParcelaSinal', 'dtVencimento as dtVencimentoParcSinal'])
            ->where('c.id = ' . $contratoNumero)->query()->fetchAll();

        foreach ($dadosSinal as $key => $sinal) {
            foreach ($sinal as $k => $s) {
                if ($k == 'valorParcelaSinal') {
                    $s = Helper::getMoney($s, 2, true);
                    if ($s) {
                        $testando = (Helper::valorPorExtenso($s));
                        if ($templateProc != null) {
                            $templateProc->setValue('parcelas_sinal' . $key . strval($k).'_extenso', $testando);
                            $templateProc->setValue(strtoupper('parcelas_sinal' . $key . strval($k).'_extenso'), strtoupper($testando));
                        }
                        $dados['parcelas_sinal'][$key]['parcelas_sinal' . $key . strval($k).'_extenso'] = $testando;
                    }
                }
                if ($k == 'dtVencimentoParcSinal')
                    if ($s)
                        $s = Helper::dataParaBrasil($s);
                if ($templateProc != null) {
                    $templateProc->setValue('parcelas_sinal' . $key . strval($k), utf8_encode($s));
                    $templateProc->setValue(strtoupper('parcelas_sinal' . $key . strval($k)), strtoupper(utf8_encode($s)));
                }
                $dados['parcelas_sinal'][$key]['parcelas_sinal' . $key . strval($k)] = $s;
            }
        }

        // Totais 

        $dados['totais']['0']['totais0vl_total_pago'] = Helper::getMoney($parcelaValorPago);
        $dados['totais']['0']['totais0vl_total_pago_extenso'] = Helper::valorPorExtenso(Helper::getMoney($parcelaValorPago));
        $dados['totais']['0']['totais0dif_vlpago_e_vlcontrato'] = $parcelaValorNaoPago;
        $dados['totais']['0']['totais0dif_vlpagar_sem_sinal'] = $parcelaValorNaoPago - $parcelaValorNaoPagoSinal;
        $dados['totais']['0']['totais0dif_vlpagar_sem_sinal_extenso'] = Helper::valorPorExtenso($dados['totais']['0']['totais0dif_vlpagar_sem_sinal']);

        // Valor total parcela
        $vlTotalTbParc = floatval($dadosParcela[0]['vl_parcela']) * $dadosParcela[0]['nr_parcela'];
        $vlSomaParcAdc = 0;
        $vlQntParcAdc = 0;
        foreach ($dadosParcela as $parcelaAdc) {
            $valorMult = floatval($parcelaAdc['vl_parcela_adc']) * $parcelaAdc['qt_parcela_adc'];
            $vlSomaParcAdc += $valorMult;
            $vlQntParcAdc += $parcelaAdc['qt_parcela_adc'];
        }
        $vlTotalTbParc += floatval($vlSomaParcAdc);
        $dados['totais']['0']['totais0nr_total_parcela'] = $vlQntParcAdc + $dadosParcela[0]['nr_parcela'];
        $dados['totais']['0']['totais0vl_total_parcela'] = Helper::getMoney($vlTotalTbParc, 2, true); 
        if ($dados['totais']['0']['totais0vl_total_parcela'])
            $dados['totais']['0']['totais0vl_total_parcela_extenso'] = Helper::valorPorExtenso($dados['totais']['0']['totais0vl_total_parcela']);

        //Para ter honorrio com todos os valores possveis
        for($ph = 0; $ph<=100; $ph++){
            if($totaisHonorario == 0){
                $dados['totais']['0']['totais_parcelahonorarios'] = 0;
                $dados['totais']['0']['totais_saldodevedorcomhonorarios'] = 0;
            }else{
                $tot = ($totaisHonorario/100) * $ph;
                $dados['totais']['0']['totais_parcelahonorarios'] = Helper::getMoney($tot);
                $dados['totais']['0']['totais_saldodevedorcomhonorarios'] = Helper::getMoney(($tot + $totaisHonorario), 2);
            }
            if ($templateProc != null) {
                $templateProc->setValue('totais_parcelahonorarios' . $ph, $dados['totais']['0']['totais_parcelahonorarios']);
                $templateProc->setValue('totais_parcelahonorarios' . $ph . 'extenso',  Helper::valorPorExtenso($dados['totais']['0']['totais_parcelahonorarios']));
                $templateProc->setValue('totais_saldodevedorcomhonorarios' . $ph,  $dados['totais']['0']['totais_saldodevedorcomhonorarios']);
                $templateProc->setValue('totais_saldodevedorcomhonorarios' . $ph . 'extenso',  Helper::valorPorExtenso($dados['totais']['0']['totais_saldodevedorcomhonorarios']));
            }
        }
        if ($templateProc != null) {
            $templateProc->setValue('totais0nr_total_parcela', $dados['totais']['0']['totais0nr_total_parcela']);
            $templateProc->setValue('totais0vl_total_parcela', $dados['totais']['0']['totais0vl_total_parcela']);
            $templateProc->setValue('totais0vl_total_parcela_extenso', $dados['totais']['0']['totais0vl_total_parcela_extenso']);
            $templateProc->setValue(strtoupper('totais0vl_total_parcela_extenso'), strtoupper($dados['totais']['0']['totais0vl_total_parcela_extenso']));
            $templateProc->setValue('totais0vl_total_pago', $dados['totais']['0']['totais0vl_total_pago']);
            $templateProc->setValue('totais0vl_total_pago_extenso', $dados['totais']['0']['totais0vl_total_pago_extenso']);
            $templateProc->setValue('totais0dif_vlpago_e_vlcontrato', $dados['totais']['0']['totais0dif_vlpago_e_vlcontrato']);
            $templateProc->setValue('totais0dif_vlpagar_sem_sinal',  $dados['totais']['0']['totais0dif_vlpagar_sem_sinal']);
            $templateProc->setValue('totais0dif_vlpagar_sem_sinal_extenso',  $dados['totais']['0']['totais0dif_vlpagar_sem_sinal_extenso']);
        }
        // Valor total intercalada
        $dados['totais']['0']['totais0vl_total_intercalada'] = Helper::getMoney(Helper::getInputMoney($dados['parcela'][0]['parcela0nr_intercalada']) * Helper::getInputMoney($dados['parcela'][0]['parcela0vl_intercalada']), 2, true);
        if ($dados['totais']['0']['totais0vl_total_intercalada'])
            $dados['totais']['0']['totais0vl_total_intercalada_extenso'] = Helper::valorPorExtenso( Helper::getMoney(Helper::getInputMoney($dados['parcela'][0]['parcela0nr_intercalada']) * Helper::getInputMoney($dados['parcela'][0]['parcela0vl_intercalada'])) );

        if ($templateProc != null) {
            $templateProc->setValue('totais0vl_total_intercalada', $dados['totais']['0']['totais0vl_total_intercalada']);
            $templateProc->setValue('totais0vl_total_intercalada_extenso', $dados['totais']['0']['totais0vl_total_intercalada_extenso']);
            $templateProc->setValue(strtoupper('totais0vl_total_intercalada_extenso'), strtoupper($dados['totais']['0']['totais0vl_total_intercalada_extenso']));
        }
        // Valor total chave
        $dados['totais']['0']['totais0vl_total_chave'] = Helper::getMoney(Helper::getInputMoney($dados['parcela'][0]['parcela0nr_parcela_entrega']) * Helper::getInputMoney($dados['parcela'][0]['parcela0vl_parcela_entrega']), 2, true);
        if ($dados['totais']['0']['totais0vl_total_chave'])
            $dados['totais']['0']['totais0vl_total_chave_extenso'] = Helper::valorPorExtenso( Helper::getMoney(Helper::getInputMoney($dados['parcela'][0]['parcela0nr_parcela_entrega']) * Helper::getInputMoney($dados['parcela'][0]['parcela0vl_parcela_entrega'])) );

        if ($templateProc != null) {
            $templateProc->setValue('totais0vl_total_chave', $dados['totais']['0']['totais0vl_total_chave']);
            $templateProc->setValue('totais0vl_total_chave_extenso', $dados['totais']['0']['totais0vl_total_chave_extenso']);
            $templateProc->setValue(strtoupper('totais0vl_total_chave_extenso'), strtoupper($dados['totais']['0']['totais0vl_total_chave_extenso']));
        }
        // Valor total lote sem sinal
        $dados['totais']['0']['totais0vl_total_lote_semSinal'] = Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_parcela']) +
            Helper::getInputMoney($dados['totais']['0']['totais0vl_total_intercalada']) + Helper::getInputMoney($dados['totais']['0']['totais0vl_total_chave']), 2, true);
        if ($dados['totais']['0']['totais0vl_total_lote_semSinal'])
            $dados['totais']['0']['totais0vl_total_lote_semSinal_extenso'] = Helper::valorPorExtenso( Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_parcela']) +
                Helper::getInputMoney($dados['totais']['0']['totais0vl_total_intercalada']) + Helper::getInputMoney($dados['totais']['0']['totais0vl_total_chave'])) );
        if ($templateProc != null) {
            $templateProc->setValue('totais0vl_total_lote_semSinal', $dados['totais']['0']['totais0vl_total_lote_semSinal']);
            $templateProc->setValue('totais0vl_total_lote_semSinal_extenso', $dados['totais']['0']['totais0vl_total_lote_semSinal_extenso']);
            $templateProc->setValue(strtoupper('totais0vl_total_lote_semSinal_extenso'), strtoupper($dados['totais']['0']['totais0vl_total_lote_semSinal_extenso']));
        }
        // Valor total lote com sinal
        $dados['totais']['0']['totais0vl_total_lote_comSinal'] = Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_lote_semSinal']) + Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal']), 2, true);
        if ($dados['totais']['0']['totais0vl_total_lote_comSinal']) {
            $dados['totais']['0']['totais0vl_total_lote_comSinal_extenso'] = Helper::valorPorExtenso( Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_lote_semSinal']) + Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal'])) );
            $dados['porcentagem']['0']['porcentagem0porcentagem_sinal'] = Helper::getMoney(Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal'] * 100), 2, true) / Helper::getMoney($dados['totais']['0']['totais0vl_total_lote_comSinal']);
            $dados['porcentagem']['0']['porcentagem0porcentagem_parcelas'] = Helper::getMoney(Helper::getMoney($dados['totais']['0']['totais0vl_total_lote_comSinal'] - $dados['parcela']['0']['parcela0vl_sinal']), 2, true) / Helper::getMoney($dados['totais']['0']['totais0vl_total_lote_comSinal']);
            $dados['porcentagem']['0']['porcentagem0porcentagem_sinal'] = number_format((float)$dados['porcentagem']['0']['porcentagem0porcentagem_sinal'], 2, ',', '');
            $dados['porcentagem']['0']['porcentagem0porcentagem_parcelas'] = number_format((float)$dados['porcentagem']['0']['porcentagem0porcentagem_parcelas'], 2, ',', '');
        }

        if ($templateProc != null) {
            $templateProc->setValue('totais0vl_total_lote_comSinal', $dados['totais']['0']['totais0vl_total_lote_comSinal']);
            $templateProc->setValue('totais0vl_total_lote_comSinal_extenso', $dados['totais']['0']['totais0vl_total_lote_comSinal_extenso']);
            $templateProc->setValue(strtoupper('totais0vl_total_lote_comSinal_extenso'), strtoupper($dados['totais']['0']['totais0vl_total_lote_comSinal_extenso']));
            $templateProc->setValue('porcentagem0porcentagem_sinal', $dados['porcentagem']['0']['porcentagem0porcentagem_sinal']);
            $templateProc->setValue('porcentagem0porcentagem_parcelas', $dados['porcentagem']['0']['porcentagem0porcentagem_parcelas']);
        }

        // Valor total sacoc sem sinal
        $dados['totais']['0']['contrato0vl_divida_sacoc'] = Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_parcela']) +
            Helper::getInputMoney($dados['totais']['0']['totais0vl_total_intercalada']) + Helper::getInputMoney($dados['totais']['0']['totais0vl_total_chave']), 2, true);
        if ($dados['totais']['0']['contrato0vl_divida_sacoc'])
            $dados['totais']['0']['contrato0vl_divida_sacoc_extenso'] = Helper::valorPorExtenso( Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_parcela']) +
                Helper::getInputMoney($dados['totais']['0']['totais0vl_total_intercalada']) + Helper::getInputMoney($dados['totais']['0']['totais0vl_total_chave'])) );
        if ($templateProc != null) {
            $templateProc->setValue('contrato0vl_divida_sacoc', $dados['totais']['0']['contrato0vl_divida_sacoc']);
            $templateProc->setValue('contrato0vl_divida_sacoc_extenso', $dados['totais']['0']['contrato0vl_divida_sacoc_extenso']);
            $templateProc->setValue(strtoupper('contrato0vl_divida_sacoc_extenso'), strtoupper($dados['totais']['0']['contrato0vl_divida_sacoc_extenso']));
        }

        $dados['totais']['0']['contrato0menos_comissao'] = Helper::getmoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_parcela']) +
            Helper::getInputMoney($dados['totais']['0']['totais0vl_total_intercalada']) + Helper::getInputMoney($dados['totais']['0']['totais0vl_total_chave']) + 
            Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal']) - Helper::getInputMoney($totalComissao), 2, true);
        if ($dados['totais']['0']['contrato0menos_comissao']) {
            $dados['totais']['0']['contrato0menos_comissao_extenso'] = Helper::valorPorExtenso(Helper::getmoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_parcela']) +
            Helper::getInputMoney($dados['totais']['0']['totais0vl_total_intercalada']) + Helper::getInputMoney($dados['totais']['0']['totais0vl_total_chave']) + 
            Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal']) - Helper::getInputMoney($totalComissao)) );
        }
        if ($templateProc != null) {
            $templateProc->setValue('contrato0menos_comissao', $dados['totais']['0']['contrato0menos_comissao']);
            $templateProc->setValue('contrato0menos_comissao_extenso', $dados['totais']['0']['contrato0menos_comissao_extenso']);
            $templateProc->setValue(strtoupper('contrato0menos_comissao_extenso'), strtoupper($dados['totais']['0']['contrato0menos_comissao_extenso']));
        }

        // Valor total sacoc com sinal
        $dados['totais']['0']['contrato0vl_divida_sacoc_comSinal'] = Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['contrato0vl_divida_sacoc']) + Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal']), 2, true);
        if ($dados['totais']['0']['contrato0vl_divida_sacoc_comSinal']) {
            $dados['totais']['0']['contrato0vl_divida_sacoc_comSinal_extenso'] = Helper::valorPorExtenso( Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['contrato0vl_divida_sacoc']) + Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal'])) );
            $dados['porcentagem']['0']['porcentagem0porcentagem_sinal'] = Helper::getMoney(Helper::getInputMoney($dados['parcela']['0']['parcela0vl_sinal'] * 100), 2, true) / Helper::getMoney($dados['totais']['0']['contrato0vl_divida_sacoc_comSinal']);
            $dados['porcentagem']['0']['porcentagem0porcentagem_parcelas'] = Helper::getMoney(Helper::getMoney($dados['totais']['0']['contrato0vl_divida_sacoc_comSinal'] - $dados['parcela']['0']['parcela0vl_sinal']), 2, true) / Helper::getMoney($dados['totais']['0']['contrato0vl_divida_sacoc_comSinal']);
            $dados['porcentagem']['0']['porcentagem0porcentagem_sinal'] = number_format((float)$dados['porcentagem']['0']['porcentagem0porcentagem_sinal'], 2, ',', '');
            $dados['porcentagem']['0']['porcentagem0porcentagem_parcelas'] = number_format((float)$dados['porcentagem']['0']['porcentagem0porcentagem_parcelas'], 2, ',', '');
        }

        if ($templateProc != null) {
            $templateProc->setValue('contrato0vl_divida_sacoc_comSinal', $dados['totais']['0']['contrato0vl_divida_sacoc_comSinal']);
            $templateProc->setValue('contrato0vl_divida_sacoc_comSinal_extenso', $dados['totais']['0']['contrato0vl_divida_sacoc_comSinal_extenso']);
            $templateProc->setValue(strtoupper('contrato0vl_divida_sacoc_comSinal_extenso'), strtoupper($dados['totais']['0']['contrato0vl_divida_sacoc_comSinal_extenso']));
            $templateProc->setValue('porcentagem0porcentagem_sinal', $dados['porcentagem']['0']['porcentagem0porcentagem_sinal']);
            $templateProc->setValue('porcentagem0porcentagem_parcelas', $dados['porcentagem']['0']['porcentagem0porcentagem_parcelas']);
        }

        if($dadosContrato[0]['tx_juros']){

            $dados['totais']['0']['totais0vl_juros'] = Helper::getMoney((float)Helper::getInputMoney($dados['totais']['0']['totais0vl_total_lote_semSinal']) - (float)$dadosContrato[0]['vl_divida']);
            $dados['totais']['0']['totais0vl_juros_extenso'] = Helper::valorPorExtenso($dados['totais']['0']['totais0vl_juros']);
            $dados['totais']['0']['totais0vl_total_lote_price_comSinal'] = Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_lote_comSinal']) - Helper::getInputMoney($dados['totais']['0']['totais0vl_juros']));
            $dados['totais']['0']['totais0vl_total_lote_price_comSinal_extenso'] = Helper::valorPorExtenso($dados['totais']['0']['totais0vl_total_lote_price_comSinal']);
            $dados['totais']['0']['totais0vl_total_lote_price_semSinal'] = Helper::getMoney(Helper::getInputMoney($dados['totais']['0']['totais0vl_total_lote_semSinal']) - Helper::getInputMoney($dados['totais']['0']['totais0vl_juros']));
            $dados['totais']['0']['totais0vl_total_lote_price_semSinal_extenso'] = Helper::valorPorExtenso($dados['totais']['0']['totais0vl_total_lote_price_semSinal']);
        
            if ($templateProc != null) {
                $templateProc->setValue('totais0vl_juros', $dados['totais']['0']['totais0vl_juros']);
                $templateProc->setValue('totais0vl_juros_extenso', $dados['totais']['0']['totais0vl_juros_extenso']);
                $templateProc->setValue('totais0vl_total_lote_price_comSinal', $dados['totais']['0']['totais0vl_total_lote_price_comSinal']);
                $templateProc->setValue('totais0vil_total_lote_price_comSinal_extenso', $dados['totais']['0']['totais0vl_total_lote_price_comSinal_extenso']);
                $templateProc->setValue('totais0vl_total_lote_price_semSinal', $dados['totais']['0']['totais0vl_total_lote_price_semSinal']);
                $templateProc->setValue('totais0vl_total_lote_price_semSinal_extenso', $dados['totais']['0']['totais0vl_total_lote_price_semSinal_extenso']);
            }
        }
        $dados['data']['0']['data_atual'] = date("d/m/Y");

        $dados['data']['0']['data_atual_extenso'] = Helper::dataPorExtenso($dados['data']['0']['data_atual']);

        if ($templateProc != null) {
            $templateProc->setValue('data_atual', $dados['data']['0']['data_atual']);
            $templateProc->setValue('data_atual_extenso', $dados['data']['0']['data_atual_extenso']);
            $templateProc->setValue(strtoupper('data_atual_extenso'), strtoupper($dados['data']['0']['data_atual_extenso']));
        }

        $dados['totais']['0']['vl0pago_contrato_quitado'] = Helper::getMoney($parcelaValorPago);
        $dados['totais']['0']['vl0pago_contrato_quitado_extenso'] = Helper::valorPorExtenso(Helper::getMoney($parcelaValorPago));
        $dados['totais']['0']['vl0pago_contrato_quitado_multa_juros'] = Helper::getMoney($parcelaTotalMultaJuros);
        $dados['totais']['0']['vl0pago_contrato_quitado_multa_juros_extenso'] = Helper::valorPorExtenso(Helper::getMoney($parcelaTotalMultaJuros));

        if ($templateProc != null){
            $templateProc->setValue('vl0pago_contrato_quitado', $dados['totais']['0']['vl0pago_contrato_quitado']);
            $templateProc->setValue('vl0pago_contrato_quitado_extenso', $dados['totais']['0']['vl0pago_contrato_quitado_extenso']);
            $templateProc->setValue('vl0pago_contrato_quitado_multa_juros', $dados['totais']['0']['vl0pago_contrato_quitado_multa_juros']);
            $templateProc->setValue('vl0pago_contrato_quitado_multa_juros_extenso',  $dados['totais']['0']['vl0pago_contrato_quitado_multa_juros_extenso']);
        }

        // Valor total porcentagem diferen�a entre valor total sem sinal e com sinal
        $dados['totais']['0']['totais0vl_porcentagem_sinal_diferenca'] = (($dados['totais']['0']['totais0vl_total_lote_comSinal'] - $dados['totais']['0']['totais0vl_total_lote_semSinal']) / $dados['totais']['0']['totais0vl_total_lote_semSinal']) * 100;
        $dados['totais']['0']['totais0vl_porcentagem_sinal_diferenca'] = number_format((float)$dados['totais']['0']['totais0vl_porcentagem_sinal_diferenca'], 2, '.', '');
        if ($templateProc != null) {
            $templateProc->setValue('totais0vl_porcentagem_sinal_diferenca', $dados['totais']['0']['totais0vl_porcentagem_sinal_diferenca']);
        }
        // Retorno
        return [
            'dados' => $dados,
            'templateProcessor' => $templateProc
        ];
    }
    public function enviarEmail($remetenteMail,$remetenteSenha,$remetenteHost,$remetentePorta, $remetenteName, $destinatarioMail, $destinatarioName, $subject, $body_of_your_email)
    {
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();                       // telling the class to use SMTP
            $mail->SMTPDebug = 0;
            // 0 = no output, 1 = errors and messages, 2 = messages only.

            $mail->SMTPAuth = true;                // enable SMTP authentication
            if($remetentePorta=="465"){
                $mail->SMTPSecure = "ssl";
            }
            else{
                $mail->SMTPSecure = "tls";
            }
            $mail->CharSet = "ISO-8859-1";
            $mail->Host = $remetenteHost;//'smtp.gmail.com';
            $mail->Port = $remetentePorta;//587;
            $mail->Username = $remetenteMail;  // Gmail username
            $mail->Password = $remetenteSenha;      // Gmail password
            $mail->SetFrom($remetenteMail,"Acade Lotear"); // send to mail
            $mail->isHTML(true);

            $mail->Body = $body_of_your_email;
            $mail->AddAddress($destinatarioMail, $destinatarioName); //send to
            $mail->AddCustomHeader("List-Unsubscribe: <mailto:".$remetenteMail."?subject=Unsubscribe>, <https://testdrive.acadeone.com.br/acadelotear/?unsubscribeMail=".$destinatarioMail.">");
            $mail->Subject = $subject; //T?tulo

            if (!$mail->Send()) {
                $error_message = "Mailer Error: " . $mail->ErrorInfo;
            } else {
                $error_message = "E-mail enviado com sucesso!";
            }

            return $error_message;
        } catch (Exception $e) {

            return $e->getMessage();
        }
    }
}