<?php
//empreendimento
$empreendimento = $this->get("empreendimento");

//Contratos, no caso de multiplas impresses
$contratos = $this->get('contratos');

// pode vir por get ou quando  requisitada essa pgina em gerar relatrio de cartas enviadas
$numContrato = ($_GET["id"]) ? $_GET["id"] : $this->get("idContrato");
$tipo = $_GET["tipo"];

//busca o jurdico do cliente
$juridico = $contratos[$numContrato]['descricao'];

//lote
$lote = $this->get("lote");
$lote = isset($contratos[$k]['lote']) ? $contratos[$k]['lote'] : $lote->toArray();

//cliente
$cliente = (array)$this->get("cliente");
$cliente = isset($contratos[$numContrato]['cliente']) ? $contratos[$numContrato]['cliente'] : $cliente;

//Carta Cobranca
$cartaCobranca = $this->get("cartaCobranca");

//Id da carta
$idCarta = $this->get("idCarta");
$idCarta = isset($contratos[$numContrato]['cartaEnviada']) ? $contratos[$numContrato]['cartaEnviada'] : $idCarta;

//busca o tipo de encode do sistema, para converter para maiscula as palavras acentuadas ou com caracteres especiais
$encoding = mb_internal_encoding();

setlocale(LC_TIME, "pt_BR.utf8");

$empresa = $this->get("empresa");
$assinatura = $this->get("assinatura");
$parcelas = (isset($contratos)) ? $contratos[$numContrato]['parcelas'] : $this->get("parcelas");

if ($cliente['cd_cidade']) {
    $cidades = new Db_Cidade();
    $cidadeC = Db_Cidade::find($cliente['cd_cidade'])->toArray();
    $cidadeCli = $cidadeC['nome'] . "/" . $cidadeC['uf'];
}

if ($lote) {
    $loteNum = $lote['lote'];
    $quadra = $lote['quadra'];
}
?>
<page backtop="10mm" backbottom="10mm">

<style type="text/css">
    table.bordasimples {
        border-collapse: collapse;
    }

    table.bordasimples thead tr th, table.bordasimples tbody tr td {
        border: 1px solid #000000;
        width: 200px;
    }
    p{
        margin-top: -5px;
    }
    .topTable{
        margin-top: 20px;
        width: 700px;
        font-size:16px;
        margin-left:60px; 
        text-align: right !important;
    }
</style>

<div class="topTable">
    <div>
    <?php

        $dsEndLogomarca = $clienteAcadeone['ds_end_logomarca'];

        //Funo que Traz as img de empreendimento ou cliente no documento .
        if ($empreendimento->ds_path_logo && file_exists($empreendimento->ds_path_logo)) {
            echo '<img src="'.$empreendimento->ds_path_logo.'" alt="'.$clienteAcadeone['nm_fantasia'].'" height="70">';
        } elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
            echo '<img style="float: left; " src="'.$dsEndLogomarca.'" alt="'.$clienteAcade['nm_fantasia'].'" height="70">';
        } else {
            echo '<img style="float: left; " src="' . LOGOMARCA_DEFAULT . '" alt="LogoPadrao" height="70">';
        }

    ?>
    </div>
    <div style="text-align: right; margin-right: 50px">
        <p>
            <?php
            //Array que trs informaes do ms! 
            $mes = array(
                1 => 'janeiro',
                2 => 'fevereiro',
                3 => 'março',
                4 => 'abril',
                5 => 'maio',
                6 => 'junho',
                7 => 'julho',
                8 => 'agosto',
                9 => 'setembro',
                10 => 'outubro',
                11 => 'novembro',
                12 => 'dezembro'
            );
        // Varivel que trs os nomes das cidades!
        $cidade = Cidade::byId($clienteAcadeone["cd_municipio"])['nome'];
        echo $cidade . ", " . utf8_decode(date("d") . ' de ' . $mes[date("n")] . ' de ' . date("Y")) . ".";

        ?>
        </p>
    </div>
</div>

<div class="tabela" style="width: 650px;font-size:16px;margin-left:60px;">
    <!--conteudo -->

    <p style="font-weight: bold">CARTA N: <?php echo str_pad($idCarta, 4, "0", STR_PAD_LEFT); ?></p>

    <p style="font-weight: bold">AO(A)<br/>
        SR(A). <?php echo mb_strtoupper($cliente['nm_pessoa'], $encoding); ?><br/>
        <?php echo mb_strtoupper($cliente['endereco'] . (($cliente['nr_endereco']) ? ', ' . $cliente['nr_endereco'] : '') . (($cliente['ds_complemento']) ? ', ' . $cliente['ds_complemento'] : ''), $encoding); ?>,
        <?php echo mb_strtoupper($cliente['nm_bairro'], $encoding); ?><br/>
        <?php echo mb_strtoupper($cidadeCli, $encoding); ?><br/>
        CEP: <?php echo $cliente['nr_cep']; ?>
    </p>
    
    <p align="center" style="margin-top: -5px; text-decoration: underline;text-transform: uppercase;font-weight: bold"> 
        <?php echo mb_strtoupper("Ref.: Prestaes em aberto - Contrato n $numContrato do Lote $loteNum da Quadra {$quadra} do Empreendimento $empreendimento->nm_empreendimento", 'ISO-8859-1'); ?>
    </p><p></p> 

    <p style="margin-top: -20px">Prezado(a) Cliente:</p>
    <?php
    if ($cartaCobranca) {
        echo '<p>' . $cartaCobranca['ds_texto_cima'] . '</p>';
    } else {
        echo '<p>Encontra-se em aberto, em nossos controles, o pagamento da(s) parcela(s) mensal(is), abaixo relacionadas, referente ao contrato acima mencionado.</p>';
    }
    ?>

</div>
<div class="tabela" style="width: 650px;font-size:16px;margin-left:60px; margin-top: -15px">
    <?php if ($juridico): ?>
        <span><strong>jurdico: </strong>(<?php echo $juridico ?>)</span>
    <?php endif; ?>
    <table style="margin-left: 10px;padding-left: 10px; font-size: 10pt;">
        <tr>
            <th width="50" align="center">
                Parcela
            </th>
            <th width="40" align="center">
                Tipo
            </th>
            <th width="80" align="center">
                Vl Original
            </th>
            <th width="90" align="center">
                Vencimento
            </th>
            <th width="30" align="center">
                &nbsp;
            </th>
            <th width="50" align="center">
                Parcela
            </th>
            <th width="40" align="center">
                Tipo
            </th>
            <th width="80" align="center">
                Vl Original
            </th>
            <th width="90" align="center">
                Vencimento
            </th>
        </tr>
        <?php
        $total = count($parcelas);
        $parte1 = round($total / 2);
        for ($i = 0; $i < $parte1; $i++):
            $p = $parcelas[$i];
            ?>
            <tr>
                <td align="center">
                    <?php echo $p->id_parcela; ?>
                </td>
                <td align="center">
                    <?php
                    switch ($p->tp_parcela) {
                        case 'N':
                            $tipoParcela = 'Normal';
                            break;
                        case 'S':
                            $tipoParcela = 'Sinal';
                            break;
                        case 'I':
                            $tipoParcela = 'Intercalada';
                            break;
                        case 'C':
                            $tipoParcela = 'Chave';
                            break;
                        case 'G':
                            $tipoParcela = 'Negociada';
                            break;
                        case 'Q':
                            $tipoParcela = 'Quitao';
                            break;
                        case 'A':
                            $tipoParcela = 'Avulso';
                            break;
                        default:
                            $tipoParcela = null;
                    }
                    echo $tipoParcela; ?>
                </td>
                <td align="center">
                    <?php echo str_replace(".", ",", "R$ " . $p->vl_parcela); ?>
                </td>
                <td align="center">
                    <?php echo $this->_helper->getDate($p->dt_parcela); ?>
                </td>
                <td align="center">
                    &nbsp;
                </td>
                <?php $p = $parcelas[$i + $parte1]; ?>
                <td align="center">
                    <?php echo $p->id_parcela; ?>
                </td>
                <td align="center">
                    <?php
                    switch ($p->tp_parcela) {
                        case 'N':
                            $tipoParcela = 'Normal';
                            break;
                        case 'S':
                            $tipoParcela = 'Sinal';
                            break;
                        case 'I':
                            $tipoParcela = 'Intercalada';
                            break;
                        case 'C':
                            $tipoParcela = 'Chave';
                            break;
                        case 'G':
                            $tipoParcela = 'Negociada';
                            break;
                        case 'Q':
                            $tipoParcela = 'Quitao';
                            break;
                        case 'A':
                            $tipoParcela = 'Avulso';
                            break;
                        default:
                            $tipoParcela = null;
                    }
                    echo $tipoParcela; ?>
                </td>
                <td align="center">
                    <?php echo ($p->vl_parcela) ? 'R$ ' : '';
                    echo str_replace(".", ",", $p->vl_parcela); ?>
                </td>
                <td align="center">
                    <?php echo $this->_helper->getDate($p->dt_parcela); ?>
                </td>
            </tr>
        <?php endfor; ?>
    </table>

</div>
<div class="tabela" style="width: 650px;font-size:16px;margin-left:60px;margin-top: -10px">
    <?php
    if ($cartaCobranca) {
        echo '<p style="margin-top: -10px">' . $cartaCobranca['ds_texto_baixo'] . '</p>';
    } else {
        echo '<p style="text-indent: 40px;">Solicitamos a gentileza de entrar em contato com o setor de cobrana pelo telefone (' . $empresa["nr_uf_telefone"] . ')' . $empresa["nr_telefone"] . ', para darmos soluo a pendncia atravs do pagamento dos valores devidos.</p>';
        echo '<p style="text-indent: 40px;">No aguardo de uma breve resposta, somos desde j agradecidos pela ateno.</p>';
        echo '<p>P.S.: Dessa forma, caso o(s) referido(s) pagamento(s) j tenham sido efetuado(s), favor desconsiderar essa correspondncia. Entrar em contato via telefone: (' . $empresa["nr_uf_telefone"] . ')' . $empresa["nr_telefone"] . ', email: ' . $empresa["ds_email"] . ' ou comparecer ao nosso escritrio localizado : ' . $empresa["ds_endereco"] . ' - ' . $empresa["nm_bairro"] . '</p>';
    }
    ?>
    <p style="margin-top: -15px">Atenciosamente,</p>

    <div style="margin-top: -10px" align="center"><img src="public/images/assinatura.jpg" border="0"/></div>
    <?php if (isset($assinatura)) : ?>
        <div align="center" style="padding-top: 7px;"><?php echo $assinatura; ?></div>
    <?php else : ?>
        <div align="center" style="padding-top: 7px;"><?php echo $empresa["nm_razao_social"]; ?></div>
        <div align="center" style="padding-top: 7px;"><?php echo $empresa["nr_cnpj"]; ?></div>
    <?php endif; ?>
</div>
</page>