function iniciarConversa(telefone, mensagem, id, dominio) {
  console.log(`Iniciando conversa com: ${telefone}, mensagem: ${mensagem}, ID: ${id}`);
  const tempoMin = 100;
  const tempoMax = 300;

  function digitarComDelay(elemento, texto) {
    let index = 0;
    function digitar() {
      if (index < texto.length) {
        elemento.value += texto[index];
        index++;
        setTimeout(digitar, Math.random() * (tempoMax - tempoMin) + tempoMin);
      }
    }
    digitar();
  }

  const novaConversa = document.querySelector('div[title="Nova conversa"]');
  if (novaConversa) {
    novaConversa.click();
    console.log('Clicado em "Nova conversa"');

    setTimeout(() => {
      const searchBox = document.querySelector('div[data-tab="3"]');
      if (searchBox) {
        console.log('Digitando número na caixa de pesquisa.');
        digitarComDelay(searchBox, telefone);

        setTimeout(() => {
          searchBox.dispatchEvent(new KeyboardEvent('keydown', { key: 'Enter' }));
          console.log('Número de telefone enviado, aguardando a interface do WhatsApp.');

          setTimeout(() => {
            const messageBox = document.querySelector('div[aria-label="Digite uma mensagem"]');
            if (messageBox) {
              console.log('Caixa de mensagem localizada, digitando a mensagem.');
              digitarComDelay(messageBox, mensagem);

              setTimeout(() => {
                const sendButton = document.querySelector('button[aria-label="Enviar"]');
                if (sendButton) {
                  sendButton.click();
                  console.log(`Mensagem enviada para ${telefone}`);

                  // Enviar confirmação para o servidor
                  fetch(`https://${dominio}.acadeone.com.br/acadelotear/?m=sc&c=cliente&a=eventoWhatsapp`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: `ack=1&agendamento=${id}`
                  })
                  .then(response => {
                    if (response.ok) {
                      console.log(`Agendamento ID: ${id} confirmado no servidor.`);
                    } else {
                      console.error(`Erro ao confirmar agendamento ID: ${id}`);
                    }
                  });
                }
              }, 1);
            } else {
              console.error('Caixa de mensagem não encontrada.');
            }
          }, 1);
        }, 1);
      } else {
        console.error('Caixa de pesquisa não encontrada.');
      }
    }, 1);
  } else {
    console.error('Botão "Nova conversa" não encontrado.');
  }
}
