chrome.runtime.onInstalled.addListener(() => {
  console.log('Extensão instalada.');
  // Cria um alarme para disparar a cada 1 minuto
  chrome.alarms.create('fetchAgendamentos', { periodInMinutes: 2 });
  console.log('Alarme criado para buscar agendamentos a cada 2 minuto.');
});

// Função para enviar mensagens ao WhatsApp Web
async function sendMessageToWhatsApp(telefone, mensagem, id, dominio) {
  console.log(`Enviando mensagem para: ${telefone} com conteúdo: ${mensagem}`);
  
  const [tab] = await chrome.tabs.query({ url: "https://web.whatsapp.com/*" });

  if (tab) {
    console.log('WhatsApp Web encontrado, executando o script de envio de mensagem.');

    // Injeta o código de 'iniciarConversa' diretamente na aba do WhatsApp
    chrome.scripting.executeScript({
      target: { tabId: tab.id },
      func: iniciarConversaOnPage,
      args: [telefone, mensagem, id, dominio]
    });
  } else {
    console.error('WhatsApp Web não está aberto. Por favor, abra o WhatsApp Web.');
  }
}
function confirmarComOServidor(dominio,id,valor){
  fetch(`https://${dominio}.acadeone.com.br/acadelotear/?m=sc&c=cliente&a=eventoWhatsapp`, {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `ack=${valor}&agendamento=${id}`
  })
  .then(response => {
    if (response.ok) {
      console.log(`Agendamento ID: ${id} confirmado no servidor.`);
    } else {
      console.error(`Erro ao confirmar agendamento ID: ${id}`);
    }
  });
}
// Função a ser injetada diretamente na página
function iniciarConversaOnPage(telefone, mensagem, id, dominio) {
  console.log(`Iniciando conversa com: ${telefone}, mensagem: ${mensagem}, ID: ${id}`);
  
  function confirmarComOServidor(dominio,id,valor){
    fetch(`https://${dominio}.acadeone.com.br/acadelotear/?m=sc&c=cliente&a=eventoWhatsapp`, {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: `ack=${valor}&agendamento=${id}`
    })
    .then(response => {
      if (response.ok) {
        console.log(`Agendamento ID: ${id} confirmado no servidor.`);
      } else {
        console.error(`Erro ao confirmar agendamento ID: ${id}`);
      }
    });
  }
  function escreverTexto(textarea, texto,id = false,dominio = false){
    const linhas = texto.split(/\n/).map(line => line.trim());
    console.log("digitando");
    if(!textarea) {
      confirmarComOServidor(dominio,id,'-1');
      console.log("Seletor não localizado");
      return false;
    }
    linhas.forEach((line, index) => {
        if (index > 0) {
            // Simular Shift+Enter para quebrar a linha
            const shiftEnterEvent = new KeyboardEvent('keydown', {
                key: 'Enter',
                code: 'Enter',
                keyCode: 13,
                which: 13,
                shiftKey: true,
                bubbles: true,
            });
            textarea.dispatchEvent(shiftEnterEvent);
        }

        // Inserir o texto da linha
        document.execCommand('insertText', false, line);
    });

    textarea.dispatchEvent(new Event('change', { bubbles: true }));
    
    if(dominio){
      setTimeout(() => {
        console.log("enviou");
        (main.querySelector(`[data-testid="send"]`) || main.querySelector(`[data-icon="send"]`)).click();
        confirmarComOServidor(dominio,id,'1');
      }, 1000);

    }
    return texto.length;
  }
  setTimeout(() => {
          
    main = document.querySelector("#main");
    if(!main){
      console.log("main não localizado");
      confirmarComOServidor(dominio,id,'-1');
      return false;
    }
    textarea = main.querySelector(`div[contenteditable="true"]`);
    console.log("inicio do envio");
    escreverTexto(textarea,mensagem,id,dominio)
    
  }, 10000);
}

chrome.alarms.onAlarm.addListener((alarm) => {
  if (alarm.name === 'fetchAgendamentos') {
    console.log('Alarme disparado. Buscando agendamentos...');
    fetchAgendamentos();
  }
});

function fetchAgendamentos() {
  chrome.storage.local.get('dominioServidorAcade', function (result) {
    chrome.storage.local.get('servicoAcade', function (resultServico) {
      servico = resultServico.servicoAcade;
      dominio = result.dominioServidorAcade;
      if(servico=="0"){
        console.log("Serviço inativo");
        return false;
      }
      if (dominio) {
        console.log(`Fazendo solicitação ao servidor ${dominio} para buscar agendamentos...`);

        fetch(`https://${dominio}.acadeone.com.br/acadelotear/?m=comunicacao&c=agendamento&a=whatsAppPendente`)
          .then(response => {
            if (!response.ok) {
              throw new Error(`Erro na resposta do servidor: ${response.status}`);
            }
            return response.json();
          })
          .then(agendamentos => {
            if (agendamentos.length === 0) {
              console.log('Nenhum agendamento pendente.');
            } else {
              console.log(`${agendamentos.length} agendamento(s) pendente(s) encontrado(s).`);
              //agendamentos.forEach(agendamento => {
                agendamento = agendamentos[0];
                var telefone = "";
                if(agendamento.emailDestinatario[0]=="+"){
                  telefone=agendamento.emailDestinatario;
                }
                else{
                  telefone="55" + agendamento.emailDestinatario;
                }
                const mensagem = agendamento.conteudo;
                const id = agendamento.id;
      
                console.log(`Processando agendamento ID: ${id}, Telefone: ${telefone}`);
                //sendMessageToWhatsApp(telefone, mensagem, id, dominio);
                chrome.tabs.query({ url: "*://web.whatsapp.com/*" }, (tabs) => {
                  if (tabs.length > 0) {
                    // Verifique se 'tabs[0]' é válido antes de acessar 'id'
                    if (tabs[0].id) {
                        chrome.tabs.update(tabs[0].id, { url: 'https://web.whatsapp.com/send/?phone='+telefone+'&text&type=phone_number&app_absent=0' }, () => {
                          setTimeout(() => {
                            chrome.scripting.executeScript({
                              target: { tabId: tabs[0].id },
                              func: iniciarConversaOnPage,
                              args: [telefone, mensagem, id, dominio]
                            });
                          }, 20000); 
                        });
                    } else {
                        console.error('Erro: Tab ID não encontrado.');
                    }
                } else {
                    // Se não houver uma aba do WhatsApp, cria uma nova
                    chrome.tabs.create({ url: 'https://web.whatsapp.com/send/?phone='+telefone+'&text&type=phone_number&app_absent=0' }, (tab) => {
                      setTimeout(() => {
                        chrome.scripting.executeScript({
                          target: { tabId: tab.id },
                          func: iniciarConversaOnPage,
                          args: [telefone, mensagem, id, dominio]
                        });
                      }, 20000); // Delay de 3 segundos para garantir que a página foi carregada
                    });
                }
                  });
              //});
            }
          })
          .catch(error => console.error('Erro ao buscar agendamentos:', error));
      }
      else{
        console.log("Domínio não configurado");
      }
    });
  });
  
 
}
